#include "osl/oslConfig.h"
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/CompilerOutputter.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <iostream>
#include <unistd.h>

int main(int argc, char **argv)
{
  // extern char *optarg;
  extern int optind;
  bool error_flag = false, is_short_test = false;
  char c;
  while ((c = getopt(argc, argv, "s")) != EOF)
  {
    switch (c)
    {
    case 's':	is_short_test = true;
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;
  if (error_flag)
  {
    std::cerr << "unknown option\n";
    return 1;
  } 

  osl::OslConfig::setInUnitTest(is_short_test ? 1 : 2);
  osl::OslConfig::setVerbose(true);
  osl::OslConfig::showOslHome();
  
  CppUnit::TextUi::TestRunner runner;

  CppUnit::TestFactoryRegistry &registry 
    = CppUnit::TestFactoryRegistry::getRegistry();
  runner.addTest(registry.makeTest());
  runner.setOutputter(new CppUnit::CompilerOutputter(&runner.result(), std::cout));
  runner.run("", false);

  CppUnit::TestResultCollector &result = runner.result(); 
  return result.wasSuccessful() ? 0 : 1;
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
