/* ----- decode/1277x2627, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1277x2627_checksums[] = {
  "74f598a5f9e175e6ac4b6bfe3c14389c99096b4e82684948c1ca634c24a8e72f",
  "06734904e6447b510c757eb71f6124fc13a4edc76b6c3d88be4d858f2f945a8a",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1277x2627_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1277x2627_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1277x2627_ITEMBYTES

static void *storage_decode_1277x2627_x;
static unsigned char *test_decode_1277x2627_x;
static void *storage_decode_1277x2627_s;
static unsigned char *test_decode_1277x2627_s;
static void *storage_decode_1277x2627_x2;
static unsigned char *test_decode_1277x2627_x2;
static void *storage_decode_1277x2627_s2;
static unsigned char *test_decode_1277x2627_s2;

#define precomputed_decode_1277x2627_NUM 4

static const int16_t precomputed_decode_1277x2627_x[precomputed_decode_1277x2627_NUM][crypto_decode_ITEMS] = {
  {-3060,1875,3414,3285,2664,-2316,1848,-1647,-1368,-21,-3414,-3009,3750,-183,1851,1281,87,-216,-3837,-3444,2139,-621,-510,1536,-3315,-2919,-2748,3810,1809,237,-3150,-2019,-189,-3120,2766,2886,204,2487,1029,273,-3744,-399,-795,-3885,-2766,-2337,999,1359,-3438,1668,471,2241,1890,-1569,3324,3135,1530,-2037,933,2784,2808,-711,-1059,-1695,1290,2745,3753,243,246,3894,1995,-1485,936,1740,-3108,2307,3648,-2349,3708,2706,-1824,-1752,2649,3822,2793,-1161,-3069,2340,150,3072,327,3630,882,-2034,1146,2649,-930,1344,-3306,-2538,-1935,-3180,189,-1419,1923,3000,1644,-138,2868,2658,3468,2889,975,-2649,2661,-2925,696,3633,-3864,3504,-1356,-1197,-993,165,-2766,-1203,-1374,-2616,3012,-381,951,-3924,-960,-453,294,2586,-2064,1860,879,2772,-3726,-936,-615,-3912,570,2736,552,-2643,-1854,1659,2712,2421,-3159,2058,2085,-1989,3771,198,-2049,327,-2514,246,342,-663,96,528,3420,-2022,2781,1674,-1491,2688,-2520,681,-2151,-2346,-135,1008,-2313,-2877,1989,1332,132,3786,3363,-1548,480,1422,-3531,-3849,-3720,-486,-2187,1242,-3255,-2520,1338,3219,-3492,-1563,3879,852,1923,2850,-249,-3198,3303,-3693,2769,15,129,-1671,345,-870,2778,1581,2448,2952,-3555,-417,3861,24,-3564,-1986,480,-603,-2091,-2766,-2157,828,-2853,2919,-2817,-2790,-3411,-2484,-369,2715,3513,-306,-2352,-198,228,-2727,2652,-1155,384,1020,-2604,2010,-2076,-3690,3765,2589,-2388,3414,-390,3588,2214,-2463,2958,1212,1896,-564,966,-1431,2340,3651,1740,-3066,3153,-2052,-495,-1971,1053,-3270,-2352,-1857,3,-3939,-1965,-1236,2361,-684,645,-2253,-2838,-246,-222,570,1095,-3579,1677,3405,-3768,-2547,993,3033,-3216,480,1698,3405,-2463,-1437,-468,-189,-3861,2601,2454,1947,-1662,1899,3528,2619,-1404,321,-1035,114,-2619,-2853,-462,3507,-486,-468,513,-3876,-2406,1719,825,-3375,-3027,2061,2199,3570,2547,-732,-3291,1218,1131,-504,3675,1218,3741,-3144,3801,3702,2844,-3408,-2379,-1545,-1200,-3366,-1083,1053,3789,1266,-1053,-2964,180,2241,-1113,867,3237,993,3318,1443,-3744,-156,-3219,-2220,-2610,1608,-1311,-981,-2847,2721,1305,-933,2928,-531,3453,303,-69,912,3888,1371,966,660,2421,2199,-1551,3849,546,-1623,1326,-1902,2112,657,3876,-2919,2769,-2025,-2172,966,1743,1848,-3189,-3018,417,873,-1956,-2769,-309,1239,774,1818,3450,-324,3447,2346,-3852,1458,-3189,129,3873,-714,-2907,-3591,1251,-48,-3456,-747,-366,-126,3234,-1845,3825,414,3507,159,-2940,-3360,3438,141,-396,-1554,492,1710,-3351,-3822,-2085,1122,2523,1488,648,-3879,1362,2397,1482,3765,-1332,3456,3282,-3351,927,-3492,1143,-777,3936,2313,2385,1707,102,1074,3243,-2391,-3615,186,-2964,-2103,1317,1389,-1755,-3567,444,-3267,1962,1866,801,1029,3042,-864,-210,-1506,3021,141,-3558,2457,2817,1818,1242,3525,-2865,-228,2190,3831,663,-1464,3810,-2166,-951,-42,2889,-2979,-798,-3093,3663,-522,-2868,-1581,3210,-807,-1842,-2028,3312,-3162,-2223,714,-3867,-3594,-2793,-2106,3087,3003,-1026,855,-552,2328,48,-3186,750,2385,2058,1812,-1668,1782,3195,-945,-2508,726,2736,-831,-1008,-2871,1524,-2142,270,498,2280,2967,654,-1689,591,3180,-2229,3408,-1839,1866,-192,3912,330,2799,3888,-2553,-2253,-192,-2388,-1059,165,-1659,-3219,3756,-1488,-3879,-2847,2307,3807,-147,1332,3084,783,-3654,3183,2076,-3249,2304,-933,-54,3360,459,840,3045,-1518,-663,-372,-297,-750,3879,1824,3162,-1704,-2052,3882,1953,-354,2754,-2559,-1398,378,-1191,-3681,-1353,-1284,-2847,855,3765,3423,-3237,-1161,-567,2967,2367,-1737,-591,171,1797,27,1206,-2718,-2484,963,783,972,2748,2868,-2211,684,-3759,-711,2925,-1110,-1560,-2391,-1041,3735,-3426,2493,2547,-1113,-2745,3375,2004,-1440,-2148,3159,-3318,2742,-1362,-1128,2460,2073,2886,12,1383,-3210,-2916,1239,-3234,1551,2058,2259,-1473,1308,-3234,-3183,1416,-3555,1572,-507,-930,-756,984,2286,582,-1236,-270,-411,1260,-2895,-2955,2685,-3846,3549,1791,3144,1002,1449,-1002,-2757,3231,-3069,2592,3441,-2640,-282,2118,144,2949,-3741,-3729,84,-2316,-2358,3387,-2817,2388,-2526,1920,-987,1635,3225,132,1098,2166,-1038,630,-876,3450,2652,909,2538,3795,1005,948,-3612,-2679,-3468,1074,-465,1254,-930,3531,567,111,1017,834,-1077,-2427,-2292,2715,1779,-2598,-696,1275,2658,-1974,1449,1623,-1113,3066,-1878,63,1176,-708,1344,621,-1386,2673,1047,-3582,-1206,2139,-2691,2316,1812,3039,-3861,-492,1389,-3126,-504,1743,-2532,3159,576,-1230,-2409,-1026,-2247,-3522,903,3075,-2253,-1335,1209,-3327,-3591,1305,1122,3783,3387,-3813,2121,-3294,2859,-2049,-246,654,-2727,2742,3171,-1404,-228,1635,-1671,-2865,-1926,-3729,834,3324,-3186,1827,-291,-3933,1512,-3183,177,-2199,1491,2841,-51,627,-3186,381,-3663,-3528,-3171,-1509,-2844,-195,-3579,3321,-180,-375,-3180,1041,-3150,-1017,2715,1044,1497,-3171,-1305,-3132,1431,2016,2703,1197,444,1707,-2325,1770,-1413,-1776,2163,600,3939,-3429,-3237,1743,885,525,-645,-1056,-2262,-1101,-3732,-3927,-3156,66,-3642,186,3555,1953,-1017,-168,-3576,-1842,3462,-375,-2022,105,-1404,2304,-1719,-1029,330,-2064,-2043,2370,-2247,-2121,-3729,168,2616,894,3552,2367,-2688,3018,1956,2385,-3702,3027,1272,918,-2538,-3258,-3051,-1830,2163,-375,1356,-2808,-3408,-1443,675,-2013,1467,-1479,468,207,-2616,579,750,-1263,-2199,-2601,2988,-3888,-3507,-2859,-756,3222,-2484,-3555,3756,2334,-3114,-342,-3186,-1191,-2739,-789,-3021,2427,-450,1104,-2589,-1284,1881,342,-2577,-3393,501,-1188,2577,-3108,2976,-951,-1452,-2823,3249,-1758,3015,333,-2580,-894,-1437,1410,873,-3585,3624,-2115,2520,3459,-3759,-2070,2283,675,-3720,-2580,2547,2883,3333,-1440,-2484,-3825,-111,-1539,297,3519,60,1050,3303,-213,-675,2148,-387,-447,-2091,3582,-2871,1203,3723,78,3528,-1740,294,1281,-2268,1140,-645,-1935,906,-2247,-1593,-966,-1731,2985,-2439,-2049,-1722,-1986,-2079,1998,2199,2793,-486,-2952,2037,-1668,-3834,1362,2772,1200,1560,3177,1584,-1422,-2007,2946,-3237,-153,2223,-2550,3375,663,-3186,-693,-813,-3228,3582,1590,3459,-792,-321,1194,-729,3819,2403,-3786,-2502,2796,-2514,3252,-1728,-3102,3030,-96,-411,2202,2619,510,-1056,2967,-456,-372,1887,3561,-1146,2673,-1917,-2004,1284,-330,-3927,1815,-1338,930,-1422,66,-1569,2502,867,-3561,-1689,3762,-2919,2610,-516,-3183,1770,3486,-2901,3867,-1656,-3555,2661,624,-2685,1374,3624,2385,-2064,-2097,3849,360,2850,-1788,-2886,921,723,-2556,3561,171,1869,3807,2136,-1587,2085,-114,231,-1716,-3057,3681,-2934,-2829,-786,3015,-3471,1389,2967,-531,-786,1050,-3135,-3897,2505,921,3789,-2256,3186,3210,-3594,681,-165,3867,-1215,708,1578,-63,3039,-3156,-3624,2451,-2901,1374,-903,957,-1890,1962,-3540,2778,-267,3252,-270,786,-729,1221,-462,447,2331,1371,3255,747,1713,-1281,-759,1782,-600,-3174,-981,-1767,-2433,1209,-102,981,1416,-1170,-2070,-2133,3204,-2574,-3477,1527,3183,-276,2118,-2058,-3540,2922,-3402,-2454,2313,1299,117,798,-729,-3135,3123,-630,-2928,-1110,87,-741,3006,2274,-2376,-2928,-3198,369,-3321,738,1713,2883,-297,510,1200,789,3657,3018,-2916,-1248,-1191,-135,-3261,-1911,2622,-2580,3153,-342,-33,-426,3591,1878,-2103},
  {2667,-1563,1647,-1521,1923,-1008,-2529,-1014,2061,-429,-2913,-1311,-3243,-204,-3333,2988,-1578,-1707,-1578,-2832,-1647,-2604,-1014,-2901,-2766,2082,-2316,138,-408,2040,1401,1497,-1494,-1749,1395,-3150,1731,1584,2964,-774,-2616,-3873,495,3060,2679,-789,2040,-1791,3414,3249,-267,-1494,1395,2988,-2574,-462,-2115,-2094,-2142,2724,1827,-762,2865,948,1416,-2262,2301,-654,507,-3039,-3525,1824,-2247,2160,2211,-2172,3240,-2643,3537,666,3105,-1293,-696,348,2046,-2718,-708,48,-1188,-3516,-1200,555,1737,-2193,3345,-2106,-3633,2439,243,819,-3135,-2817,-675,3390,-2808,-3012,2520,3618,-3297,-60,1872,-2820,-2922,3834,3696,-3702,-2277,-2442,3723,-3411,-312,-2571,1524,69,3,-3123,750,-747,-1068,-3369,-3453,-3750,-1608,1254,-1188,-696,-1638,-3849,-3420,3627,906,-1089,-1002,1317,-2955,87,-2235,-378,-2055,2172,-3468,186,-1776,1914,3852,-1029,-2679,3900,1365,543,3096,3120,-2217,3879,-2541,-885,1473,-396,-2439,3165,-198,558,753,-3900,3303,-978,-3543,-1485,-2010,3921,2127,480,-2163,-165,2748,-1548,-3450,3762,-2949,1905,2178,-1095,1497,-390,-222,-1029,-2895,-3213,-2484,3669,-2760,-1863,-3024,-2346,-3642,-2583,2052,-2697,3612,-1269,-345,2775,-738,666,912,2715,234,1188,3861,0,-3486,2040,-2310,2502,-2625,3009,597,2469,2226,1953,2109,2520,2079,-2556,-3387,-3402,-534,-3213,783,-3732,-3786,453,-2847,-123,1278,-3906,660,-3012,2295,3000,2658,-3579,-3033,-3621,-3096,2625,1641,-2772,3378,255,-2502,3621,3060,-1803,2025,-1116,-3705,2256,-3150,975,-3432,-819,630,-3138,-966,2208,-813,-1302,573,3552,972,-3126,-3603,3249,-3393,1971,681,2661,-3168,-1131,3582,1059,-3396,-2640,2853,-1455,3798,240,3360,3324,1866,1116,1023,2448,2682,909,3354,669,-1515,-2307,-1479,-3876,864,3144,1869,885,1797,-462,2055,1425,447,-3549,-2574,-1323,2040,1146,-2220,2934,507,-573,1140,-2442,-2112,-1266,2058,1641,510,-1614,222,-2913,2076,2787,-3933,1848,1914,-78,-3477,-651,2208,117,558,-2829,3477,-3084,621,-105,-1491,3792,2946,-1032,-333,-831,2589,-1209,2577,-3570,2355,591,-3330,879,-3429,-129,-2706,3765,-3816,1182,-954,1191,1098,-3813,1668,864,2019,-1593,1143,1032,1437,-189,-3627,-3216,3399,-3606,-3234,-2691,1710,-393,-156,255,-1704,-2064,153,3789,2409,27,2478,1410,-3834,1653,2838,-1122,1647,-48,-1038,1452,-2427,2775,-948,1506,-828,2553,1818,984,-2439,141,-2616,-918,2889,3120,1800,-432,1707,-606,-2304,-2223,3183,-2169,-3867,-3609,3330,771,-1329,-2952,585,-1821,3189,3558,-294,1224,-2802,2775,708,-1020,-1962,3750,144,-1395,-654,-1077,-1584,600,-1689,-2778,-1305,-831,3039,-3936,-2355,-945,-942,1944,522,366,63,-96,-3609,-3633,-3615,2787,-2076,1050,888,1608,687,2100,-705,690,-2853,2691,-1338,-1149,2406,2067,-3906,888,3861,1803,1797,1536,-387,3114,1965,2607,2817,3567,1227,-3612,-2364,2760,-1281,-546,-1479,201,-1710,-114,1650,-3603,-2916,177,2868,672,-81,3057,-231,-2766,-1524,-2874,648,-1230,-132,3849,-1530,2739,2316,339,-2967,1917,1623,651,-1389,-3885,24,-795,6,-3909,-2499,3120,-558,-2703,1515,1884,654,-63,1785,-1293,-2229,-3864,-3474,-1986,-1734,-3099,3579,-1593,-2046,2880,942,-246,279,-186,1893,-3396,-486,-714,-2391,-111,1536,-2712,-2127,-3300,-3807,3318,-2856,1812,-1713,1020,-2709,-2769,1359,-222,1071,2817,-2364,1500,2757,-99,2811,3081,3111,408,3888,1050,-1242,816,3543,207,750,-1404,591,-2208,-18,-324,564,3162,1773,1794,-1425,2742,3894,-3741,-1377,3627,1224,3516,2583,3648,3216,3237,-1809,1077,231,1461,2616,-3036,3834,2421,-525,2805,720,-1497,2103,-1953,2886,1788,-2946,3579,-2145,1611,-3834,-1707,3237,-324,-102,189,2601,-1419,3372,2604,2925,3624,-3000,3102,-2214,564,-2229,2394,-1875,-612,-54,-942,-1194,-681,-3795,-1704,-570,1638,1056,-1470,813,-1086,-1095,-813,-1956,-780,-1509,-3111,-816,-1380,2949,3642,-1908,-2370,2583,-2949,2247,3204,2820,-2886,3081,1878,-3780,6,-1977,2538,-1389,3423,-3267,-837,-891,-153,-3009,3600,1731,-2874,-2835,1965,3489,3666,3345,-3600,-2829,1647,3735,204,-3414,1218,-1149,-1743,3897,-2280,-3159,-1008,3585,-2526,-2526,222,1851,1998,2703,-1368,1770,-1137,-876,-1158,-3021,-1056,2430,2247,135,-597,-1518,-2427,-3018,441,381,-438,300,-171,2343,699,1092,-453,-1923,1095,1002,3066,-2847,270,-93,2571,-837,-2265,-1491,-1944,-2991,-3564,-2211,-1914,3000,-2088,-930,402,3006,-2898,-3351,1794,732,612,-1782,1191,-1551,3303,-831,405,-3321,681,-663,1623,1653,1479,1587,3516,-516,-3303,-2403,-3051,1635,-2994,-897,-3690,1953,3771,3,-2445,-3195,-369,1686,3192,1617,-2985,1014,2796,1002,-1197,1602,3360,3738,3843,3849,984,-3297,2553,1146,-1098,285,-2907,-3468,309,-2517,-1563,-381,849,3906,2487,-18,-2637,-3552,3870,3018,3423,3585,3363,3813,2133,1656,675,876,2226,-1353,-3576,948,-390,219,273,531,1215,-3249,1578,2286,3171,1428,3708,-3765,-3219,3048,-3486,-1653,3075,3477,-237,-1767,-2811,-363,1488,-1707,-402,1389,39,-15,2769,-1656,-342,3573,2739,-1041,2496,-36,2796,663,78,-678,-3198,885,870,3531,-2973,-1884,-3921,2325,1737,3819,-3342,1026,2694,3084,2706,-2361,-1800,753,3216,3129,2985,2157,2544,1413,-189,-1533,1635,1029,1146,1062,-1158,1392,1341,495,2577,-3162,3492,159,-1788,1290,681,2475,1218,-2025,-1842,3468,3846,579,-2163,-1527,-153,-1176,-2919,2970,-2814,2586,-840,-2733,-2874,-660,2955,2913,-894,-846,2658,-573,2496,1098,-2205,3201,3561,-2790,2427,1185,-1863,3243,-510,2475,-3879,-810,936,3600,2364,-2961,-339,-2094,-1095,2331,-1902,1104,576,-3081,1317,2001,3906,-2133,504,2718,1053,-2070,3813,-24,3717,-1287,3177,2001,1038,-129,3639,-1884,-3909,-3150,-3480,2256,-132,2349,768,-3318,2547,834,-3825,-1731,-1734,-1593,3576,-1926,2286,-150,909,1566,1230,1854,-2682,-2154,-2370,1551,495,3477,3759,2712,-663,-2244,2406,-2139,1713,1335,3150,1413,-261,1392,-2028,1335,-648,-1632,-1188,-2139,189,-2784,3243,-555,2508,2292,-177,-3750,-2277,-2415,-816,-513,801,120,2346,-732,2520,-639,-3006,2667,-177,1758,60,-2334,2298,-3417,2208,-1686,729,-1335,2028,-45,-3930,-2298,-2139,-2376,1002,-1395,-1668,3204,-3489,3714,420,3618,1800,-1437,-543,-2898,1383,552,1134,-3318,537,-738,-1488,-1476,45,2646,-2151,108,-3627,702,2241,-2835,-3849,-3000,-816,963,-3906,2010,3327,-369,2736,1311,291,2118,3555,2706,3150,-1890,-1692,-2343,3204,-939,-3111,-2127,-2541,-3888,-471,-1227,12,-249,2358,-3090,2010,1764,3309,2619,2712,1686,-1809,882,-3330,2082,-33,321,-2691,3387,-1635,1041,-309,2079,2187,-651,-2985,1731,-3741,-711,1428,3015,2535,1977,1563,1242,3900,942,-3264,1512,2670,2799,300,-2172,2034,-2040,561,-3498,-3894,-1155,2463,1419,3252,-2268,-1620,741,2265,384,2520,558,-2634,2169,-2631,981,954,-3171,-3834,735,3687,3621,906,-2934,2232,729,-2505,2970,3501,-153,2580,-2100,1128,84,-846,471,2634,3618,-2625,3312,687,2679,675,-1575,2436,-372,1830,894,-3888,936,-2799,609,-3252,2625,2457,-2049,2823,-519,-12,-1377,-3759,1680,3762,-2646,2142,1653,3042,-1581,1203,405,-3240,1389,-2208,-1155,-2583,96,-3477,1683,2289,-126,-1326,2007,2517,-3264,-2649,-1455},
  {360,1566,564,2598,3609,3720,-1137,-1074,-774,-429,2385,1398,2097,-405,1131,-1806,-1398,-3048,-1074,-864,-3552,462,-510,3255,1821,1455,2541,-378,-3585,-1308,-1137,-1374,-741,480,2838,3378,3138,2256,777,2517,2634,-3711,2967,3270,468,1125,-693,702,3813,-3894,2487,2076,-3825,-3729,-900,-3876,3213,-669,489,-57,2667,15,-1179,-1191,-1656,-1959,-1266,-2298,2430,-1638,-1629,1917,-165,-1140,339,-678,1260,768,-2784,-2925,-2823,-831,2142,3366,2457,1197,-2013,3153,-1857,2154,3939,-2061,744,-213,27,3615,1458,1047,-246,3573,-1701,945,-3258,3417,1575,-1368,3540,-3177,-321,-1689,2874,699,1665,-1332,1455,-1308,948,-45,-1641,-1632,3714,3903,-2100,3009,3033,-2019,2820,2688,3324,-600,3657,-2394,3567,-168,-1320,2397,-2715,2532,-24,-3177,-2523,-1998,2385,-3402,-3099,303,2985,-2664,2361,2382,2460,723,1161,-2412,1308,-2823,2043,3114,-2820,-1038,-2511,-3120,-90,-141,-615,1737,-204,1272,2721,-1542,-126,3231,-1407,201,-1932,-180,1323,3138,933,-3180,2214,2325,-2700,132,-2907,1959,-105,1407,-1287,1341,588,-3768,-3741,-1932,-1458,543,1143,1275,-792,1992,2685,1833,1671,-1467,-2466,294,1200,261,-1560,1596,3297,-3567,273,-783,-2763,-1941,-699,1368,2907,2511,-723,3558,2340,-330,-3576,2451,2220,-1266,-795,1908,-1842,2109,1641,2106,-2295,-2967,27,3663,-846,402,-3075,2841,1683,-2352,-2097,2754,2886,3447,2214,3531,-2607,-1686,-639,1443,-3060,2124,1041,-3174,-825,-3915,-1752,-3750,-1251,3474,-2913,-756,-726,-3924,2259,765,-1122,249,-3477,-2685,1056,-1875,3198,1221,-750,2106,-2328,-3561,-1101,-1713,3393,3408,2994,-948,885,-1923,-1419,-2217,-915,2142,-1302,3519,-2097,-1149,-555,-81,-3108,-3063,-585,3495,-3249,723,2898,3054,-3471,-3552,-3528,141,3510,-1767,978,-3798,1881,-1902,-1731,-1731,-2034,-81,1080,1374,-1725,1602,96,2463,1209,-3894,-1590,1602,-159,1875,2106,-2043,1932,-366,3114,2790,357,1701,-2316,-1476,-2664,1008,1290,-3930,-3738,-975,-2772,3726,1797,-288,648,1179,-3375,2271,1179,-378,-246,1122,-3186,-1497,-3492,-789,1506,-2313,-831,-549,-573,1122,-2193,-1662,-1641,-453,-3165,615,156,2811,57,-1509,-144,3702,-1695,2463,1386,3363,-1941,-1452,2841,1215,-1464,-1878,-1983,1662,-1269,2400,3123,1050,726,2589,480,708,-3474,3186,1758,3717,1995,2586,2241,-2670,-2820,3810,3453,-1131,-1878,-1782,2448,615,2571,-141,876,2283,243,3891,3126,996,228,-3756,1464,3810,-3825,1302,-66,-3603,1689,-1269,3270,2763,252,3270,2436,2505,3771,-2718,-357,-1824,-3594,579,39,558,2130,3696,-303,-489,2982,-3834,-1416,1026,-2235,645,93,-3342,2664,-1575,111,-690,-1359,-1614,-3894,-570,264,-2199,-3624,-3561,-561,-2742,1011,-1230,915,-1305,-840,-3069,162,600,1776,-2160,1068,2865,-3105,-438,-3039,-3861,1230,2490,-1407,-2934,-438,-3702,3555,525,-2133,-3420,-891,2838,2001,-3111,-3192,3648,-2940,-2979,87,3015,3075,324,-2847,-879,-2103,1821,-141,2352,-2511,2019,-2484,1464,-489,3828,1623,-3351,3567,-405,1683,3144,582,2958,-2268,2628,1095,1752,663,3234,-1785,-942,-1584,-1308,2937,2814,-780,2868,-996,-1173,816,1605,-3156,-2814,-2832,-327,2454,1035,-891,-1281,3759,3255,-2910,2484,1233,1599,-696,-3186,3201,2535,-3015,273,-1680,-522,-2316,-3582,2517,-2208,3900,2682,1911,-2187,2196,21,3018,987,-1905,-150,-3003,-3690,1908,-2043,1368,-2811,-3096,828,-3417,-2349,-1209,1989,1488,-171,1590,2166,1134,2904,-2652,1491,-912,-96,-3222,792,1617,1800,-1566,-3747,3273,-2508,-1179,-228,582,-237,-3156,348,1560,1749,1599,3102,-276,2997,2574,-963,3375,-3618,-2529,-129,-2931,2619,2070,426,-717,2139,-885,978,3111,-357,1125,-711,-906,-2781,-2181,-3075,318,-1944,-2415,1047,1071,-1473,2856,-1176,-3015,837,-1992,1671,3477,-1896,2160,441,2232,2730,702,-2754,-660,-2958,135,1989,2394,-3678,3189,1101,2538,2415,-3228,-2781,-837,-210,-3351,1104,-3084,3195,-2412,-1431,501,3465,1941,-945,-3276,-1677,3198,-492,-3507,-945,597,48,3132,-2229,2451,2595,2505,2889,18,-2994,-1866,-852,1392,600,273,-948,378,2943,2664,-3900,-675,963,-2601,588,63,-1647,2232,3102,1476,-2106,1020,207,-885,-1335,-1539,3693,1536,-1290,2766,1503,-1332,-1137,-573,336,-459,1260,-1515,-3609,1017,-30,-1188,324,2313,2973,45,-1809,-3891,-2523,-1242,-135,-2079,-2493,2208,-1416,-2085,-2721,2247,561,696,-2232,2385,-2406,-2334,-3201,2895,-3186,3363,-3129,1368,-3519,-45,-147,699,-312,813,-27,-2946,-1338,3837,-105,3411,-1143,1128,-2505,3279,1743,2574,-3693,3885,2901,2622,-1353,-2919,-3315,-87,2184,-1587,2442,-3885,2493,2118,-705,-3303,-2256,3516,-1116,1152,831,-1875,-3921,-2706,-861,-3531,-3033,909,-2934,-3198,-159,-3729,-3495,1881,180,-2091,-1494,-213,2010,-3900,2256,2367,495,3783,3768,-3087,-2655,-3609,-1185,-822,-687,-2217,672,2625,-1506,-1566,-2424,-2010,2748,2637,2586,2727,3207,2004,1548,1587,-30,-2499,-417,-1941,-2490,-633,312,1035,-2277,-3207,-2355,-3111,-3939,-750,75,-2589,1575,-672,-981,3159,-2832,3906,-1791,-1158,-1347,2505,-3318,3162,-633,-348,1755,690,1716,33,3279,-3918,1368,-1119,-1143,561,441,-3450,-3495,2001,2154,711,-2463,-3468,-3876,-534,1239,54,-3219,906,-3558,1383,1968,3216,1530,1164,-3027,-870,-2409,1401,-465,3585,252,1635,-1587,1368,2310,534,-3630,318,1860,-816,-3204,-2229,-717,708,-351,-1137,-2232,-2223,1749,-288,744,-975,-2316,-903,-3756,867,-1413,-729,3153,-318,1773,1407,2004,1413,3567,1245,2946,-2475,-1161,-2130,-1728,2853,804,-1437,-915,1059,-2652,2595,-2619,-2328,828,3669,-729,2025,-1995,1941,-381,3342,-1173,-165,-3834,-2892,-2955,2991,3741,1275,1878,24,-1692,105,-780,-432,3861,2076,-2277,-402,-1137,327,2268,3426,849,-3588,3222,3738,3237,-2370,1953,-375,1713,3936,-927,870,3075,-1665,-921,2517,1845,-1791,-3597,3837,3534,3057,216,-2574,2217,2877,3177,816,-3315,2328,-2295,435,1341,-1761,3645,-3420,1932,-30,-2793,642,-618,3462,2349,-3927,291,168,-474,3243,-3303,-3207,-3462,-534,720,-1962,363,2274,2151,-3405,-501,546,-1500,-630,-819,1938,-3417,-309,1911,-2913,2739,-1911,3888,1242,3153,1452,1041,1587,735,2175,-1509,-3558,-2745,3351,2175,1281,2274,-3759,-3045,-3321,-3606,1134,3417,-2817,2838,-258,-3414,-318,375,2769,-3420,1242,-3810,-1911,1524,2922,-1743,-3288,-3888,-1290,483,-1257,3048,-18,-534,-129,63,1092,-1437,2904,486,1050,-2475,219,93,3075,1200,312,3774,-582,-330,3912,525,3651,2910,3411,-3075,-468,2136,45,-1227,2334,1179,-948,3666,-3306,-3651,-2046,3054,930,-861,3294,-3291,-249,750,-1392,2637,-567,-1554,3120,2463,2124,3396,3582,2967,-1104,924,-891,1092,3732,-2625,876,3252,3681,720,2655,2958,3621,-3339,-702,3243,-765,-1059,456,-2475,-1917,615,2349,-2679,2148,-3924,435,-3516,3609,603,-3042,-3264,3888,-2154,2295,-528,2664,-2250,-2340,-3213,183,-3924,-3126,-2634,-1410,-2466,63,-1929,-3576,1032,1065,357,-1065,-3897,2649,-474,-432,459,1149,-459,-2352,2712,-2496,-2841,-987,-3813,-72,2481,-2496,-1569,300,2661,-3291,3687,1695,-3282,372,1086,2034,-2496,2388,3792,-585,1806,1158,1743,561,963,-2271,573,642,2313,-3099,-381,3261,3606,2364,1683,-582,54,-1617},
  {-3717,1191,477,966,15,-3903,-1083,-1914,1467,-3828,3222,-1035,-213,-807,-1905,828,-3618,207,651,-2811,-2922,1056,-1455,-1665,1233,-3444,-354,3861,-1320,-3240,-3363,-3897,-1659,2472,474,-309,1803,3255,3252,1800,-3540,1575,-1971,-3714,2430,-3726,1551,522,-3063,-333,-378,75,210,1230,1329,-741,-3489,-1392,-15,-1227,-3393,-1260,-2163,-2286,723,3609,942,3198,-1056,3666,1866,-3207,-453,2589,-3282,2250,3240,-1881,2460,-1590,3378,1620,3009,39,-2637,1494,1068,-498,3603,-2358,-1881,3771,-2418,1911,-2817,-2202,231,2730,-2829,-876,-678,1248,-3336,-2688,2919,-3051,3201,-3930,-3183,2376,-876,-3135,-174,-3903,-1281,1998,-3735,2034,-603,-2208,-3429,3552,-2205,2457,540,765,1947,-3894,-1482,-2100,-3396,-3768,-3870,-1110,-672,-1854,-177,3798,-3423,267,3789,1335,-3243,-2502,-3006,3390,-483,1455,3540,-405,231,-3009,-3528,-3033,1080,-3456,-1842,-2718,3039,-3336,2655,-441,-3858,-2856,2433,1035,-1518,507,3429,2067,-1626,-1704,-3456,-1992,-2142,-3549,1629,3558,-1329,9,2118,-897,-2475,2145,303,1923,1917,2436,-1866,762,831,-2130,-2313,-2565,-3783,-3534,-1986,-2853,-2706,-2235,3669,2310,2712,1839,543,2832,-2301,-3924,3177,-486,-180,-2271,-564,2592,-3861,897,-2961,3582,2889,-3318,-3312,369,3831,-2802,-3498,-1548,2763,-879,-57,3117,-3711,1110,453,-1569,-3231,-3285,-2307,-945,336,2397,2394,3786,1401,-2940,3669,-3024,2769,-897,1605,-555,2739,-600,1134,-147,-1083,-3912,-333,3492,-2073,-831,2529,-3540,-2847,-3429,3927,-3822,1917,-2754,-2880,-1821,-3099,1017,-1467,-2802,-3834,2547,-3084,-1140,3135,-2529,-2760,3303,2397,-822,2667,-729,-1062,2529,-1095,201,-957,1035,-1263,-2388,-2271,-3375,3591,-1284,3156,-1545,-1914,435,1365,-864,-741,-3321,3339,-1635,2124,-3801,3444,1131,-2952,-3429,1806,2229,-198,2640,2937,3687,-858,-174,1749,-1398,1920,-3888,1203,1725,165,3513,2631,-1683,-2541,-2787,1815,-3933,2907,-3264,-27,-132,-1644,336,3066,-3159,-750,3603,-3783,2388,-243,1860,-207,-1950,-402,1911,-1461,-207,-870,-102,-2835,1128,-2823,2937,-3135,2382,-1323,-2166,747,-873,2880,-1953,2385,3372,-1206,-327,3546,-3027,-486,-1626,-2526,3741,-3732,2667,1083,678,192,3855,3120,-3237,882,3474,-3624,2802,1890,2598,1650,3573,3477,-474,3819,3033,2949,-1758,75,3732,-1779,-3648,-1044,1128,-2721,1056,1146,-924,2019,1953,1893,-3201,-477,2808,-1179,3432,3033,78,-1581,1338,-1200,2196,-3930,-2949,-1062,-3048,3900,-594,-1899,3246,-3888,-1884,2505,3186,-3561,-114,933,-249,1737,-3651,3477,2532,150,1362,-3072,-3531,597,-2091,-2328,2205,2364,345,3327,498,-3789,-3372,-3612,3849,-2232,2664,147,2271,-3318,-444,2550,3627,-546,2997,1731,1971,2412,3315,3279,3531,-183,1272,3765,-738,-1281,-2439,-2469,2358,600,396,69,900,630,2808,-1128,-3117,1860,2391,2952,1128,-2247,3015,-2298,-3015,660,2322,849,2835,-2367,-1029,3864,-966,-3084,3504,-1710,3009,-1737,-987,2046,1068,867,-3537,-843,-2661,-1977,996,-2625,-1044,-2799,-969,1614,-3915,-1866,1698,837,1899,3009,-1950,1008,-2592,-735,-1797,-216,1623,-3777,3222,1545,2373,-396,-2397,-1065,-1080,-2205,2541,1212,-225,-327,-348,1830,-2838,1896,3063,-3579,2991,336,1641,-369,-3408,102,1686,3168,-2310,-2826,-2721,-3375,2610,-1122,522,2148,3555,3018,2742,-3120,-855,2991,-2031,780,2208,2784,2376,-1242,-657,783,201,-2199,-2085,945,2868,-183,-2082,-3606,-630,-3555,3792,453,1755,660,1125,-1485,3282,2889,39,-1392,-123,1389,2868,-342,-2349,1158,3399,3591,2094,-2115,783,348,3936,1719,-1203,-2562,-2019,2082,1176,-1689,2184,-3804,-1719,3354,3831,3777,-3669,-549,1911,-1722,1482,3882,2388,-3072,3024,-591,-2712,-3642,-2595,-1293,-1770,-672,-1059,-618,-972,3468,-3447,951,1584,3324,-2349,-3558,-2793,900,-480,3264,2643,-1134,3573,-600,666,1845,-2130,3570,-528,-3684,2493,3621,-3114,444,-957,-825,2793,-1704,3177,1623,3384,1917,2745,3480,-2961,540,1194,-1248,-195,1986,-1446,-228,-3921,-1863,2010,-2754,-3366,1746,2040,3411,2616,-2637,2481,-1938,1005,-2109,165,-1509,-3909,-2769,-2724,537,3141,-1311,-1164,-2049,-1986,531,-723,450,-2649,1566,2967,-294,-306,-2427,-1563,-3042,309,2388,-1089,831,-954,-3420,-1659,-2256,441,-2037,2931,-138,3387,-1644,318,-381,390,-3606,3897,2112,1569,687,3006,3546,3594,3012,-3000,2334,1884,-3675,462,-3912,1752,2661,2805,-2778,3360,2820,-2058,-1893,-2400,-708,-2577,-1896,-3705,-654,3273,2883,-45,3657,2802,894,3699,-3396,1686,2199,-3135,-1680,2445,1089,3087,-2415,3450,3177,-3123,-1863,27,-741,1494,-3150,1914,-702,2019,-2634,-2499,-846,-2646,1929,210,-1971,2769,-693,-2418,1329,3681,2085,1374,2055,99,-3543,-2970,-588,-2595,3105,3048,114,-858,-537,-2094,168,-3645,1524,198,-1551,-2757,-2784,-1938,3516,-1284,-780,-900,-738,-2226,-2205,-3597,-117,-1527,-1977,321,-54,-633,207,2220,273,-567,2277,1308,3555,-1419,-2799,-2145,675,-1821,1026,336,2232,2400,3531,3045,-2337,3651,-2607,-2199,-2088,-3303,-249,135,-2502,-1113,-1368,1749,1065,-2187,1158,1407,-1431,3414,3759,1212,-60,3036,1623,3933,-3237,-828,1782,-3705,-1443,141,2874,-2685,3069,-3465,-2253,-2412,3411,1416,1629,3351,-2775,-3027,2685,3081,558,2610,-3183,2367,-3216,2988,1350,-2688,-3465,-2091,-2844,753,1818,2982,711,3729,2442,-3531,-1152,1485,-2454,-2088,-2202,1452,3522,153,-3669,3165,-1221,-2061,3870,3474,-1923,-99,-603,156,-3630,-3252,54,1905,2553,-402,-807,2061,-756,2985,-1923,-2172,1521,-1368,-360,-942,2919,-2103,-207,435,-2706,-510,2970,1254,2913,183,-6,-3180,1911,-3360,1938,-1230,-2286,-2103,3258,696,-3330,-387,1599,3552,1989,-1638,2784,3855,-1998,-2598,-2349,-222,3549,1722,-9,2730,1338,234,-3597,-2217,-228,-780,2724,1983,-2577,2568,-3894,423,-2595,-3294,1809,-2064,2784,1323,-3591,-1341,-2565,-1464,-2337,-1611,2892,3639,-141,-2418,-2511,-3612,372,-2862,-3429,1848,459,3330,3618,108,2166,-2907,-591,1281,-1173,-1404,-1776,-369,-2634,1791,1995,348,2253,165,3378,-3849,1839,-3420,969,3222,2586,-2286,3930,3567,540,864,264,1584,-3570,834,-1497,954,-3231,3321,-1821,-1650,546,-1614,843,-1368,2361,3582,-3174,-3417,-1980,3003,-3000,1011,-3687,-2286,2766,-2964,2352,159,-2601,252,2970,2115,-1962,-3258,-2358,-3213,1488,-1296,-2538,1212,1425,594,-648,978,-1257,2046,-2670,-3816,2463,2481,-1563,3765,2607,3246,-3651,-723,-1566,-2073,1737,2988,-3111,-2820,-282,-2295,-3081,2148,-3399,2520,-3165,1923,-1437,-3060,-1902,2274,-1074,3549,1845,1260,-3864,-894,-87,-1656,2388,-3876,-1905,1581,195,-3843,3462,1896,-3132,-2124,-1734,-3807,18,390,3465,-2331,-267,741,1464,3348,-489,-2331,-1482,-432,2664,3693,-1227,3030,-405,2145,2241,738,-2535,3819,1167,-681,1986,-414,204,3762,-840,-459,1215,2097,-1803,-2169,3153,2007,-3078,-2052,3897,-156,2211,-3612,-2790,1692,3606,2658,3843,-675,345,2022,1788,432,390,-3309,-2055,-144,3930,-1767,1029,-2580,2652,3075,873,3810,582,3897,-741,-753,1944,1992,-381,408,-375,492,-3735,219,3117,-1206,1860,-1887,2010,-2457,1530,2823,1926,-42,1287,-6,-3819,567,-1038,-3,3045,1806,2451,2547,2694,3699,-3378,213,42,-3609,1236,-828,699,-3726,2463,-3267,1446,-1926,-1305,1458,2871},
} ;

static const unsigned char precomputed_decode_1277x2627_s[precomputed_decode_1277x2627_NUM][crypto_decode_STRBYTES] = {
  {91,176,203,143,48,184,125,167,39,93,209,109,175,57,238,198,9,196,81,157,96,93,26,44,204,161,146,139,204,211,135,168,85,246,36,58,255,225,236,77,21,77,206,188,73,105,160,208,206,235,226,152,89,178,151,142,13,113,219,218,101,42,132,255,235,85,218,234,204,174,208,209,200,231,251,117,151,72,170,211,140,59,165,187,30,39,233,230,246,178,223,39,120,122,91,13,206,154,12,185,211,38,56,177,253,190,222,208,98,46,81,69,240,66,14,149,157,50,108,115,147,166,222,217,55,144,194,176,115,147,54,135,255,151,192,52,88,126,189,177,66,32,56,174,50,54,233,86,21,207,129,3,49,34,246,21,243,80,160,2,244,236,95,203,244,180,210,166,109,8,83,143,229,188,77,75,135,30,196,50,143,117,58,61,25,252,114,167,98,52,134,35,69,60,175,246,85,171,221,191,37,14,231,189,115,235,228,82,174,221,40,83,81,7,79,202,124,27,194,15,227,253,222,24,201,152,189,174,49,180,180,163,179,91,159,113,36,237,165,148,110,254,41,55,117,59,64,72,186,126,38,86,136,67,126,65,70,151,199,192,90,220,8,32,47,137,83,114,142,177,219,63,44,80,221,246,179,211,34,5,97,32,43,134,14,141,156,89,52,68,246,213,0,40,169,153,168,46,116,12,7,40,50,112,171,31,166,98,209,173,69,4,215,169,241,238,93,43,118,132,29,130,78,101,75,221,153,155,104,143,160,44,19,93,57,226,189,232,69,236,207,241,91,169,173,34,40,33,226,254,142,171,56,183,37,150,209,10,129,152,244,58,156,239,249,242,72,140,231,248,166,31,122,137,112,254,18,49,65,146,178,183,61,214,111,253,154,121,194,11,136,18,227,247,144,62,213,112,41,171,182,155,54,140,65,90,83,79,120,81,167,164,116,52,96,242,254,86,235,3,242,28,222,91,133,33,180,167,53,4,25,167,76,247,5,4,221,51,52,203,208,189,139,141,174,226,150,128,249,144,239,161,221,139,53,211,167,175,39,247,136,210,179,228,85,255,120,70,173,147,202,120,152,0,102,184,73,30,113,137,168,55,76,251,85,0,28,152,148,103,90,31,28,135,0,141,123,118,9,245,231,193,37,151,213,217,233,23,196,186,221,21,164,220,229,81,255,177,27,131,139,226,114,139,58,107,41,46,49,156,103,127,196,202,5,18,36,193,226,20,207,133,134,223,14,116,124,10,214,86,213,143,253,72,226,9,144,78,147,78,69,22,245,36,45,45,41,147,204,235,97,13,27,143,21,19,69,125,64,124,63,210,109,208,82,118,230,180,140,221,3,213,5,104,137,107,215,236,47,205,129,87,243,200,95,174,49,122,254,232,136,57,51,196,144,114,121,245,91,189,240,141,185,154,86,246,212,106,202,17,32,75,242,190,194,169,3,196,134,114,84,30,196,95,157,31,185,109,4,187,58,205,214,186,191,228,54,178,216,247,253,113,128,241,107,85,132,119,232,131,61,57,111,33,50,172,63,114,83,40,52,251,86,114,39,142,71,163,249,56,160,203,132,112,154,9,39,124,52,39,189,70,162,153,70,14,61,69,12,207,229,68,239,100,44,243,57,14,148,206,212,180,45,229,109,139,250,74,30,126,123,110,40,153,96,16,154,190,133,207,37,95,199,82,89,214,242,251,143,103,153,211,48,35,217,204,162,55,163,234,111,242,23,175,4,74,62,88,203,156,209,123,136,50,177,244,39,92,163,203,205,57,79,149,63,68,209,14,221,227,43,240,15,217,54,56,31,238,149,148,52,190,94,205,24,52,240,17,65,52,136,184,41,166,188,73,128,99,109,70,105,232,27,127,166,92,241,208,214,17,1,12,70,25,13,33,40,69,142,158,102,7,219,185,55,126,254,120,13,8,212,1,209,163,113,139,241,11,97,157,20,74,213,203,129,152,182,168,67,118,39,74,253,233,237,173,192,218,156,236,184,171,205,137,197,237,81,41,106,132,64,30,198,195,201,102,106,5,143,168,75,11,240,109,194,228,34,19,221,78,206,76,145,224,42,156,227,75,142,246,97,135,5,20,130,236,60,27,37,47,222,166,144,35,113,90,8,194,166,229,111,107,223,95,143,199,254,226,120,183,200,110,222,178,101,35,70,219,224,16,183,184,94,24,144,16,126,102,97,123,13,59,104,77,199,199,251,34,173,245,153,236,161,45,190,29,106,177,231,123,38,193,249,104,207,225,73,249,160,174,216,40,152,47,123,109,215,135,92,22,38,172,114,174,124,210,71,89,68,173,137,128,250,181,107,182,144,107,231,196,68,223,30,203,235,161,107,188,236,134,214,66,68,27,93,86,74,251,154,52,231,95,152,212,16,179,245,27,198,168,41,1,52,151,51,151,0,135,41,96,25,132,36,234,45,22,131,154,252,172,155,19,110,255,50,23,230,49,86,98,85,18,171,122,59,74,184,173,226,61,119,92,113,221,166,63,254,225,40,18,172,134,255,18,60,19,195,232,169,130,105,30,48,61,88,78,121,36,171,0,35,255,141,137,35,159,47,123,126,198,91,241,185,128,82,244,82,135,25,117,137,35,93,185,234,209,37,214,197,238,108,49,78,146,88,173,182,144,96,248,227,134,244,142,127,187,232,81,243,26,83,209,101,127,223,97,219,254,20,111,120,219,130,192,31,26,252,38,86,246,41,159,104,251,44,166,62,139,61,117,22,61,86,9,18,203,55,194,138,6,253,35,98,70,116,9,213,250,252,41,18,173,64,216,26,5,137,80,82,194,223,63,30,206,60,192,16,13,60,132,203,144,211,126,130,46,223,118,41,51,209,254,24,246,112,215,206,25,26,49,9,25,143,245,71,195,241,245,188,143,133,55,215,238,44,111,83,190,10,193,7,140,191,120,29,0,111,232,51,183,10,120,104,244,159,130,120,53,249,37,111,55,211,117,56,92,185,133,151,62,62,228,25,68,237,177,192,53,204,189,178,128,118,156,205,113,149,209,217,235,26,127,231,98,118,164,114,87,124,238,123,159,96,11,79,199,231,21,71,143,134,119,192,138,184,144,182,243,54,18,170,198,208,50,232,193,119,99,202,9,8,217,51,53,98,91,119,105,223,115,176,46,205,78,71,160,59,232,172,235,225,152,173,4,70,28,155,130,228,233,39,154,188,206,234,28,4,80,4,232,106,137,19,140,170,240,43,87,88,218,1,81,84,77,236,19,101,111,121,155,64,143,200,105,45,113,190,217,106,228,107,96,92,113,241,63,191,22,146,142,6,10,16,28,220,203,219,103,251,221,220,74,201,204,38,113,1,146,25,182,139,163,142,253,48,146,75,128,8,170,115,142,35,39,196,34,235,103,195,34,98,187,16,155,230,118,126,175,86,95,181,227,221,116,221,144,116,67,153,137,113,126,165,238,212,218,140,250,206,249,13,4,227,127,82,174,97,6,113,216,73,128,72,8,21,152,212,130,19,53,31,150,20,118,152,150,176,219,201,173,33,36,48,84,199,133,177,99,192,231,144,148,229,201,213,192,166,208,228,200,67,76,101,38,59,166,158,168,215,129,121,242,232,116,32,13,166,95,101,75,172,63,245,53,18,40,136,55,203,220,65,74,181,118,47,72,167,93,252,82,42,126,253,71,252,12,110,254,19,63,241,241,251,12,122,65,205,75,69,199,169,70,180,165,231,123,234,119,81,56,190,60,59,88,231,56,57,93,121,72,175,248,201,67,229,128,186,206,87,150,166,110,161,173,205,202,177,162,5,71,180,63,49,140,213,163,32,131,225,96,147,201,229,121,72,112,8,27,106,33,159,10,56,39,41,160,103,214,39,89,67,14,44,60,253,27,3,110,73,176,139,149,36,16,218,220,165,177,223,246,184,72,41,87,158,125,75,104,31,98,59,14,116,121,208,67,75,0,157,104,88,156,185,101,196,153,205,170,10,208,180,83,39,143,46,136,210,189,9,191,85,121,218,117,247,63,58,200,113,56,244,136,49,67,143,82,68,78,34,184,162,33,3,59,225,153,96,183,245,48,84,189,60,249,173,206,99,159,74,157,43,149,133,29,29},
  {226,199,56,86,85,49,3,23,6,238,154,30,191,232,25,143,203,213,166,205,115,217,93,226,204,116,202,123,52,232,48,169,61,70,199,145,53,211,26,83,123,227,93,138,108,31,45,187,167,20,21,176,65,149,28,119,85,169,158,9,171,122,51,85,70,111,181,236,78,12,77,1,71,128,41,164,105,90,121,145,2,100,56,76,80,88,8,74,124,170,159,15,182,91,101,135,208,56,136,152,238,254,161,241,88,100,174,1,61,213,48,251,112,221,158,52,195,2,10,24,17,76,197,148,82,236,147,172,119,161,31,135,18,102,128,88,217,54,187,24,241,26,91,62,130,204,225,150,147,169,122,30,110,55,3,236,131,191,234,233,252,90,72,120,64,208,35,94,180,237,48,27,131,139,191,153,154,202,55,8,105,19,142,111,76,251,120,230,30,23,19,8,177,114,181,230,178,180,157,169,165,190,42,74,175,30,39,160,195,182,104,186,232,139,207,238,182,134,203,171,50,228,8,18,218,215,240,164,11,194,91,85,125,130,145,45,197,183,53,202,91,175,84,254,53,197,220,104,121,191,255,215,236,64,189,181,19,159,105,19,103,5,117,147,11,192,193,198,185,169,217,176,212,185,34,38,31,64,99,29,82,227,132,11,76,248,204,53,249,133,209,209,8,92,140,57,166,224,32,21,142,146,169,93,143,207,127,155,136,209,179,218,44,170,104,124,205,124,194,179,188,59,255,245,102,249,214,215,112,255,54,7,146,185,155,150,160,22,237,186,155,230,221,82,116,158,114,239,217,57,177,218,63,118,106,64,163,79,146,224,214,139,170,130,173,246,100,143,29,97,12,233,179,241,234,108,109,143,141,181,80,52,108,96,73,114,38,34,123,169,155,124,203,173,181,104,207,14,124,16,132,71,66,6,0,129,251,183,148,172,185,4,22,12,178,183,234,196,105,194,250,206,228,133,70,95,183,90,108,227,31,144,213,239,176,175,226,104,93,248,129,51,170,82,81,53,42,1,53,183,180,6,92,191,65,3,245,65,12,169,55,134,146,138,226,96,66,3,34,159,96,139,121,94,32,23,50,223,170,171,52,36,221,182,11,222,208,151,201,74,57,72,38,127,22,195,27,47,237,65,194,126,158,83,65,101,120,132,119,89,96,84,152,30,151,132,105,0,32,165,90,127,41,177,14,62,78,56,97,20,185,61,91,49,36,64,172,91,8,188,113,7,74,185,179,83,59,136,25,213,31,208,74,98,197,2,252,24,39,60,116,98,90,31,136,94,231,42,247,72,216,27,248,39,44,108,27,140,69,247,32,217,133,69,172,163,43,177,234,75,140,174,184,87,54,213,105,30,110,179,86,140,112,111,66,229,233,38,122,82,90,231,149,161,31,72,121,175,100,27,24,163,97,104,89,235,94,8,134,44,80,25,247,4,202,32,27,167,32,145,130,142,41,117,132,42,219,210,183,86,31,45,92,180,84,118,187,22,122,21,22,45,183,160,239,118,132,16,205,139,43,221,236,136,230,3,21,37,106,200,44,56,102,19,80,53,85,84,134,249,220,66,53,121,170,26,157,194,94,182,155,141,148,97,126,115,66,154,233,188,75,66,128,228,33,167,15,145,196,164,109,101,148,232,54,91,239,52,183,42,17,235,216,154,123,91,241,98,225,119,154,44,181,134,245,175,220,172,15,55,79,135,13,205,61,94,204,0,171,154,202,69,140,159,157,62,240,0,20,98,59,171,243,3,233,16,132,196,160,4,220,241,233,154,28,213,89,142,230,198,4,15,218,187,126,85,242,107,145,163,241,131,120,223,179,167,175,87,74,12,120,251,106,180,110,79,118,198,2,4,165,169,250,141,229,4,159,209,50,191,120,252,136,207,53,195,34,193,86,254,209,230,177,106,194,87,81,103,210,154,208,43,207,173,26,102,9,221,250,113,222,76,116,227,51,184,97,8,28,52,10,159,158,22,224,186,158,128,60,21,27,136,121,69,250,45,80,166,198,18,94,68,41,255,164,2,111,178,228,234,209,71,0,242,63,64,84,223,47,4,32,167,218,210,169,150,79,160,64,141,131,167,30,34,104,125,21,248,32,47,145,147,58,22,74,75,253,194,219,193,63,240,111,7,206,14,210,192,110,153,149,164,36,17,218,112,123,60,179,33,145,184,140,41,197,255,213,49,152,63,221,16,200,195,127,218,150,213,94,39,176,65,86,27,131,2,223,63,116,90,166,59,33,218,245,95,43,188,183,150,1,81,64,24,237,135,16,70,212,182,18,35,48,230,211,236,165,170,41,140,61,121,169,108,176,47,223,203,28,24,52,211,52,249,248,69,58,229,117,206,190,201,108,135,79,191,214,43,168,143,249,255,0,197,120,42,15,248,215,40,79,76,61,53,111,188,250,89,150,255,168,81,177,123,204,76,74,118,52,88,241,34,43,98,243,189,100,113,43,15,22,7,111,91,143,12,62,72,130,184,134,99,165,29,106,206,75,207,254,195,197,62,143,236,125,48,47,153,74,53,172,187,204,196,161,29,249,52,220,139,169,41,24,193,178,8,59,115,36,20,82,176,157,86,55,206,39,40,24,126,189,223,197,230,37,125,104,41,153,56,108,178,138,210,42,135,68,226,130,195,168,172,107,186,216,137,178,139,158,196,62,11,170,85,149,172,98,209,13,35,9,232,34,142,81,28,124,254,84,235,28,83,180,117,16,130,69,103,41,104,96,235,133,198,170,117,46,47,15,114,165,31,112,182,18,89,43,217,121,152,3,217,36,175,59,49,238,25,190,180,205,65,219,51,136,126,96,92,11,125,10,107,38,237,48,66,77,78,168,183,163,92,243,39,236,33,143,49,166,62,236,238,246,74,107,61,243,128,176,106,85,49,72,31,85,209,74,53,64,206,194,158,220,123,195,136,133,7,25,52,75,84,250,85,77,166,252,21,199,74,27,210,39,129,162,32,38,46,14,221,118,245,67,33,247,31,85,229,17,222,24,140,246,109,204,230,82,42,236,200,147,67,165,99,202,122,2,203,5,191,149,99,54,179,174,78,189,83,176,222,13,163,201,193,85,85,1,39,108,93,70,90,154,81,142,3,165,24,245,221,184,166,236,171,92,122,189,40,39,115,2,200,153,83,239,182,126,218,37,73,81,106,74,102,159,4,171,171,182,114,77,106,74,19,45,94,193,56,193,150,72,162,193,255,45,139,193,188,244,158,8,168,29,137,169,36,100,225,178,214,225,2,208,119,116,174,8,94,194,188,61,212,157,167,192,175,35,230,175,41,216,254,234,143,202,176,253,215,70,149,144,129,116,161,57,163,126,152,185,145,200,36,242,68,113,85,207,219,143,208,250,120,31,52,68,39,26,154,78,84,207,17,238,193,236,74,42,100,213,51,78,157,190,221,225,108,164,180,234,146,58,213,52,121,118,71,140,253,157,86,52,82,199,181,210,10,2,189,79,200,115,135,27,64,172,144,2,220,148,74,158,39,185,198,47,61,47,61,136,123,165,21,88,85,48,112,36,84,12,24,29,250,6,161,29,134,236,55,35,92,197,178,27,163,3,87,13,51,200,138,225,164,74,35,208,252,187,21,35,207,90,206,150,237,11,195,185,214,176,97,171,167,186,51,230,129,107,55,25,151,250,88,113,168,104,75,89,49,78,112,64,66,105,202,2,248,121,155,198,163,86,151,31,200,60,51,162,50,168,103,228,120,165,58,78,186,42,132,213,65,135,133,55,244,240,168,57,89,42,231,223,43,177,43,198,211,40,2,57,251,14,226,110,135,55,240,176,165,102,42,30,56,158,108,166,181,226,133,41,112,178,71,124,147,213,156,50,127,22,219,207,238,243,203,199,155,126,23,244,2,57,239,149,212,212,103,128,81,204,191,231,115,150,239,43,55,95,186,148,212,31,57,10,236,50,40,13,198,210,36,226,5,87,56,61,86,36,255,155,110,255,127,113,24,101,248,86,229,157,208,140,75,221,114,245,2,128,143,186,211,8,50,69,197,89,174,204,200,150,220,145,130,237,160,86,164,215,205,3,42,48,236,224,222,30,92,236,167,88,7,96,25,181,50,95},
  {218,147,38,94,255,95,151,75,85,234,213,87,42,64,175,134,10,235,254,25,114,206,17,36,18,26,25,157,253,39,107,73,173,15,40,205,170,207,92,73,115,20,231,91,133,175,27,7,142,241,29,103,120,206,116,219,150,186,110,228,140,221,84,187,181,119,164,240,8,199,226,65,25,107,15,152,104,235,247,141,152,136,52,163,100,168,54,197,67,108,24,34,39,207,44,244,1,166,39,100,254,68,159,74,121,97,55,56,0,21,125,1,187,220,141,46,19,14,65,214,25,210,137,216,148,176,240,148,192,166,173,174,193,108,41,172,31,120,147,51,45,241,21,53,42,175,63,18,165,125,11,83,219,109,49,240,23,69,138,196,79,243,89,196,128,219,120,165,201,15,121,210,120,84,140,60,63,150,143,42,123,186,196,102,226,207,96,115,20,144,208,78,89,209,61,230,124,177,132,67,44,40,246,14,52,145,25,37,248,247,224,1,208,48,214,179,51,237,156,55,57,48,6,65,239,97,54,191,47,36,91,210,161,204,240,254,92,152,188,4,156,152,197,59,75,112,61,185,177,215,73,28,210,237,20,4,57,63,175,163,86,137,53,16,5,137,7,133,114,226,7,249,0,194,145,154,115,251,132,201,19,15,228,193,127,52,246,255,40,246,130,5,113,68,17,170,204,73,250,144,129,181,232,88,156,75,248,120,95,44,121,132,47,15,180,232,73,63,128,131,13,143,10,4,71,12,195,143,161,160,116,12,34,180,71,93,90,197,56,242,160,97,252,234,60,27,33,115,215,154,54,108,251,207,119,104,126,250,83,155,84,164,5,162,99,23,241,192,202,79,231,163,235,110,28,151,76,218,51,54,50,125,138,29,110,141,245,151,145,61,118,230,6,141,45,217,125,182,111,178,147,63,40,29,48,52,83,83,247,54,193,252,122,139,152,142,220,212,155,225,208,199,19,41,136,164,186,249,100,119,14,145,95,7,91,130,66,180,17,150,94,88,121,34,143,90,45,71,153,94,127,27,250,11,182,29,44,112,110,90,32,66,85,255,213,158,183,110,49,20,248,3,69,69,99,13,211,2,199,56,28,56,239,163,82,171,164,204,25,240,131,200,250,11,152,237,249,112,60,47,50,175,161,241,49,145,248,23,220,96,13,213,232,239,9,255,96,228,228,248,197,19,162,157,64,51,21,204,138,226,20,66,61,171,148,45,20,193,9,17,195,221,67,14,152,42,21,68,244,247,35,249,217,25,42,9,141,68,65,126,218,135,160,41,174,211,222,5,234,19,22,138,168,72,10,171,66,199,107,41,210,129,118,112,117,241,205,218,51,163,241,84,5,93,81,25,248,178,100,63,182,56,201,95,204,153,150,117,99,143,52,93,170,55,231,181,215,147,59,40,87,153,217,124,4,73,97,7,119,27,221,177,27,204,135,83,56,234,110,161,160,90,112,58,239,182,172,229,52,40,249,124,170,141,150,173,246,160,168,249,228,243,220,209,243,247,227,85,13,142,214,35,108,219,218,31,118,58,4,133,248,96,193,238,243,121,91,215,183,98,123,83,201,132,180,243,218,8,51,58,2,24,194,1,187,75,99,226,88,86,16,68,152,165,2,66,236,172,107,252,1,250,0,142,230,131,173,126,42,165,74,28,246,132,39,108,38,207,240,252,58,108,125,191,215,115,85,35,23,124,242,107,121,65,124,249,36,99,2,123,152,235,95,215,146,84,28,190,172,72,162,40,244,212,249,131,121,222,151,24,44,220,141,163,226,175,117,124,120,75,52,194,154,68,126,101,179,47,24,245,241,81,232,110,37,150,196,87,47,213,189,69,50,241,5,62,167,125,252,193,195,194,66,64,33,34,146,27,253,115,187,130,2,239,235,16,181,173,215,129,128,198,8,71,105,4,32,41,176,204,195,119,129,158,205,138,66,65,226,91,205,55,24,132,108,88,55,66,34,17,3,95,41,209,120,59,36,43,157,78,85,166,204,174,79,138,209,211,155,189,191,165,145,84,169,53,107,25,94,149,222,118,2,233,152,95,248,139,95,239,73,113,210,190,28,216,41,52,3,164,140,29,65,244,110,28,53,54,121,117,6,114,107,9,114,116,18,134,200,38,114,129,48,214,80,15,17,247,145,210,116,2,76,151,115,179,235,117,160,198,226,198,7,87,109,111,202,81,101,5,66,32,62,141,159,104,18,107,201,56,170,171,248,179,242,237,92,1,14,146,201,254,19,108,53,39,6,167,67,192,48,11,219,58,9,61,211,60,13,117,13,245,75,3,46,175,7,236,15,188,184,137,5,73,41,190,64,86,0,81,162,148,17,228,151,141,211,66,172,29,161,92,149,255,82,146,118,88,220,114,17,85,176,101,51,14,10,133,162,81,214,136,145,96,226,68,225,125,97,103,160,240,158,156,127,180,49,1,20,47,236,59,119,151,115,201,121,145,244,122,244,127,169,244,224,186,209,10,58,242,219,115,87,80,175,142,152,8,17,169,3,248,0,192,59,1,131,96,76,175,57,25,9,95,40,132,24,126,211,116,242,40,55,150,42,229,117,179,106,20,56,61,169,175,99,141,242,148,128,48,200,65,169,106,90,161,243,217,136,114,221,38,243,177,223,171,1,225,117,226,179,147,204,9,69,80,240,253,223,60,159,152,156,27,95,74,71,48,48,14,197,250,98,127,113,149,236,219,28,222,60,59,153,172,18,186,14,6,234,227,177,155,242,153,107,181,173,56,232,112,204,177,144,224,36,108,76,109,104,147,221,84,63,200,56,134,76,224,171,173,214,178,29,205,163,172,77,53,34,230,167,206,254,41,170,79,176,84,143,199,85,242,130,133,204,75,99,143,126,139,153,217,171,38,184,94,151,56,208,7,173,169,186,249,93,34,159,101,97,220,57,62,52,181,115,244,19,31,239,201,94,78,46,234,32,45,132,179,28,45,150,132,66,47,8,187,146,232,194,65,94,157,220,118,20,161,151,94,83,184,114,156,203,78,204,101,32,75,243,69,132,175,52,87,78,148,39,157,252,24,71,36,36,96,91,169,9,140,96,168,213,141,232,140,120,82,115,229,83,59,112,83,131,156,95,248,15,21,187,26,52,17,242,80,66,114,156,189,156,144,129,199,209,48,9,255,121,75,210,253,71,41,188,106,12,34,2,87,149,38,171,89,47,210,16,180,167,144,206,139,66,29,222,50,243,119,31,193,98,17,108,238,201,50,175,171,192,109,189,107,42,39,72,109,5,22,79,53,205,207,204,223,197,188,78,30,159,141,194,206,96,167,211,157,180,184,26,16,160,86,29,153,50,228,233,83,57,93,175,43,132,220,5,236,99,71,100,180,70,20,2,138,101,112,176,217,219,59,48,15,74,185,133,0,47,100,53,185,152,13,55,197,25,8,32,26,210,3,26,246,238,222,106,88,131,221,18,183,177,149,183,236,33,246,201,160,26,142,212,35,212,124,68,201,6,204,241,187,194,172,65,180,116,211,15,23,89,15,3,140,162,161,173,38,138,207,9,188,249,229,34,173,14,0,244,23,42,219,249,103,134,203,140,18,86,151,143,183,25,204,19,66,22,138,149,201,103,99,71,39,72,31,109,127,20,195,12,51,60,174,132,152,165,12,212,219,90,46,0,158,132,44,29,208,148,39,228,100,240,105,30,108,234,157,254,139,87,124,47,12,173,58,110,9,243,204,91,236,139,107,34,108,207,249,13,209,18,149,111,126,233,41,167,67,245,25,53,124,155,221,123,190,183,233,10,189,166,125,120,104,33,46,48,79,92,31,101,229,202,146,189,21,127,81,59,149,159,136,164,249,121,89,9,213,44,173,33,188,128,133,156,28,45,167,66,237,97,189,218,147,126,29,255,33,237,79,146,19,121,49,126,236,210,80,105,183,126,249,114,182,189,155,69,157,159,157,251,233,54,47,154,67,122,154,45,123,149,52,39,234,9,240,23,61,64,97,174,201,27,195,146,44,152,149,161,200,47,3,55,68,8,80,167,103,119,0,63,97,128,65,91,136,82,170,111,114,177,93,227,225,122,104,57,183,17,107,112,183,19,72,43,202,173,109,4},
  {212,139,169,143,74,128,97,18,185,130,171,214,22,222,133,180,29,102,98,24,22,191,158,101,235,163,35,61,100,90,243,221,67,172,109,134,20,39,8,184,143,173,49,4,224,224,83,162,186,47,209,166,88,22,218,193,201,8,180,65,109,204,133,24,142,224,252,98,54,161,107,207,10,62,200,178,227,136,66,107,126,80,22,48,171,153,182,0,191,41,76,7,85,44,255,54,59,33,169,238,194,82,236,183,102,230,158,117,231,97,33,194,148,205,103,87,89,207,91,37,45,24,62,120,53,224,32,239,162,149,160,73,228,204,38,224,223,101,154,51,42,130,69,52,152,238,18,23,11,66,144,114,147,27,172,122,64,83,177,23,192,197,150,120,58,126,5,107,142,73,254,223,124,4,93,56,73,51,210,195,69,173,172,76,236,88,199,53,208,210,7,50,252,93,137,105,73,133,67,198,17,137,187,60,137,126,250,130,129,44,105,78,40,72,254,157,103,127,17,85,165,144,79,59,42,243,174,235,158,76,197,118,122,176,250,189,82,3,81,174,44,64,27,96,187,67,30,174,112,62,253,165,107,177,19,96,249,78,146,137,59,93,234,209,115,154,1,221,39,78,116,57,105,52,249,169,76,103,56,224,83,197,45,174,164,236,3,112,224,84,208,121,203,188,96,139,109,131,23,6,57,116,43,29,20,70,122,210,239,223,235,199,199,209,147,113,210,236,62,238,120,82,21,251,20,182,210,180,116,151,94,45,82,102,4,28,205,13,55,227,240,33,43,117,29,202,43,138,183,128,97,152,245,46,206,224,188,72,123,181,80,225,125,118,21,180,148,253,35,146,11,184,171,70,79,57,72,236,215,159,147,68,83,183,83,41,111,106,252,18,126,18,224,95,159,102,241,85,86,50,61,45,113,132,51,230,208,183,89,191,166,79,198,193,250,227,29,43,163,128,133,181,111,133,200,252,97,58,122,235,6,188,121,3,88,117,249,59,47,28,66,84,132,224,47,128,200,217,185,116,32,183,25,26,241,69,139,82,169,147,217,15,68,60,20,255,182,179,129,32,131,177,248,254,27,245,20,217,127,165,73,207,82,14,67,37,24,242,95,173,142,44,95,255,199,155,4,189,222,236,191,90,50,174,50,137,234,227,134,195,112,116,11,217,102,116,154,238,84,101,134,23,21,243,69,176,150,176,83,89,120,84,134,7,145,156,244,5,10,163,19,86,239,174,204,93,35,159,41,55,146,151,183,166,251,255,144,189,115,150,10,153,93,148,249,28,252,45,94,205,181,71,17,130,216,158,179,41,232,77,29,54,122,135,104,40,172,105,213,221,82,87,2,200,51,250,229,212,28,55,243,76,118,26,197,175,39,127,238,47,57,0,199,250,101,67,205,18,31,166,82,26,152,62,14,150,75,169,18,96,25,211,217,169,89,219,154,165,196,46,208,113,38,148,148,10,103,105,163,245,171,254,129,127,42,169,145,156,49,210,43,72,121,80,16,62,151,251,255,98,22,140,89,51,90,157,117,241,209,15,219,221,90,247,181,23,25,224,188,86,251,26,162,155,33,10,52,87,103,66,177,127,136,169,2,235,109,159,198,201,235,17,106,216,200,105,133,61,124,159,131,23,215,26,98,254,65,66,165,77,176,143,64,193,195,195,223,28,159,232,149,119,77,136,208,205,17,232,94,228,75,220,11,180,101,160,231,209,236,176,248,148,42,214,73,206,132,10,240,36,70,136,230,42,237,146,7,55,19,35,115,97,152,16,249,27,161,20,110,41,34,198,225,79,126,231,153,188,116,240,178,0,35,156,164,53,253,159,83,63,212,74,153,119,196,163,235,86,160,215,89,5,20,252,13,243,157,249,183,100,16,48,99,171,255,242,6,78,58,206,18,190,84,131,60,159,156,231,24,148,102,63,50,238,121,49,181,80,168,19,215,35,154,181,254,249,200,82,106,37,12,187,2,91,60,108,136,65,229,129,56,116,105,196,145,3,92,111,5,117,189,66,101,221,140,55,254,53,81,146,221,39,48,135,69,202,122,94,105,105,189,150,58,111,20,49,12,213,48,135,30,67,64,143,6,190,214,177,193,178,72,129,2,123,231,123,209,124,106,189,146,10,179,182,26,236,96,27,224,22,160,81,151,187,86,46,7,27,5,75,132,47,49,136,199,158,103,97,30,16,26,145,114,118,192,210,8,108,134,28,86,41,33,196,252,57,83,138,186,247,171,118,185,30,117,198,179,44,132,237,87,172,157,173,235,32,236,200,172,2,108,58,79,41,113,243,153,72,5,160,15,21,207,87,26,183,181,19,46,29,255,73,163,87,99,96,146,105,133,83,223,37,230,28,251,209,192,195,193,226,67,182,149,145,185,79,24,222,97,61,205,246,29,181,180,30,17,85,216,50,76,209,224,198,11,100,72,2,115,152,172,22,133,96,85,134,137,250,43,196,15,37,137,22,202,15,179,201,93,1,37,237,252,27,101,181,164,87,50,213,113,152,62,183,159,251,98,166,106,208,48,243,87,9,240,248,225,241,179,149,179,244,47,252,37,86,47,78,104,84,241,193,172,6,251,16,23,127,190,175,47,134,188,223,54,196,194,77,174,0,100,65,99,198,208,220,236,133,16,141,192,100,198,128,38,223,105,2,129,33,94,79,17,134,162,170,224,142,60,33,58,235,161,131,74,173,50,169,246,123,190,55,59,150,137,102,190,62,88,47,226,166,157,171,200,110,153,112,135,183,187,15,7,47,123,192,73,144,127,185,28,150,20,71,221,25,51,57,2,143,157,141,145,114,9,213,9,97,156,25,235,147,66,53,39,155,73,204,40,178,249,22,243,122,249,109,36,152,159,222,246,2,160,236,67,32,38,202,217,4,101,139,194,236,149,184,71,149,166,51,38,224,86,8,239,35,12,105,139,135,221,171,101,78,211,169,118,251,216,7,167,99,237,65,8,36,186,146,130,95,116,254,120,238,140,57,5,197,198,13,144,99,159,205,47,113,185,4,237,164,65,247,247,69,239,154,178,47,51,192,179,27,144,215,126,145,84,16,43,159,145,150,80,217,60,114,223,4,228,119,130,213,222,153,127,46,61,77,242,255,146,99,95,138,226,45,119,228,37,252,129,27,178,89,66,25,106,82,140,110,195,154,10,236,82,63,171,98,22,1,42,54,100,119,231,155,180,84,41,45,234,130,190,12,156,228,139,67,3,40,70,37,246,191,31,54,100,219,89,83,12,82,12,222,230,141,5,66,155,90,85,194,217,41,166,12,57,49,152,27,148,68,141,165,50,61,118,64,232,233,240,123,114,194,47,176,149,49,65,229,170,135,146,21,106,9,40,187,4,73,180,204,147,99,235,126,144,20,51,243,255,242,52,193,133,14,108,14,54,129,72,192,156,220,128,138,180,253,8,202,203,4,128,166,88,212,219,235,199,135,62,113,112,227,124,195,89,73,111,254,144,130,38,204,189,240,179,61,144,34,78,94,119,31,99,11,78,133,196,172,38,105,198,44,206,209,206,106,204,188,60,203,129,210,226,198,213,198,18,173,224,44,179,72,55,192,206,233,76,100,24,43,110,248,162,77,106,223,197,154,61,153,138,33,52,238,84,248,167,80,60,17,89,59,167,87,97,130,71,23,226,146,104,217,208,218,226,193,115,243,101,141,214,39,134,145,63,87,251,108,7,181,54,178,54,44,31,30,52,94,147,178,176,190,19,228,138,33,0,12,255,144,206,163,71,13,144,254,186,115,30,0,39,187,10,198,31,17,152,113,234,196,42,2,69,158,99,43,2,5,238,30,245,51,151,104,146,32,127,83,125,92,176,93,161,28,225,174,68,178,116,86,47,129,244,243,249,164,57,42,70,196,32,36,97,34,61,238,245,171,185,83,20,204,221,68,99,183,32,116,170,58,50,110,233,34,224,245,212,15,105,27,218,236,75,54,238,30,34,154,238,116,113,177,49,24,13,175,187,0,135,105,45,211,119,210,96,126,205,165,198,33,192,222,115,207,132,60,217,80,151,29,93,49,129,105,168,193,35,82,201,106,118,208,3,249,186,62,133,177,163,133,48,115,250},
} ;

static void test_decode_1277x2627_impl(long long impl)
{
  unsigned char *x = test_decode_1277x2627_x;
  unsigned char *s = test_decode_1277x2627_s;
  unsigned char *x2 = test_decode_1277x2627_x2;
  unsigned char *s2 = test_decode_1277x2627_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1277x2627_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1277x2627(impl);
    printf("decode_1277x2627 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277x2627_implementation(impl),ntruprime_dispatch_decode_1277x2627_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1277x2627;
    printf("decode_1277x2627 selected implementation %s compiler %s\n",ntruprime_decode_1277x2627_implementation(),ntruprime_decode_1277x2627_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1277x2627_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1277x2627_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1277x2627_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1277x2627_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1277x2627_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1277x2627_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1277x2627(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277x2627")) return;
  storage_decode_1277x2627_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1277x2627_x = aligned(storage_decode_1277x2627_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1277x2627_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1277x2627_s = aligned(storage_decode_1277x2627_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1277x2627_x2 = callocplus(maxalloc);
  test_decode_1277x2627_x2 = aligned(storage_decode_1277x2627_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1277x2627_s2 = callocplus(maxalloc);
  test_decode_1277x2627_s2 = aligned(storage_decode_1277x2627_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1277x2627 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1277x2627();++impl)
      forked(test_decode_1277x2627_impl,impl);
    ++test_decode_1277x2627_x;
    ++test_decode_1277x2627_s;
    ++test_decode_1277x2627_x2;
    ++test_decode_1277x2627_s2;
  }
  free(storage_decode_1277x2627_s2);
  free(storage_decode_1277x2627_x2);
  free(storage_decode_1277x2627_s);
  free(storage_decode_1277x2627_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

