------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2010-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;               use Ada.Text_IO;

package body Test_Refcount_Support is

   overriding procedure Free (Self : in out My_Type) is
   begin
      Put_Line ("Freeing" & Self.Value'Img);
      Free (Weak_Refcounted (Self));
   end Free;

   function Create (Value : Integer) return access My_Type is
   begin
      Put_Line ("Allocate" & Value'Img);
      return new My_Type'(GNATCOLL.Refcount.Weakref.Weak_Refcounted
                          with Value => Value);
   end Create;

end Test_Refcount_Support;
