/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.ErrorExp;
import gnu.expr.ScopeExp;
import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Procedure1;
import gnu.text.Printable;
import gnu.text.ReportFormat;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.lang.Macro;
import kawa.lang.Pattern;
import kawa.lang.PatternScope;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxPattern;
import kawa.lang.SyntaxRule;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class SyntaxRules
extends Procedure1
implements Printable,
Externalizable {
    Object[] literal_identifiers;
    SyntaxRule[] rules;
    int maxVars = 0;

    public SyntaxRules() {
    }

    public SyntaxRules(Object[] literal_identifiers, SyntaxRule[] rules, int maxVars) {
        this.literal_identifiers = literal_identifiers;
        this.rules = rules;
        this.maxVars = maxVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxRules(Object[] literal_identifiers, Object srules, Translator tr) {
        int i;
        this.literal_identifiers = literal_identifiers;
        int rules_count = Translator.listLength(srules);
        if (rules_count < 0) {
            rules_count = 0;
            tr.syntaxError("missing or invalid syntax-rules");
        }
        this.rules = new SyntaxRule[rules_count];
        SyntaxForm rules_syntax = null;
        for (i = 0; i < rules_count; ++i) {
            while (srules instanceof SyntaxForm) {
                rules_syntax = (SyntaxForm)srules;
                srules = rules_syntax.form;
            }
            Pair rules_pair = (Pair)srules;
            SyntaxForm rule_syntax = rules_syntax;
            Object syntax_rule = rules_pair.car;
            while (syntax_rule instanceof SyntaxForm) {
                rule_syntax = (SyntaxForm)syntax_rule;
                syntax_rule = rule_syntax.form;
            }
            if (!(syntax_rule instanceof Pair)) {
                tr.syntaxError("missing pattern in " + i + "'th syntax rule");
                return;
            }
            SyntaxForm pattern_syntax = rule_syntax;
            Pair syntax_rule_pair = (Pair)syntax_rule;
            Object pattern = syntax_rule_pair.car;
            String save_filename = tr.getFileName();
            int save_line = tr.getLineNumber();
            int save_column = tr.getColumnNumber();
            try {
                SyntaxForm template_syntax = rule_syntax;
                tr.setLine(syntax_rule_pair);
                syntax_rule = syntax_rule_pair.cdr;
                while (syntax_rule instanceof SyntaxForm) {
                    template_syntax = (SyntaxForm)syntax_rule;
                    syntax_rule = template_syntax.form;
                }
                if (!(syntax_rule instanceof Pair)) {
                    tr.syntaxError("missing template in " + i + "'th syntax rule");
                    return;
                }
                syntax_rule_pair = (Pair)syntax_rule;
                if (syntax_rule_pair.cdr != LList.Empty) {
                    tr.syntaxError("junk after " + i + "'th syntax rule");
                    return;
                }
                Object template = syntax_rule_pair.car;
                PatternScope patternScope = PatternScope.push(tr);
                tr.push(patternScope);
                while (pattern instanceof SyntaxForm) {
                    pattern_syntax = (SyntaxForm)pattern;
                    pattern = pattern_syntax.form;
                }
                StringBuffer programbuf = new StringBuffer();
                if (!(pattern instanceof Pair)) {
                    tr.syntaxError("pattern does not start with name");
                    return;
                }
                literal_identifiers[0] = ((Pair)pattern).car;
                Pair p = (Pair)pattern;
                programbuf.append('\f');
                programbuf.append('\u0018');
                pattern = p.cdr;
                SyntaxPattern spattern = new SyntaxPattern(programbuf, pattern, pattern_syntax, literal_identifiers, tr);
                this.rules[i] = new SyntaxRule(spattern, template, template_syntax, tr);
                PatternScope.pop(tr);
                tr.pop();
            }
            finally {
                tr.setLine(save_filename, save_line, save_column);
            }
            srules = rules_pair.cdr;
        }
        i = this.rules.length;
        while (--i >= 0) {
            int size = this.rules[i].patternNesting.length();
            if (size <= this.maxVars) continue;
            this.maxVars = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply1(Object arg) {
        if (arg instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)arg;
            Translator tr = (Translator)Compilation.getCurrent();
            ScopeExp save_scope = tr.currentScope();
            tr.setCurrentScope(sf.scope);
            try {
                Object object2 = this.expand(sf, tr);
                return object2;
            }
            finally {
                tr.setCurrentScope(save_scope);
            }
        }
        return this.expand(arg, (Translator)Compilation.getCurrent());
    }

    public Object expand(Object obj, Translator tr) {
        Object[] vars = new Object[this.maxVars];
        Macro macro = (Macro)tr.getCurrentSyntax();
        for (int i = 0; i < this.rules.length; ++i) {
            SyntaxRule rule = this.rules[i];
            if (rule == null) {
                return new ErrorExp("error defining " + macro);
            }
            SyntaxPattern pattern = rule.pattern;
            boolean matched = ((Pattern)pattern).match(obj, vars, 0);
            if (!matched) continue;
            Object expansion = rule.execute(vars, tr, TemplateScope.make(tr));
            return expansion;
        }
        return tr.syntaxError("no matching syntax-rule for " + this.literal_identifiers[0]);
    }

    public void print(Consumer out) {
        out.write("#<macro ");
        ReportFormat.print(this.literal_identifiers[0], out);
        out.write(62);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.literal_identifiers);
        out.writeObject(this.rules);
        out.writeInt(this.maxVars);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.literal_identifiers = (Object[])in.readObject();
        this.rules = (SyntaxRule[])in.readObject();
        this.maxVars = in.readInt();
    }
}

