#ifndef NETWORKPROPERTIES_H
#define NETWORKPROPERTIES_H

#include <QObject>
#include <QString>

class NetworkPropertiesModel : public QObject {
    Q_OBJECT
    Q_PROPERTY(QStringList ipAddress
            READ ipAddress
            WRITE setIpAddress
            NOTIFY ipAddressChanged)
    Q_PROPERTY(QString netmask
            READ netmask
            WRITE setNetmask
            NOTIFY netmaskChanged)
    Q_PROPERTY(QString gateway
            READ gateway
            WRITE setGateway
            NOTIFY gatewayChanged)
    Q_PROPERTY(QString password
            READ password
            WRITE setPassword
            NOTIFY passwordChanged)
public:
    explicit NetworkPropertiesModel(QObject *parent = nullptr);
    ~NetworkPropertiesModel();
    const QStringList ipAddress() const;
    void setIpAddress(const QStringList &ipAddress);
    const QString netmask() const;
    void setNetmask(const QString &netmask);
    const QString gateway() const;
    void setGateway(const QString &gateway);
    const QString password() const;
    void setPassword(const QString &password);

Q_SIGNALS:
    void ipAddressChanged();
    void netmaskChanged();
    void gatewayChanged();
    void passwordChanged();

private:
    QStringList m_ipAddress;
    QString m_netmask;
    QString m_gateway;
    QString m_password;
};

#endif // NETWORKPROPERTIES_H
