/*
 * Copyright (C) 2024 Guido Berhoerster <guido+ubports@berhoerster.name>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "ActionRegistry.h"
#include "ItemRegistry.h"
#include "ListenerRegistry.h"
#include "ServiceRegistry.h"

#define PLUGMAN_URI "PlugMan"

void
registerPlugManQmlTypes()
{
    qmlRegisterType<ActionRegistry>(PLUGMAN_URI, 1, 0, "ActionRegistry");
    qmlRegisterType<ItemRegistry>(PLUGMAN_URI, 1, 0, "ItemRegistry");
    qmlRegisterType<ListenerRegistry>(PLUGMAN_URI, 1, 0, "ListenerRegistry");
    qmlRegisterType<ServiceRegistry>(PLUGMAN_URI, 1, 0, "ServiceRegistry");
}
