#ifndef LOGGER_H_
#define LOGGER_H_

#include <iostream>
#include <string>

#define CHECK(expr) (((expr) == 0) ? LOG(FATAL) << __FILE__ << ": "<<__LINE__<< " : "<< __PRETTY_FUNCTION__<< ": check failed: "<< #expr<<": ": LOG(DEV_NULL))
#define CHECK_EQ(expr, val) CHECK_EQ_FUN(expr,val,#expr,#val,__FILE__,__LINE__,__PRETTY_FUNCTION__)

enum LogType {
  INFO,
  FATAL,
  DEV_NULL,
};


class Logger: public std::ostream {
  public:
  ~Logger();
  Logger(const Logger& l);
  Logger& operator << (const char *);
  Logger& operator << (const std::string&);
  Logger& operator << (int);
  Logger& operator << (double);
  private:
  friend Logger LOG(LogType t);
  Logger(LogType t);
  LogType type_;
};
Logger LOG(LogType t);

template <typename A, typename B>
Logger CHECK_EQ_FUN(A expr, B val, const char* expr_str, const char* val_str , const char* file, int line, const char* func){
  return expr!=val ? LOG(FATAL) << file<<": "<<line<<": "<<func<<": equality check failed: "<<expr_str<<"="<<expr<<" != "<<val_str<<"="<<val<<" :" : LOG(DEV_NULL);
}


#endif /*LOGGER_H_*/
