package tests::ConfigDlfAnalyserSpecTest;

use strict;

use base qw/tests::ConfigPluginSpecTest/;

use Lire::Config::ConfigSpec;
use Lire::Config::DlfAnalyserSpec;
use Lire::PluginManager;
use Lire::DlfAnalyser;
use Lire::Test::Mock;

sub new {
    my $self = shift->SUPER::new( @_ );
    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();

    $self->{'test1'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test1'}->set_result( 'name' => 'test1-analyser',
                                  'src_schema' => 'test',
                                  'dst_schema' => 'test-extended',
                                  'title' => 'Test 1 Analyser',
                                  'description' =>
                                  '<para>Description.</para>' );

    $self->{'test2'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test2'}->set_result( 'name' => 'test2-analyser',
                                  'src_schema' => 'test',
                                  'dst_schema' => 'test-extended',
                                  'title' => 'Test 2 Analyser',
                                  'description' =>
                                  '<para>Description 2.</para>' );
    $self->{'test3'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test3'}->set_result( 'name' => 'test3-analyser',
                                  'src_schema' => 'other',
                                  'dst_schema' => 'test-extended',
                                  'title' => 'Test 3 Analyser',
                                  'description' =>
                                  '<para>Description 3.</para>' );

    $self->set_up_plugin_mgr();
    foreach my $key ( qw/test1 test2 test3/ ) {
        Lire::PluginManager->register_plugin( $self->{$key} );
    }

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub set_up_spec {
    my $self = $_[0];

    $self->{'cfg'}{'_lr_config_spec'} = new Lire::Config::ConfigSpec();
    $self->SUPER::set_up_spec();

    return;
}

sub type {
    return 'Lire::Config::DlfAnalyserSpec';
}

sub test_new {
    my $self = $_[0];

    # We cannot uses SUPER::test_new() because we override summary()
    # and description.

    my $spec = new Lire::Config::DlfAnalyserSpec( 'name' => 'test-extended' );
    my @options = $spec->options();
    $self->assert_num_equals( 4, scalar @options );
    $self->assert_str_equals( 'none', $options[0]->name() );
    $self->assert_str_equals( 'No analyser', $options[0]->summary() );
    $self->assert_str_equals( '<para>No analyser will be used.</para>',
                              $options[0]->description() );
    $self->assert_str_equals( 'test1-analyser', $options[1]->name() );
    $self->assert_str_equals( $self->{'test1'}->title(),
                              $options[1]->summary() );
    $self->assert_str_equals( $self->{'test1'}->description(),
                              $options[1]->description() );
    $self->assert_str_equals( 'test2-analyser', $options[2]->name() );
    $self->assert_str_equals( 'test3-analyser', $options[3]->name() );
    my $default = new Lire::Config::Plugin( 'spec' => $spec,
                                            'value' => 'test1-analyser' );
    $self->assert_deep_equals( $default, $spec->default() );

    my $limited =
      new Lire::Config::DlfAnalyserSpec( 'name' => 'test-extended',
                                         'src_schema' => 'test' );
    $self->assert_num_equals( 3, scalar $limited->options() );
    $self->assert_str_equals( 'test', $limited->{'_src_schema'} );
    $self->assert_str_equals( 'test', $limited->src_schema() );

    $self->assert_num_equals( 4, scalar @options );
    my $other = new Lire::Config::DlfAnalyserSpec( 'name' => 'other' );
    @options = $other->options();
    $self->assert_num_equals( 1, scalar @options  );
    $self->assert_str_equals( 'none', $options[0]->name() );
    $default = new Lire::Config::Plugin( 'spec' => $other,
                                         'value' => 'none' );
    $self->assert_deep_equals( $default, $other->default() );
}

1;

