/* web_url.vala
 *
 * Copyright (C) 2010 Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

using Soup;

public string get_html_url(string url){
        var session = new Soup.SessionAsync ();
        var message = new Soup.Message ("GET", url);
        session.send_message (message);
        return message.response_body.flatten ().data;
   
}


public string get_lekhonee_template(string url, string ntitle, string ncontent){
    string oldpost = get_html_url(url);

    oldpost = oldpost.replace("OLDTITLE",ntitle);
    oldpost = oldpost.replace("TESTDESC",ncontent);
    return oldpost;
}

