/*****************************************************************************
 * Copyright (C) 2005-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "debugoutputtextedit.h"

#include <QtGui/QMenu>
#include <QtGui/QWidget>
#include <KAction>
#include <klocale.h>

DebugOutputTextEdit::DebugOutputTextEdit(QWidget* parent, const char* name)
        : KTextBrowser(parent, name)
{

    setContextMenuPolicy(Qt::DefaultContextMenu);

}

DebugOutputTextEdit::~DebugOutputTextEdit()
{
}

void DebugOutputTextEdit::contextMenuEvent(QContextMenuEvent * event)
{
    popup = new QMenu(this);

    KAction *CutAction = new KAction(i18n("Cut Content"), this);
    connect(CutAction, SIGNAL(triggered()), this, SLOT(cut()));
    popup->addAction(CutAction);

    popup->insertSeparator(CutAction);

    KAction *CopyAction = new KAction(i18n("Copy Content"), this);
    connect(CopyAction, SIGNAL(triggered()), this, SLOT(copy()));
    popup->addAction(CopyAction);

    KAction *ClearAction = new KAction(i18n("Clear Log Window"), this);
    connect(ClearAction, SIGNAL(triggered()), this, SLOT(clear()));
    popup->addAction(ClearAction);

    popup->show();
    popup->exec(event->globalPos());
    delete popup;
    delete CutAction;
    delete CopyAction;
    delete ClearAction;
}

void DebugOutputTextEdit::append(const QString & text)
{
    KTextBrowser::append(text);
    moveCursor(QTextCursor::End);
}

#include "debugoutputtextedit.moc"
