/*
 * Jalview - A Sequence Alignment Editor and Viewer (2.11.5.0)
 * Copyright (C) 2025 The Jalview Authors
 * 
 * This file is part of Jalview.
 * 
 * Jalview is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *  
 * Jalview is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Jalview.  If not, see <http://www.gnu.org/licenses/>.
 * The Jalview Authors are detailed in the 'AUTHORS' file.
 */
package jalview.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/**
 * A class to hold constants relating to Url links used in Jalview
 */
public class Constants
{

  // character used to represent secondary structures
  public static final char HELIX = 'H';

  public static final char SHEET = 'E';

  public static final char COIL = 'C';

  // label in secondary structure annotation data model from 3d structures
  public static final String SS_ANNOTATION_LABEL = "Secondary Structure";

  // label in secondary structure annotation data model from JPred
  public static final String SS_ANNOTATION_FROM_JPRED_LABEL = "jnetpred";

  public static final Map<String, String> SECONDARY_STRUCTURE_LABELS = new HashMap<>();
  static
  {
    SECONDARY_STRUCTURE_LABELS.put(SS_ANNOTATION_LABEL, "3D Structures");
    SECONDARY_STRUCTURE_LABELS.put(SS_ANNOTATION_FROM_JPRED_LABEL, "JPred");
    // Add other secondary structure labels here if needed
  }

  public static final String SS_PROVIDER_PROPERTY = "SS_PROVIDER";

  // generic secondary structure provider options
  public static final String SS_ALL_PROVIDERS = "All";

  public static final String SS_NONE_PROVIDER = "None";

  // Secondary structure consensus label
  public static final String SECONDARY_STRUCTURE_CONSENSUS_LABEL = "Secondary Structure Consensus";

  // A map that stores abbreviations of structure providers as keys and their
  // full names as values.
  public static final Map<String, String> STRUCTURE_PROVIDERS = new HashMap<>();

  static
  {
    STRUCTURE_PROVIDERS.put("None", "No Secondary Structure");
    STRUCTURE_PROVIDERS.put("AF", "AlphaFold DB");
    STRUCTURE_PROVIDERS.put("SM", "SWISS-MODEL");
    STRUCTURE_PROVIDERS.put("PDB", "PDB");
    STRUCTURE_PROVIDERS.put("JP", "JPred");
    STRUCTURE_PROVIDERS.put("AFill", "AlphaFill");
  }

  public static final Map<String, Color> STRUCTURE_PROVIDERS_COLOR = new HashMap<>();

  public static final String CHAINID = "CHAINID"; // String used to save CHAINID as annot property

  public static final String PDBID = "PDBID";  // String used to save PDBID as annot property

  public static final String PDB = "PDB"; // String used for PDB provider

  static
  {
    STRUCTURE_PROVIDERS_COLOR.put("No Secondary Structure", Color.GRAY);
    STRUCTURE_PROVIDERS_COLOR.put("AlphaFold DB", new Color(255, 0, 0));
    STRUCTURE_PROVIDERS_COLOR.put("SWISS-MODEL", new Color(255, 165, 0));
    STRUCTURE_PROVIDERS_COLOR.put("PDB", new Color(0, 128, 0));
    STRUCTURE_PROVIDERS_COLOR.put("JPred", new Color(0, 0, 255));
    STRUCTURE_PROVIDERS_COLOR.put("AlphaFill", Color.CYAN);
  }
}
