/*
 * gwenrenameview.cpp
 *
 * Copyright (C) 2008 Spiros Georgaras <sng@hellug.gr>
 */
#include "gwenrenameview.h"
#include "settings.h"

#include <klocale.h>
#include <QtGui/QLabel>

gwenrenameView::gwenrenameView(QWidget *)
{
    ui_gwenrenameview_base.setupUi(this);
    settingsChanged();
    setAutoFillBackground(true);
}

gwenrenameView::~gwenrenameView()
{

}

void gwenrenameView::switchColors()
{
    // switch the foreground/background colors of the label
    QColor color = Settings::col_background();
    Settings::setCol_background( Settings::col_foreground() );
    Settings::setCol_foreground( color );

    settingsChanged();
}

void gwenrenameView::settingsChanged()
{
    QPalette pal;
    pal.setColor( QPalette::Window, Settings::col_background());
    pal.setColor( QPalette::WindowText, Settings::col_foreground());
    ui_gwenrenameview_base.kcfg_sillyLabel->setPalette( pal );

    // i18n : internationalization
    ui_gwenrenameview_base.kcfg_sillyLabel->setText( i18n("This project is %1 days old",Settings::val_time()) );
    emit signalChangeStatusbar( i18n("Settings changed") );
}

#include "gwenrenameview.moc"
