#ifndef _EVAL_DEBUG_H
#define _EVAL_DEBUG_H

#include "itemDelegate.h"
#include <boost/scoped_ptr.hpp>
#include <QWidget>
#include <QDialog>
#include <QModelIndex>
#include <QStringList>
#include "osl/eval/ml/openMidEndingEval.h"
#include "osl/state/numEffectState.h"
#include "osl/stl/vector.h"
#include "osl/container/pieceValues.h"

class OpenMidEndingEvalDebugModel;
class OpenMidEndingEvalDiffModel;

class OpenMidEndingEvalUtil
{
public:
  static QStringList featureName();
  static int progressAdjustedValue(const osl::eval::ml::OpenMidEndingEvalDebugInfo &debug_info,
                                   int progress,
                                   int progress_stage,
                                   int index);
  static int progressAdjustedTotal(const osl::eval::ml::OpenMidEndingEvalDebugInfo &debug_info,
                                   int progress,
                                   int index);
};

class OpenMidEndingEvalDebug : public QWidget
{
  Q_OBJECT
public:
  OpenMidEndingEvalDebug(
    const osl::state::NumEffectState &s,
    QWidget *parent = 0, const char *name = 0);
  void setStatus(const osl::state::SimpleState &state);
private:
  OpenMidEndingEvalDebugModel *model;
  boost::scoped_ptr<DoubleItemDelegate> delegate;
};

class OpenMidEndingEvalDiff : public QWidget
{
public:
  OpenMidEndingEvalDiff(const osl::state::NumEffectState &s1,
                        const osl::state::NumEffectState &s2,
                        QWidget *parent = 0);
private:
  OpenMidEndingEvalDiffModel *model;
  boost::scoped_ptr<DoubleItemDelegate> delegate;
};

class OpenMidEndingEvalDebugDialog : public QDialog
{
  Q_OBJECT
public:
  OpenMidEndingEvalDebugDialog(const osl::state::SimpleState &s,
		      QWidget *parent = 0, const char *name = 0);
public slots:
  void setStatus(const osl::state::SimpleState &state,
		 const osl::stl::vector<osl::Move> &,
		 int, osl::Move);
private:
  OpenMidEndingEvalDebug *debug;
};

class OpenMidEndingEvalDiffDialog : public QDialog
{
  Q_OBJECT
public:
  OpenMidEndingEvalDiffDialog(
    const osl::state::NumEffectState &s1,
    const osl::state::NumEffectState &s2,
    QWidget *parent = 0);
  QSize sizeHint() const;
private slots:
  void selectTab(int);
private:
  OpenMidEndingEvalDiff *debug;
  OpenMidEndingEvalDebug *debug1;
  OpenMidEndingEvalDebug *debug2;
};

#endif // _EVAL_DEBUG_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
