
   ;;  Node test 
   ;;
   ;;  The purpose of this program is to verify that nodes
   ;; can interconnect I/O pins.


        include "processor.inc"
        include <coff.inc>              ; Grab some useful macros

  CONFIG  OSC = HSPLL, OSCS = ON, WDT = ON, LVP = OFF
  CONFIG  CP0 = ON, CP1 = ON, CPB = ON

	include "ssd0323.inc"
	include "osram128x64.inc"
	include "portdef.inc"

;------------------------------------------------------------------------
; gpsim command
.command macro x
  .direct "C", x
  endm


;----------------------------------------------------------------------
;  Variable declarations
;----------------------------------------------------------------------
GPR_DATA                UDATA_ACS
temp            RES     1


temp0           RES     1
temp1           RES     1
temp2           RES     1
temp3           RES     1

  GLOBAL temp0, temp1, temp2, temp3


Tx RES 1
Ty RES 1

DISPLAY_DATA  UDATA 400
DisplayBuffer	RES LCD_nROWS*LCD_nCOLS/8
  GLOBAL DisplayBuffer

;------------------------------------------------------------------------
; Code labels

  GLOBAL done


;----------------------------------------------------------------------
;   ********************* RESET VECTOR LOCATION  ********************
;----------------------------------------------------------------------
RESET_VECTOR  CODE    0x000              ; processor reset vector
        bra   start                      ; go to beginning of program

;----------------------------------------------------------------------
;   ******************* INTERRUPT VECTOR LOCATION  ******************
;----------------------------------------------------------------------

INT_VECTOR   CODE    0x008               ; interrupt vector location
	RETFIE 1

;----------------------------------------------------------------------
;   ******************* MAIN CODE START LOCATION  ******************
;----------------------------------------------------------------------
MAIN    CODE
start

   ;;
   ;; Define the simulation environment.
   ;;

   .sim "module library libgpsim_extras"
   .sim "module library libgpsim_modules"

   .sim "module load OSRAM128X64 LCD"
   .sim "module load pullup R1"
   .sim "module load pullup R2"

  if InterfaceMode == Mode8080
   .sim "module load pullup RBS1"
   .sim "module load pullup RBS2"
  endif

  if InterfaceMode == Mode6800
   .sim "module load pulldown RBS1"
   .sim "module load pullup RBS2"
  endif

  if InterfaceMode == ModeSPI
   .sim "module load pulldown RBS1"
   .sim "module load pulldown RBS2"
  endif

   .sim "node nBS1"
   .sim "node nBS2"
   .sim "attach nBS2 RBS2.pin LCD.bs2"
   .sim "attach nBS1 RBS1.pin LCD.bs1"


  if InterfaceMode == Mode6800 || InterfaceMode == Mode8080
   .sim "node nE"
   .sim "node nRW"

   .sim "attach nE  porte0 LCD.e"
   .sim "attach nRW porte1 LCD.rw"

   .sim "node nd0 nd1 nd2 nd3 nd4 nd5 nd6 nd7"

   .sim "attach nd0 portb0 LCD.d0"
   .sim "attach nd1 portb1 LCD.d1"
   .sim "attach nd2 portb2 LCD.d2"
   .sim "attach nd3 portb3 LCD.d3"
   .sim "attach nd4 portb4 LCD.d4"
   .sim "attach nd5 portb5 LCD.d5"
   .sim "attach nd6 portb6 LCD.d6"
   .sim "attach nd7 portb7 LCD.d7"

  else

   .sim "module load pulldown Rgnd"
   .sim "node nGnd"

   .sim "attach nGnd Rgnd.pin LCD.d7 LCD.d6 LCD.d5 LCD.d4 LCD.d3 LCD.d2 LCD.e LCD.rw"

   .sim "node nSDA nSCL"
   .sim "attach nSDA portc5 LCD.d1"
   .sim "attach nSCL portc3 LCD.d0"

  endif


   .sim "node nCS"
   .sim "node nRES"
   .sim "node nDC"
   .sim "attach nDC porte2 LCD.dc"
   .sim "attach nCS  portd0 LCD.cs R2.pin"
   .sim "attach nRES portd1 LCD.res"

   ;; Now position the modules in the BreadBoard viewer

   .sim "LCD.xpos=220.0"
   .sim "LCD.ypos=24.0"
   .sim "R1.xpos=216.0"
   .sim "R1.ypos=264.0"
   .sim "R2.xpos=312.0"
   .sim "R2.ypos=264.0"
;   .sim "R3.xpos=376.0"
;   .sim "R3.ypos=264.0"


  if InterfaceMode == ModeSPI

   ;; Initialize the SPI port:
   ;CKP == 1 
   ;CKE == 0

        BCF     TRISC, RC5
        BCF     TRISC, RC3

        CLRF    SSPSTAT
SPIClk_FOSC_64  EQU (1<<SSPM1)
        MOVLW  (1<<SSPEN)|(1<<CKP)|SPIClk_FOSC_64
        MOVWF  SSPCON1

  endif

   ;; Initialize the SSD0323 LCD graphics controller.

	RCALL	SSD0323_Init

   ;; Set the virtual display size to match the physical display
        MOVLW   LCD_nROWS
        MOVWF   DisplaySizeY
        MOVLW   LCD_nCOLS
        MOVWF   DisplaySizeX

  ;;########################################################################
  ;;
  ;;  Main Loop

loop:
	CLRWDT

   ; Clear Screen Test

	RCALL	LCD_ClearScreen
	RCALL	LCD_RefreshEntireDisplay

   ; Line Test

	movlw	63
	movwf	Ty
	movlw	127
	movwf	Tx
LL
	clrwdt
	movf	Tx,W
	MOVWF	LCD_x2
	movf	Ty,W
	MOVWF	LCD_y2
        MOVLW	0
	MOVWF	PixelX
	MOVLW	1
	MOVWF	PixelY

	RCALL	LCD_Line
;	RCALL	LCD_RefreshDisplay

	decf	Tx,F
	BNN	LL

        CLRWDT
	RCALL	LCD_RefreshEntireDisplay
        CLRWDT

        MOVLW	0
	MOVWF	PixelX
	MOVWF	PixelY
	MOVLW	99
	MOVWF	LCD_x2
	MOVLW	15
	MOVWF	LCD_y2

	RCALL	LCD_Line
	RCALL	LCD_RefreshDisplay
        CLRWDT

	MOVLW	20
	MOVWF	PixelX
	CLRF	PixelY

   .assert "\"Press run for next test\""
	nop
	RCALL	LCD_ClearScreen

	MOVLW	1
	RCALL	LCD_putBitMap
	RCALL	LCD_RefreshEntireDisplay
        CLRWDT

   .assert "\"Press run for next test\""
	nop
	RCALL	LCD_ClearScreen

	CLRF	PixelX
	MOVLW	0
	RCALL	LCD_putBitMap
	RCALL	LCD_RefreshEntireDisplay
        CLRWDT

	MOVLW	32
	MOVWF	PixelX

	MOVLW	2
	RCALL	LCD_putBitMap
	RCALL	LCD_RefreshEntireDisplay
        CLRWDT

	MOVLW	32
	MOVWF	PixelY
        CLRF    PixelX

   .assert "\"Press run for next test\""
	nop
	RCALL	LCD_ClearScreen
	RCALL	LCD_RefreshEntireDisplay
        CLRWDT

        RCALL   BarTest
        RCALL   TextTest

        movlw   0
        clrf    Ty
        rcall   BitMapGrayscaleTest

        movlw   10
        movwf   Ty
        movlw   1
        rcall   BitMapGrayscaleTest

        movlw   20
        movwf   Ty
        movlw   2
        rcall   BitMapGrayscaleTest

        movlw   30
        movwf   Ty
        movlw   3
        rcall   BitMapGrayscaleTest

  .assert "\" Stop test \""
	nop
	bra	loop



;========================================================================
TextTest:
   ; Now do a text test.
 if 1
        MOVLW   127
        MOVWF   temp0
        MOVLW   0
        call    SSD_SetColumnRange

        MOVLW   63
        MOVWF   temp0
        MOVLW   56
        call    SSD_SetRowRange
        call    LCD_ResetCursor
 endif
	RCALL	LCD_ClearScreen
        RCALL   LCD_ResetCursor

        MOVLW   'G'
        rcall   LCD_putc
        MOVLW   'P'
        rcall   LCD_putc
        MOVLW   'S'
        rcall   LCD_putc
        MOVLW   'I'
        rcall   LCD_putc
        MOVLW   'M'
        rcall   LCD_putc
        MOVLW   ' '
        rcall   LCD_putc
        MOVLW   '5'
        rcall   LCD_putc
        MOVLW   'X'
        rcall   LCD_putc
        MOVLW   '7'
        rcall   LCD_putc
        MOVLW   ' '
        rcall   LCD_putc
        MOVLW   'f'
        rcall   LCD_putc
        MOVLW   'o'
        rcall   LCD_putc
        MOVLW   'n'
        rcall   LCD_putc
        MOVLW   't'
        rcall   LCD_putc

	bra	LCD_RefreshDisplay


;========================================================================
BarTest:
 if 0
  if InterfaceMode == ModeSPI
        ; Delay a little to allow the last data byte to complete.
        movlw   64
SpiWait:
        decfsz  WREG,F
         bra    SpiWait
  endif


   ; This next test illustrates how to tell the SSD0323 that we
   ; we want to draw in a small rectangular area. All we draw is
   ; a gradient.
	MOVLW	LOW(WindowCursor)
	MOVWF	TBLPTRL
	MOVLW	HIGH(WindowCursor)
	MOVWF	TBLPTRH

        MOVLW   WindowCursorEnd-WindowCursor
        MOVWF   temp0

        call    CommandLoop

        movlw   0
        movwf   Tx
        clrf    Ty

bars:
        
        rcall   SSD0323_Write
        incf    Ty,F
        bcf     Ty,4
        swapf   Ty,W
        iorwf   Ty,W

        decfsz  Tx,F
         bra bars
  endif
        return


;========================================================================

BitMapGrayscaleTest:

	RLNCF	WREG,W
	ADDLW	LOW(FontPtrs)
	MOVWF	TBLPTRL
	MOVLW	HIGH(FontPtrs)
	SKPNC
	 ADDLW	1
	MOVWF	TBLPTRH

        movlw   64
SpiWait:
        decfsz  WREG,F
         bra    SpiWait


	TBLRD   *+
	MOVF	TABLAT,W
	TBLRD   *+
	MOVWF	TBLPTRL
	MOVF	TABLAT,W
	MOVWF	TBLPTRH

;	MOVLW	LOW(BitMapTest)
;	MOVWF	TBLPTRL
;	MOVLW	HIGH(BitMapTest)
;	MOVWF	TBLPTRH


   ; The first byte of the bitmap is the width and the second is the height


        MOVLW   0x15
        RCALL   SSD0323_WriteCmd
        MOVLW   0x00
        RCALL   SSD0323_WriteCmd
	TBLRD   *+
	MOVF	TABLAT,W
        RCALL   SSD0323_WriteCmd

        MOVLW   0x75
        RCALL   SSD0323_WriteCmd
        MOVF    Ty,W
        RCALL   SSD0323_WriteCmd
	TBLRD   *+
	MOVF	TABLAT,W
        ADDWF   Ty,W
        RCALL   SSD0323_WriteCmd

	TBLRD   *+
	MOVF	TABLAT,W
	MOVWF	temp0
	TBLRD   *+
	INCF	TABLAT,W
	MOVWF	temp1

GSLoop:
        RCALL   CommandWaitForSPI
	TBLRD   *+
	MOVF	TABLAT,W
        RCALL   SSD0323_Write
        dcfsnz  temp0,f
         decfsz temp1,f
          bra    GSLoop
        
 ;       decfsz  temp0,F
        RCALL   CommandWaitForSPI
        return

WindowCursor:
  ; CmdSetColumnAddress EQU 0x15
  ; CmdSetRowAddress    EQU 0x75
  ; 
  ; This test command defines an 16 by 16 rectangular region starting at 
  ; row 0x21 and column 0x08

        db 0x15, 0x08, 0x17,    0x75, 0x21, 0x30
WindowCursorEnd:


BITMAPS   CODE    0x3400

FontPtrs:
        dw  CourierNumbers, CourierNumbersBold, Numbers4, N46
BitMapTest:

CourierNumbersBold:
  ;bold Courier 10
    db 0x21, 7, low(272), high(272)
    db 0x80,0xEF,0x08,0x10,0xD8,0x09,0x00,0xE8,0xDF,0x03,0xA0,0xFE,0x1B,0x00,0x00,0xF2
    db 0x0C,0xF0,0xFF,0xEF,0x00,0x30,0xFB,0x0E,0xE0,0xFF,0xFF,0x00,0xC3,0xEF,0x09,0x20
    db 0xFC,0x1B,0xF7,0x88,0x6F,0x70,0xFD,0x0A,0x10,0x7F,0xF8,0x0D,0x50,0x85,0x8F,0x00
    db 0x00,0xFB,0x0F,0xF0,0x5C,0x45,0x00,0xF2,0x2A,0x00,0xA0,0x55,0xBD,0x00,0xEE,0x86

    db 0x8F,0xC0,0x6E,0x9F,0xDD,0x00,0xCD,0x00,0xF0,0x0A,0x00,0x00,0xF0,0x0F,0x00,0x20
    db 0x8F,0x00,0x40,0xAE,0x0F,0xF0,0x0A,0x00,0x00,0xEA,0x01,0x00,0x00,0x10,0x6F,0x00
    db 0xCD,0x42,0x7F,0xF0,0x0A,0xEA,0xAF,0x00,0xFA,0x00,0xF0,0x0A,0x00,0x00,0xF8,0x09
    db 0x00,0xFD,0x0D,0x00,0xC0,0xA6,0x0F,0xF0,0xFF,0x4E,0x00,0xEE,0xFF,0x04,0x00,0x60

    db 0x2F,0x00,0xE2,0xFF,0x0A,0xE0,0x2D,0xFD,0xAF,0x00,0xFA,0x00,0xF0,0x0A,0x00,0x50
    db 0xBF,0x00,0x00,0xC9,0x5F,0x00,0xE5,0xA0,0x2F,0x50,0x55,0xDE,0x00,0xEF,0xE5,0x0D
    db 0x00,0xC0,0x0D,0x00,0xEA,0x85,0x5F,0x60,0xFF,0xEE,0xDD,0x00,0xDD,0x00,0xF0,0x0A
    db 0x00,0xF3,0x0A,0x00,0x00,0x00,0x9F,0x00,0xFA,0xFF,0xFF,0x00,0x00,0xFA,0x00,0xAE

    db 0xA0,0x0F,0x00,0xF2,0x08,0x00,0xAF,0x00,0x9F,0x00,0x22,0xAD,0xF7,0x88,0x7F,0x30
    db 0xF5,0x4C,0x00,0xEE,0x67,0x0F,0xC4,0x97,0x7F,0x00,0x21,0xD7,0x6F,0xB2,0x78,0xCF
    db 0x00,0xEA,0xE6,0x0C,0x00,0xF8,0x03,0x00,0xFC,0x96,0x6F,0x00,0x91,0x2F,0x80,0xFF
    db 0x08,0xE0,0xFF,0xEF,0x10,0xFF,0xFF,0x0F,0xB1,0xFF,0x09,0x00,0x00,0xFE,0xEF,0xD2

    db 0xFF,0x2B,0x00,0xB1,0xCF,0x02,0x00,0xEE,0x00,0x00,0xB2,0xEF,0x08,0xD0,0xCF,0x03

CourierNumbers:
  ;Courier 10
    db 0x22, 7, low(280), high(280)
    db 0x10,0xEC,0x0A,0x00,0x80,0xDA,0x00,0x20,0xEC,0x2C,0x00,0xB2,0xDD,0x04,0x00,0x80
    db 0x0D,0x10,0xEF,0xDE,0x01,0x00,0xB3,0xAD,0x00,0xEF,0xEE,0x0D,0x50,0xED,0x3C,0x00
    db 0xD4,0x9D,0x00,0xA0,0x07,0x6A,0x00,0x00,0xE1,0x00,0x90,0x06,0xB5,0x00,0x00,0x40
    db 0x0D,0x00,0xA2,0x0E,0x10,0x0E,0x00,0x00,0x30,0x2D,0x00,0x00,0x05,0x70,0x09,0xF0
    db 0x02,0xD4,0x00,0x3E,0x70,0x07,0xF0,0x01,0xB4,0x00,0x00,0xE1,0x00,0x00,0x00,0xD2
    db 0x00,0x00,0x72,0x09,0x00,0x3B,0x0E,0x10,0xCF,0x9E,0x00,0xB0,0x03,0x00,0x00,0x00
    db 0xD0,0x03,0xE0,0x03,0xB5,0x10,0x0F,0x20,0x0C,0xF1,0x00,0xE1,0x00,0x00,0xE1,0x00
    db 0x00,0x00,0x98,0x00,0x00,0xEB,0x03,0x40,0x19,0x0E,0x10,0x2D,0xA0,0x08,0xE0,0xEA
    db 0x1B,0x00,0x00,0xD4,0x00,0x40,0xEF,0x2F,0x00,0x5D,0x70,0x0E,0xF1,0x00,0xE1,0x00
    db 0x00,0xE1,0x00,0x00,0x60,0x0C,0x00,0x00,0x50,0x0C,0xD0,0x11,0x0E,0x00,0x00,0x20
    db 0x0D,0xF1,0x05,0xA8,0x00,0x00,0x6B,0x00,0xD0,0x04,0xA7,0x00,0xC2,0x9E,0x0D,0xF0
    db 0x01,0xC3,0x00,0x00,0xE1,0x00,0x00,0xD5,0x01,0x00,0x00,0x10,0x0E,0xF1,0xFF,0xCF
    db 0x00,0x00,0x20,0x0D,0xE0,0x00,0xE2,0x00,0x20,0x1F,0x00,0xF1,0x00,0xE1,0x00,0x00
    db 0x60,0x08,0xA0,0x07,0x7A,0x00,0x00,0xE1,0x00,0x60,0x1D,0x50,0x00,0x4D,0x70,0x0A
    db 0x00,0x10,0x0E,0x00,0x00,0xA0,0x08,0xB0,0x04,0xB6,0x00,0x90,0x0A,0x00,0xE0,0x04
    db 0xB6,0x00,0x00,0xD4,0x01,0x10,0xEC,0x0A,0x00,0xC0,0xFE,0x0D,0xE0,0xFF,0xDF,0x00
    db 0xE5,0xBE,0x01,0x00,0xD0,0xAF,0x00,0xDB,0xAE,0x00,0x10,0xEB,0x2C,0x00,0xF0,0x04
    db 0x00,0x30,0xED,0x1C,0x00,0xDC,0x2A,0x00


Numbers4:
    db 0x1c, 7, low(174), high(174)
    db 0xE3,0x3E,0x00,0xE0,0x0F,0x00,0xF0,0x6E,0x00,0xF0,0x7F,0x00,0xE0,0x0F,0x00,0xF0
    db 0xFF,0x00,0xB1,0xEF,0x00,0xFF,0xFF,0x00,0xC6,0x5C,0x00,0xE5,0x3D,0x5C,0xC5,0x00
    db 0x00,0x0F,0x00,0x00,0xF2,0x00,0x00,0xE3,0x00,0xC4,0x0F,0x00,0xF0,0x00,0x00,0x8A
    db 0x00,0x00,0x00,0x96,0x00,0x3E,0xE3,0x00,0x3E,0xC3,0xCF,0xF0,0x00,0x00,0x0F,0x00

    db 0x00,0xB3,0x00,0x00,0x6F,0x00,0x78,0x0F,0x00,0xE0,0x5E,0x00,0xAF,0x6F,0x00,0x00
    db 0x1D,0x00,0xF4,0x4F,0x00,0x3F,0xF5,0x0F,0xF0,0x00,0x00,0x0F,0x00,0x10,0x1C,0x00
    db 0x00,0xE3,0x00,0x2D,0x0F,0x00,0x00,0xE2,0x00,0x5F,0xF3,0x00,0x80,0x07,0x00,0x4D
    db 0xD4,0x00,0xF6,0xEB,0x4C,0xC5,0x00,0x00,0x0F,0x00,0x90,0x04,0x00,0x00,0xE3,0x00

    db 0xFF,0xFF,0x00,0x00,0xE3,0x00,0x4B,0xE2,0x00,0xD2,0x00,0x00,0x3F,0xF3,0x00,0x00
    db 0xA8,0xE4,0x3E,0x00,0xF0,0xFF,0x00,0xF0,0xFF,0x00,0xF0,0x5E,0x00,0x00,0x0F,0x00
    db 0xF0,0x5F,0x00,0xD2,0x5F,0x00,0x4B,0x00,0x00,0xE6,0x6E,0x00,0xFF,0x1B

N46:
    db 0x10, 0x24, low(408), high(408)

    db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
    db 0x52,0x00,0x00,0x00,0x00,0x00,0xF3,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83
    db 0xFC,0x9E,0x00,0x00,0x00,0x00,0x10,0xFE,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xC5
    db 0xFF,0x3A,0x00,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0xB2

    db 0xFF,0x3D,0x00,0x00,0x00,0x00,0x00,0x00,0xF9,0xFF,0xFF,0x00,0x00,0x00,0x00,0x50
    db 0xFF,0xCF,0x01,0x00,0x00,0x00,0x00,0x00,0x60,0xFE,0xFF,0xFF,0x00,0x00,0x00,0x00
    db 0xF6,0xFF,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0xF3,0xF3,0xFF,0xFF,0x00,0x00,0x00
    db 0x40,0xFF,0xFF,0x04,0x00,0x00,0x00,0x00,0x00,0x10,0x8E,0xF0,0xFF,0xFF,0x00,0x00

    db 0x00,0xE1,0xFF,0xBF,0x00,0x00,0x00,0x00,0x00,0x00,0xB0,0x0C,0xF0,0xFF,0xFF,0x00
    db 0x00,0x00,0xF9,0xFF,0x4F,0x00,0x00,0x00,0x00,0x00,0x00,0xE8,0x01,0xF0,0xFF,0xFF
    db 0x00,0x00,0x10,0xFF,0xFF,0x0E,0x21,0x01,0x00,0x00,0x00,0x40,0x5F,0x00,0xF0,0xFF
    db 0xFF,0x00,0x00,0x60,0xFF,0xFF,0xEF,0xFF,0xEF,0x18,0x00,0x00,0xE1,0x09,0x00,0xF0

    db 0xFF,0xFF,0x00,0x00,0xA0,0xFF,0xFF,0x07,0x91,0xFF,0xEF,0x03,0x00,0xDB,0x00,0x00
    db 0xF0,0xFF,0xFF,0x00,0x00,0xD0,0xFF,0xFF,0x02,0x00,0xFC,0xFF,0x0E,0x60,0x2F,0x00
    db 0x00,0xF0,0xFF,0xFF,0x00,0x00,0xF0,0xFF,0xFF,0x01,0x00,0xF6,0xFF,0x7F,0xF2,0x06
    db 0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00,0xF3,0xFF,0xCF,0xF8

    db 0xDD,0xDD,0xDD,0xFD,0xFF,0xFF,0xFE,0x02,0xF0,0xFF,0xFF,0x00,0x00,0xF1,0xFF,0xFF
    db 0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x02,0xD0,0xFF,0xFF,0x00,0x00,0xF0,0xFF
    db 0xFF,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x02,0xA0,0xFF,0xFF,0x00,0x00,0xF0
    db 0xFF,0xEF,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x02,0x60,0xFF,0xFF,0x02,0x00

    db 0xF0,0xFF,0xBF,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00,0x10,0xFF,0xFF,0x04
    db 0x00,0xF0,0xFF,0x6F,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00,0x00,0xF7,0xFF
    db 0x06,0x00,0xF1,0xFF,0x0E,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00,0x00,0xB0
    db 0xFF,0x0B,0x00,0xF4,0xFF,0x04,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00,0x00

    db 0x00,0xFA,0x5F,0x00,0xFB,0x4E,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0x00,0x00
    db 0x00,0x00,0x40,0xEA,0xFF,0x7C,0x01,0x00

        db 8, 8  ; size
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe

        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe
        db 0x10,0x32, 0x54,0x76, 0x98,0xba, 0xdc,0xfe

; botched A
    db 0x00, 0x11, 0xcc, 0x00
    db 0x00, 0x44, 0xdd, 0x00
    db 0x00, 0x44, 0x66, 0x00
    db 0x00, 0x33, 0x00, 0x00
    db 0x00, 0x00, 0x44, 0x55
    db 0x00, 0x22, 0x22, 0xaa
    db 0x11, 0x99, 0x00, 0xff
    db 0xff, 0xff, 0x00, 0xff


BitMapTestEnd:

	nop

done:

  .assert  "\"*** PASSED LCD test\""
	goto	$

FAILED:
  .assert  "\"*** FAILED LCD test\""
	goto	$



  end
