package healthcareapis

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/healthcareapis/mgmt/2021-11-01/healthcareapis"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityParameters input values.
type CheckNameAvailabilityParameters struct {
	// Name - The name of the service instance to check.
	Name *string `json:"name,omitempty"`
	// Type - The fully qualified resource type which includes provider namespace.
	Type *string `json:"type,omitempty"`
}

// DicomService the description of Dicom Service
type DicomService struct {
	autorest.Response `json:"-"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
	// DicomServiceProperties - Dicom Service configuration.
	*DicomServiceProperties `json:"properties,omitempty"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DicomService.
func (ds DicomService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.Tags != nil {
		objectMap["tags"] = ds.Tags
	}
	if ds.Location != nil {
		objectMap["location"] = ds.Location
	}
	if ds.Identity != nil {
		objectMap["identity"] = ds.Identity
	}
	if ds.DicomServiceProperties != nil {
		objectMap["properties"] = ds.DicomServiceProperties
	}
	if ds.SystemData != nil {
		objectMap["systemData"] = ds.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DicomService struct.
func (ds *DicomService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ds.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ds.Location = &location
			}
		case "identity":
			if v != nil {
				var identity ServiceManagedIdentityIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ds.Identity = &identity
			}
		case "properties":
			if v != nil {
				var dicomServiceProperties DicomServiceProperties
				err = json.Unmarshal(*v, &dicomServiceProperties)
				if err != nil {
					return err
				}
				ds.DicomServiceProperties = &dicomServiceProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ds.SystemData = &systemData
			}
		}
	}

	return nil
}

// DicomServiceAuthenticationConfiguration authentication configuration information
type DicomServiceAuthenticationConfiguration struct {
	// Authority - READ-ONLY; The authority url for the service
	Authority *string `json:"authority,omitempty"`
	// Audiences - READ-ONLY; The audiences for the service
	Audiences *[]string `json:"audiences,omitempty"`
}

// MarshalJSON is the custom marshaler for DicomServiceAuthenticationConfiguration.
func (dsac DicomServiceAuthenticationConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DicomServiceCollection the collection of Dicom Services.
type DicomServiceCollection struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of Dicom Services.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of Dicom Services.
	Value *[]DicomService `json:"value,omitempty"`
}

// DicomServiceCollectionIterator provides access to a complete listing of DicomService values.
type DicomServiceCollectionIterator struct {
	i    int
	page DicomServiceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DicomServiceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DicomServiceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DicomServiceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DicomServiceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DicomServiceCollectionIterator) Response() DicomServiceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DicomServiceCollectionIterator) Value() DicomService {
	if !iter.page.NotDone() {
		return DicomService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DicomServiceCollectionIterator type.
func NewDicomServiceCollectionIterator(page DicomServiceCollectionPage) DicomServiceCollectionIterator {
	return DicomServiceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsc DicomServiceCollection) IsEmpty() bool {
	return dsc.Value == nil || len(*dsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsc DicomServiceCollection) hasNextLink() bool {
	return dsc.NextLink != nil && len(*dsc.NextLink) != 0
}

// dicomServiceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsc DicomServiceCollection) dicomServiceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsc.NextLink)))
}

// DicomServiceCollectionPage contains a page of DicomService values.
type DicomServiceCollectionPage struct {
	fn  func(context.Context, DicomServiceCollection) (DicomServiceCollection, error)
	dsc DicomServiceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DicomServiceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DicomServiceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsc)
		if err != nil {
			return err
		}
		page.dsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DicomServiceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DicomServiceCollectionPage) NotDone() bool {
	return !page.dsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DicomServiceCollectionPage) Response() DicomServiceCollection {
	return page.dsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DicomServiceCollectionPage) Values() []DicomService {
	if page.dsc.IsEmpty() {
		return nil
	}
	return *page.dsc.Value
}

// Creates a new instance of the DicomServiceCollectionPage type.
func NewDicomServiceCollectionPage(cur DicomServiceCollection, getNextPage func(context.Context, DicomServiceCollection) (DicomServiceCollection, error)) DicomServiceCollectionPage {
	return DicomServiceCollectionPage{
		fn:  getNextPage,
		dsc: cur,
	}
}

// DicomServicePatchResource dicom Service patch properties
type DicomServicePatchResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for DicomServicePatchResource.
func (dspr DicomServicePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dspr.Tags != nil {
		objectMap["tags"] = dspr.Tags
	}
	if dspr.Identity != nil {
		objectMap["identity"] = dspr.Identity
	}
	return json.Marshal(objectMap)
}

// DicomServiceProperties dicom Service properties.
type DicomServiceProperties struct {
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AuthenticationConfiguration - Dicom Service authentication configuration.
	AuthenticationConfiguration *DicomServiceAuthenticationConfiguration `json:"authenticationConfiguration,omitempty"`
	// ServiceURL - READ-ONLY; The url of the Dicom Services.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Control permission for data plane traffic coming from public networks while private endpoint is enabled. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for DicomServiceProperties.
func (dsp DicomServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsp.ProvisioningState != "" {
		objectMap["provisioningState"] = dsp.ProvisioningState
	}
	if dsp.AuthenticationConfiguration != nil {
		objectMap["authenticationConfiguration"] = dsp.AuthenticationConfiguration
	}
	if dsp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = dsp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// DicomServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DicomServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DicomServicesClient) (DicomService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DicomServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DicomServicesCreateOrUpdateFuture.Result.
func (future *DicomServicesCreateOrUpdateFuture) result(client DicomServicesClient) (ds DicomService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.DicomServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ds.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.DicomServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ds.Response.Response, err = future.GetResult(sender); err == nil && ds.Response.Response.StatusCode != http.StatusNoContent {
		ds, err = client.CreateOrUpdateResponder(ds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.DicomServicesCreateOrUpdateFuture", "Result", ds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DicomServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DicomServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DicomServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DicomServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DicomServicesDeleteFuture.Result.
func (future *DicomServicesDeleteFuture) result(client DicomServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.DicomServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.DicomServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DicomServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DicomServicesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DicomServicesClient) (DicomService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DicomServicesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DicomServicesUpdateFuture.Result.
func (future *DicomServicesUpdateFuture) result(client DicomServicesClient) (ds DicomService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.DicomServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ds.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.DicomServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ds.Response.Response, err = future.GetResult(sender); err == nil && ds.Response.Response.StatusCode != http.StatusNoContent {
		ds, err = client.UpdateResponder(ds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.DicomServicesUpdateFuture", "Result", ds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Error error details.
type Error struct {
	// Error - Error details
	Error *ErrorDetailsInternal `json:"error,omitempty"`
}

// ErrorDetails error details.
type ErrorDetails struct {
	// Error - Error details
	Error *ErrorDetailsInternal `json:"error,omitempty"`
}

// ErrorDetailsInternal error details.
type ErrorDetailsInternal struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetailsInternal.
func (edi ErrorDetailsInternal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FhirService the description of Fhir Service
type FhirService struct {
	autorest.Response `json:"-"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
	// Kind - The kind of the service. Possible values include: 'FhirServiceKindFhirStu3', 'FhirServiceKindFhirR4'
	Kind FhirServiceKind `json:"kind,omitempty"`
	// FhirServiceProperties - Fhir Service configuration.
	*FhirServiceProperties `json:"properties,omitempty"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for FhirService.
func (fs FhirService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.Tags != nil {
		objectMap["tags"] = fs.Tags
	}
	if fs.Location != nil {
		objectMap["location"] = fs.Location
	}
	if fs.Identity != nil {
		objectMap["identity"] = fs.Identity
	}
	if fs.Kind != "" {
		objectMap["kind"] = fs.Kind
	}
	if fs.FhirServiceProperties != nil {
		objectMap["properties"] = fs.FhirServiceProperties
	}
	if fs.SystemData != nil {
		objectMap["systemData"] = fs.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FhirService struct.
func (fs *FhirService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fs.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fs.Location = &location
			}
		case "identity":
			if v != nil {
				var identity ServiceManagedIdentityIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				fs.Identity = &identity
			}
		case "kind":
			if v != nil {
				var kind FhirServiceKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fs.Kind = kind
			}
		case "properties":
			if v != nil {
				var fhirServiceProperties FhirServiceProperties
				err = json.Unmarshal(*v, &fhirServiceProperties)
				if err != nil {
					return err
				}
				fs.FhirServiceProperties = &fhirServiceProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fs.SystemData = &systemData
			}
		}
	}

	return nil
}

// FhirServiceAccessPolicyEntry an access policy entry.
type FhirServiceAccessPolicyEntry struct {
	// ObjectID - An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
	ObjectID *string `json:"objectId,omitempty"`
}

// FhirServiceAcrConfiguration azure container registry configuration information
type FhirServiceAcrConfiguration struct {
	// LoginServers - The list of the Azure container registry login servers.
	LoginServers *[]string `json:"loginServers,omitempty"`
	// OciArtifacts - The list of Open Container Initiative (OCI) artifacts.
	OciArtifacts *[]ServiceOciArtifactEntry `json:"ociArtifacts,omitempty"`
}

// FhirServiceAuthenticationConfiguration authentication configuration information
type FhirServiceAuthenticationConfiguration struct {
	// Authority - The authority url for the service
	Authority *string `json:"authority,omitempty"`
	// Audience - The audience url for the service
	Audience *string `json:"audience,omitempty"`
	// SmartProxyEnabled - If the SMART on FHIR proxy is enabled
	SmartProxyEnabled *bool `json:"smartProxyEnabled,omitempty"`
}

// FhirServiceCollection a collection of Fhir services.
type FhirServiceCollection struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of Fhir Services.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of Fhir Services.
	Value *[]FhirService `json:"value,omitempty"`
}

// FhirServiceCollectionIterator provides access to a complete listing of FhirService values.
type FhirServiceCollectionIterator struct {
	i    int
	page FhirServiceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FhirServiceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FhirServiceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FhirServiceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FhirServiceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FhirServiceCollectionIterator) Response() FhirServiceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FhirServiceCollectionIterator) Value() FhirService {
	if !iter.page.NotDone() {
		return FhirService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FhirServiceCollectionIterator type.
func NewFhirServiceCollectionIterator(page FhirServiceCollectionPage) FhirServiceCollectionIterator {
	return FhirServiceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fsc FhirServiceCollection) IsEmpty() bool {
	return fsc.Value == nil || len(*fsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fsc FhirServiceCollection) hasNextLink() bool {
	return fsc.NextLink != nil && len(*fsc.NextLink) != 0
}

// fhirServiceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fsc FhirServiceCollection) fhirServiceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !fsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fsc.NextLink)))
}

// FhirServiceCollectionPage contains a page of FhirService values.
type FhirServiceCollectionPage struct {
	fn  func(context.Context, FhirServiceCollection) (FhirServiceCollection, error)
	fsc FhirServiceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FhirServiceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FhirServiceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fsc)
		if err != nil {
			return err
		}
		page.fsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FhirServiceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FhirServiceCollectionPage) NotDone() bool {
	return !page.fsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FhirServiceCollectionPage) Response() FhirServiceCollection {
	return page.fsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FhirServiceCollectionPage) Values() []FhirService {
	if page.fsc.IsEmpty() {
		return nil
	}
	return *page.fsc.Value
}

// Creates a new instance of the FhirServiceCollectionPage type.
func NewFhirServiceCollectionPage(cur FhirServiceCollection, getNextPage func(context.Context, FhirServiceCollection) (FhirServiceCollection, error)) FhirServiceCollectionPage {
	return FhirServiceCollectionPage{
		fn:  getNextPage,
		fsc: cur,
	}
}

// FhirServiceCorsConfiguration the settings for the CORS configuration of the service instance.
type FhirServiceCorsConfiguration struct {
	// Origins - The origins to be allowed via CORS.
	Origins *[]string `json:"origins,omitempty"`
	// Headers - The headers to be allowed via CORS.
	Headers *[]string `json:"headers,omitempty"`
	// Methods - The methods to be allowed via CORS.
	Methods *[]string `json:"methods,omitempty"`
	// MaxAge - The max age to be allowed via CORS.
	MaxAge *int32 `json:"maxAge,omitempty"`
	// AllowCredentials - If credentials are allowed via CORS.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`
}

// FhirServiceExportConfiguration export operation configuration information
type FhirServiceExportConfiguration struct {
	// StorageAccountName - The name of the default export storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
}

// FhirServicePatchResource fhirService patch properties
type FhirServicePatchResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for FhirServicePatchResource.
func (fspr FhirServicePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fspr.Tags != nil {
		objectMap["tags"] = fspr.Tags
	}
	if fspr.Identity != nil {
		objectMap["identity"] = fspr.Identity
	}
	return json.Marshal(objectMap)
}

// FhirServiceProperties fhir Service properties.
type FhirServiceProperties struct {
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AccessPolicies - Fhir Service access policies.
	AccessPolicies *[]FhirServiceAccessPolicyEntry `json:"accessPolicies,omitempty"`
	// AcrConfiguration - Fhir Service Azure container registry configuration.
	AcrConfiguration *FhirServiceAcrConfiguration `json:"acrConfiguration,omitempty"`
	// AuthenticationConfiguration - Fhir Service authentication configuration.
	AuthenticationConfiguration *FhirServiceAuthenticationConfiguration `json:"authenticationConfiguration,omitempty"`
	// CorsConfiguration - Fhir Service Cors configuration.
	CorsConfiguration *FhirServiceCorsConfiguration `json:"corsConfiguration,omitempty"`
	// ExportConfiguration - Fhir Service export configuration.
	ExportConfiguration *FhirServiceExportConfiguration `json:"exportConfiguration,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Control permission for data plane traffic coming from public networks while private endpoint is enabled. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// EventState - Fhir Service event support status. Possible values include: 'ServiceEventStateDisabled', 'ServiceEventStateEnabled', 'ServiceEventStateUpdating'
	EventState ServiceEventState `json:"eventState,omitempty"`
	// ResourceVersionPolicyConfiguration - Determines tracking of history for resources.
	ResourceVersionPolicyConfiguration *ResourceVersionPolicyConfiguration `json:"resourceVersionPolicyConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for FhirServiceProperties.
func (fsp FhirServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsp.ProvisioningState != "" {
		objectMap["provisioningState"] = fsp.ProvisioningState
	}
	if fsp.AccessPolicies != nil {
		objectMap["accessPolicies"] = fsp.AccessPolicies
	}
	if fsp.AcrConfiguration != nil {
		objectMap["acrConfiguration"] = fsp.AcrConfiguration
	}
	if fsp.AuthenticationConfiguration != nil {
		objectMap["authenticationConfiguration"] = fsp.AuthenticationConfiguration
	}
	if fsp.CorsConfiguration != nil {
		objectMap["corsConfiguration"] = fsp.CorsConfiguration
	}
	if fsp.ExportConfiguration != nil {
		objectMap["exportConfiguration"] = fsp.ExportConfiguration
	}
	if fsp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = fsp.PublicNetworkAccess
	}
	if fsp.EventState != "" {
		objectMap["eventState"] = fsp.EventState
	}
	if fsp.ResourceVersionPolicyConfiguration != nil {
		objectMap["resourceVersionPolicyConfiguration"] = fsp.ResourceVersionPolicyConfiguration
	}
	return json.Marshal(objectMap)
}

// FhirServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FhirServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FhirServicesClient) (FhirService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FhirServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FhirServicesCreateOrUpdateFuture.Result.
func (future *FhirServicesCreateOrUpdateFuture) result(client FhirServicesClient) (fs FhirService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.FhirServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fs.Response.Response, err = future.GetResult(sender); err == nil && fs.Response.Response.StatusCode != http.StatusNoContent {
		fs, err = client.CreateOrUpdateResponder(fs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.FhirServicesCreateOrUpdateFuture", "Result", fs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FhirServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FhirServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FhirServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FhirServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FhirServicesDeleteFuture.Result.
func (future *FhirServicesDeleteFuture) result(client FhirServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.FhirServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FhirServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FhirServicesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FhirServicesClient) (FhirService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FhirServicesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FhirServicesUpdateFuture.Result.
func (future *FhirServicesUpdateFuture) result(client FhirServicesClient) (fs FhirService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.FhirServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fs.Response.Response, err = future.GetResult(sender); err == nil && fs.Response.Response.StatusCode != http.StatusNoContent {
		fs, err = client.UpdateResponder(fs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.FhirServicesUpdateFuture", "Result", fs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotConnector ioT Connector definition.
type IotConnector struct {
	autorest.Response `json:"-"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
	// IotConnectorProperties - IoT Connector configuration.
	*IotConnectorProperties `json:"properties,omitempty"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for IotConnector.
func (ic IotConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.Tags != nil {
		objectMap["tags"] = ic.Tags
	}
	if ic.Location != nil {
		objectMap["location"] = ic.Location
	}
	if ic.Identity != nil {
		objectMap["identity"] = ic.Identity
	}
	if ic.IotConnectorProperties != nil {
		objectMap["properties"] = ic.IotConnectorProperties
	}
	if ic.SystemData != nil {
		objectMap["systemData"] = ic.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IotConnector struct.
func (ic *IotConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ic.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ic.Location = &location
			}
		case "identity":
			if v != nil {
				var identity ServiceManagedIdentityIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ic.Identity = &identity
			}
		case "properties":
			if v != nil {
				var iotConnectorProperties IotConnectorProperties
				err = json.Unmarshal(*v, &iotConnectorProperties)
				if err != nil {
					return err
				}
				ic.IotConnectorProperties = &iotConnectorProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ic.SystemData = &systemData
			}
		}
	}

	return nil
}

// IotConnectorCollection a collection of IoT Connectors.
type IotConnectorCollection struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of IoT Connectors.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of IoT Connectors.
	Value *[]IotConnector `json:"value,omitempty"`
}

// IotConnectorCollectionIterator provides access to a complete listing of IotConnector values.
type IotConnectorCollectionIterator struct {
	i    int
	page IotConnectorCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotConnectorCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotConnectorCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotConnectorCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotConnectorCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotConnectorCollectionIterator) Response() IotConnectorCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotConnectorCollectionIterator) Value() IotConnector {
	if !iter.page.NotDone() {
		return IotConnector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotConnectorCollectionIterator type.
func NewIotConnectorCollectionIterator(page IotConnectorCollectionPage) IotConnectorCollectionIterator {
	return IotConnectorCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (icc IotConnectorCollection) IsEmpty() bool {
	return icc.Value == nil || len(*icc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (icc IotConnectorCollection) hasNextLink() bool {
	return icc.NextLink != nil && len(*icc.NextLink) != 0
}

// iotConnectorCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (icc IotConnectorCollection) iotConnectorCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !icc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(icc.NextLink)))
}

// IotConnectorCollectionPage contains a page of IotConnector values.
type IotConnectorCollectionPage struct {
	fn  func(context.Context, IotConnectorCollection) (IotConnectorCollection, error)
	icc IotConnectorCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotConnectorCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotConnectorCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.icc)
		if err != nil {
			return err
		}
		page.icc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotConnectorCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotConnectorCollectionPage) NotDone() bool {
	return !page.icc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotConnectorCollectionPage) Response() IotConnectorCollection {
	return page.icc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotConnectorCollectionPage) Values() []IotConnector {
	if page.icc.IsEmpty() {
		return nil
	}
	return *page.icc.Value
}

// Creates a new instance of the IotConnectorCollectionPage type.
func NewIotConnectorCollectionPage(cur IotConnectorCollection, getNextPage func(context.Context, IotConnectorCollection) (IotConnectorCollection, error)) IotConnectorCollectionPage {
	return IotConnectorCollectionPage{
		fn:  getNextPage,
		icc: cur,
	}
}

// IotConnectorFhirDestinationCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type IotConnectorFhirDestinationCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotConnectorFhirDestinationClient) (IotFhirDestination, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotConnectorFhirDestinationCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotConnectorFhirDestinationCreateOrUpdateFuture.Result.
func (future *IotConnectorFhirDestinationCreateOrUpdateFuture) result(client IotConnectorFhirDestinationClient) (ifd IotFhirDestination, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorFhirDestinationCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.IotConnectorFhirDestinationCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifd.Response.Response, err = future.GetResult(sender); err == nil && ifd.Response.Response.StatusCode != http.StatusNoContent {
		ifd, err = client.CreateOrUpdateResponder(ifd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorFhirDestinationCreateOrUpdateFuture", "Result", ifd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotConnectorFhirDestinationDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IotConnectorFhirDestinationDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotConnectorFhirDestinationClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotConnectorFhirDestinationDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotConnectorFhirDestinationDeleteFuture.Result.
func (future *IotConnectorFhirDestinationDeleteFuture) result(client IotConnectorFhirDestinationClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorFhirDestinationDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.IotConnectorFhirDestinationDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IotConnectorPatchResource iot Connector patch properties
type IotConnectorPatchResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for IotConnectorPatchResource.
func (icpr IotConnectorPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icpr.Tags != nil {
		objectMap["tags"] = icpr.Tags
	}
	if icpr.Identity != nil {
		objectMap["identity"] = icpr.Identity
	}
	return json.Marshal(objectMap)
}

// IotConnectorProperties ioT Connector properties.
type IotConnectorProperties struct {
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// IngestionEndpointConfiguration - Source configuration.
	IngestionEndpointConfiguration *IotEventHubIngestionEndpointConfiguration `json:"ingestionEndpointConfiguration,omitempty"`
	// DeviceMapping - Device Mappings.
	DeviceMapping *IotMappingProperties `json:"deviceMapping,omitempty"`
}

// IotConnectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IotConnectorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotConnectorsClient) (IotConnector, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotConnectorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotConnectorsCreateOrUpdateFuture.Result.
func (future *IotConnectorsCreateOrUpdateFuture) result(client IotConnectorsClient) (ic IotConnector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ic.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.IotConnectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ic.Response.Response, err = future.GetResult(sender); err == nil && ic.Response.Response.StatusCode != http.StatusNoContent {
		ic, err = client.CreateOrUpdateResponder(ic.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorsCreateOrUpdateFuture", "Result", ic.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotConnectorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotConnectorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotConnectorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotConnectorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotConnectorsDeleteFuture.Result.
func (future *IotConnectorsDeleteFuture) result(client IotConnectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.IotConnectorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IotConnectorsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotConnectorsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotConnectorsClient) (IotConnector, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotConnectorsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotConnectorsUpdateFuture.Result.
func (future *IotConnectorsUpdateFuture) result(client IotConnectorsClient) (ic IotConnector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ic.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.IotConnectorsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ic.Response.Response, err = future.GetResult(sender); err == nil && ic.Response.Response.StatusCode != http.StatusNoContent {
		ic, err = client.UpdateResponder(ic.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.IotConnectorsUpdateFuture", "Result", ic.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDestinationProperties common IoT Connector destination properties.
type IotDestinationProperties struct {
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// IotEventHubIngestionEndpointConfiguration event Hub ingestion endpoint configuration
type IotEventHubIngestionEndpointConfiguration struct {
	// EventHubName - Event Hub name to connect to.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ConsumerGroup - Consumer group of the event hub to connected to.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// FullyQualifiedEventHubNamespace - Fully qualified namespace of the Event Hub to connect to.
	FullyQualifiedEventHubNamespace *string `json:"fullyQualifiedEventHubNamespace,omitempty"`
}

// IotFhirDestination ioT Connector FHIR destination definition.
type IotFhirDestination struct {
	autorest.Response `json:"-"`
	// IotFhirDestinationProperties - IoT FHIR Destination settings.
	*IotFhirDestinationProperties `json:"properties,omitempty"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Etag - An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for IotFhirDestination.
func (ifd IotFhirDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifd.IotFhirDestinationProperties != nil {
		objectMap["properties"] = ifd.IotFhirDestinationProperties
	}
	if ifd.SystemData != nil {
		objectMap["systemData"] = ifd.SystemData
	}
	if ifd.Location != nil {
		objectMap["location"] = ifd.Location
	}
	if ifd.Etag != nil {
		objectMap["etag"] = ifd.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IotFhirDestination struct.
func (ifd *IotFhirDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iotFhirDestinationProperties IotFhirDestinationProperties
				err = json.Unmarshal(*v, &iotFhirDestinationProperties)
				if err != nil {
					return err
				}
				ifd.IotFhirDestinationProperties = &iotFhirDestinationProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ifd.SystemData = &systemData
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ifd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifd.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ifd.Etag = &etag
			}
		}
	}

	return nil
}

// IotFhirDestinationCollection a collection of IoT Connector FHIR destinations.
type IotFhirDestinationCollection struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of IoT FHIR destinations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of IoT Connector FHIR destinations.
	Value *[]IotFhirDestination `json:"value,omitempty"`
}

// IotFhirDestinationCollectionIterator provides access to a complete listing of IotFhirDestination values.
type IotFhirDestinationCollectionIterator struct {
	i    int
	page IotFhirDestinationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotFhirDestinationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotFhirDestinationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotFhirDestinationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotFhirDestinationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotFhirDestinationCollectionIterator) Response() IotFhirDestinationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotFhirDestinationCollectionIterator) Value() IotFhirDestination {
	if !iter.page.NotDone() {
		return IotFhirDestination{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotFhirDestinationCollectionIterator type.
func NewIotFhirDestinationCollectionIterator(page IotFhirDestinationCollectionPage) IotFhirDestinationCollectionIterator {
	return IotFhirDestinationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifdc IotFhirDestinationCollection) IsEmpty() bool {
	return ifdc.Value == nil || len(*ifdc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ifdc IotFhirDestinationCollection) hasNextLink() bool {
	return ifdc.NextLink != nil && len(*ifdc.NextLink) != 0
}

// iotFhirDestinationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifdc IotFhirDestinationCollection) iotFhirDestinationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ifdc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifdc.NextLink)))
}

// IotFhirDestinationCollectionPage contains a page of IotFhirDestination values.
type IotFhirDestinationCollectionPage struct {
	fn   func(context.Context, IotFhirDestinationCollection) (IotFhirDestinationCollection, error)
	ifdc IotFhirDestinationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotFhirDestinationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotFhirDestinationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ifdc)
		if err != nil {
			return err
		}
		page.ifdc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotFhirDestinationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotFhirDestinationCollectionPage) NotDone() bool {
	return !page.ifdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotFhirDestinationCollectionPage) Response() IotFhirDestinationCollection {
	return page.ifdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotFhirDestinationCollectionPage) Values() []IotFhirDestination {
	if page.ifdc.IsEmpty() {
		return nil
	}
	return *page.ifdc.Value
}

// Creates a new instance of the IotFhirDestinationCollectionPage type.
func NewIotFhirDestinationCollectionPage(cur IotFhirDestinationCollection, getNextPage func(context.Context, IotFhirDestinationCollection) (IotFhirDestinationCollection, error)) IotFhirDestinationCollectionPage {
	return IotFhirDestinationCollectionPage{
		fn:   getNextPage,
		ifdc: cur,
	}
}

// IotFhirDestinationProperties ioT Connector destination properties for an Azure FHIR service.
type IotFhirDestinationProperties struct {
	// ResourceIdentityResolutionType - Determines how resource identity is resolved on the destination. Possible values include: 'IotIdentityResolutionTypeCreate', 'IotIdentityResolutionTypeLookup'
	ResourceIdentityResolutionType IotIdentityResolutionType `json:"resourceIdentityResolutionType,omitempty"`
	// FhirServiceResourceID - Fully qualified resource id of the FHIR service to connect to.
	FhirServiceResourceID *string `json:"fhirServiceResourceId,omitempty"`
	// FhirMapping - FHIR Mappings
	FhirMapping *IotMappingProperties `json:"fhirMapping,omitempty"`
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// IotMappingProperties the mapping content.
type IotMappingProperties struct {
	// Content - The mapping.
	Content interface{} `json:"content,omitempty"`
}

// ListOperations available operations of the service
type ListOperations struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of available operation details
	Value *[]OperationDetail `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListOperations.
func (lo ListOperations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lo.NextLink != nil {
		objectMap["nextLink"] = lo.NextLink
	}
	return json.Marshal(objectMap)
}

// ListOperationsIterator provides access to a complete listing of OperationDetail values.
type ListOperationsIterator struct {
	i    int
	page ListOperationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListOperationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListOperationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListOperationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListOperationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListOperationsIterator) Response() ListOperations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListOperationsIterator) Value() OperationDetail {
	if !iter.page.NotDone() {
		return OperationDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListOperationsIterator type.
func NewListOperationsIterator(page ListOperationsPage) ListOperationsIterator {
	return ListOperationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lo ListOperations) IsEmpty() bool {
	return lo.Value == nil || len(*lo.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lo ListOperations) hasNextLink() bool {
	return lo.NextLink != nil && len(*lo.NextLink) != 0
}

// listOperationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lo ListOperations) listOperationsPreparer(ctx context.Context) (*http.Request, error) {
	if !lo.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lo.NextLink)))
}

// ListOperationsPage contains a page of OperationDetail values.
type ListOperationsPage struct {
	fn func(context.Context, ListOperations) (ListOperations, error)
	lo ListOperations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListOperationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListOperationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lo)
		if err != nil {
			return err
		}
		page.lo = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListOperationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListOperationsPage) NotDone() bool {
	return !page.lo.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListOperationsPage) Response() ListOperations {
	return page.lo
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListOperationsPage) Values() []OperationDetail {
	if page.lo.IsEmpty() {
		return nil
	}
	return *page.lo.Value
}

// Creates a new instance of the ListOperationsPage type.
func NewListOperationsPage(cur ListOperations, getNextPage func(context.Context, ListOperations) (ListOperations, error)) ListOperationsPage {
	return ListOperationsPage{
		fn: getNextPage,
		lo: cur,
	}
}

// LocationBasedResource the common properties for any location based resource, tracked or proxy.
type LocationBasedResource struct {
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Etag - An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationBasedResource.
func (lbr LocationBasedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbr.Location != nil {
		objectMap["location"] = lbr.Location
	}
	if lbr.Etag != nil {
		objectMap["etag"] = lbr.Etag
	}
	return json.Marshal(objectMap)
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricDimension specifications of the Dimension of metrics
type MetricDimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - Whether this dimension should be included for the Shoebox export scenario
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
	// Category - Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - Supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Dimensions - Dimensions of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// SourceMdmNamespace - Name of the MDM namespace. Optional.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
}

// OperationDetail service REST API operation.
type OperationDetail struct {
	// Name - READ-ONLY; Name of the operation
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; Default value is 'user,system'.
	Origin *string `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
	// Properties - Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDetail.
func (od OperationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if od.Display != nil {
		objectMap["display"] = od.Display
	}
	if od.Properties != nil {
		objectMap["properties"] = od.Properties
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.HealthcareApis
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource Type: Services
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Friendly description for the operation,
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (od OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationProperties extra Operation properties
type OperationProperties struct {
	// ServiceSpecification - Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationResultsDescription the properties indicating the operation result of an operation on a service.
type OperationResultsDescription struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the operation returned.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the operation result.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the operation being performed. Possible values include: 'OperationResultStatusCanceled', 'OperationResultStatusSucceeded', 'OperationResultStatusFailed', 'OperationResultStatusRequested', 'OperationResultStatusRunning'
	Status OperationResultStatus `json:"status,omitempty"`
	// StartTime - READ-ONLY; The time that the operation was started.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The time that the operation finished.
	EndTime *string `json:"endTime,omitempty"`
	// Properties - Additional properties of the operation result.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResultsDescription.
func (ord OperationResultsDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ord.Properties != nil {
		objectMap["properties"] = ord.Properties
	}
	return json.Marshal(objectMap)
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionDescription the Private Endpoint Connection resource.
type PrivateEndpointConnectionDescription struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionDescription.
func (pecd PrivateEndpointConnectionDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecd.SystemData != nil {
		objectMap["systemData"] = pecd.SystemData
	}
	if pecd.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pecd.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionDescription struct.
func (pecd *PrivateEndpointConnectionDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pecd.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pecd.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pecd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pecd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pecd.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionListResultDescription list of private endpoint connection associated with the
// specified storage account
type PrivateEndpointConnectionListResultDescription struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnectionDescription `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnectionDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pecd PrivateEndpointConnectionDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pecd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pecd.Response.Response, err = future.GetResult(sender); err == nil && pecd.Response.Response.StatusCode != http.StatusNoContent {
		pecd, err = client.CreateOrUpdateResponder(pecd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pecd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceDescription the Private Endpoint Connection resource.
type PrivateLinkResourceDescription struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceDescription.
func (plrd PrivateLinkResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrd.SystemData != nil {
		objectMap["systemData"] = plrd.SystemData
	}
	if plrd.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plrd.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResourceDescription struct.
func (plrd *PrivateLinkResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				plrd.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plrd.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plrd.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResultDescription a list of private link resources
type PrivateLinkResourceListResultDescription struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResourceDescription `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceCore the common properties for any resource, tracked or proxy.
type ResourceCore struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Etag - An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceCore.
func (rc ResourceCore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rc.Etag != nil {
		objectMap["etag"] = rc.Etag
	}
	return json.Marshal(objectMap)
}

// ResourceTags list of key value pairs that describe the resource. This will overwrite the existing tags.
type ResourceTags struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceTags.
func (rt ResourceTags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceVersionPolicyConfiguration the settings for history tracking for FHIR resources.
type ResourceVersionPolicyConfiguration struct {
	// Default - The default value for tracking history across all resources. Possible values include: 'FhirResourceVersionPolicyNoVersion', 'FhirResourceVersionPolicyVersioned', 'FhirResourceVersionPolicyVersionedUpdate'
	Default FhirResourceVersionPolicy `json:"default,omitempty"`
	// ResourceTypeOverrides - A list of FHIR Resources and their version policy overrides.
	ResourceTypeOverrides map[string]*FhirResourceVersionPolicy `json:"resourceTypeOverrides"`
}

// MarshalJSON is the custom marshaler for ResourceVersionPolicyConfiguration.
func (rvpc ResourceVersionPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rvpc.Default != "" {
		objectMap["default"] = rvpc.Default
	}
	if rvpc.ResourceTypeOverrides != nil {
		objectMap["resourceTypeOverrides"] = rvpc.ResourceTypeOverrides
	}
	return json.Marshal(objectMap)
}

// ServiceAccessPolicyEntry an access policy entry.
type ServiceAccessPolicyEntry struct {
	// ObjectID - An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
	ObjectID *string `json:"objectId,omitempty"`
}

// ServiceAcrConfigurationInfo azure container registry configuration information
type ServiceAcrConfigurationInfo struct {
	// LoginServers - The list of the ACR login servers.
	LoginServers *[]string `json:"loginServers,omitempty"`
	// OciArtifacts - The list of Open Container Initiative (OCI) artifacts.
	OciArtifacts *[]ServiceOciArtifactEntry `json:"ociArtifacts,omitempty"`
}

// ServiceAuthenticationConfigurationInfo authentication configuration information
type ServiceAuthenticationConfigurationInfo struct {
	// Authority - The authority url for the service
	Authority *string `json:"authority,omitempty"`
	// Audience - The audience url for the service
	Audience *string `json:"audience,omitempty"`
	// SmartProxyEnabled - If the SMART on FHIR proxy is enabled
	SmartProxyEnabled *bool `json:"smartProxyEnabled,omitempty"`
}

// ServiceCorsConfigurationInfo the settings for the CORS configuration of the service instance.
type ServiceCorsConfigurationInfo struct {
	// Origins - The origins to be allowed via CORS.
	Origins *[]string `json:"origins,omitempty"`
	// Headers - The headers to be allowed via CORS.
	Headers *[]string `json:"headers,omitempty"`
	// Methods - The methods to be allowed via CORS.
	Methods *[]string `json:"methods,omitempty"`
	// MaxAge - The max age to be allowed via CORS.
	MaxAge *int32 `json:"maxAge,omitempty"`
	// AllowCredentials - If credentials are allowed via CORS.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`
}

// ServiceCosmosDbConfigurationInfo the settings for the Cosmos DB database backing the service.
type ServiceCosmosDbConfigurationInfo struct {
	// OfferThroughput - The provisioned throughput for the backing database.
	OfferThroughput *int32 `json:"offerThroughput,omitempty"`
	// KeyVaultKeyURI - The URI of the customer-managed key for the backing database.
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`
}

// ServiceExportConfigurationInfo export operation configuration information
type ServiceExportConfigurationInfo struct {
	// StorageAccountName - The name of the default export storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
}

// ServiceManagedIdentity managed service identity (system assigned and/or user assigned identities)
type ServiceManagedIdentity struct {
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
}

// ServiceManagedIdentityIdentity setting indicating whether the service has a managed identity associated
// with it.
type ServiceManagedIdentityIdentity struct {
	// Type - Type of identity being specified, currently SystemAssigned and None are allowed. Possible values include: 'ServiceManagedIdentityTypeNone', 'ServiceManagedIdentityTypeSystemAssigned', 'ServiceManagedIdentityTypeUserAssigned', 'ServiceManagedIdentityTypeSystemAssignedUserAssigned'
	Type ServiceManagedIdentityType `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID               *uuid.UUID                       `json:"tenantId,omitempty"`
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ServiceManagedIdentityIdentity.
func (smi ServiceManagedIdentityIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smi.Type != "" {
		objectMap["type"] = smi.Type
	}
	if smi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = smi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ServiceOciArtifactEntry an Open Container Initiative (OCI) artifact.
type ServiceOciArtifactEntry struct {
	// LoginServer - The Azure Container Registry login server.
	LoginServer *string `json:"loginServer,omitempty"`
	// ImageName - The artifact name.
	ImageName *string `json:"imageName,omitempty"`
	// Digest - The artifact digest.
	Digest *string `json:"digest,omitempty"`
}

// ServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServicesDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesCreateOrUpdateFuture.Result.
func (future *ServicesCreateOrUpdateFuture) result(client ServicesClient) (sd ServicesDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.ServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.ServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sd.Response.Response, err = future.GetResult(sender); err == nil && sd.Response.Response.StatusCode != http.StatusNoContent {
		sd, err = client.CreateOrUpdateResponder(sd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.ServicesCreateOrUpdateFuture", "Result", sd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesDeleteFuture.Result.
func (future *ServicesDeleteFuture) result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesDescription the description of the service.
type ServicesDescription struct {
	autorest.Response `json:"-"`
	// Properties - The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Kind - The kind of the service. Possible values include: 'KindFhir', 'KindFhirStu3', 'KindFhirR4'
	Kind Kind `json:"kind,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicesDescription.
func (sd ServicesDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.Properties != nil {
		objectMap["properties"] = sd.Properties
	}
	if sd.SystemData != nil {
		objectMap["systemData"] = sd.SystemData
	}
	if sd.Kind != "" {
		objectMap["kind"] = sd.Kind
	}
	if sd.Location != nil {
		objectMap["location"] = sd.Location
	}
	if sd.Tags != nil {
		objectMap["tags"] = sd.Tags
	}
	if sd.Etag != nil {
		objectMap["etag"] = sd.Etag
	}
	if sd.Identity != nil {
		objectMap["identity"] = sd.Identity
	}
	return json.Marshal(objectMap)
}

// ServicesDescriptionListResult a list of service description objects with a next link.
type ServicesDescriptionListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - A list of service description objects.
	Value *[]ServicesDescription `json:"value,omitempty"`
}

// ServicesDescriptionListResultIterator provides access to a complete listing of ServicesDescription
// values.
type ServicesDescriptionListResultIterator struct {
	i    int
	page ServicesDescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServicesDescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesDescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServicesDescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServicesDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServicesDescriptionListResultIterator) Response() ServicesDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServicesDescriptionListResultIterator) Value() ServicesDescription {
	if !iter.page.NotDone() {
		return ServicesDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServicesDescriptionListResultIterator type.
func NewServicesDescriptionListResultIterator(page ServicesDescriptionListResultPage) ServicesDescriptionListResultIterator {
	return ServicesDescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdlr ServicesDescriptionListResult) IsEmpty() bool {
	return sdlr.Value == nil || len(*sdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdlr ServicesDescriptionListResult) hasNextLink() bool {
	return sdlr.NextLink != nil && len(*sdlr.NextLink) != 0
}

// servicesDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdlr ServicesDescriptionListResult) servicesDescriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdlr.NextLink)))
}

// ServicesDescriptionListResultPage contains a page of ServicesDescription values.
type ServicesDescriptionListResultPage struct {
	fn   func(context.Context, ServicesDescriptionListResult) (ServicesDescriptionListResult, error)
	sdlr ServicesDescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServicesDescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesDescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdlr)
		if err != nil {
			return err
		}
		page.sdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServicesDescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServicesDescriptionListResultPage) NotDone() bool {
	return !page.sdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServicesDescriptionListResultPage) Response() ServicesDescriptionListResult {
	return page.sdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServicesDescriptionListResultPage) Values() []ServicesDescription {
	if page.sdlr.IsEmpty() {
		return nil
	}
	return *page.sdlr.Value
}

// Creates a new instance of the ServicesDescriptionListResultPage type.
func NewServicesDescriptionListResultPage(cur ServicesDescriptionListResult, getNextPage func(context.Context, ServicesDescriptionListResult) (ServicesDescriptionListResult, error)) ServicesDescriptionListResultPage {
	return ServicesDescriptionListResultPage{
		fn:   getNextPage,
		sdlr: cur,
	}
}

// ServicesNameAvailabilityInfo the properties indicating whether a given service name is available.
type ServicesNameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason for unavailability. Possible values include: 'ServiceNameUnavailabilityReasonInvalid', 'ServiceNameUnavailabilityReasonAlreadyExists'
	Reason ServiceNameUnavailabilityReason `json:"reason,omitempty"`
	// Message - The detailed reason message.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicesNameAvailabilityInfo.
func (snai ServicesNameAvailabilityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if snai.Message != nil {
		objectMap["message"] = snai.Message
	}
	return json.Marshal(objectMap)
}

// ServicesPatchDescription the description of the service.
type ServicesPatchDescription struct {
	// Tags - Instance tags
	Tags map[string]*string `json:"tags"`
	// ServicesPropertiesUpdateParameters - The properties for updating a service instance.
	*ServicesPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicesPatchDescription.
func (spd ServicesPatchDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spd.Tags != nil {
		objectMap["tags"] = spd.Tags
	}
	if spd.ServicesPropertiesUpdateParameters != nil {
		objectMap["properties"] = spd.ServicesPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServicesPatchDescription struct.
func (spd *ServicesPatchDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				spd.Tags = tags
			}
		case "properties":
			if v != nil {
				var servicesPropertiesUpdateParameters ServicesPropertiesUpdateParameters
				err = json.Unmarshal(*v, &servicesPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				spd.ServicesPropertiesUpdateParameters = &servicesPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// ServicesProperties the properties of a service instance.
type ServicesProperties struct {
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AccessPolicies - The access policies of the service instance.
	AccessPolicies *[]ServiceAccessPolicyEntry `json:"accessPolicies,omitempty"`
	// CosmosDbConfiguration - The settings for the Cosmos DB database backing the service.
	CosmosDbConfiguration *ServiceCosmosDbConfigurationInfo `json:"cosmosDbConfiguration,omitempty"`
	// AuthenticationConfiguration - The authentication configuration for the service instance.
	AuthenticationConfiguration *ServiceAuthenticationConfigurationInfo `json:"authenticationConfiguration,omitempty"`
	// CorsConfiguration - The settings for the CORS configuration of the service instance.
	CorsConfiguration *ServiceCorsConfigurationInfo `json:"corsConfiguration,omitempty"`
	// ExportConfiguration - The settings for the export operation of the service instance.
	ExportConfiguration *ServiceExportConfigurationInfo `json:"exportConfiguration,omitempty"`
	// PrivateEndpointConnections - The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Control permission for data plane traffic coming from public networks while private endpoint is enabled. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// AcrConfiguration - The azure container registry settings used for convert data operation of the service instance.
	AcrConfiguration *ServiceAcrConfigurationInfo `json:"acrConfiguration,omitempty"`
}

// ServicesPropertiesUpdateParameters the properties for updating a service instance.
type ServicesPropertiesUpdateParameters struct {
	// PublicNetworkAccess - Control permission for data plane traffic coming from public networks while private endpoint is enabled. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// ServicesResource the common properties of a service.
type ServicesResource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Kind - The kind of the service. Possible values include: 'KindFhir', 'KindFhirStu3', 'KindFhirR4'
	Kind Kind `json:"kind,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`
	// Identity - Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicesResource.
func (sr ServicesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Kind != "" {
		objectMap["kind"] = sr.Kind
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.Identity != nil {
		objectMap["identity"] = sr.Identity
	}
	return json.Marshal(objectMap)
}

// ServicesResourceIdentity setting indicating whether the service has a managed identity associated with
// it.
type ServicesResourceIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Type of identity being specified, currently SystemAssigned and None are allowed. Possible values include: 'ManagedServiceIdentityTypeSystemAssigned', 'ManagedServiceIdentityTypeNone'
	Type ManagedServiceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicesResourceIdentity.
func (sr ServicesResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Type != "" {
		objectMap["type"] = sr.Type
	}
	return json.Marshal(objectMap)
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServicesDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServicesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServicesUpdateFuture.Result.
func (future *ServicesUpdateFuture) result(client ServicesClient) (sd ServicesDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sd.Response.Response, err = future.GetResult(sender); err == nil && sd.Response.Response.StatusCode != http.StatusNoContent {
		sd, err = client.UpdateResponder(sd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.ServicesUpdateFuture", "Result", sd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TaggedResource the common properties of tracked resources in the service.
type TaggedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for TaggedResource.
func (tr TaggedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserAssignedIdentity user assigned identity properties
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client ID of the assigned identity.
	ClientID *uuid.UUID `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Workspace workspace resource.
type Workspace struct {
	autorest.Response `json:"-"`
	// Properties - Workspaces resource specific properties.
	Properties *WorkspaceProperties `json:"properties,omitempty"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.Properties != nil {
		objectMap["properties"] = w.Properties
	}
	if w.SystemData != nil {
		objectMap["systemData"] = w.SystemData
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// WorkspaceList collection of workspace object with a next link
type WorkspaceList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of resources.
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspaceListIterator provides access to a complete listing of Workspace values.
type WorkspaceListIterator struct {
	i    int
	page WorkspaceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListIterator) Response() WorkspaceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListIterator type.
func NewWorkspaceListIterator(page WorkspaceListPage) WorkspaceListIterator {
	return WorkspaceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wl WorkspaceList) IsEmpty() bool {
	return wl.Value == nil || len(*wl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wl WorkspaceList) hasNextLink() bool {
	return wl.NextLink != nil && len(*wl.NextLink) != 0
}

// workspaceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wl WorkspaceList) workspaceListPreparer(ctx context.Context) (*http.Request, error) {
	if !wl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wl.NextLink)))
}

// WorkspaceListPage contains a page of Workspace values.
type WorkspaceListPage struct {
	fn func(context.Context, WorkspaceList) (WorkspaceList, error)
	wl WorkspaceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wl)
		if err != nil {
			return err
		}
		page.wl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListPage) NotDone() bool {
	return !page.wl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListPage) Response() WorkspaceList {
	return page.wl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListPage) Values() []Workspace {
	if page.wl.IsEmpty() {
		return nil
	}
	return *page.wl.Value
}

// Creates a new instance of the WorkspaceListPage type.
func NewWorkspaceListPage(cur WorkspaceList, getNextPage func(context.Context, WorkspaceList) (WorkspaceList, error)) WorkspaceListPage {
	return WorkspaceListPage{
		fn: getNextPage,
		wl: cur,
	}
}

// WorkspacePatchResource workspace patch properties
type WorkspacePatchResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkspacePatchResource.
func (wpr WorkspacePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpr.Tags != nil {
		objectMap["tags"] = wpr.Tags
	}
	return json.Marshal(objectMap)
}

// WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacePrivateEndpointConnectionsClient) (PrivateEndpointConnectionDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture) result(client WorkspacePrivateEndpointConnectionsClient) (pecd PrivateEndpointConnectionDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pecd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pecd.Response.Response, err = future.GetResult(sender); err == nil && pecd.Response.Response.StatusCode != http.StatusNoContent {
		pecd, err = client.CreateOrUpdateResponder(pecd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacePrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pecd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacePrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type WorkspacePrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacePrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacePrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacePrivateEndpointConnectionsDeleteFuture.Result.
func (future *WorkspacePrivateEndpointConnectionsDeleteFuture) result(client WorkspacePrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacePrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.WorkspacePrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceProperties workspaces resource specific properties.
type WorkspaceProperties struct {
	// ProvisioningState - The provisioning state. Possible values include: 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateCreating', 'ProvisioningStateAccepted', 'ProvisioningStateVerifying', 'ProvisioningStateUpdating', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeprovisioned', 'ProvisioningStateMoving', 'ProvisioningStateSuspended', 'ProvisioningStateWarned', 'ProvisioningStateSystemMaintenance'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Control permission for data plane traffic coming from public networks while private endpoint is enabled. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.ProvisioningState != "" {
		objectMap["provisioningState"] = w.ProvisioningState
	}
	if w.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = w.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesCreateOrUpdateFuture.Result.
func (future *WorkspacesCreateOrUpdateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDeleteFuture.Result.
func (future *WorkspacesDeleteFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspacesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesUpdateFuture.Result.
func (future *WorkspacesUpdateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthcareapis.WorkspacesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.UpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthcareapis.WorkspacesUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}
