// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package timestreamquery

import (
	"fmt"
	"net/url"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/crr"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelQuery = "CancelQuery"

// CancelQueryRequest generates a "aws/request.Request" representing the
// client's request for the CancelQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelQuery for more information on using the CancelQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelQueryRequest method.
//    req, resp := client.CancelQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/CancelQuery
func (c *TimestreamQuery) CancelQueryRequest(input *CancelQueryInput) (req *request.Request, output *CancelQueryOutput) {
	op := &request.Operation{
		Name:       opCancelQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelQueryInput{}
	}

	output = &CancelQueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CancelQuery API operation for Amazon Timestream Query.
//
// Cancels a query that has been issued. Cancellation is guaranteed only if
// the query has not completed execution before the cancellation request was
// issued. Because cancellation is an idempotent operation, subsequent cancellation
// requests will return a CancellationMessage, indicating that the query has
// already been canceled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation CancelQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/CancelQuery
func (c *TimestreamQuery) CancelQuery(input *CancelQueryInput) (*CancelQueryOutput, error) {
	req, out := c.CancelQueryRequest(input)
	return out, req.Send()
}

// CancelQueryWithContext is the same as CancelQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CancelQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) CancelQueryWithContext(ctx aws.Context, input *CancelQueryInput, opts ...request.Option) (*CancelQueryOutput, error) {
	req, out := c.CancelQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DescribeEndpoints
func (c *TimestreamQuery) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for Amazon Timestream Query.
//
// DescribeEndpoints returns a list of available endpoints to make Timestream
// API calls against. This API is available through both Write and Query.
//
// Because Timestream’s SDKs are designed to transparently work with the service’s
// architecture, including the management and mapping of the service endpoints,
// it is not recommended that you use this API unless:
//
//    * Your application uses a programming language that does not yet have
//    SDK support
//
//    * You require better control over the client-side implementation
//
// For detailed information on how to use DescribeEndpoints, see The Endpoint
// Discovery Pattern and REST APIs (https://docs.aws.amazon.com/timestream/latest/developerguide/Using-API.endpoint-discovery.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DescribeEndpoints
func (c *TimestreamQuery) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type discovererDescribeEndpoints struct {
	Client        *TimestreamQuery
	Required      bool
	EndpointCache *crr.EndpointCache
	Params        map[string]*string
	Key           string
	req           *request.Request
}

func (d *discovererDescribeEndpoints) Discover() (crr.Endpoint, error) {
	input := &DescribeEndpointsInput{}

	resp, err := d.Client.DescribeEndpoints(input)
	if err != nil {
		return crr.Endpoint{}, err
	}

	endpoint := crr.Endpoint{
		Key: d.Key,
	}

	for _, e := range resp.Endpoints {
		if e.Address == nil {
			continue
		}

		address := *e.Address

		var scheme string
		if idx := strings.Index(address, "://"); idx != -1 {
			scheme = address[:idx]
		}

		if len(scheme) == 0 {
			address = fmt.Sprintf("%s://%s", d.req.HTTPRequest.URL.Scheme, address)
		}

		cachedInMinutes := aws.Int64Value(e.CachePeriodInMinutes)
		u, err := url.Parse(address)
		if err != nil {
			continue
		}

		addr := crr.WeightedAddress{
			URL:     u,
			Expired: time.Now().Add(time.Duration(cachedInMinutes) * time.Minute),
		}

		endpoint.Add(addr)
	}

	d.EndpointCache.Add(endpoint)

	return endpoint, nil
}

func (d *discovererDescribeEndpoints) Handler(r *request.Request) {
	endpointKey := crr.BuildEndpointKey(d.Params)
	d.Key = endpointKey
	d.req = r

	endpoint, err := d.EndpointCache.Get(d, endpointKey, d.Required)
	if err != nil {
		r.Error = err
		return
	}

	if endpoint.URL != nil && len(endpoint.URL.String()) > 0 {
		r.HTTPRequest.URL = endpoint.URL
	}
}

const opQuery = "Query"

// QueryRequest generates a "aws/request.Request" representing the
// client's request for the Query operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Query for more information on using the Query
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryRequest method.
//    req, resp := client.QueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/Query
func (c *TimestreamQuery) QueryRequest(input *QueryInput) (req *request.Request, output *QueryOutput) {
	op := &request.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRows",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &QueryInput{}
	}

	output = &QueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// Query API operation for Amazon Timestream Query.
//
// Query is a synchronous operation that enables you to execute a query. Query
// will timeout after 60 seconds. You must update the default timeout in the
// SDK to support a timeout of 60 seconds. The result set will be truncated
// to 1MB. Service quotas apply. For more information, see Quotas in the Timestream
// Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation Query for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ConflictException
//   Unable to poll results for a cancelled query.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * QueryExecutionException
//   Timestream was unable to run the query successfully.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/Query
func (c *TimestreamQuery) Query(input *QueryInput) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	return out, req.Send()
}

// QueryWithContext is the same as Query with the addition of
// the ability to pass a context and additional request options.
//
// See Query for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) QueryWithContext(ctx aws.Context, input *QueryInput, opts ...request.Option) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// QueryPages iterates over the pages of a Query operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Query method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Query operation.
//    pageNum := 0
//    err := client.QueryPages(params,
//        func(page *timestreamquery.QueryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TimestreamQuery) QueryPages(input *QueryInput, fn func(*QueryOutput, bool) bool) error {
	return c.QueryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// QueryPagesWithContext same as QueryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) QueryPagesWithContext(ctx aws.Context, input *QueryInput, fn func(*QueryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *QueryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.QueryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*QueryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// You are not authorized to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelQueryInput struct {
	_ struct{} `type:"structure"`

	// The id of the query that needs to be cancelled. QueryID is returned as part
	// of QueryResult.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelQueryInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *CancelQueryInput) SetQueryId(v string) *CancelQueryInput {
	s.QueryId = &v
	return s
}

type CancelQueryOutput struct {
	_ struct{} `type:"structure"`

	// A CancellationMessage is returned when a CancelQuery request for the query
	// specified by QueryId has already been issued.
	CancellationMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryOutput) GoString() string {
	return s.String()
}

// SetCancellationMessage sets the CancellationMessage field's value.
func (s *CancelQueryOutput) SetCancellationMessage(v string) *CancelQueryOutput {
	s.CancellationMessage = &v
	return s
}

// Contains the meta data for query results such as the column names, data types,
// and other attributes.
type ColumnInfo struct {
	_ struct{} `type:"structure"`

	// The name of the result set column. The name of the result set is available
	// for columns of all data types except for arrays.
	Name *string `type:"string"`

	// The data type of the result set column. The data type can be a scalar or
	// complex. Scalar data types are integers, strings, doubles, booleans, and
	// others. Complex data types are types such as arrays, rows, and others.
	//
	// Type is a required field
	Type *Type `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ColumnInfo) SetName(v string) *ColumnInfo {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnInfo) SetType(v *Type) *ColumnInfo {
	s.Type = v
	return s
}

// Unable to poll results for a cancelled query.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Datum represents a single data point in a query result.
type Datum struct {
	_ struct{} `type:"structure"`

	// Indicates if the data point is an array.
	ArrayValue []*Datum `type:"list"`

	// Indicates if the data point is null.
	NullValue *bool `type:"boolean"`

	// Indicates if the data point is a row.
	RowValue *Row `type:"structure"`

	// Indicates if the data point is a scalar value such as integer, string, double,
	// or boolean.
	ScalarValue *string `type:"string"`

	// Indicates if the data point is of timeseries data type.
	TimeSeriesValue []*TimeSeriesDataPoint `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Datum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Datum) GoString() string {
	return s.String()
}

// SetArrayValue sets the ArrayValue field's value.
func (s *Datum) SetArrayValue(v []*Datum) *Datum {
	s.ArrayValue = v
	return s
}

// SetNullValue sets the NullValue field's value.
func (s *Datum) SetNullValue(v bool) *Datum {
	s.NullValue = &v
	return s
}

// SetRowValue sets the RowValue field's value.
func (s *Datum) SetRowValue(v *Row) *Datum {
	s.RowValue = v
	return s
}

// SetScalarValue sets the ScalarValue field's value.
func (s *Datum) SetScalarValue(v string) *Datum {
	s.ScalarValue = &v
	return s
}

// SetTimeSeriesValue sets the TimeSeriesValue field's value.
func (s *Datum) SetTimeSeriesValue(v []*TimeSeriesDataPoint) *Datum {
	s.TimeSeriesValue = v
	return s
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// An Endpoints object is returned when a DescribeEndpoints request is made.
	//
	// Endpoints is a required field
	Endpoints []*Endpoint `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

// Represents an available endpoint against which to make API calls agaisnt,
// as well as the TTL for that endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// An endpoint address.
	//
	// Address is a required field
	Address *string `type:"string" required:"true"`

	// The TTL for the endpoint, in minutes.
	//
	// CachePeriodInMinutes is a required field
	CachePeriodInMinutes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetCachePeriodInMinutes sets the CachePeriodInMinutes field's value.
func (s *Endpoint) SetCachePeriodInMinutes(v int64) *Endpoint {
	s.CachePeriodInMinutes = &v
	return s
}

// Timestream was unable to fully process this request because of an internal
// server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested endpoint was invalid.
type InvalidEndpointException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) GoString() string {
	return s.String()
}

func newErrorInvalidEndpointException(v protocol.ResponseMetadata) error {
	return &InvalidEndpointException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEndpointException) Code() string {
	return "InvalidEndpointException"
}

// Message returns the exception's message.
func (s *InvalidEndpointException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEndpointException) OrigErr() error {
	return nil
}

func (s *InvalidEndpointException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEndpointException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEndpointException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Timestream was unable to run the query successfully.
type QueryExecutionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryExecutionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryExecutionException) GoString() string {
	return s.String()
}

func newErrorQueryExecutionException(v protocol.ResponseMetadata) error {
	return &QueryExecutionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QueryExecutionException) Code() string {
	return "QueryExecutionException"
}

// Message returns the exception's message.
func (s *QueryExecutionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueryExecutionException) OrigErr() error {
	return nil
}

func (s *QueryExecutionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueryExecutionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueryExecutionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type QueryInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive string of up to 64 ASCII characters that you specify
	// when you make a Query request. Providing a ClientToken makes the call to
	// Query idempotent, meaning that multiple identical calls have the same effect
	// as one single call.
	//
	// Your query request will fail in the following cases:
	//
	//    * If you submit a request with the same client token outside the 5-minute
	//    idepotency window.
	//
	//    * If you submit a request with the same client token but a change in other
	//    parameters within the 5-minute idempotency window.
	//
	// After 4 hours, any request with the same client token is treated as a new
	// request.
	//
	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by QueryInput's
	// String and GoString methods.
	ClientToken *string `min:"32" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The total number of rows to return in the output. If the total number of
	// rows available is more than the value specified, a NextToken is provided
	// in the command's output. To resume pagination, provide the NextToken value
	// in the starting-token argument of a subsequent command.
	MaxRows *int64 `min:"1" type:"integer"`

	// A pagination token passed to get a set of results.
	NextToken *string `type:"string"`

	// The query to be executed by Timestream.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by QueryInput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 32))
	}
	if s.MaxRows != nil && *s.MaxRows < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRows", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *QueryInput) SetClientToken(v string) *QueryInput {
	s.ClientToken = &v
	return s
}

// SetMaxRows sets the MaxRows field's value.
func (s *QueryInput) SetMaxRows(v int64) *QueryInput {
	s.MaxRows = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryInput) SetNextToken(v string) *QueryInput {
	s.NextToken = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *QueryInput) SetQueryString(v string) *QueryInput {
	s.QueryString = &v
	return s
}

type QueryOutput struct {
	_ struct{} `type:"structure"`

	// The column data types of the returned result set.
	//
	// ColumnInfo is a required field
	ColumnInfo []*ColumnInfo `type:"list" required:"true"`

	// A pagination token that can be used again on a Query call to get the next
	// set of results.
	NextToken *string `type:"string"`

	// A unique ID for the given query.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`

	// Information about the status of the query, including progress and bytes scannned.
	QueryStatus *QueryStatus `type:"structure"`

	// The result set rows returned by the query.
	//
	// Rows is a required field
	Rows []*Row `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryOutput) GoString() string {
	return s.String()
}

// SetColumnInfo sets the ColumnInfo field's value.
func (s *QueryOutput) SetColumnInfo(v []*ColumnInfo) *QueryOutput {
	s.ColumnInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryOutput) SetNextToken(v string) *QueryOutput {
	s.NextToken = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *QueryOutput) SetQueryId(v string) *QueryOutput {
	s.QueryId = &v
	return s
}

// SetQueryStatus sets the QueryStatus field's value.
func (s *QueryOutput) SetQueryStatus(v *QueryStatus) *QueryOutput {
	s.QueryStatus = v
	return s
}

// SetRows sets the Rows field's value.
func (s *QueryOutput) SetRows(v []*Row) *QueryOutput {
	s.Rows = v
	return s
}

// Information about the status of the query, including progress and bytes scannned.
type QueryStatus struct {
	_ struct{} `type:"structure"`

	// The amount of data scanned by the query in bytes that you will be charged
	// for. This is a cumulative sum and represents the total amount of data that
	// you will be charged for since the query was started. The charge is applied
	// only once and is either applied when the query completes execution or when
	// the query is cancelled.
	CumulativeBytesMetered *int64 `type:"long"`

	// The amount of data scanned by the query in bytes. This is a cumulative sum
	// and represents the total amount of bytes scanned since the query was started.
	CumulativeBytesScanned *int64 `type:"long"`

	// The progress of the query, expressed as a percentage.
	ProgressPercentage *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryStatus) GoString() string {
	return s.String()
}

// SetCumulativeBytesMetered sets the CumulativeBytesMetered field's value.
func (s *QueryStatus) SetCumulativeBytesMetered(v int64) *QueryStatus {
	s.CumulativeBytesMetered = &v
	return s
}

// SetCumulativeBytesScanned sets the CumulativeBytesScanned field's value.
func (s *QueryStatus) SetCumulativeBytesScanned(v int64) *QueryStatus {
	s.CumulativeBytesScanned = &v
	return s
}

// SetProgressPercentage sets the ProgressPercentage field's value.
func (s *QueryStatus) SetProgressPercentage(v float64) *QueryStatus {
	s.ProgressPercentage = &v
	return s
}

// Represents a single row in the query results.
type Row struct {
	_ struct{} `type:"structure"`

	// List of data points in a single row of the result set.
	//
	// Data is a required field
	Data []*Datum `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Row) SetData(v []*Datum) *Row {
	s.Data = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The timeseries datatype represents the values of a measure over time. A time
// series is an array of rows of timestamps and measure values, with rows sorted
// in ascending order of time. A TimeSeriesDataPoint is a single data point
// in the timeseries. It represents a tuple of (time, measure value) in a timeseries.
type TimeSeriesDataPoint struct {
	_ struct{} `type:"structure"`

	// The timestamp when the measure value was collected.
	//
	// Time is a required field
	Time *string `type:"string" required:"true"`

	// The measure value for the data point.
	//
	// Value is a required field
	Value *Datum `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesDataPoint) GoString() string {
	return s.String()
}

// SetTime sets the Time field's value.
func (s *TimeSeriesDataPoint) SetTime(v string) *TimeSeriesDataPoint {
	s.Time = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TimeSeriesDataPoint) SetValue(v *Datum) *TimeSeriesDataPoint {
	s.Value = v
	return s
}

// Contains the data type of a column in a query result set. The data type can
// be scalar or complex. The supported scalar data types are integers, boolean,
// string, double, timestamp, date, time, and intervals. The supported complex
// data types are arrays, rows, and timeseries.
type Type struct {
	_ struct{} `type:"structure"`

	// Indicates if the column is an array.
	ArrayColumnInfo *ColumnInfo `type:"structure"`

	// Indicates if the column is a row.
	RowColumnInfo []*ColumnInfo `type:"list"`

	// Indicates if the column is of type string, integer, boolean, double, timestamp,
	// date, time.
	ScalarType *string `type:"string" enum:"ScalarType"`

	// Indicates if the column is a timeseries data type.
	TimeSeriesMeasureValueColumnInfo *ColumnInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Type) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Type) GoString() string {
	return s.String()
}

// SetArrayColumnInfo sets the ArrayColumnInfo field's value.
func (s *Type) SetArrayColumnInfo(v *ColumnInfo) *Type {
	s.ArrayColumnInfo = v
	return s
}

// SetRowColumnInfo sets the RowColumnInfo field's value.
func (s *Type) SetRowColumnInfo(v []*ColumnInfo) *Type {
	s.RowColumnInfo = v
	return s
}

// SetScalarType sets the ScalarType field's value.
func (s *Type) SetScalarType(v string) *Type {
	s.ScalarType = &v
	return s
}

// SetTimeSeriesMeasureValueColumnInfo sets the TimeSeriesMeasureValueColumnInfo field's value.
func (s *Type) SetTimeSeriesMeasureValueColumnInfo(v *ColumnInfo) *Type {
	s.TimeSeriesMeasureValueColumnInfo = v
	return s
}

// Invalid or malformed request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ScalarTypeVarchar is a ScalarType enum value
	ScalarTypeVarchar = "VARCHAR"

	// ScalarTypeBoolean is a ScalarType enum value
	ScalarTypeBoolean = "BOOLEAN"

	// ScalarTypeBigint is a ScalarType enum value
	ScalarTypeBigint = "BIGINT"

	// ScalarTypeDouble is a ScalarType enum value
	ScalarTypeDouble = "DOUBLE"

	// ScalarTypeTimestamp is a ScalarType enum value
	ScalarTypeTimestamp = "TIMESTAMP"

	// ScalarTypeDate is a ScalarType enum value
	ScalarTypeDate = "DATE"

	// ScalarTypeTime is a ScalarType enum value
	ScalarTypeTime = "TIME"

	// ScalarTypeIntervalDayToSecond is a ScalarType enum value
	ScalarTypeIntervalDayToSecond = "INTERVAL_DAY_TO_SECOND"

	// ScalarTypeIntervalYearToMonth is a ScalarType enum value
	ScalarTypeIntervalYearToMonth = "INTERVAL_YEAR_TO_MONTH"

	// ScalarTypeUnknown is a ScalarType enum value
	ScalarTypeUnknown = "UNKNOWN"

	// ScalarTypeInteger is a ScalarType enum value
	ScalarTypeInteger = "INTEGER"
)

// ScalarType_Values returns all elements of the ScalarType enum
func ScalarType_Values() []string {
	return []string{
		ScalarTypeVarchar,
		ScalarTypeBoolean,
		ScalarTypeBigint,
		ScalarTypeDouble,
		ScalarTypeTimestamp,
		ScalarTypeDate,
		ScalarTypeTime,
		ScalarTypeIntervalDayToSecond,
		ScalarTypeIntervalYearToMonth,
		ScalarTypeUnknown,
		ScalarTypeInteger,
	}
}
