// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mobile

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/CreateProject
func (c *Mobile) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS Mobile.
//
// Creates an AWS Mobile Hub project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
//   * LimitExceededException
//   There are too many AWS Mobile Hub projects in the account or the account
//   has exceeded the maximum number of resources in some AWS service. You should
//   create another sub-account using AWS Organizations or remove some resources
//   and retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/CreateProject
func (c *Mobile) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DeleteProject
func (c *Mobile) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS Mobile.
//
// Delets a project in AWS Mobile Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DeleteProject
func (c *Mobile) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBundle = "DescribeBundle"

// DescribeBundleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBundle for more information on using the DescribeBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBundleRequest method.
//    req, resp := client.DescribeBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeBundle
func (c *Mobile) DescribeBundleRequest(input *DescribeBundleInput) (req *request.Request, output *DescribeBundleOutput) {
	op := &request.Operation{
		Name:       opDescribeBundle,
		HTTPMethod: "GET",
		HTTPPath:   "/bundles/{bundleId}",
	}

	if input == nil {
		input = &DescribeBundleInput{}
	}

	output = &DescribeBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBundle API operation for AWS Mobile.
//
// Get the bundle details for the requested bundle id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation DescribeBundle for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeBundle
func (c *Mobile) DescribeBundle(input *DescribeBundleInput) (*DescribeBundleOutput, error) {
	req, out := c.DescribeBundleRequest(input)
	return out, req.Send()
}

// DescribeBundleWithContext is the same as DescribeBundle with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) DescribeBundleWithContext(ctx aws.Context, input *DescribeBundleInput, opts ...request.Option) (*DescribeBundleOutput, error) {
	req, out := c.DescribeBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeProject
func (c *Mobile) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/project",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for AWS Mobile.
//
// Gets details about a project in AWS Mobile Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeProject
func (c *Mobile) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportBundle = "ExportBundle"

// ExportBundleRequest generates a "aws/request.Request" representing the
// client's request for the ExportBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportBundle for more information on using the ExportBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportBundleRequest method.
//    req, resp := client.ExportBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportBundle
func (c *Mobile) ExportBundleRequest(input *ExportBundleInput) (req *request.Request, output *ExportBundleOutput) {
	op := &request.Operation{
		Name:       opExportBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/bundles/{bundleId}",
	}

	if input == nil {
		input = &ExportBundleInput{}
	}

	output = &ExportBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportBundle API operation for AWS Mobile.
//
// Generates customized software development kit (SDK) and or tool packages
// used to integrate mobile web or mobile app clients with backend AWS resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation ExportBundle for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportBundle
func (c *Mobile) ExportBundle(input *ExportBundleInput) (*ExportBundleOutput, error) {
	req, out := c.ExportBundleRequest(input)
	return out, req.Send()
}

// ExportBundleWithContext is the same as ExportBundle with the addition of
// the ability to pass a context and additional request options.
//
// See ExportBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) ExportBundleWithContext(ctx aws.Context, input *ExportBundleInput, opts ...request.Option) (*ExportBundleOutput, error) {
	req, out := c.ExportBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportProject = "ExportProject"

// ExportProjectRequest generates a "aws/request.Request" representing the
// client's request for the ExportProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportProject for more information on using the ExportProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportProjectRequest method.
//    req, resp := client.ExportProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportProject
func (c *Mobile) ExportProjectRequest(input *ExportProjectInput) (req *request.Request, output *ExportProjectOutput) {
	op := &request.Operation{
		Name:       opExportProject,
		HTTPMethod: "POST",
		HTTPPath:   "/exports/{projectId}",
	}

	if input == nil {
		input = &ExportProjectInput{}
	}

	output = &ExportProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportProject API operation for AWS Mobile.
//
// Exports project configuration to a snapshot which can be downloaded and shared.
// Note that mobile app push credentials are encrypted in exported projects,
// so they can only be shared successfully within the same AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation ExportProject for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportProject
func (c *Mobile) ExportProject(input *ExportProjectInput) (*ExportProjectOutput, error) {
	req, out := c.ExportProjectRequest(input)
	return out, req.Send()
}

// ExportProjectWithContext is the same as ExportProject with the addition of
// the ability to pass a context and additional request options.
//
// See ExportProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) ExportProjectWithContext(ctx aws.Context, input *ExportProjectInput, opts ...request.Option) (*ExportProjectOutput, error) {
	req, out := c.ExportProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBundles = "ListBundles"

// ListBundlesRequest generates a "aws/request.Request" representing the
// client's request for the ListBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBundles for more information on using the ListBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBundlesRequest method.
//    req, resp := client.ListBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles
func (c *Mobile) ListBundlesRequest(input *ListBundlesInput) (req *request.Request, output *ListBundlesOutput) {
	op := &request.Operation{
		Name:       opListBundles,
		HTTPMethod: "GET",
		HTTPPath:   "/bundles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBundlesInput{}
	}

	output = &ListBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBundles API operation for AWS Mobile.
//
// List all available bundles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation ListBundles for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles
func (c *Mobile) ListBundles(input *ListBundlesInput) (*ListBundlesOutput, error) {
	req, out := c.ListBundlesRequest(input)
	return out, req.Send()
}

// ListBundlesWithContext is the same as ListBundles with the addition of
// the ability to pass a context and additional request options.
//
// See ListBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) ListBundlesWithContext(ctx aws.Context, input *ListBundlesInput, opts ...request.Option) (*ListBundlesOutput, error) {
	req, out := c.ListBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBundlesPages iterates over the pages of a ListBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBundles operation.
//    pageNum := 0
//    err := client.ListBundlesPages(params,
//        func(page *mobile.ListBundlesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mobile) ListBundlesPages(input *ListBundlesInput, fn func(*ListBundlesOutput, bool) bool) error {
	return c.ListBundlesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBundlesPagesWithContext same as ListBundlesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) ListBundlesPagesWithContext(ctx aws.Context, input *ListBundlesInput, fn func(*ListBundlesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBundlesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBundlesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBundlesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects
func (c *Mobile) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS Mobile.
//
// Lists projects in AWS Mobile Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects
func (c *Mobile) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *mobile.ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mobile) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/UpdateProject
func (c *Mobile) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/update",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS Mobile.
//
// Update an existing project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mobile's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   The service has encountered an unexpected error condition which prevents
//   it from servicing the request.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable. The request should be retried after
//   some time delay.
//
//   * UnauthorizedException
//   Credentials of the caller are insufficient to authorize the request.
//
//   * TooManyRequestsException
//   Too many requests have been received for this AWS account in too short a
//   time. The request should be retried after some time delay.
//
//   * BadRequestException
//   The request cannot be processed because some parameter is not valid or the
//   project state prevents the operation from being performed.
//
//   * NotFoundException
//   No entity can be found with the specified identifier.
//
//   * AccountActionRequiredException
//   Account Action is required in order to continue the request.
//
//   * LimitExceededException
//   There are too many AWS Mobile Hub projects in the account or the account
//   has exceeded the maximum number of resources in some AWS service. You should
//   create another sub-account using AWS Organizations or remove some resources
//   and retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/UpdateProject
func (c *Mobile) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mobile) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Account Action is required in order to continue the request.
type AccountActionRequiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountActionRequiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountActionRequiredException) GoString() string {
	return s.String()
}

func newErrorAccountActionRequiredException(v protocol.ResponseMetadata) error {
	return &AccountActionRequiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountActionRequiredException) Code() string {
	return "AccountActionRequiredException"
}

// Message returns the exception's message.
func (s *AccountActionRequiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountActionRequiredException) OrigErr() error {
	return nil
}

func (s *AccountActionRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountActionRequiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountActionRequiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request cannot be processed because some parameter is not valid or the
// project state prevents the operation from being performed.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of the bundle.
type BundleDetails struct {
	_ struct{} `type:"structure"`

	// Developer desktop or mobile app or website platforms.
	AvailablePlatforms []*string `locationName:"availablePlatforms" type:"list"`

	// Unique bundle identifier.
	BundleId *string `locationName:"bundleId" type:"string"`

	// Description of the download bundle.
	Description *string `locationName:"description" type:"string"`

	// Icon for the download bundle.
	IconUrl *string `locationName:"iconUrl" type:"string"`

	// Title of the download bundle.
	Title *string `locationName:"title" type:"string"`

	// Version of the download bundle.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BundleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BundleDetails) GoString() string {
	return s.String()
}

// SetAvailablePlatforms sets the AvailablePlatforms field's value.
func (s *BundleDetails) SetAvailablePlatforms(v []*string) *BundleDetails {
	s.AvailablePlatforms = v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *BundleDetails) SetBundleId(v string) *BundleDetails {
	s.BundleId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BundleDetails) SetDescription(v string) *BundleDetails {
	s.Description = &v
	return s
}

// SetIconUrl sets the IconUrl field's value.
func (s *BundleDetails) SetIconUrl(v string) *BundleDetails {
	s.IconUrl = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *BundleDetails) SetTitle(v string) *BundleDetails {
	s.Title = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *BundleDetails) SetVersion(v string) *BundleDetails {
	s.Version = &v
	return s
}

// Request structure used to request a project be created.
type CreateProjectInput struct {
	_ struct{} `type:"structure" payload:"Contents"`

	// ZIP or YAML file which contains configuration settings to be used when creating
	// the project. This may be the contents of the file downloaded from the URL
	// provided in an export project operation.
	Contents []byte `locationName:"contents" type:"blob"`

	// Name of the project.
	Name *string `location:"querystring" locationName:"name" type:"string"`

	// Default region where project resources should be created.
	Region *string `location:"querystring" locationName:"region" type:"string"`

	// Unique identifier for an exported snapshot of project configuration. This
	// snapshot identifier is included in the share URL when a project is exported.
	SnapshotId *string `location:"querystring" locationName:"snapshotId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// SetContents sets the Contents field's value.
func (s *CreateProjectInput) SetContents(v []byte) *CreateProjectInput {
	s.Contents = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *CreateProjectInput) SetRegion(v string) *CreateProjectInput {
	s.Region = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateProjectInput) SetSnapshotId(v string) *CreateProjectInput {
	s.SnapshotId = &v
	return s
}

// Result structure used in response to a request to create a project.
type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the created AWS Mobile Hub project.
	Details *ProjectDetails `locationName:"details" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *CreateProjectOutput) SetDetails(v *ProjectDetails) *CreateProjectOutput {
	s.Details = v
	return s
}

// Request structure used to request a project be deleted.
type DeleteProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique project identifier.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *DeleteProjectInput) SetProjectId(v string) *DeleteProjectInput {
	s.ProjectId = &v
	return s
}

// Result structure used in response to request to delete a project.
type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`

	// Resources which were deleted.
	DeletedResources []*Resource `locationName:"deletedResources" type:"list"`

	// Resources which were not deleted, due to a risk of losing potentially important
	// data or files.
	OrphanedResources []*Resource `locationName:"orphanedResources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// SetDeletedResources sets the DeletedResources field's value.
func (s *DeleteProjectOutput) SetDeletedResources(v []*Resource) *DeleteProjectOutput {
	s.DeletedResources = v
	return s
}

// SetOrphanedResources sets the OrphanedResources field's value.
func (s *DeleteProjectOutput) SetOrphanedResources(v []*Resource) *DeleteProjectOutput {
	s.OrphanedResources = v
	return s
}

// Request structure to request the details of a specific bundle.
type DescribeBundleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique bundle identifier.
	//
	// BundleId is a required field
	BundleId *string `location:"uri" locationName:"bundleId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBundleInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.BundleId != nil && len(*s.BundleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeBundleInput) SetBundleId(v string) *DescribeBundleInput {
	s.BundleId = &v
	return s
}

// Result structure contains the details of the bundle.
type DescribeBundleOutput struct {
	_ struct{} `type:"structure"`

	// The details of the bundle.
	Details *BundleDetails `locationName:"details" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *DescribeBundleOutput) SetDetails(v *BundleDetails) *DescribeBundleOutput {
	s.Details = v
	return s
}

// Request structure used to request details about a project.
type DescribeProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique project identifier.
	//
	// ProjectId is a required field
	ProjectId *string `location:"querystring" locationName:"projectId" type:"string" required:"true"`

	// If set to true, causes AWS Mobile Hub to synchronize information from other
	// services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile
	// Hub project.
	SyncFromResources *bool `location:"querystring" locationName:"syncFromResources" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeProjectInput) SetProjectId(v string) *DescribeProjectInput {
	s.ProjectId = &v
	return s
}

// SetSyncFromResources sets the SyncFromResources field's value.
func (s *DescribeProjectInput) SetSyncFromResources(v bool) *DescribeProjectInput {
	s.SyncFromResources = &v
	return s
}

// Result structure used for requests of project details.
type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about an AWS Mobile Hub project.
	Details *ProjectDetails `locationName:"details" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *DescribeProjectOutput) SetDetails(v *ProjectDetails) *DescribeProjectOutput {
	s.Details = v
	return s
}

// Request structure used to request generation of custom SDK and tool packages
// required to integrate mobile web or app clients with backed AWS resources.
type ExportBundleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique bundle identifier.
	//
	// BundleId is a required field
	BundleId *string `location:"uri" locationName:"bundleId" type:"string" required:"true"`

	// Developer desktop or target application platform.
	Platform *string `location:"querystring" locationName:"platform" type:"string" enum:"Platform"`

	// Unique project identifier.
	ProjectId *string `location:"querystring" locationName:"projectId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportBundleInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.BundleId != nil && len(*s.BundleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *ExportBundleInput) SetBundleId(v string) *ExportBundleInput {
	s.BundleId = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ExportBundleInput) SetPlatform(v string) *ExportBundleInput {
	s.Platform = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ExportBundleInput) SetProjectId(v string) *ExportBundleInput {
	s.ProjectId = &v
	return s
}

// Result structure which contains link to download custom-generated SDK and
// tool packages used to integrate mobile web or app clients with backed AWS
// resources.
type ExportBundleOutput struct {
	_ struct{} `type:"structure"`

	// URL which contains the custom-generated SDK and tool packages used to integrate
	// the client mobile app or web app with the AWS resources created by the AWS
	// Mobile Hub project.
	DownloadUrl *string `locationName:"downloadUrl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBundleOutput) GoString() string {
	return s.String()
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *ExportBundleOutput) SetDownloadUrl(v string) *ExportBundleOutput {
	s.DownloadUrl = &v
	return s
}

// Request structure used in requests to export project configuration details.
type ExportProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique project identifier.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *ExportProjectInput) SetProjectId(v string) *ExportProjectInput {
	s.ProjectId = &v
	return s
}

// Result structure used for requests to export project configuration details.
type ExportProjectOutput struct {
	_ struct{} `type:"structure"`

	// URL which can be used to download the exported project configuation file(s).
	DownloadUrl *string `locationName:"downloadUrl" type:"string"`

	// URL which can be shared to allow other AWS users to create their own project
	// in AWS Mobile Hub with the same configuration as the specified project. This
	// URL pertains to a snapshot in time of the project configuration that is created
	// when this API is called. If you want to share additional changes to your
	// project configuration, then you will need to create and share a new snapshot
	// by calling this method again.
	ShareUrl *string `locationName:"shareUrl" type:"string"`

	// Unique identifier for the exported snapshot of the project configuration.
	// This snapshot identifier is included in the share URL.
	SnapshotId *string `locationName:"snapshotId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportProjectOutput) GoString() string {
	return s.String()
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *ExportProjectOutput) SetDownloadUrl(v string) *ExportProjectOutput {
	s.DownloadUrl = &v
	return s
}

// SetShareUrl sets the ShareUrl field's value.
func (s *ExportProjectOutput) SetShareUrl(v string) *ExportProjectOutput {
	s.ShareUrl = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *ExportProjectOutput) SetSnapshotId(v string) *ExportProjectOutput {
	s.SnapshotId = &v
	return s
}

// The service has encountered an unexpected error condition which prevents
// it from servicing the request.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There are too many AWS Mobile Hub projects in the account or the account
// has exceeded the maximum number of resources in some AWS service. You should
// create another sub-account using AWS Organizations or remove some resources
// and retry your request.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`

	// The Exception Error Message.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request structure to request all available bundles.
type ListBundlesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Pagination token. Set to null to start listing bundles from start. If non-null
	// pagination token is returned in a result, then pass its value in here in
	// another request to list more bundles.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBundlesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBundlesInput) SetMaxResults(v int64) *ListBundlesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBundlesInput) SetNextToken(v string) *ListBundlesInput {
	s.NextToken = &v
	return s
}

// Result structure contains a list of all available bundles with details.
type ListBundlesOutput struct {
	_ struct{} `type:"structure"`

	// A list of bundles.
	BundleList []*BundleDetails `locationName:"bundleList" type:"list"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBundlesOutput) GoString() string {
	return s.String()
}

// SetBundleList sets the BundleList field's value.
func (s *ListBundlesOutput) SetBundleList(v []*BundleDetails) *ListBundlesOutput {
	s.BundleList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBundlesOutput) SetNextToken(v string) *ListBundlesOutput {
	s.NextToken = &v
	return s
}

// Request structure used to request projects list in AWS Mobile Hub.
type ListProjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Pagination token. Set to null to start listing projects from start. If non-null
	// pagination token is returned in a result, then pass its value in here in
	// another request to list more projects.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// Result structure used for requests to list projects in AWS Mobile Hub.
type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Set to null to start listing records from start. If non-null
	// pagination token is returned in a result, then pass its value in here in
	// another request to list more entries.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of projects.
	Projects []*ProjectSummary `locationName:"projects" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectSummary) *ListProjectsOutput {
	s.Projects = v
	return s
}

// No entity can be found with the specified identifier.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Detailed information about an AWS Mobile Hub project.
type ProjectDetails struct {
	_ struct{} `type:"structure"`

	// Website URL for this project in the AWS Mobile Hub console.
	ConsoleUrl *string `locationName:"consoleUrl" type:"string"`

	// Date the project was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// Date of the last modification of the project.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// Name of the project.
	Name *string `locationName:"name" type:"string"`

	// Unique project identifier.
	ProjectId *string `locationName:"projectId" type:"string"`

	// Default region to use for AWS resource creation in the AWS Mobile Hub project.
	Region *string `locationName:"region" type:"string"`

	// List of AWS resources associated with a project.
	Resources []*Resource `locationName:"resources" type:"list"`

	// Synchronization state for a project.
	State *string `locationName:"state" type:"string" enum:"ProjectState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDetails) GoString() string {
	return s.String()
}

// SetConsoleUrl sets the ConsoleUrl field's value.
func (s *ProjectDetails) SetConsoleUrl(v string) *ProjectDetails {
	s.ConsoleUrl = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ProjectDetails) SetCreatedDate(v time.Time) *ProjectDetails {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *ProjectDetails) SetLastUpdatedDate(v time.Time) *ProjectDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProjectDetails) SetName(v string) *ProjectDetails {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ProjectDetails) SetProjectId(v string) *ProjectDetails {
	s.ProjectId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ProjectDetails) SetRegion(v string) *ProjectDetails {
	s.Region = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ProjectDetails) SetResources(v []*Resource) *ProjectDetails {
	s.Resources = v
	return s
}

// SetState sets the State field's value.
func (s *ProjectDetails) SetState(v string) *ProjectDetails {
	s.State = &v
	return s
}

// Summary information about an AWS Mobile Hub project.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// Name of the project.
	Name *string `locationName:"name" type:"string"`

	// Unique project identifier.
	ProjectId *string `locationName:"projectId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ProjectSummary) SetName(v string) *ProjectSummary {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ProjectSummary) SetProjectId(v string) *ProjectSummary {
	s.ProjectId = &v
	return s
}

// Information about an instance of an AWS resource associated with a project.
type Resource struct {
	_ struct{} `type:"structure"`

	// AWS resource name which uniquely identifies the resource in AWS systems.
	Arn *string `locationName:"arn" type:"string"`

	// Key-value attribute pairs.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
	Feature *string `locationName:"feature" type:"string"`

	// Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name
	// of the bucket).
	Name *string `locationName:"name" type:"string"`

	// Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Resource) SetArn(v string) *Resource {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Resource) SetAttributes(v map[string]*string) *Resource {
	s.Attributes = v
	return s
}

// SetFeature sets the Feature field's value.
func (s *Resource) SetFeature(v string) *Resource {
	s.Feature = &v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// The service is temporarily unavailable. The request should be retried after
// some time delay.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`

	// The Exception Error Message.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Too many requests have been received for this AWS account in too short a
// time. The request should be retried after some time delay.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`

	// The Exception Error Message.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Credentials of the caller are insufficient to authorize the request.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Exception Error Message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request structure used for requests to update project configuration.
type UpdateProjectInput struct {
	_ struct{} `type:"structure" payload:"Contents"`

	// ZIP or YAML file which contains project configuration to be updated. This
	// should be the contents of the file downloaded from the URL provided in an
	// export project operation.
	Contents []byte `locationName:"contents" type:"blob"`

	// Unique project identifier.
	//
	// ProjectId is a required field
	ProjectId *string `location:"querystring" locationName:"projectId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContents sets the Contents field's value.
func (s *UpdateProjectInput) SetContents(v []byte) *UpdateProjectInput {
	s.Contents = v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *UpdateProjectInput) SetProjectId(v string) *UpdateProjectInput {
	s.ProjectId = &v
	return s
}

// Result structure used for requests to updated project configuration.
type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the updated AWS Mobile Hub project.
	Details *ProjectDetails `locationName:"details" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *UpdateProjectOutput) SetDetails(v *ProjectDetails) *UpdateProjectOutput {
	s.Details = v
	return s
}

// Developer desktop or target mobile app or website platform.
const (
	// PlatformOsx is a Platform enum value
	PlatformOsx = "OSX"

	// PlatformWindows is a Platform enum value
	PlatformWindows = "WINDOWS"

	// PlatformLinux is a Platform enum value
	PlatformLinux = "LINUX"

	// PlatformObjc is a Platform enum value
	PlatformObjc = "OBJC"

	// PlatformSwift is a Platform enum value
	PlatformSwift = "SWIFT"

	// PlatformAndroid is a Platform enum value
	PlatformAndroid = "ANDROID"

	// PlatformJavascript is a Platform enum value
	PlatformJavascript = "JAVASCRIPT"
)

// Platform_Values returns all elements of the Platform enum
func Platform_Values() []string {
	return []string{
		PlatformOsx,
		PlatformWindows,
		PlatformLinux,
		PlatformObjc,
		PlatformSwift,
		PlatformAndroid,
		PlatformJavascript,
	}
}

// Synchronization state for a project.
const (
	// ProjectStateNormal is a ProjectState enum value
	ProjectStateNormal = "NORMAL"

	// ProjectStateSyncing is a ProjectState enum value
	ProjectStateSyncing = "SYNCING"

	// ProjectStateImporting is a ProjectState enum value
	ProjectStateImporting = "IMPORTING"
)

// ProjectState_Values returns all elements of the ProjectState enum
func ProjectState_Values() []string {
	return []string{
		ProjectStateNormal,
		ProjectStateSyncing,
		ProjectStateImporting,
	}
}
