// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package emr provides a client for Amazon Elastic MapReduce.
package emr

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddInstanceGroups = "AddInstanceGroups"

// AddInstanceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AddInstanceGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddInstanceGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddInstanceGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddInstanceGroupsRequest method.
//    req, resp := client.AddInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) AddInstanceGroupsRequest(input *AddInstanceGroupsInput) (req *request.Request, output *AddInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opAddInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddInstanceGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddInstanceGroupsOutput{}
	req.Data = output
	return
}

// AddInstanceGroups API operation for Amazon Elastic MapReduce.
//
// AddInstanceGroups adds an instance group to a running cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddInstanceGroups for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) AddInstanceGroups(input *AddInstanceGroupsInput) (*AddInstanceGroupsOutput, error) {
	req, out := c.AddInstanceGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opAddJobFlowSteps = "AddJobFlowSteps"

// AddJobFlowStepsRequest generates a "aws/request.Request" representing the
// client's request for the AddJobFlowSteps operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddJobFlowSteps for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddJobFlowSteps method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddJobFlowStepsRequest method.
//    req, resp := client.AddJobFlowStepsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) AddJobFlowStepsRequest(input *AddJobFlowStepsInput) (req *request.Request, output *AddJobFlowStepsOutput) {
	op := &request.Operation{
		Name:       opAddJobFlowSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddJobFlowStepsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddJobFlowStepsOutput{}
	req.Data = output
	return
}

// AddJobFlowSteps API operation for Amazon Elastic MapReduce.
//
// AddJobFlowSteps adds new steps to a running job flow. A maximum of 256 steps
// are allowed in each job flow.
//
// If your job flow is long-running (such as a Hive data warehouse) or complex,
// you may require more than 256 steps to process your data. You can bypass
// the 256-step limitation in various ways, including using the SSH shell to
// connect to the master node and submitting queries directly to the software
// running on the master node, such as Hive and Hadoop. For more information
// on how to do this, go to Add More than 256 Steps to a Job Flow (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/AddMoreThan256Steps.html)
// in the Amazon Elastic MapReduce Developer's Guide.
//
// A step specifies the location of a JAR file stored either on the master node
// of the job flow or in Amazon S3. Each step is performed by the main function
// of the main class of the JAR file. The main class can be specified either
// in the manifest of the JAR or by using the MainFunction parameter of the
// step.
//
// Elastic MapReduce executes each step in the order listed. For a step to be
// considered complete, the main function must exit with a zero exit code and
// all Hadoop jobs started while the step was running must have completed and
// run successfully.
//
// You can only add steps to a job flow that is in one of the following states:
// STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddJobFlowSteps for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) AddJobFlowSteps(input *AddJobFlowStepsInput) (*AddJobFlowStepsOutput, error) {
	req, out := c.AddJobFlowStepsRequest(input)
	err := req.Send()
	return out, err
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// AddTags API operation for Amazon Elastic MapReduce.
//
// Adds tags to an Amazon EMR resource. Tags make it easier to associate clusters
// in various ways, such as grouping clusters to track your Amazon EMR resource
// allocation costs. For more information, see Tagging Amazon EMR Resources
// (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSecurityConfiguration = "CreateSecurityConfiguration"

// CreateSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSecurityConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSecurityConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSecurityConfigurationRequest method.
//    req, resp := client.CreateSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) CreateSecurityConfigurationRequest(input *CreateSecurityConfigurationInput) (req *request.Request, output *CreateSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSecurityConfigurationOutput{}
	req.Data = output
	return
}

// CreateSecurityConfiguration API operation for Amazon Elastic MapReduce.
//
// Creates a security configuration using EMR Security Configurations, which
// are stored in the service. Security Configurations enable you to more easily
// create a configuration, reuse it, and apply it whenever a cluster is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation CreateSecurityConfiguration for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) CreateSecurityConfiguration(input *CreateSecurityConfigurationInput) (*CreateSecurityConfigurationOutput, error) {
	req, out := c.CreateSecurityConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSecurityConfiguration = "DeleteSecurityConfiguration"

// DeleteSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSecurityConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSecurityConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSecurityConfigurationRequest method.
//    req, resp := client.DeleteSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) DeleteSecurityConfigurationRequest(input *DeleteSecurityConfigurationInput) (req *request.Request, output *DeleteSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSecurityConfigurationOutput{}
	req.Data = output
	return
}

// DeleteSecurityConfiguration API operation for Amazon Elastic MapReduce.
//
// Deletes a security configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DeleteSecurityConfiguration for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) DeleteSecurityConfiguration(input *DeleteSecurityConfigurationInput) (*DeleteSecurityConfigurationOutput, error) {
	req, out := c.DeleteSecurityConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCluster for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCluster method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterOutput{}
	req.Data = output
	return
}

// DescribeCluster API operation for Amazon Elastic MapReduce.
//
// Provides cluster-level details including status, hardware and software configuration,
// VPC settings, and so on. For information about the cluster steps, see ListSteps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeJobFlows = "DescribeJobFlows"

// DescribeJobFlowsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobFlows operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeJobFlows for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeJobFlows method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeJobFlowsRequest method.
//    req, resp := client.DescribeJobFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) DescribeJobFlowsRequest(input *DescribeJobFlowsInput) (req *request.Request, output *DescribeJobFlowsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeJobFlows, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobFlowsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeJobFlowsOutput{}
	req.Data = output
	return
}

// DescribeJobFlows API operation for Amazon Elastic MapReduce.
//
// This API is deprecated and will eventually be removed. We recommend you use
// ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions
// instead.
//
// DescribeJobFlows returns a list of job flows that match all of the supplied
// parameters. The parameters can include a list of job flow IDs, job flow states,
// and restrictions on job flow creation date and time.
//
// Regardless of supplied parameters, only job flows created within the last
// two months are returned.
//
// If no parameters are supplied, then job flows matching either of the following
// criteria are returned:
//
//    * Job flows created and completed in the last two weeks
//
//    *  Job flows created within the last two months that are in one of the
//    following states: RUNNING, WAITING, SHUTTING_DOWN, STARTING
//
// Amazon Elastic MapReduce can return a maximum of 512 job flow descriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeJobFlows for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) DescribeJobFlows(input *DescribeJobFlowsInput) (*DescribeJobFlowsOutput, error) {
	req, out := c.DescribeJobFlowsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSecurityConfiguration = "DescribeSecurityConfiguration"

// DescribeSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSecurityConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSecurityConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSecurityConfigurationRequest method.
//    req, resp := client.DescribeSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) DescribeSecurityConfigurationRequest(input *DescribeSecurityConfigurationInput) (req *request.Request, output *DescribeSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSecurityConfigurationOutput{}
	req.Data = output
	return
}

// DescribeSecurityConfiguration API operation for Amazon Elastic MapReduce.
//
// Provides the details of a security configuration by returning the configuration
// JSON.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeSecurityConfiguration for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) DescribeSecurityConfiguration(input *DescribeSecurityConfigurationInput) (*DescribeSecurityConfigurationOutput, error) {
	req, out := c.DescribeSecurityConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStep = "DescribeStep"

// DescribeStepRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStep operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStep for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStep method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStepRequest method.
//    req, resp := client.DescribeStepRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) DescribeStepRequest(input *DescribeStepInput) (req *request.Request, output *DescribeStepOutput) {
	op := &request.Operation{
		Name:       opDescribeStep,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStepInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStepOutput{}
	req.Data = output
	return
}

// DescribeStep API operation for Amazon Elastic MapReduce.
//
// Provides more detail about the cluster step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeStep for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) DescribeStep(input *DescribeStepInput) (*DescribeStepOutput, error) {
	req, out := c.DescribeStepRequest(input)
	err := req.Send()
	return out, err
}

const opListBootstrapActions = "ListBootstrapActions"

// ListBootstrapActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBootstrapActions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListBootstrapActions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListBootstrapActions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListBootstrapActionsRequest method.
//    req, resp := client.ListBootstrapActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ListBootstrapActionsRequest(input *ListBootstrapActionsInput) (req *request.Request, output *ListBootstrapActionsOutput) {
	op := &request.Operation{
		Name:       opListBootstrapActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBootstrapActionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListBootstrapActionsOutput{}
	req.Data = output
	return
}

// ListBootstrapActions API operation for Amazon Elastic MapReduce.
//
// Provides information about the bootstrap actions associated with a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListBootstrapActions for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) ListBootstrapActions(input *ListBootstrapActionsInput) (*ListBootstrapActionsOutput, error) {
	req, out := c.ListBootstrapActionsRequest(input)
	err := req.Send()
	return out, err
}

// ListBootstrapActionsPages iterates over the pages of a ListBootstrapActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBootstrapActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBootstrapActions operation.
//    pageNum := 0
//    err := client.ListBootstrapActionsPages(params,
//        func(page *ListBootstrapActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListBootstrapActionsPages(input *ListBootstrapActionsInput, fn func(p *ListBootstrapActionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListBootstrapActionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListBootstrapActionsOutput), lastPage)
	})
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListClusters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListClusters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListClustersOutput{}
	req.Data = output
	return
}

// ListClusters API operation for Amazon Elastic MapReduce.
//
// Provides the status of all clusters visible to this AWS account. Allows you
// to filter the list of clusters based on certain criteria; for example, filtering
// by cluster creation date and time or by status. This call returns a maximum
// of 50 clusters per call, but returns a marker to track the paging of the
// cluster list across multiple ListClusters calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListClusters for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	err := req.Send()
	return out, err
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusters operation.
//    pageNum := 0
//    err := client.ListClustersPages(params,
//        func(page *ListClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListClustersPages(input *ListClustersInput, fn func(p *ListClustersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListClustersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListClustersOutput), lastPage)
	})
}

const opListInstanceGroups = "ListInstanceGroups"

// ListInstanceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListInstanceGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListInstanceGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListInstanceGroupsRequest method.
//    req, resp := client.ListInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ListInstanceGroupsRequest(input *ListInstanceGroupsInput) (req *request.Request, output *ListInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opListInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInstanceGroupsOutput{}
	req.Data = output
	return
}

// ListInstanceGroups API operation for Amazon Elastic MapReduce.
//
// Provides all available details about the instance groups in a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListInstanceGroups for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) ListInstanceGroups(input *ListInstanceGroupsInput) (*ListInstanceGroupsOutput, error) {
	req, out := c.ListInstanceGroupsRequest(input)
	err := req.Send()
	return out, err
}

// ListInstanceGroupsPages iterates over the pages of a ListInstanceGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstanceGroups operation.
//    pageNum := 0
//    err := client.ListInstanceGroupsPages(params,
//        func(page *ListInstanceGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListInstanceGroupsPages(input *ListInstanceGroupsInput, fn func(p *ListInstanceGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstanceGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstanceGroupsOutput), lastPage)
	})
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListInstancesRequest method.
//    req, resp := client.ListInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInstancesOutput{}
	req.Data = output
	return
}

// ListInstances API operation for Amazon Elastic MapReduce.
//
// Provides information about the cluster instances that Amazon EMR provisions
// on behalf of a user when it creates the cluster. For example, this operation
// indicates when the EC2 instances reach the Ready state, when instances become
// available to Amazon EMR to use for jobs, and the IP addresses for cluster
// instances, etc.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListInstances for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	err := req.Send()
	return out, err
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstances operation.
//    pageNum := 0
//    err := client.ListInstancesPages(params,
//        func(page *ListInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListInstancesPages(input *ListInstancesInput, fn func(p *ListInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstancesOutput), lastPage)
	})
}

const opListSecurityConfigurations = "ListSecurityConfigurations"

// ListSecurityConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSecurityConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSecurityConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSecurityConfigurationsRequest method.
//    req, resp := client.ListSecurityConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ListSecurityConfigurationsRequest(input *ListSecurityConfigurationsInput) (req *request.Request, output *ListSecurityConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListSecurityConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSecurityConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSecurityConfigurationsOutput{}
	req.Data = output
	return
}

// ListSecurityConfigurations API operation for Amazon Elastic MapReduce.
//
// Lists all the security configurations visible to this account, providing
// their creation dates and times, and their names. This call returns a maximum
// of 50 clusters per call, but returns a marker to track the paging of the
// cluster list across multiple ListSecurityConfigurations calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListSecurityConfigurations for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) ListSecurityConfigurations(input *ListSecurityConfigurationsInput) (*ListSecurityConfigurationsOutput, error) {
	req, out := c.ListSecurityConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

const opListSteps = "ListSteps"

// ListStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListSteps operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSteps for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSteps method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListStepsRequest method.
//    req, resp := client.ListStepsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ListStepsRequest(input *ListStepsInput) (req *request.Request, output *ListStepsOutput) {
	op := &request.Operation{
		Name:       opListSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStepsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStepsOutput{}
	req.Data = output
	return
}

// ListSteps API operation for Amazon Elastic MapReduce.
//
// Provides a list of steps for the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListSteps for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) ListSteps(input *ListStepsInput) (*ListStepsOutput, error) {
	req, out := c.ListStepsRequest(input)
	err := req.Send()
	return out, err
}

// ListStepsPages iterates over the pages of a ListSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSteps operation.
//    pageNum := 0
//    err := client.ListStepsPages(params,
//        func(page *ListStepsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListStepsPages(input *ListStepsInput, fn func(p *ListStepsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStepsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStepsOutput), lastPage)
	})
}

const opModifyInstanceGroups = "ModifyInstanceGroups"

// ModifyInstanceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ModifyInstanceGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyInstanceGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyInstanceGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyInstanceGroupsRequest method.
//    req, resp := client.ModifyInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) ModifyInstanceGroupsRequest(input *ModifyInstanceGroupsInput) (req *request.Request, output *ModifyInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ModifyInstanceGroupsOutput{}
	req.Data = output
	return
}

// ModifyInstanceGroups API operation for Amazon Elastic MapReduce.
//
// ModifyInstanceGroups modifies the number of nodes and configuration settings
// of an instance group. The input parameters include the new target instance
// count for the group and the instance group ID. The call will either succeed
// or fail atomically.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ModifyInstanceGroups for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) ModifyInstanceGroups(input *ModifyInstanceGroupsInput) (*ModifyInstanceGroupsOutput, error) {
	req, out := c.ModifyInstanceGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// RemoveTags API operation for Amazon Elastic MapReduce.
//
// Removes tags from an Amazon EMR resource. Tags make it easier to associate
// clusters in various ways, such as grouping clusters to track your Amazon
// EMR resource allocation costs. For more information, see Tagging Amazon EMR
// Resources (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
//
// The following example removes the stack tag with value Prod from a cluster:
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the EMR service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
func (c *EMR) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opRunJobFlow = "RunJobFlow"

// RunJobFlowRequest generates a "aws/request.Request" representing the
// client's request for the RunJobFlow operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RunJobFlow for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RunJobFlow method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RunJobFlowRequest method.
//    req, resp := client.RunJobFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) RunJobFlowRequest(input *RunJobFlowInput) (req *request.Request, output *RunJobFlowOutput) {
	op := &request.Operation{
		Name:       opRunJobFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunJobFlowInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RunJobFlowOutput{}
	req.Data = output
	return
}

// RunJobFlow API operation for Amazon Elastic MapReduce.
//
// RunJobFlow creates and starts running a new job flow. The job flow will run
// the steps specified. Once the job flow completes, the cluster is stopped
// and the HDFS partition is lost. To prevent loss of data, configure the last
// step of the job flow to store results in Amazon S3. If the JobFlowInstancesConfigKeepJobFlowAliveWhenNoSteps
// parameter is set to TRUE, the job flow will transition to the WAITING state
// rather than shutting down once the steps have completed.
//
// For additional protection, you can set the JobFlowInstancesConfigTerminationProtected
// parameter to TRUE to lock the job flow and prevent it from being terminated
// by API call, user intervention, or in the event of a job flow error.
//
// A maximum of 256 steps are allowed in each job flow.
//
// If your job flow is long-running (such as a Hive data warehouse) or complex,
// you may require more than 256 steps to process your data. You can bypass
// the 256-step limitation in various ways, including using the SSH shell to
// connect to the master node and submitting queries directly to the software
// running on the master node, such as Hive and Hadoop. For more information
// on how to do this, go to Add More than 256 Steps to a Job Flow (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/AddMoreThan256Steps.html)
// in the Amazon Elastic MapReduce Developer's Guide.
//
// For long running job flows, we recommend that you periodically store your
// results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation RunJobFlow for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) RunJobFlow(input *RunJobFlowInput) (*RunJobFlowOutput, error) {
	req, out := c.RunJobFlowRequest(input)
	err := req.Send()
	return out, err
}

const opSetTerminationProtection = "SetTerminationProtection"

// SetTerminationProtectionRequest generates a "aws/request.Request" representing the
// client's request for the SetTerminationProtection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetTerminationProtection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetTerminationProtection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetTerminationProtectionRequest method.
//    req, resp := client.SetTerminationProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) SetTerminationProtectionRequest(input *SetTerminationProtectionInput) (req *request.Request, output *SetTerminationProtectionOutput) {
	op := &request.Operation{
		Name:       opSetTerminationProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTerminationProtectionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetTerminationProtectionOutput{}
	req.Data = output
	return
}

// SetTerminationProtection API operation for Amazon Elastic MapReduce.
//
// SetTerminationProtection locks a job flow so the Amazon EC2 instances in
// the cluster cannot be terminated by user intervention, an API call, or in
// the event of a job-flow error. The cluster still terminates upon successful
// completion of the job flow. Calling SetTerminationProtection on a job flow
// is analogous to calling the Amazon EC2 DisableAPITermination API on all of
// the EC2 instances in a cluster.
//
// SetTerminationProtection is used to prevent accidental termination of a job
// flow and to ensure that in the event of an error, the instances will persist
// so you can recover any data stored in their ephemeral instance storage.
//
// To terminate a job flow that has been locked by setting SetTerminationProtection
// to true, you must first unlock the job flow by a subsequent call to SetTerminationProtection
// in which you set the value to false.
//
// For more information, go to Protecting a Job Flow from Termination (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/UsingEMR_TerminationProtection.html)
// in the Amazon Elastic MapReduce Developer's Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation SetTerminationProtection for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) SetTerminationProtection(input *SetTerminationProtectionInput) (*SetTerminationProtectionOutput, error) {
	req, out := c.SetTerminationProtectionRequest(input)
	err := req.Send()
	return out, err
}

const opSetVisibleToAllUsers = "SetVisibleToAllUsers"

// SetVisibleToAllUsersRequest generates a "aws/request.Request" representing the
// client's request for the SetVisibleToAllUsers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetVisibleToAllUsers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetVisibleToAllUsers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetVisibleToAllUsersRequest method.
//    req, resp := client.SetVisibleToAllUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) SetVisibleToAllUsersRequest(input *SetVisibleToAllUsersInput) (req *request.Request, output *SetVisibleToAllUsersOutput) {
	op := &request.Operation{
		Name:       opSetVisibleToAllUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetVisibleToAllUsersInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetVisibleToAllUsersOutput{}
	req.Data = output
	return
}

// SetVisibleToAllUsers API operation for Amazon Elastic MapReduce.
//
// Sets whether all AWS Identity and Access Management (IAM) users under your
// account can access the specified job flows. This action works on running
// job flows. You can also set the visibility of a job flow when you launch
// it using the VisibleToAllUsers parameter of RunJobFlow. The SetVisibleToAllUsers
// action can be called only by an IAM user who created the job flow or the
// AWS account that owns the job flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation SetVisibleToAllUsers for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) SetVisibleToAllUsers(input *SetVisibleToAllUsersInput) (*SetVisibleToAllUsersOutput, error) {
	req, out := c.SetVisibleToAllUsersRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateJobFlows = "TerminateJobFlows"

// TerminateJobFlowsRequest generates a "aws/request.Request" representing the
// client's request for the TerminateJobFlows operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TerminateJobFlows for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TerminateJobFlows method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TerminateJobFlowsRequest method.
//    req, resp := client.TerminateJobFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *EMR) TerminateJobFlowsRequest(input *TerminateJobFlowsInput) (req *request.Request, output *TerminateJobFlowsOutput) {
	op := &request.Operation{
		Name:       opTerminateJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateJobFlowsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &TerminateJobFlowsOutput{}
	req.Data = output
	return
}

// TerminateJobFlows API operation for Amazon Elastic MapReduce.
//
// TerminateJobFlows shuts a list of job flows down. When a job flow is shut
// down, any step not yet completed is canceled and the EC2 instances on which
// the job flow is running are stopped. Any log files not already saved are
// uploaded to Amazon S3 if a LogUri was specified when the job flow was created.
//
// The maximum number of JobFlows allowed is 10. The call to TerminateJobFlows
// is asynchronous. Depending on the configuration of the job flow, it may take
// up to 5-20 minutes for the job flow to completely terminate and release allocated
// resources, such as Amazon EC2 instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation TerminateJobFlows for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
func (c *EMR) TerminateJobFlows(input *TerminateJobFlowsInput) (*TerminateJobFlowsOutput, error) {
	req, out := c.TerminateJobFlowsRequest(input)
	err := req.Send()
	return out, err
}

// Input to an AddInstanceGroups call.
type AddInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// Instance Groups to add.
	//
	// InstanceGroups is a required field
	InstanceGroups []*InstanceGroupConfig `type:"list" required:"true"`

	// Job flow in which to add the instance groups.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddInstanceGroupsInput"}
	if s.InstanceGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceGroups"))
	}
	if s.JobFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowId"))
	}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Output from an AddInstanceGroups call.
type AddInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Instance group IDs of the newly created instance groups.
	InstanceGroupIds []*string `type:"list"`

	// The job flow ID in which the instance groups are added.
	JobFlowId *string `type:"string"`
}

// String returns the string representation
func (s AddInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceGroupsOutput) GoString() string {
	return s.String()
}

// The input argument to the AddJobFlowSteps operation.
type AddJobFlowStepsInput struct {
	_ struct{} `type:"structure"`

	// A string that uniquely identifies the job flow. This identifier is returned
	// by RunJobFlow and can also be obtained from ListClusters.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`

	// A list of StepConfig to be executed by the job flow.
	//
	// Steps is a required field
	Steps []*StepConfig `type:"list" required:"true"`
}

// String returns the string representation
func (s AddJobFlowStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddJobFlowStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddJobFlowStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddJobFlowStepsInput"}
	if s.JobFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowId"))
	}
	if s.Steps == nil {
		invalidParams.Add(request.NewErrParamRequired("Steps"))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the AddJobFlowSteps operation.
type AddJobFlowStepsOutput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the list of steps added to the job flow.
	StepIds []*string `type:"list"`
}

// String returns the string representation
func (s AddJobFlowStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddJobFlowStepsOutput) GoString() string {
	return s.String()
}

// This input identifies a cluster and a list of tags to attach.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon EMR resource identifier to which tags will be added. This value
	// must be a cluster identifier.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
	// Tags are user-defined key/value pairs that consist of a required key string
	// with a maximum of 128 characters, and an optional value string with a maximum
	// of 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output indicates the result of adding tags to a resource.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// An application is any Amazon or third-party software that you can add to
// the cluster. This structure contains a list of strings that indicates the
// software to use with the cluster and accepts a user argument list. Amazon
// EMR accepts and forwards the argument list to the corresponding installation
// script as bootstrap action argument. For more information, see Launch a Job
// Flow on the MapR Distribution for Hadoop (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-mapr.html).
// Currently supported values are:
//
//    * "mapr-m3" - launch the job flow using MapR M3 Edition.
//
//    * "mapr-m5" - launch the job flow using MapR M5 Edition.
//
//    * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5"
//    - launch the job flow using MapR M3 or M5 Edition, respectively.
//
// In Amazon EMR releases 4.0 and greater, the only accepted parameter is the
// application name. To pass arguments to applications, you supply a configuration
// for each application.
type Application struct {
	_ struct{} `type:"structure"`

	// This option is for advanced users only. This is meta information about third-party
	// applications that third-party vendors use for testing purposes.
	AdditionalInfo map[string]*string `type:"map"`

	// Arguments for Amazon EMR to pass to the application.
	Args []*string `type:"list"`

	// The name of the application.
	Name *string `type:"string"`

	// The version of the application.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

type BootstrapActionConfig struct {
	_ struct{} `type:"structure"`

	// Name is a required field
	Name *string `type:"string" required:"true"`

	// ScriptBootstrapAction is a required field
	ScriptBootstrapAction *ScriptBootstrapActionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s BootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapActionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BootstrapActionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BootstrapActionConfig"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ScriptBootstrapAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ScriptBootstrapAction"))
	}
	if s.ScriptBootstrapAction != nil {
		if err := s.ScriptBootstrapAction.Validate(); err != nil {
			invalidParams.AddNested("ScriptBootstrapAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Reports the configuration of a bootstrap action in a job flow.
type BootstrapActionDetail struct {
	_ struct{} `type:"structure"`

	// A description of the bootstrap action.
	BootstrapActionConfig *BootstrapActionConfig `type:"structure"`
}

// String returns the string representation
func (s BootstrapActionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapActionDetail) GoString() string {
	return s.String()
}

// The detailed description of the cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The applications installed on this cluster.
	Applications []*Application `type:"list"`

	// Specifies whether the cluster should terminate after completing all steps.
	AutoTerminate *bool `type:"boolean"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of Configurations supplied to the EMR cluster.
	Configurations []*Configuration `type:"list"`

	// Provides information about the EC2 instances in a cluster grouped by category.
	// For example, key name, subnet ID, IAM instance profile, and so on.
	Ec2InstanceAttributes *Ec2InstanceAttributes `type:"structure"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	// The path to the Amazon S3 location where logs for this cluster are stored.
	LogUri *string `type:"string"`

	// The public DNS name of the master EC2 instance.
	MasterPublicDnsName *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the job flow, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The release label for the Amazon EMR release. For Amazon EMR 3.x and 2.x
	// AMIs, use amiVersion instead instead of ReleaseLabel.
	ReleaseLabel *string `type:"string"`

	// The AMI version requested for this cluster.
	RequestedAmiVersion *string `type:"string"`

	// The AMI version running on this cluster.
	RunningAmiVersion *string `type:"string"`

	// The name of the security configuration applied to the cluster.
	SecurityConfiguration *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// The current status details about the cluster.
	Status *ClusterStatus `type:"structure"`

	// A list of tags associated with a cluster.
	Tags []*Tag `type:"list"`

	// Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances
	// from being terminated by an API call or user intervention, or in the event
	// of a cluster error.
	TerminationProtected *bool `type:"boolean"`

	// Indicates whether the job flow is visible to all IAM users of the AWS account
	// associated with the job flow. If this value is set to true, all IAM users
	// of that AWS account can view and manage the job flow if they have the proper
	// policy permissions set. If this value is false, only the IAM user that created
	// the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers
	// action.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// The reason that the cluster changed to its current state.
type ClusterStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmatic code for the state change reason.
	Code *string `type:"string" enum:"ClusterStateChangeReasonCode"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s ClusterStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterStateChangeReason) GoString() string {
	return s.String()
}

// The detailed status of the cluster.
type ClusterStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the cluster.
	State *string `type:"string" enum:"ClusterState"`

	// The reason for the cluster status change.
	StateChangeReason *ClusterStateChangeReason `type:"structure"`

	// A timeline that represents the status of a cluster over the lifetime of the
	// cluster.
	Timeline *ClusterTimeline `type:"structure"`
}

// String returns the string representation
func (s ClusterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterStatus) GoString() string {
	return s.String()
}

// The summary description of the cluster.
type ClusterSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the job flow, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The details about the current status of the cluster.
	Status *ClusterStatus `type:"structure"`
}

// String returns the string representation
func (s ClusterSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSummary) GoString() string {
	return s.String()
}

// Represents the timeline of the cluster's lifecycle.
type ClusterTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the cluster.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster was terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster was ready to execute steps.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ClusterTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterTimeline) GoString() string {
	return s.String()
}

// An entity describing an executable that runs on a cluster.
type Command struct {
	_ struct{} `type:"structure"`

	// Arguments for Amazon EMR to pass to the command for execution.
	Args []*string `type:"list"`

	// The name of the command.
	Name *string `type:"string"`

	// The Amazon S3 location of the command script.
	ScriptPath *string `type:"string"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// Amazon EMR releases 4.x or later.
//
// Specifies a hardware and software configuration of the EMR cluster. This
// includes configurations for applications and software bundled with Amazon
// EMR. The Configuration object is a JSON object which is defined by a classification
// and a set of properties. Configurations can be nested, so a configuration
// may have its own Configuration objects listed.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The classification of a configuration. For more information see, Amazon EMR
	// Configurations (http://docs.aws.amazon.com/ElasticMapReduce/latest/API/EmrConfigurations.html).
	Classification *string `type:"string"`

	// A list of configurations you apply to this configuration object.
	Configurations []*Configuration `type:"list"`

	// A set of properties supplied to the Configuration object.
	Properties map[string]*string `type:"map"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

type CreateSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The security configuration details in JSON format.
	//
	// SecurityConfiguration is a required field
	SecurityConfiguration *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SecurityConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecurityConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityConfigurationOutput) GoString() string {
	return s.String()
}

// This input determines which cluster to describe.
type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to describe.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the description of the cluster.
type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// This output contains the details for the requested cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// The input for the DescribeJobFlows operation.
type DescribeJobFlowsInput struct {
	_ struct{} `type:"structure"`

	// Return only job flows created after this date and time.
	CreatedAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Return only job flows created before this date and time.
	CreatedBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Return only job flows whose job flow ID is contained in this list.
	JobFlowIds []*string `type:"list"`

	// Return only job flows whose state is contained in this list.
	JobFlowStates []*string `type:"list"`
}

// String returns the string representation
func (s DescribeJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobFlowsInput) GoString() string {
	return s.String()
}

// The output for the DescribeJobFlows operation.
type DescribeJobFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job flows matching the parameters supplied.
	JobFlows []*JobFlowDetail `type:"list"`
}

// String returns the string representation
func (s DescribeJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobFlowsOutput) GoString() string {
	return s.String()
}

type DescribeSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecurityConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the security configuration.
	Name *string `type:"string"`

	// The security configuration details in JSON format.
	SecurityConfiguration *string `type:"string"`
}

// String returns the string representation
func (s DescribeSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityConfigurationOutput) GoString() string {
	return s.String()
}

// This input determines which step to describe.
type DescribeStepInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster with steps to describe.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The identifier of the step to describe.
	//
	// StepId is a required field
	StepId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStepInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the description of the cluster step.
type DescribeStepOutput struct {
	_ struct{} `type:"structure"`

	// The step details for the requested step identifier.
	Step *Step `type:"structure"`
}

// String returns the string representation
func (s DescribeStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStepOutput) GoString() string {
	return s.String()
}

// Configuration of requested EBS block device associated with the instance
// group.
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string `type:"string"`

	// EBS volume specifications such as volume type, IOPS, and size(GiB) that will
	// be requested for the EBS volume attached to an EC2 instance in the cluster.
	VolumeSpecification *VolumeSpecification `type:"structure"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDevice) GoString() string {
	return s.String()
}

// Configuration of requested EBS block device associated with the instance
// group with count of volumes that will be associated to every instance.
type EbsBlockDeviceConfig struct {
	_ struct{} `type:"structure"`

	// EBS volume specifications such as volume type, IOPS, and size(GiB) that will
	// be requested for the EBS volume attached to an EC2 instance in the cluster.
	//
	// VolumeSpecification is a required field
	VolumeSpecification *VolumeSpecification `type:"structure" required:"true"`

	// Number of EBS volumes with specific volume configuration, that will be associated
	// with every instance in the instance group
	VolumesPerInstance *int64 `type:"integer"`
}

// String returns the string representation
func (s EbsBlockDeviceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDeviceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsBlockDeviceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EbsBlockDeviceConfig"}
	if s.VolumeSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSpecification"))
	}
	if s.VolumeSpecification != nil {
		if err := s.VolumeSpecification.Validate(); err != nil {
			invalidParams.AddNested("VolumeSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EbsConfiguration struct {
	_ struct{} `type:"structure"`

	EbsBlockDeviceConfigs []*EbsBlockDeviceConfig `type:"list"`

	EbsOptimized *bool `type:"boolean"`
}

// String returns the string representation
func (s EbsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EbsConfiguration"}
	if s.EbsBlockDeviceConfigs != nil {
		for i, v := range s.EbsBlockDeviceConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EbsBlockDeviceConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// EBS block device that's attached to an EC2 instance.
type EbsVolume struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string `type:"string"`

	// The volume identifier of the EBS volume.
	VolumeId *string `type:"string"`
}

// String returns the string representation
func (s EbsVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsVolume) GoString() string {
	return s.String()
}

// Provides information about the EC2 instances in a cluster grouped by category.
// For example, key name, subnet ID, IAM instance profile, and so on.
type Ec2InstanceAttributes struct {
	_ struct{} `type:"structure"`

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []*string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the slave nodes.
	AdditionalSlaveSecurityGroups []*string `type:"list"`

	// The Availability Zone in which the cluster will run.
	Ec2AvailabilityZone *string `type:"string"`

	// The name of the Amazon EC2 key pair to use when connecting with SSH into
	// the master node as a user named "hadoop".
	Ec2KeyName *string `type:"string"`

	// To launch the job flow in Amazon VPC, set this parameter to the identifier
	// of the Amazon VPC subnet where you want the job flow to launch. If you do
	// not specify this value, the job flow is launched in the normal AWS cloud,
	// outside of a VPC.
	//
	// Amazon VPC currently does not support cluster compute quadruple extra large
	// (cc1.4xlarge) instances. Thus, you cannot specify the cc1.4xlarge instance
	// type for nodes of a job flow launched in a VPC.
	Ec2SubnetId *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the slave nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// The IAM role that was specified when the job flow was launched. The EC2 instances
	// of the job flow assume this role.
	IamInstanceProfile *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the Amazon EMR service
	// to access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string `type:"string"`
}

// String returns the string representation
func (s Ec2InstanceAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ec2InstanceAttributes) GoString() string {
	return s.String()
}

// The details of the step failure. The service attempts to detect the root
// cause for many common failures.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// The path to the log file where the step failure root cause was originally
	// recorded.
	LogFile *string `type:"string"`

	// The descriptive message including the error the EMR service has identified
	// as the cause of step failure. This is text from an error log that describes
	// the root cause of the failure.
	Message *string `type:"string"`

	// The reason for the step failure. In the case where the service cannot successfully
	// determine the root cause of the failure, it returns "Unknown Error" as a
	// reason.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureDetails) GoString() string {
	return s.String()
}

// A job flow step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopJarStepConfig struct {
	_ struct{} `type:"structure"`

	// A list of command line arguments passed to the JAR file's main function when
	// executed.
	Args []*string `type:"list"`

	// A path to a JAR file run during the step.
	//
	// Jar is a required field
	Jar *string `type:"string" required:"true"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a Main-Class in its manifest file.
	MainClass *string `type:"string"`

	// A list of Java properties that are set when the step runs. You can use these
	// properties to pass key value pairs to your main function.
	Properties []*KeyValue `type:"list"`
}

// String returns the string representation
func (s HadoopJarStepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HadoopJarStepConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HadoopJarStepConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HadoopJarStepConfig"}
	if s.Jar == nil {
		invalidParams.Add(request.NewErrParamRequired("Jar"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A cluster step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopStepConfig struct {
	_ struct{} `type:"structure"`

	// The list of command line arguments to pass to the JAR file's main function
	// for execution.
	Args []*string `type:"list"`

	// The path to the JAR file that runs during the step.
	Jar *string `type:"string"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a main class in its manifest file.
	MainClass *string `type:"string"`

	// The list of Java properties that are set when the step runs. You can use
	// these properties to pass key value pairs to your main function.
	Properties map[string]*string `type:"map"`
}

// String returns the string representation
func (s HadoopStepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HadoopStepConfig) GoString() string {
	return s.String()
}

// Represents an EC2 instance provisioned as part of cluster.
type Instance struct {
	_ struct{} `type:"structure"`

	// The list of EBS volumes that are attached to this instance.
	EbsVolumes []*EbsVolume `type:"list"`

	// The unique identifier of the instance in Amazon EC2.
	Ec2InstanceId *string `type:"string"`

	// The unique identifier for the instance in Amazon EMR.
	Id *string `type:"string"`

	// The identifier of the instance group to which this instance belongs.
	InstanceGroupId *string `type:"string"`

	// The private DNS name of the instance.
	PrivateDnsName *string `type:"string"`

	// The private IP address of the instance.
	PrivateIpAddress *string `type:"string"`

	// The public DNS name of the instance.
	PublicDnsName *string `type:"string"`

	// The public IP address of the instance.
	PublicIpAddress *string `type:"string"`

	// The current status of the instance.
	Status *InstanceStatus `type:"structure"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// This entity represents an instance group, which is a group of instances that
// have common purpose. For example, CORE instance group is used for HDFS.
type InstanceGroup struct {
	_ struct{} `type:"structure"`

	// The bid price for each EC2 instance in the instance group when launching
	// nodes as Spot Instances, expressed in USD.
	BidPrice *string `type:"string"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []*Configuration `type:"list"`

	// The EBS block devices that are mapped to this instance group.
	EbsBlockDevices []*EbsBlockDevice `type:"list"`

	// If the instance group is EBS-optimized. An Amazon EBS-optimized instance
	// uses an optimized configuration stack and provides additional, dedicated
	// capacity for Amazon EBS I/O.
	EbsOptimized *bool `type:"boolean"`

	// The identifier of the instance group.
	Id *string `type:"string"`

	// The type of the instance group. Valid values are MASTER, CORE or TASK.
	InstanceGroupType *string `type:"string" enum:"InstanceGroupType"`

	// The EC2 instance type for all instances in the instance group.
	InstanceType *string `min:"1" type:"string"`

	// The marketplace to provision instances for this group. Valid values are ON_DEMAND
	// or SPOT.
	Market *string `type:"string" enum:"MarketType"`

	// The name of the instance group.
	Name *string `type:"string"`

	// The target number of instances for the instance group.
	RequestedInstanceCount *int64 `type:"integer"`

	// The number of instances currently running in this instance group.
	RunningInstanceCount *int64 `type:"integer"`

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy `type:"structure"`

	// The current status of the instance group.
	Status *InstanceGroupStatus `type:"structure"`
}

// String returns the string representation
func (s InstanceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroup) GoString() string {
	return s.String()
}

// Configuration defining a new instance group.
type InstanceGroupConfig struct {
	_ struct{} `type:"structure"`

	// Bid price for each Amazon EC2 instance in the instance group when launching
	// nodes as Spot Instances, expressed in USD.
	BidPrice *string `type:"string"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []*Configuration `type:"list"`

	// EBS configurations that will be attached to each Amazon EC2 instance in the
	// instance group.
	EbsConfiguration *EbsConfiguration `type:"structure"`

	// Target number of instances for the instance group.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// The role of the instance group in the cluster.
	//
	// InstanceRole is a required field
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// The Amazon EC2 instance type for all instances in the instance group.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Market type of the Amazon EC2 instances used to create a cluster node.
	Market *string `type:"string" enum:"MarketType"`

	// Friendly name given to the instance group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceGroupConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceGroupConfig"}
	if s.InstanceCount == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceRole"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.EbsConfiguration != nil {
		if err := s.EbsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Detailed information about an instance group.
type InstanceGroupDetail struct {
	_ struct{} `type:"structure"`

	// Bid price for EC2 Instances when launching nodes as Spot Instances, expressed
	// in USD.
	BidPrice *string `type:"string"`

	// The date/time the instance group was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The date/time the instance group was terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for the instance group.
	InstanceGroupId *string `type:"string"`

	// Target number of instances to run in the instance group.
	//
	// InstanceRequestCount is a required field
	InstanceRequestCount *int64 `type:"integer" required:"true"`

	// Instance group role in the cluster
	//
	// InstanceRole is a required field
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// Actual count of running instances.
	//
	// InstanceRunningCount is a required field
	InstanceRunningCount *int64 `type:"integer" required:"true"`

	// Amazon EC2 Instance type.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Details regarding the state of the instance group.
	LastStateChangeReason *string `type:"string"`

	// Market type of the Amazon EC2 instances used to create a cluster node.
	//
	// Market is a required field
	Market *string `type:"string" required:"true" enum:"MarketType"`

	// Friendly name for the instance group.
	Name *string `type:"string"`

	// The date/time the instance group was available to the cluster.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date/time the instance group was started.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// State of instance group. The following values are deprecated: STARTING, TERMINATED,
	// and FAILED.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"InstanceGroupState"`
}

// String returns the string representation
func (s InstanceGroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupDetail) GoString() string {
	return s.String()
}

// Modify an instance group size.
type InstanceGroupModifyConfig struct {
	_ struct{} `type:"structure"`

	// The EC2 InstanceIds to terminate. Once you terminate the instances, the instance
	// group will not return to its original requested size.
	EC2InstanceIdsToTerminate []*string `type:"list"`

	// Target size for the instance group.
	InstanceCount *int64 `type:"integer"`

	// Unique ID of the instance group to expand or shrink.
	//
	// InstanceGroupId is a required field
	InstanceGroupId *string `type:"string" required:"true"`

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupModifyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupModifyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceGroupModifyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceGroupModifyConfig"}
	if s.InstanceGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status change reason details for the instance group.
type InstanceGroupStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason.
	Code *string `type:"string" enum:"InstanceGroupStateChangeReasonCode"`

	// The status change reason description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupStateChangeReason) GoString() string {
	return s.String()
}

// The details of the instance group status.
type InstanceGroupStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the instance group.
	State *string `type:"string" enum:"InstanceGroupState"`

	// The status change reason details for the instance group.
	StateChangeReason *InstanceGroupStateChangeReason `type:"structure"`

	// The timeline of the instance group status over time.
	Timeline *InstanceGroupTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupStatus) GoString() string {
	return s.String()
}

// The timeline of the instance group lifecycle.
type InstanceGroupTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the instance group.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance group terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance group became ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s InstanceGroupTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupTimeline) GoString() string {
	return s.String()
}

// Custom policy for requesting termination protection or termination of specific
// instances when shrinking an instance group.
type InstanceResizePolicy struct {
	_ struct{} `type:"structure"`

	// Decommissioning timeout override for the specific list of instances to be
	// terminated.
	InstanceTerminationTimeout *int64 `type:"integer"`

	// Specific list of instances to be protected when shrinking an instance group.
	InstancesToProtect []*string `type:"list"`

	// Specific list of instances to be terminated when shrinking an instance group.
	InstancesToTerminate []*string `type:"list"`
}

// String returns the string representation
func (s InstanceResizePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceResizePolicy) GoString() string {
	return s.String()
}

// The details of the status change reason for the instance.
type InstanceStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason.
	Code *string `type:"string" enum:"InstanceStateChangeReasonCode"`

	// The status change reason description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStateChangeReason) GoString() string {
	return s.String()
}

// The instance status details.
type InstanceStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the instance.
	State *string `type:"string" enum:"InstanceState"`

	// The details of the status change reason for the instance.
	StateChangeReason *InstanceStateChangeReason `type:"structure"`

	// The timeline of the instance status over time.
	Timeline *InstanceTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatus) GoString() string {
	return s.String()
}

// The timeline of the instance lifecycle.
type InstanceTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the instance.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance was terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance was ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s InstanceTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTimeline) GoString() string {
	return s.String()
}

// A description of a job flow.
type JobFlowDetail struct {
	_ struct{} `type:"structure"`

	// The version of the AMI used to initialize Amazon EC2 instances in the job
	// flow. For a list of AMI versions currently supported by Amazon ElasticMapReduce,
	// go to AMI Versions Supported in Elastic MapReduce (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/EnvironmentConfig_AMIVersion.html#ami-versions-supported)
	// in the Amazon Elastic MapReduce Developer Guide.
	AmiVersion *string `type:"string"`

	// A list of the bootstrap actions run by the job flow.
	BootstrapActions []*BootstrapActionDetail `type:"list"`

	// Describes the execution status of the job flow.
	//
	// ExecutionStatusDetail is a required field
	ExecutionStatusDetail *JobFlowExecutionStatusDetail `type:"structure" required:"true"`

	// Describes the Amazon EC2 instances of the job flow.
	//
	// Instances is a required field
	Instances *JobFlowInstancesDetail `type:"structure" required:"true"`

	// The job flow identifier.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`

	// The IAM role that was specified when the job flow was launched. The EC2 instances
	// of the job flow assume this role.
	JobFlowRole *string `type:"string"`

	// The location in Amazon S3 where log files for the job are stored.
	LogUri *string `type:"string"`

	// The name of the job flow.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// A list of steps run by the job flow.
	Steps []*StepDetail `type:"list"`

	// A list of strings set by third party software when the job flow is launched.
	// If you are not using third party software to manage the job flow this value
	// is empty.
	SupportedProducts []*string `type:"list"`

	// Specifies whether the job flow is visible to all IAM users of the AWS account
	// associated with the job flow. If this value is set to true, all IAM users
	// of that AWS account can view and (if they have the proper policy permissions
	// set) manage the job flow. If it is set to false, only the IAM user that created
	// the job flow can view and manage it. This value can be changed using the
	// SetVisibleToAllUsers action.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowDetail) GoString() string {
	return s.String()
}

// Describes the status of the job flow.
type JobFlowExecutionStatusDetail struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the job flow.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The completion date and time of the job flow.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Description of the job flow last changed state.
	LastStateChangeReason *string `type:"string"`

	// The date and time when the job flow was ready to start running bootstrap
	// actions.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The start date and time of the job flow.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The state of the job flow.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"JobFlowExecutionState"`
}

// String returns the string representation
func (s JobFlowExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowExecutionStatusDetail) GoString() string {
	return s.String()
}

// A description of the Amazon EC2 instance running the job flow. A valid JobFlowInstancesConfig
// must contain at least InstanceGroups, which is the recommended configuration.
// However, a valid alternative is to have MasterInstanceType, SlaveInstanceType,
// and InstanceCount (all three must be present).
type JobFlowInstancesConfig struct {
	_ struct{} `type:"structure"`

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []*string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the slave nodes.
	AdditionalSlaveSecurityGroups []*string `type:"list"`

	// The name of the Amazon EC2 key pair that can be used to ssh to the master
	// node as the user called "hadoop."
	Ec2KeyName *string `type:"string"`

	// To launch the job flow in Amazon Virtual Private Cloud (Amazon VPC), set
	// this parameter to the identifier of the Amazon VPC subnet where you want
	// the job flow to launch. If you do not specify this value, the job flow is
	// launched in the normal Amazon Web Services cloud, outside of an Amazon VPC.
	//
	// Amazon VPC currently does not support cluster compute quadruple extra large
	// (cc1.4xlarge) instances. Thus you cannot specify the cc1.4xlarge instance
	// type for nodes of a job flow launched in a Amazon VPC.
	Ec2SubnetId *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the slave nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// The Hadoop version for the job flow. Valid inputs are "0.18" (deprecated),
	// "0.20" (deprecated), "0.20.205" (deprecated), "1.0.3", "2.2.0", or "2.4.0".
	// If you do not set this value, the default of 0.18 is used, unless the AmiVersion
	// parameter is set in the RunJobFlow call, in which case the default version
	// of Hadoop for that AMI version is used.
	HadoopVersion *string `type:"string"`

	// The number of Amazon EC2 instances used to execute the job flow.
	InstanceCount *int64 `type:"integer"`

	// Configuration for the job flow's instance groups.
	InstanceGroups []*InstanceGroupConfig `type:"list"`

	// Specifies whether the job flow should be kept alive after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The EC2 instance type of the master node.
	MasterInstanceType *string `min:"1" type:"string"`

	// The Availability Zone the job flow will run in.
	Placement *PlacementType `type:"structure"`

	// The identifier of the Amazon EC2 security group for the Amazon EMR service
	// to access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string `type:"string"`

	// The EC2 instance type of the slave nodes.
	SlaveInstanceType *string `min:"1" type:"string"`

	// Specifies whether to lock the job flow to prevent the Amazon EC2 instances
	// from being terminated by API call, user intervention, or in the event of
	// a job flow error.
	TerminationProtected *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowInstancesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowInstancesConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobFlowInstancesConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobFlowInstancesConfig"}
	if s.MasterInstanceType != nil && len(*s.MasterInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterInstanceType", 1))
	}
	if s.SlaveInstanceType != nil && len(*s.SlaveInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlaveInstanceType", 1))
	}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Placement != nil {
		if err := s.Placement.Validate(); err != nil {
			invalidParams.AddNested("Placement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specify the type of Amazon EC2 instances to run the job flow on.
type JobFlowInstancesDetail struct {
	_ struct{} `type:"structure"`

	// The name of an Amazon EC2 key pair that can be used to ssh to the master
	// node of job flow.
	Ec2KeyName *string `type:"string"`

	// For job flows launched within Amazon Virtual Private Cloud, this value specifies
	// the identifier of the subnet where the job flow was launched.
	Ec2SubnetId *string `type:"string"`

	// The Hadoop version for the job flow.
	HadoopVersion *string `type:"string"`

	// The number of Amazon EC2 instances in the cluster. If the value is 1, the
	// same instance serves as both the master and slave node. If the value is greater
	// than 1, one instance is the master node and all others are slave nodes.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// Details about the job flow's instance groups.
	InstanceGroups []*InstanceGroupDetail `type:"list"`

	// Specifies whether the job flow should terminate after completing all steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The Amazon EC2 instance identifier of the master node.
	MasterInstanceId *string `type:"string"`

	// The Amazon EC2 master node instance type.
	//
	// MasterInstanceType is a required field
	MasterInstanceType *string `min:"1" type:"string" required:"true"`

	// The DNS name of the master node.
	MasterPublicDnsName *string `type:"string"`

	// An approximation of the cost of the job flow, represented in m1.small/hours.
	// This value is incremented once for every hour an m1.small runs. Larger instances
	// are weighted more, so an Amazon EC2 instance that is roughly four times more
	// expensive would result in the normalized instance hours being incremented
	// by four. This result is only an approximation and does not reflect the actual
	// billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone for the job flow.
	Placement *PlacementType `type:"structure"`

	// The Amazon EC2 slave node instance type.
	//
	// SlaveInstanceType is a required field
	SlaveInstanceType *string `min:"1" type:"string" required:"true"`

	// Specifies whether the Amazon EC2 instances in the cluster are protected from
	// termination by API calls, user intervention, or in the event of a job flow
	// error.
	TerminationProtected *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowInstancesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowInstancesDetail) GoString() string {
	return s.String()
}

// A key value pair.
type KeyValue struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a key value pair.
	Key *string `type:"string"`

	// The value part of the identified key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyValue) GoString() string {
	return s.String()
}

// This input determines which bootstrap actions to retrieve.
type ListBootstrapActionsInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for the bootstrap actions to list .
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListBootstrapActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBootstrapActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBootstrapActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBootstrapActionsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the boostrap actions detail .
type ListBootstrapActionsOutput struct {
	_ struct{} `type:"structure"`

	// The bootstrap actions associated with the cluster .
	BootstrapActions []*Command `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListBootstrapActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBootstrapActionsOutput) GoString() string {
	return s.String()
}

// This input determines how the ListClusters action filters the list of clusters
// that it returns.
type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The cluster state filters to apply when listing clusters.
	ClusterStates []*string `type:"list"`

	// The creation date and time beginning value filter for listing clusters .
	CreatedAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The creation date and time end value filter for listing clusters .
	CreatedBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// This contains a ClusterSummaryList with the cluster details; for example,
// the cluster IDs, names, and status.
type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// The list of clusters for the account based on the given filters.
	Clusters []*ClusterSummary `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// This input determines which instance groups to retrieve.
type ListInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the instance groups.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceGroupsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This input determines which instance groups to retrieve.
type ListInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of instance groups for the cluster and given filters.
	InstanceGroups []*InstanceGroup `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceGroupsOutput) GoString() string {
	return s.String()
}

// This input determines which instances to list.
type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the instances.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The identifier of the instance group for which to list the instances.
	InstanceGroupId *string `type:"string"`

	// The type of instance group for which to list the instances.
	InstanceGroupTypes []*string `type:"list"`

	// A list of instance states that will filter the instances returned with this
	// request.
	InstanceStates []*string `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the list of instances.
type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of instances for the cluster and given filters.
	Instances []*Instance `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

type ListSecurityConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListSecurityConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityConfigurationsInput) GoString() string {
	return s.String()
}

type ListSecurityConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that indicates the next set of results to retrieve. Include
	// the marker in the next ListSecurityConfiguration call to retrieve the next
	// page of results, if required.
	Marker *string `type:"string"`

	// The creation date and time, and name, of each security configuration.
	SecurityConfigurations []*SecurityConfigurationSummary `type:"list"`
}

// String returns the string representation
func (s ListSecurityConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityConfigurationsOutput) GoString() string {
	return s.String()
}

// This input determines which steps to list.
type ListStepsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the steps.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The filter to limit the step list based on the identifier of the steps.
	StepIds []*string `type:"list"`

	// The filter to limit the step list based on certain states.
	StepStates []*string `type:"list"`
}

// String returns the string representation
func (s ListStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStepsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the list of steps returned in reverse order. This means
// that the last step is the first element in the list.
type ListStepsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The filtered list of steps for the cluster.
	Steps []*StepSummary `type:"list"`
}

// String returns the string representation
func (s ListStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStepsOutput) GoString() string {
	return s.String()
}

// Change the size of some instance groups.
type ModifyInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// Instance groups to change.
	InstanceGroups []*InstanceGroupModifyConfig `type:"list"`
}

// String returns the string representation
func (s ModifyInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyInstanceGroupsInput"}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceGroupsOutput) GoString() string {
	return s.String()
}

// The Amazon EC2 location for the job flow.
type PlacementType struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 Availability Zone for the job flow.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PlacementType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlacementType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlacementType"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This input identifies a cluster and a list of tags to remove.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon EMR resource identifier from which tags will be removed. This
	// value must be a cluster identifier.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of tag keys to remove from a resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output indicates the result of removing tags from a resource.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Input to the RunJobFlow operation.
type RunJobFlowInput struct {
	_ struct{} `type:"structure"`

	// A JSON string for selecting additional features.
	AdditionalInfo *string `type:"string"`

	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and greater,
	// use ReleaseLabel.
	//
	// The version of the Amazon Machine Image (AMI) to use when launching Amazon
	// EC2 instances in the job flow. The following values are valid:
	//
	//    * The version number of the AMI to use, for example, "2.0."
	//
	// If the AMI supports multiple versions of Hadoop (for example, AMI 1.0 supports
	// both Hadoop 0.18 and 0.20) you can use the JobFlowInstancesConfigHadoopVersion
	// parameter to modify the version of Hadoop from the defaults shown above.
	//
	// For details about the AMI versions currently supported by Amazon Elastic
	// MapReduce, go to AMI Versions Supported in Elastic MapReduce (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/EnvironmentConfig_AMIVersion.html#ami-versions-supported)
	// in the Amazon Elastic MapReduce Developer's Guide.
	AmiVersion *string `type:"string"`

	// Amazon EMR releases 4.x or later.
	//
	// A list of applications for the cluster. Valid values are: "Hadoop", "Hive",
	// "Mahout", "Pig", and "Spark." They are case insensitive.
	Applications []*Application `type:"list"`

	// A list of bootstrap actions that will be run before Hadoop is started on
	// the cluster nodes.
	BootstrapActions []*BootstrapActionConfig `type:"list"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for the EMR cluster you are creating.
	Configurations []*Configuration `type:"list"`

	// A specification of the number and type of Amazon EC2 instances on which to
	// run the job flow.
	//
	// Instances is a required field
	Instances *JobFlowInstancesConfig `type:"structure" required:"true"`

	// Also called instance profile and EC2 role. An IAM role for an EMR cluster.
	// The EC2 instances of the cluster assume this role. The default role is EMR_EC2_DefaultRole.
	// In order to use the default role, you must have already created it using
	// the CLI or console.
	JobFlowRole *string `type:"string"`

	// The location in Amazon S3 to write the log files of the job flow. If a value
	// is not provided, logs are not created.
	LogUri *string `type:"string"`

	// The name of the job flow.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and greater,
	// use Applications.
	//
	// A list of strings that indicates third-party software to use with the job
	// flow that accepts a user argument list. EMR accepts and forwards the argument
	// list to the corresponding installation script as bootstrap action arguments.
	// For more information, see Launch a Job Flow on the MapR Distribution for
	// Hadoop (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-mapr.html).
	// Currently supported values are:
	//
	//    * "mapr-m3" - launch the cluster using MapR M3 Edition.
	//
	//    * "mapr-m5" - launch the cluster using MapR M5 Edition.
	//
	//    * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5"
	//    - launch the job flow using MapR M3 or M5 Edition respectively.
	//
	//    * "mapr-m7" - launch the cluster using MapR M7 Edition.
	//
	//    * "hunk" - launch the cluster with the Hunk Big Data Analtics Platform.
	//
	//    * "hue"- launch the cluster with Hue installed.
	//
	//    * "spark" - launch the cluster with Apache Spark installed.
	//
	//    * "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
	NewSupportedProducts []*SupportedProductConfig `type:"list"`

	// Amazon EMR releases 4.x or later.
	//
	// The release label for the Amazon EMR release. For Amazon EMR 3.x and 2.x
	// AMIs, use amiVersion instead instead of ReleaseLabel.
	ReleaseLabel *string `type:"string"`

	// The name of a security configuration to apply to the cluster.
	SecurityConfiguration *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// A list of steps to be executed by the job flow.
	Steps []*StepConfig `type:"list"`

	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and greater,
	// use Applications.
	//
	// A list of strings that indicates third-party software to use with the job
	// flow. For more information, go to Use Third Party Applications with Amazon
	// EMR (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-supported-products.html).
	// Currently supported values are:
	//
	//    * "mapr-m3" - launch the job flow using MapR M3 Edition.
	//
	//    * "mapr-m5" - launch the job flow using MapR M5 Edition.
	SupportedProducts []*string `type:"list"`

	// A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
	Tags []*Tag `type:"list"`

	// Whether the job flow is visible to all IAM users of the AWS account associated
	// with the job flow. If this value is set to true, all IAM users of that AWS
	// account can view and (if they have the proper policy permissions set) manage
	// the job flow. If it is set to false, only the IAM user that created the job
	// flow can view and manage it.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s RunJobFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunJobFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunJobFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunJobFlowInput"}
	if s.Instances == nil {
		invalidParams.Add(request.NewErrParamRequired("Instances"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.BootstrapActions != nil {
		for i, v := range s.BootstrapActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BootstrapActions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Instances != nil {
		if err := s.Instances.Validate(); err != nil {
			invalidParams.AddNested("Instances", err.(request.ErrInvalidParams))
		}
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of the RunJobFlow operation.
type RunJobFlowOutput struct {
	_ struct{} `type:"structure"`

	// An unique identifier for the job flow.
	JobFlowId *string `type:"string"`
}

// String returns the string representation
func (s RunJobFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunJobFlowOutput) GoString() string {
	return s.String()
}

type ScriptBootstrapActionConfig struct {
	_ struct{} `type:"structure"`

	Args []*string `type:"list"`

	// Path is a required field
	Path *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ScriptBootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScriptBootstrapActionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScriptBootstrapActionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScriptBootstrapActionConfig"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The creation date and time, and name, of a security configuration.
type SecurityConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the security configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityConfigurationSummary) GoString() string {
	return s.String()
}

// The input argument to the TerminationProtection operation.
type SetTerminationProtectionInput struct {
	_ struct{} `type:"structure"`

	// A list of strings that uniquely identify the job flows to protect. This identifier
	// is returned by RunJobFlow and can also be obtained from DescribeJobFlows
	// .
	//
	// JobFlowIds is a required field
	JobFlowIds []*string `type:"list" required:"true"`

	// A Boolean that indicates whether to protect the job flow and prevent the
	// Amazon EC2 instances in the cluster from shutting down due to API calls,
	// user intervention, or job-flow error.
	//
	// TerminationProtected is a required field
	TerminationProtected *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetTerminationProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTerminationProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTerminationProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTerminationProtectionInput"}
	if s.JobFlowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowIds"))
	}
	if s.TerminationProtected == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminationProtected"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetTerminationProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTerminationProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTerminationProtectionOutput) GoString() string {
	return s.String()
}

// The input to the SetVisibleToAllUsers action.
type SetVisibleToAllUsersInput struct {
	_ struct{} `type:"structure"`

	// Identifiers of the job flows to receive the new visibility setting.
	//
	// JobFlowIds is a required field
	JobFlowIds []*string `type:"list" required:"true"`

	// Whether the specified job flows are visible to all IAM users of the AWS account
	// associated with the job flow. If this value is set to True, all IAM users
	// of that AWS account can view and, if they have the proper IAM policy permissions
	// set, manage the job flows. If it is set to False, only the IAM user that
	// created a job flow can view and manage it.
	//
	// VisibleToAllUsers is a required field
	VisibleToAllUsers *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetVisibleToAllUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVisibleToAllUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVisibleToAllUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetVisibleToAllUsersInput"}
	if s.JobFlowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowIds"))
	}
	if s.VisibleToAllUsers == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibleToAllUsers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetVisibleToAllUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetVisibleToAllUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVisibleToAllUsersOutput) GoString() string {
	return s.String()
}

// Policy for customizing shrink operations. Allows configuration of decommissioning
// timeout and targeted instance shrinking.
type ShrinkPolicy struct {
	_ struct{} `type:"structure"`

	// The desired timeout for decommissioning an instance. Overrides the default
	// YARN decommissioning timeout.
	DecommissionTimeout *int64 `type:"integer"`

	// Custom policy for requesting termination protection or termination of specific
	// instances when shrinking an instance group.
	InstanceResizePolicy *InstanceResizePolicy `type:"structure"`
}

// String returns the string representation
func (s ShrinkPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShrinkPolicy) GoString() string {
	return s.String()
}

// This represents a step in a cluster.
type Step struct {
	_ struct{} `type:"structure"`

	// This specifies what action to take when the cluster step fails. Possible
	// values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`
}

// String returns the string representation
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Step) GoString() string {
	return s.String()
}

// Specification of a job flow step.
type StepConfig struct {
	_ struct{} `type:"structure"`

	// The action to take if the job flow step fails.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The JAR file used for the job flow step.
	//
	// HadoopJarStep is a required field
	HadoopJarStep *HadoopJarStepConfig `type:"structure" required:"true"`

	// The name of the job flow step.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepConfig"}
	if s.HadoopJarStep == nil {
		invalidParams.Add(request.NewErrParamRequired("HadoopJarStep"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.HadoopJarStep != nil {
		if err := s.HadoopJarStep.Validate(); err != nil {
			invalidParams.AddNested("HadoopJarStep", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Combines the execution state and configuration of a step.
type StepDetail struct {
	_ struct{} `type:"structure"`

	// The description of the step status.
	//
	// ExecutionStatusDetail is a required field
	ExecutionStatusDetail *StepExecutionStatusDetail `type:"structure" required:"true"`

	// The step configuration.
	//
	// StepConfig is a required field
	StepConfig *StepConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StepDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepDetail) GoString() string {
	return s.String()
}

// The execution state of a step.
type StepExecutionStatusDetail struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the step.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The completion date and time of the step.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description of the step's current state.
	LastStateChangeReason *string `type:"string"`

	// The start date and time of the step.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The state of the job flow step.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"StepExecutionState"`
}

// String returns the string representation
func (s StepExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepExecutionStatusDetail) GoString() string {
	return s.String()
}

// The details of the step state change reason.
type StepStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason. Note: Currently, the service
	// provides no code for the state change.
	Code *string `type:"string" enum:"StepStateChangeReasonCode"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s StepStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepStateChangeReason) GoString() string {
	return s.String()
}

// The execution status details of the cluster step.
type StepStatus struct {
	_ struct{} `type:"structure"`

	// The details for the step failure including reason, message, and log file
	// path where the root cause was identified.
	FailureDetails *FailureDetails `type:"structure"`

	// The execution state of the cluster step.
	State *string `type:"string" enum:"StepState"`

	// The reason for the step execution status change.
	StateChangeReason *StepStateChangeReason `type:"structure"`

	// The timeline of the cluster step status over time.
	Timeline *StepTimeline `type:"structure"`
}

// String returns the string representation
func (s StepStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepStatus) GoString() string {
	return s.String()
}

// The summary of the cluster step.
type StepSummary struct {
	_ struct{} `type:"structure"`

	// This specifies what action to take when the cluster step fails. Possible
	// values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`
}

// String returns the string representation
func (s StepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepSummary) GoString() string {
	return s.String()
}

// The timeline of the cluster step lifecycle.
type StepTimeline struct {
	_ struct{} `type:"structure"`

	// The date and time when the cluster step was created.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster step execution completed or failed.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster step execution started.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s StepTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepTimeline) GoString() string {
	return s.String()
}

// The list of supported product configurations which allow user-supplied arguments.
// EMR accepts these arguments and forwards them to the corresponding installation
// script as bootstrap action arguments.
type SupportedProductConfig struct {
	_ struct{} `type:"structure"`

	// The list of user-supplied arguments.
	Args []*string `type:"list"`

	// The name of the product configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SupportedProductConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedProductConfig) GoString() string {
	return s.String()
}

// A key/value pair containing user-defined metadata that you can associate
// with an Amazon EMR resource. Tags make it easier to associate clusters in
// various ways, such as grouping clu\ sters to track your Amazon EMR resource
// allocation costs. For more information, see Tagging Amazon EMR Resources
// (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// A user-defined key, which is the minimum required information for a valid
	// tag. For more information, see Tagging Amazon EMR Resources (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
	Key *string `type:"string"`

	// A user-defined value, which is optional in a tag. For more information, see
	// Tagging Amazon EMR Resources (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Input to the TerminateJobFlows operation.
type TerminateJobFlowsInput struct {
	_ struct{} `type:"structure"`

	// A list of job flows to be shutdown.
	//
	// JobFlowIds is a required field
	JobFlowIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateJobFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateJobFlowsInput"}
	if s.JobFlowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TerminateJobFlowsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TerminateJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobFlowsOutput) GoString() string {
	return s.String()
}

// EBS volume specifications such as volume type, IOPS, and size(GiB) that will
// be requested for the EBS volume attached to an EC2 instance in the cluster.
type VolumeSpecification struct {
	_ struct{} `type:"structure"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	Iops *int64 `type:"integer"`

	// The volume size, in gibibytes (GiB). This can be a number from 1 - 1024.
	// If the volume type is EBS-optimized, the minimum value is 10.
	//
	// SizeInGB is a required field
	SizeInGB *int64 `type:"integer" required:"true"`

	// The volume type. Volume types supported are gp2, io1, standard.
	//
	// VolumeType is a required field
	VolumeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VolumeSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VolumeSpecification"}
	if s.SizeInGB == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGB"))
	}
	if s.VolumeType == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// ActionOnFailureTerminateJobFlow is a ActionOnFailure enum value
	ActionOnFailureTerminateJobFlow = "TERMINATE_JOB_FLOW"

	// ActionOnFailureTerminateCluster is a ActionOnFailure enum value
	ActionOnFailureTerminateCluster = "TERMINATE_CLUSTER"

	// ActionOnFailureCancelAndWait is a ActionOnFailure enum value
	ActionOnFailureCancelAndWait = "CANCEL_AND_WAIT"

	// ActionOnFailureContinue is a ActionOnFailure enum value
	ActionOnFailureContinue = "CONTINUE"
)

const (
	// ClusterStateStarting is a ClusterState enum value
	ClusterStateStarting = "STARTING"

	// ClusterStateBootstrapping is a ClusterState enum value
	ClusterStateBootstrapping = "BOOTSTRAPPING"

	// ClusterStateRunning is a ClusterState enum value
	ClusterStateRunning = "RUNNING"

	// ClusterStateWaiting is a ClusterState enum value
	ClusterStateWaiting = "WAITING"

	// ClusterStateTerminating is a ClusterState enum value
	ClusterStateTerminating = "TERMINATING"

	// ClusterStateTerminated is a ClusterState enum value
	ClusterStateTerminated = "TERMINATED"

	// ClusterStateTerminatedWithErrors is a ClusterState enum value
	ClusterStateTerminatedWithErrors = "TERMINATED_WITH_ERRORS"
)

const (
	// ClusterStateChangeReasonCodeInternalError is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ClusterStateChangeReasonCodeValidationError is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// ClusterStateChangeReasonCodeInstanceFailure is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// ClusterStateChangeReasonCodeBootstrapFailure is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeBootstrapFailure = "BOOTSTRAP_FAILURE"

	// ClusterStateChangeReasonCodeUserRequest is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeUserRequest = "USER_REQUEST"

	// ClusterStateChangeReasonCodeStepFailure is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeStepFailure = "STEP_FAILURE"

	// ClusterStateChangeReasonCodeAllStepsCompleted is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeAllStepsCompleted = "ALL_STEPS_COMPLETED"
)

const (
	// InstanceGroupStateProvisioning is a InstanceGroupState enum value
	InstanceGroupStateProvisioning = "PROVISIONING"

	// InstanceGroupStateBootstrapping is a InstanceGroupState enum value
	InstanceGroupStateBootstrapping = "BOOTSTRAPPING"

	// InstanceGroupStateRunning is a InstanceGroupState enum value
	InstanceGroupStateRunning = "RUNNING"

	// InstanceGroupStateResizing is a InstanceGroupState enum value
	InstanceGroupStateResizing = "RESIZING"

	// InstanceGroupStateSuspended is a InstanceGroupState enum value
	InstanceGroupStateSuspended = "SUSPENDED"

	// InstanceGroupStateTerminating is a InstanceGroupState enum value
	InstanceGroupStateTerminating = "TERMINATING"

	// InstanceGroupStateTerminated is a InstanceGroupState enum value
	InstanceGroupStateTerminated = "TERMINATED"

	// InstanceGroupStateArrested is a InstanceGroupState enum value
	InstanceGroupStateArrested = "ARRESTED"

	// InstanceGroupStateShuttingDown is a InstanceGroupState enum value
	InstanceGroupStateShuttingDown = "SHUTTING_DOWN"

	// InstanceGroupStateEnded is a InstanceGroupState enum value
	InstanceGroupStateEnded = "ENDED"
)

const (
	// InstanceGroupStateChangeReasonCodeInternalError is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// InstanceGroupStateChangeReasonCodeValidationError is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// InstanceGroupStateChangeReasonCodeInstanceFailure is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// InstanceGroupStateChangeReasonCodeClusterTerminated is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

const (
	// InstanceGroupTypeMaster is a InstanceGroupType enum value
	InstanceGroupTypeMaster = "MASTER"

	// InstanceGroupTypeCore is a InstanceGroupType enum value
	InstanceGroupTypeCore = "CORE"

	// InstanceGroupTypeTask is a InstanceGroupType enum value
	InstanceGroupTypeTask = "TASK"
)

const (
	// InstanceRoleTypeMaster is a InstanceRoleType enum value
	InstanceRoleTypeMaster = "MASTER"

	// InstanceRoleTypeCore is a InstanceRoleType enum value
	InstanceRoleTypeCore = "CORE"

	// InstanceRoleTypeTask is a InstanceRoleType enum value
	InstanceRoleTypeTask = "TASK"
)

const (
	// InstanceStateAwaitingFulfillment is a InstanceState enum value
	InstanceStateAwaitingFulfillment = "AWAITING_FULFILLMENT"

	// InstanceStateProvisioning is a InstanceState enum value
	InstanceStateProvisioning = "PROVISIONING"

	// InstanceStateBootstrapping is a InstanceState enum value
	InstanceStateBootstrapping = "BOOTSTRAPPING"

	// InstanceStateRunning is a InstanceState enum value
	InstanceStateRunning = "RUNNING"

	// InstanceStateTerminated is a InstanceState enum value
	InstanceStateTerminated = "TERMINATED"
)

const (
	// InstanceStateChangeReasonCodeInternalError is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// InstanceStateChangeReasonCodeValidationError is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// InstanceStateChangeReasonCodeInstanceFailure is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// InstanceStateChangeReasonCodeBootstrapFailure is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeBootstrapFailure = "BOOTSTRAP_FAILURE"

	// InstanceStateChangeReasonCodeClusterTerminated is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

// The type of instance.
const (
	// JobFlowExecutionStateStarting is a JobFlowExecutionState enum value
	JobFlowExecutionStateStarting = "STARTING"

	// JobFlowExecutionStateBootstrapping is a JobFlowExecutionState enum value
	JobFlowExecutionStateBootstrapping = "BOOTSTRAPPING"

	// JobFlowExecutionStateRunning is a JobFlowExecutionState enum value
	JobFlowExecutionStateRunning = "RUNNING"

	// JobFlowExecutionStateWaiting is a JobFlowExecutionState enum value
	JobFlowExecutionStateWaiting = "WAITING"

	// JobFlowExecutionStateShuttingDown is a JobFlowExecutionState enum value
	JobFlowExecutionStateShuttingDown = "SHUTTING_DOWN"

	// JobFlowExecutionStateTerminated is a JobFlowExecutionState enum value
	JobFlowExecutionStateTerminated = "TERMINATED"

	// JobFlowExecutionStateCompleted is a JobFlowExecutionState enum value
	JobFlowExecutionStateCompleted = "COMPLETED"

	// JobFlowExecutionStateFailed is a JobFlowExecutionState enum value
	JobFlowExecutionStateFailed = "FAILED"
)

const (
	// MarketTypeOnDemand is a MarketType enum value
	MarketTypeOnDemand = "ON_DEMAND"

	// MarketTypeSpot is a MarketType enum value
	MarketTypeSpot = "SPOT"
)

const (
	// StepExecutionStatePending is a StepExecutionState enum value
	StepExecutionStatePending = "PENDING"

	// StepExecutionStateRunning is a StepExecutionState enum value
	StepExecutionStateRunning = "RUNNING"

	// StepExecutionStateContinue is a StepExecutionState enum value
	StepExecutionStateContinue = "CONTINUE"

	// StepExecutionStateCompleted is a StepExecutionState enum value
	StepExecutionStateCompleted = "COMPLETED"

	// StepExecutionStateCancelled is a StepExecutionState enum value
	StepExecutionStateCancelled = "CANCELLED"

	// StepExecutionStateFailed is a StepExecutionState enum value
	StepExecutionStateFailed = "FAILED"

	// StepExecutionStateInterrupted is a StepExecutionState enum value
	StepExecutionStateInterrupted = "INTERRUPTED"
)

const (
	// StepStatePending is a StepState enum value
	StepStatePending = "PENDING"

	// StepStateRunning is a StepState enum value
	StepStateRunning = "RUNNING"

	// StepStateCompleted is a StepState enum value
	StepStateCompleted = "COMPLETED"

	// StepStateCancelled is a StepState enum value
	StepStateCancelled = "CANCELLED"

	// StepStateFailed is a StepState enum value
	StepStateFailed = "FAILED"

	// StepStateInterrupted is a StepState enum value
	StepStateInterrupted = "INTERRUPTED"
)

const (
	// StepStateChangeReasonCodeNone is a StepStateChangeReasonCode enum value
	StepStateChangeReasonCodeNone = "NONE"
)
