/*=========================================================================
 Authors: The GoFigure Dev. Team.
 at Megason Lab, Systems biology, Harvard Medical school, 2009

 Copyright (c) 2009, President and Fellows of Harvard College.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.
 Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.
 Neither the name of the  President and Fellows of Harvard College
 nor the names of its contributors may be used to endorse or promote
 products derived from this software without specific prior written
 permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include <QApplication>
#include <QTimer>

#include "QGoWizardDB.h"

int main(int argc, char *argv[])
{
  if ( argc != 2 )
    {
    std::cerr << "QGoWizardTest requires 1 argument:" << std::endl;
    std::cerr << "1-test (boolean)" << std::endl;
    return EXIT_FAILURE;
    }

  //Q_INIT_RESOURCE(qgocreatedb);
  QApplication app(argc, argv);
  QCoreApplication::setOrganizationName("MegasonLab");
  QCoreApplication::setOrganizationDomain("http://gofigure2.sourceforge.net");

  QGoWizardDB *wizard = new QGoWizardDB;
  wizard->show();

  QTimer *timer = new QTimer;
  timer->setSingleShot(true);
  QObject::connect( timer, SIGNAL( timeout() ), wizard, SLOT( close() ) );

  int  output;
  bool test = ( atoi(argv[1]) == 1 );

  if ( test )
    {
    timer->start(1000);
    output = EXIT_SUCCESS;
    }
  else
    {
    output = app.exec();
    }

  if ( !test )
    {
    std::vector< std::vector< std::string > > filenames = wizard->GetFilenamesFromDB();

    for ( unsigned int i = 0; i < filenames.size(); i++ )
      {
      for ( unsigned int j = 0; j < filenames[i].size(); j++ )
        {
        std::cout << "image filename with channel "
                  << i << " " << filenames[i][j].c_str() << std::endl;
        }
      }
    }

  delete wizard;
  delete timer;

  return output;
}