-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/lista4/pgrecordset.adb,v $
--  Description     : binding package
--  Author          : Julio Cano                                             --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/01/08 19:58:50 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Julio Cano                                            --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Julio Cano  <julius_bip@yahoo.com>                               --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

--with Text_Io;
with Ada.Strings.Fixed;
with Ada.Strings.Unbounded;
use Ada.Strings.Unbounded;
with Ada.Exceptions;

with Gnu.Db.Sqlcli;
use Gnu.Db.Sqlcli;
with Gnu.Db.Sqlcli.Diag;
use Gnu.Db.Sqlcli.Diag;

with Gnu.Db.Sqlcli.Environment_Attribute;
use Gnu.Db.Sqlcli.Environment_Attribute;
with Gnu.Db.Sqlcli.Statement_Attribute;
use Gnu.Db.Sqlcli.Statement_Attribute;

with Unchecked_Deallocation;

package body Pgrecordset is

   -- this is for i commented package as generic
      conninfo : string := "";
      username : string := "";
      passwd : string := "";

   type Fields_List is array (Natural range <>) of String_Access;
   type Fields_List_Ptr is access all Fields_List;
   procedure Free is
   new Unchecked_Deallocation (Fields_List, Fields_List_Ptr);

   Std_Conx : Pgrecordset_Ptr;

   type Pgrecordset is
      record
         Entorno   : Sqlhenv;
         Conexion  : Sqlhdbc;
         Resultado : Sqlhstmt;
         Error     : Boolean       := False;
         Error_Msg : String_Access;

         Actual     : Integer;
         Ncampos    : Integer;
         Campos     : Fields_List_Ptr;
         Nregistros : Integer;

         Lista_String : Base_Data;

         Editando : Boolean;
      end record;
   procedure Free is
   new Unchecked_Deallocation(Pgrecordset, Pgrecordset_Ptr);

   function Get_Bind_List (
         Recordset : Pgrecordset_Ptr )
     return Base_Data is
   begin
      return Recordset.Lista_String;
   end Get_Bind_List;

   procedure Set_Bind_List (
         Recordset : in out Pgrecordset_Ptr;
         List      :        Base_Data        ) is
   begin
      Recordset.Lista_String := List;
   end Set_Bind_List;

   procedure Registerdata (
         Recordset : Pgrecordset_Ptr;
         Str       : String_Access;
         Field     : String           ) is
      List : Base_Data;
   begin
      List := Recordset.Lista_String;
      Registerdata (List, Str, Field);
      Binddatalist(List, Recordset.Resultado);
      --  Binddatalist(Recordset.Lista_String, Recordset.Resultado);
      Recordset.Lista_String := List;
   end Registerdata;

   function Recordset_New(
      Conninfo : String; Username : String := ""; Passwd : String := "") return Pgrecordset_Ptr is
      Pgr : Pgrecordset_Ptr;
   begin
      Pgr := new Pgrecordset;
      Pgr.Entorno := Sql_Null_Handle;
      Pgr.Conexion := Sql_Null_Handle;
      Pgr.Resultado := Sql_Null_Handle;

      Sqlallochandle (Sql_Handle_Env, Sql_Null_Handle, Pgr.Entorno);
      Sqlsetenvattr (Pgr.Entorno, Environment_Attribute_Odbc_Version'
         (Attribute => Sql_Attr_Odbc_Version,
            Value => Sql_Ov_Odbc3));

      Sqlallochandle (Sql_Handle_Dbc, Pgr.Entorno, Pgr.Conexion);
      Sqlconnect (Pgr.Conexion, Conninfo, username, passwd);

      return Pgr;
   exception
      when others =>
         Check_Errors (Pgr);
         return Pgr;
   end Recordset_New;

   procedure Recordset_Close (
         Recordset : in out Pgrecordset_Ptr ) is
   begin

      Sqldisconnect (Recordset.Conexion);
      --   Sqlfreehandle (Sql_Handle_Stmt, Recordset.Resultado);
      Sqlfreehandle (Sql_Handle_Dbc, Recordset.Conexion);
      Sqlfreehandle (Sql_Handle_Env, Recordset.Entorno);

--       for I in 1..Recordset.Ncampos loop
--          if Recordset.Campos(I) /= null then
--             Free (Recordset.Campos(I));
--          end if;
--       end loop;
      Free (Recordset.Campos);
      Unregisterall (Recordset.Lista_String);
      --      Recordset := null;
      Free (Recordset);
   end Recordset_Close;

   function Recordset_New return Pgrecordset_Ptr is
   begin
      if Std_Conx /= null then
--          if Std_Conx.Entorno = Sql_Null_Handle
--            or Std_Conx.Conexion = Sql_Null_Handle then
--             -- Reset
--             Recordset_Close;
--             Std_Conx := Recordset_New;
--          end if;
         return Std_Conx;
      else
         Recordset_Close;
         Std_Conx := new Pgrecordset;
         Std_Conx.Entorno := Sql_Null_Handle;
         Std_Conx.Conexion := Sql_Null_Handle;
         Std_Conx.Resultado := Sql_Null_Handle;

         Sqlallochandle (Sql_Handle_Env, Sql_Null_Handle, Std_Conx.
                         Entorno);
         Sqlsetenvattr (Std_Conx.Entorno,
            Environment_Attribute_Odbc_Version'
                        (Attribute => Sql_Attr_Odbc_Version,
                         Value => Sql_Ov_Odbc3));

         Sqlallochandle (Sql_Handle_Dbc, Std_Conx.Entorno, Std_Conx.
                         Conexion);
         Sqlconnect (Std_Conx.Conexion, Conninfo, username, passwd);
         return Std_Conx;
      end if;
   exception
      when others =>
         Check_Errors (Std_Conx);
         return Std_Conx;
   end Recordset_New;

   procedure Recordset_Close is
   begin
      if Std_Conx /= null then
         if Std_Conx.Resultado /= Sql_Null_Handle then
            Sqlcommit (Std_Conx.Conexion);
            Sqlfreehandle (Sql_Handle_Stmt, Std_Conx.Resultado);
         end if;

         for I in 1..Std_Conx.Ncampos loop
            Free (Std_Conx.Campos(I));
         end loop;
         Free (Std_Conx.Campos);
         Unregisterall (Std_Conx.Lista_String);
      end if;
      --free (std_conx);
   end Recordset_Close;

   function Actual (
         Recordset : Pgrecordset_Ptr )
     return Integer is
   begin
      return Recordset.Actual;
   end Actual;

   function Nrecords (
         Recordset : Pgrecordset_Ptr )
     return Integer is
   begin
      return Recordset.Nregistros;
   end Nrecords;

   function First_Record (
         Recordset : Pgrecordset_Ptr )
     return Integer is
   begin
      return 0;
   end First_Record;

   function Last_Record (
         Recordset : Pgrecordset_Ptr )
     return Integer is
   begin
      return Recordset.Nregistros -1;
   end Last_Record;

   function First_Field (
         Recordset : Pgrecordset_Ptr )
     return Integer is
   begin
      return 0;
   end First_Field;

   function Last_Field (
         Recordset : Pgrecordset_Ptr )
     return Integer is
   begin
      return Recordset.Ncampos -1;
   end Last_Field;

   procedure Movefirst (
         Recordset : Pgrecordset_Ptr ) is
   begin
      --   SQLFetchScroll (Recordset.resultado, SQL_FETCH_FIRST);
--      declare
      begin
         Sqlfetchscroll (Recordset.Resultado, Sql_Fetch_Absolute, 1);
      exception
         when others =>
            null; -- not supported??
      end;
      Datalistfix (Recordset.Lista_String);
   exception
      when Gnu.Db.Sqlcli.No_Data =>
         raise No_Data;
   end;

   procedure Movenext (
         Recordset : Pgrecordset_Ptr ) is
   begin
      begin
         Sqlfetchscroll (Recordset.Resultado, Sql_Fetch_Next);
      exception
         when Gnu.Db.Sqlcli.No_Data =>
            raise No_Data;
         when others =>
            null; -- not supported??
      end;

      -- String Data needs to be "readjusted"
      Datalistfix (Recordset.Lista_String);
   exception
      when Gnu.Db.Sqlcli.No_Data =>
         raise No_Data;
   end;


   function Error (
         Recordset : Pgrecordset_Ptr )
     return Boolean is
      -- Default is true if recordset is null!
   begin
      if Recordset /= null then
         return Recordset.Error;
      else
         return True;
         --Check_Errors(Recordset);
      end if;
   end Error;


   function Error_Msg (
         Recordset : Pgrecordset_Ptr )
     return String is
   begin
      if Recordset /= null then
         return Recordset.Error_Msg.all;
      else
         return "Recordset is null";
      end if;
   end;

   procedure Error_Msg (
         Recordset :        Pgrecordset_Ptr;
         Msg       :    out String           ) is
   begin
      --      Msg := To_String(Recordset.Error_Msg);
      --Msg := Recordset.Error_Msg.all;
      if Recordset /= null then
         Ada.Strings.Fixed.Move (Recordset.Error_Msg.all, Msg);
      else
         Ada.Strings.Fixed.Move ("Recordset is null", Msg);
      end if;
   end Error_Msg;

   function Getcolnums (
         Rs : Pgrecordset_Ptr )
     return Integer is
   begin
      return Integer(Sqlnumresultcols(Rs.Resultado));
   end Getcolnums;

   function Getcolname (
         Rs  : Pgrecordset_Ptr;
         Num : Integer          )
     return String is
   begin
      return Rs.Campos(Num).all;
   end Getcolname;

   -- Private getcolname
   function P_Getcolname (
         Rs  : Pgrecordset_Ptr;
         Num : Integer          )
     return String is
      Datatype :
      aliased Sql_Data_Type;
      Col_Size :
      aliased Sqluinteger;
      Decimaldigits :
      aliased Sqlsmallint;
      Nullable :
      aliased Sql_Nullable_Info;
      Errorcode :
      aliased Sqlreturn;
   begin
      return Sqldescribecol (Rs.Resultado, Sql_Column_Number(Num),
         Sqlsmallint(256),
         Datatype'access,
         Col_Size'access,
         Decimaldigits'access,
         Nullable'access,
         Errorcode'access);
   end P_Getcolname;

   -- function Name2col (
   --       Stmt   : Sqlhstmt;
   --       Column : Unbounded_String )
   --   return Sql_Column_Number is
   --    Name    : Unbounded_String;
   --    Ucolumn : Unbounded_String := Column;

   --    Datatype :
   --    aliased Sql_Data_Type;
   --    Col_Size :
   --    aliased Sqluinteger;
   --    Decimaldigits :
   --    aliased Sqlsmallint;
   --    Nullable :
   --    aliased Sql_Nullable_Info;
   --    Errorcode :
   --    aliased Sqlreturn;
   -- begin
   --    Trim (Ucolumn, Ada.Strings.Both);

   --    for I in 1..Sqlnumresultcols(Stmt) loop
   --       Name := To_Unbounded_String(
   --          Sqldescribecol (Stmt, Sql_Column_Number(I),
   --             Sqlsmallint(256),
   --             Datatype'access,
   --             Col_Size'access,
   --             Decimaldigits'access,
   --             Nullable'access,
   --             Errorcode'access));

   --       Trim (Name, Ada.Strings.Both);
   --       if Ucolumn = Name then
   --          return I;
   --       end if;
   --    end loop;
   --    return 0;
   -- end;



   procedure Query (
         Recordset : in out Pgrecordset_Ptr;
         Query     :        String           ) is
      --   List : Data_List_Ptr;
   begin
      Sqlallochandle (Sql_Handle_Stmt, Recordset.Conexion, Recordset.
         Resultado);

--      declare
--      begin
--         Sqlsetstmtattr (Recordset.Resultado, Statement_Attribute_Cscr'
--            (Attribute => Sql_Attr_Cursor_Scrollable,
--               Value => Sql_Scrollable));
--      exception
--         --      when others => Text_Io.Put_Line ("No soportado por el driver ODBC");
--         when others =>
--            null; -- Not supported by ODBC driver
--      end;
      Sqlprepare (Recordset.Resultado, Query);

      Binddatalist (Recordset.Lista_String, Recordset.Resultado);

      Sqlexecute (Recordset.Resultado);
      --   SqlExecDirect (Recordset.Resultado, Query);

      Recordset.Ncampos := Integer(Sqlnumresultcols(Recordset.Resultado));
      Recordset.Campos := new Fields_List(1..Recordset.Ncampos);
      for I in 1..Recordset.Ncampos loop
         Recordset.Campos(I) := new String'(P_Getcolname(Recordset,I));
      end loop;


      Sqlfetch (Recordset.Resultado);
      --MoveFirst (Recordset);

      -- Not actally valid due to ODBC
      --Recordset.Nregistros := Integer(Sqlrowcount(Recordset.Resultado));

   exception
      when Gnu.Db.Sqlcli.No_Data =>
         raise No_Data;
      when Not_Implemented =>
         Ada.Exceptions.Raise_Exception (Database_Error'Identity,
            "El driver no implementa la funcion");
         --      when others => text_io.put_line ("Exception no procesada");
         when others => check_errors(recordset);
   end Query;

   procedure Exec (
         Recordset : in out Pgrecordset_Ptr;
         Cmd       :        String           ) is
   begin
      Sqlallochandle (Sql_Handle_Stmt, Recordset.Conexion, Recordset.
         Resultado);

      Sqlprepare (Recordset.Resultado, Cmd);
      Sqlexecute (Recordset.Resultado);

      Recordset.Ncampos := Integer(Sqlnumresultcols (Recordset.Resultado));
      -- Not actally valid due to ODBC
      --Recordset.Nregistros := Integer(Sqlrowcount(Recordset.Resultado));
   exception
      when Gnu.Db.Sqlcli.No_Data =>
         raise No_Data;
      when Not_Implemented =>
         Ada.Exceptions.Raise_Exception (Database_Error'Identity,
            "El driver no implementa la funcion");
      when others =>
         check_errors(recordset);
   end Exec;

   procedure Set_Table (
         Recordset : Pgrecordset_Ptr;
         Table     : String           ) is
   begin
      null;
   end Set_Table;

   procedure Connect_Table is
   begin
      null;
   end Connect_Table;

   function Getdata (
         Rs     : Pgrecordset_Ptr;
         Column : String           )
     return String is
      -- Limited to 256!!!!!!!!
      Text : String (1 .. 256);
      Len  :
      aliased Sqlinteger;
   begin
      for I in 1 .. Rs.Ncampos loop
         Sqlgetdata (Rs.Resultado, Name2col (Rs.Resultado,
               To_Unbounded_String(Column)),
            Sql_C_Char, To_Sqlpointer(Text), Text'Length, Len'access);
      end loop;
      Sqlfixnts(Text, Len);
      return Text;
   end Getdata;

   procedure Check_Errors (
         Conx : in out Pgrecordset_Ptr ) is
      State :
      aliased Sqlstate;
      Native_Error :
      aliased Sqlinteger;
      Msg : String_Access;
   begin
      if Conx = null then
         Msg := new String'("No Pgrecordset created");
         Conx := new Pgrecordset;
      else
         if Conx.Resultado /= Sql_Null_Handle then
            Msg := new String'(Sqlgetdiagrec (Handletype => Sql_Handle_Stmt,
                                              Handle => Conx.Resultado,
                                              State => State'access,
                                              Nativeerror => Native_Error'access));
         elsif Conx.Conexion /= Sql_Null_Handle then
            Msg := new String'(Sqlgetdiagrec (Handletype => Sql_Handle_Dbc,
                                              Handle => Conx.Conexion,
                                              State => State'access,
                                              Nativeerror => Native_Error'access));
         elsif Conx.Entorno /= Sql_Null_Handle then
            Msg := new String'(Sqlgetdiagrec (Handletype => Sql_Handle_Env,
                                              Handle => Conx.Entorno,
                                              State => State'access,
                                              Nativeerror => Native_Error'access));
         else
            Msg := new String'("No environment nor connection created");
         end if;
      end if;

      --       Text_Io.Put_Line ("state: "&State);
      --       Text_Io.Put_Line ("error: "&Sqlinteger'Image(Native_Error));

      if Msg.all /= "" then
         Conx.Error := True;
         Conx.Error_Msg := Msg;
         Ada.Exceptions.Raise_Exception(Database_Error'Identity, Msg.all);
      else
         Conx.Error := False;
         Conx.Error_Msg := Msg;
      end if;

   end Check_Errors;

end Pgrecordset;
