/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIOUT.C  -  MIDI OUT functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modifies by Josep Andreu

*/

#include "GMorgan.h"
#include <FL/fl_message.H>
#include <iostream>
using namespace std;

void
GMO::enviomidi (int i, int fchout)
{
//  cout << "enviomidi: i " << i << " fchout: " << fchout << endl; 
  snd_seq_event_t midievent;
  snd_seq_ev_clear (&midievent);


  enviocontrol (i, 0, fchout);
  enviocontrol (i, 32, fchout);

  if (grabacion) PonGraba(4,tick,0,fchout,0,0,0,0,progch[i]);


  snd_seq_ev_set_pgmchange (&midievent, fchout, progch[i]);

  snd_seq_ev_set_subs (&midievent);
  snd_seq_ev_set_direct (&midievent);

  snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, &midievent);
    
};


int
GMO::calculaval(int valctrl, int min,int max)
{
cout << "calculaval: " << valctrl << " min: " << min << " max: " << max << endl;
int valtemp;

valtemp = int( (valctrl*(max-min))/999);

DataMSB = (int) valtemp / 128;
DataLSB = (int) valtemp % 128;

return (valtemp);

};

void
GMO::enviocontrol (int i, int j, int fchout)
{
  int jj;
  snd_seq_event_t midievent;
  snd_seq_ev_clear (&midievent);
  jj = j;
// *rlv  noticable delay in higher numbered calls, so commented out. 
  if (j > 199)
	{
//	cout << "enviocontrol " << j << " i: " << i << " fchout: " << fchout << endl;
	return;
	}
  switch (j)
    {
    case 0:
      qcontrol = BankMSB[i];
      break;
    case 5:
      qcontrol = Ptime[i];
      break;
    case 6:
      qcontrol =DataMSB;
      break;

    case 7:
      if (MasterON) 
      {
       qcontrol = (int) (volume[i] * MasterVolume);
       if ( qcontrol > 127) qcontrol = 127;
      }
      else qcontrol = volume[i];
      break;
    case 10:
      qcontrol = pan[i];
      break;
    case 32:
      qcontrol = BankLSB[i] -1;
      break;
    case 37:
      qcontrol = Ptime[i];
      break;
    case 38:
      qcontrol = DataLSB;
      break;
    case 42:
      qcontrol = pan[i];
      break;
    case 65:
      qcontrol = Pon[i];
      break;
    case 91:
      qcontrol = reverb[i];
      break;
    case 93:
      qcontrol = chorus[i];
      break;
    case 98:
      qcontrol = cttemp;
      break;
    case 99:
      qcontrol = 127;
      break;
    case 100:
      qcontrol = 1;
      break;
    case 101:
      qcontrol = 0;
      break;
    case 121:
      qcontrol = 0;
      break;
    case 123:
      qcontrol = 0;
      break;
    case 201:
      qcontrol = calculaval(valorctrl,0,127);
      jj = 10;
      break;
    case 202:
      qcontrol = calculaval(valorctrl,0,127);
      jj = 7;
      break;
    case 203:
      qcontrol = calculaval(valorctrl,0,127);
      jj = 91;
      break;
    case 204:
      qcontrol = calculaval(valorctrl,0,127);
      jj = 93;
      break;
    case 205:    
      enviocontrol(1,101,fchout);
      enviocontrol(1,100,fchout);
      qcontrol = calculaval(valorctrl,-8192,8191);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
     case 206:
      qcontrol = calculaval(valorctrl,0,127);
      jj = 5;
      break;
     case 207:
      enviocontrol(1,99,fchout);
      cttemp = 22;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout); 
      enviocontrol(1,38,fchout);
      break;
      case 208:
      enviocontrol(1,99,fchout);
      cttemp = 0;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5900);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 209:
      enviocontrol(1,99,fchout);
      cttemp = 1;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 210:
      enviocontrol(1,99,fchout);
      cttemp = 2;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5900);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 211:
      enviocontrol(1,99,fchout);
      cttemp = 3;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 212:
      enviocontrol(1,99,fchout);
      cttemp = 4;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5900);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 213:
      enviocontrol(1,99,fchout);
      cttemp = 5;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5940);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 214:
      enviocontrol(1,99,fchout);
      cttemp = 6;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,8191);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 215:
      enviocontrol(1,99,fchout);
      cttemp = 7;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5940);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 216:
      enviocontrol(1,99,fchout);
      cttemp = 8;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 217:
      enviocontrol(1,99,fchout);
      cttemp = 9;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5940);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 218:
      enviocontrol(1,99,fchout);
      cttemp = 10;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5900);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 219:
      enviocontrol(1,99,fchout);
      cttemp = 11;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5940);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 220:
      enviocontrol(1,99,fchout);
      cttemp = 12;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,8191);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 221:
      enviocontrol(1,99,fchout);
      cttemp = 13;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5940);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 222:
      enviocontrol(1,99,fchout);
      cttemp = 14;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 223:
      enviocontrol(1,99,fchout);
      cttemp = 15;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,5940);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 224:
      enviocontrol(1,99,fchout);
      cttemp = 17;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,-127,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 225:
      enviocontrol(1,99,fchout);
      cttemp = 18;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,-127,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 226:
      enviocontrol(1,99,fchout);
      cttemp = 19;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,-127,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 227:
      enviocontrol(1,99,fchout);
      cttemp = 20;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 228:
      enviocontrol(1,99,fchout);
      cttemp = 21;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,0,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 229:
      enviocontrol(1,99,fchout);
      cttemp = 23;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,-64,63);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 230:
      enviocontrol(1,99,fchout);
      cttemp = 24;
      enviocontrol(1,98,fchout);
      qcontrol = calculaval(valorctrl,-127,127);
      enviocontrol(1,6,fchout);
      enviocontrol(1,38,fchout);
      break;
      case 231:
      qcontrol = calculaval(valorctrl,0,255);
      jj = 1;
      break;


      }
       
//   cout << " enviocontrol change fchout: " << fchout << " qcontrol " << qcontrol << endl;
   if ((grabacion) && (jj < 200))  PonGraba(3,tick,0,fchout,0,0,jj,qcontrol,0);


  snd_seq_ev_set_controller (&midievent, fchout, jj, qcontrol);

  snd_seq_ev_set_subs (&midievent);
  snd_seq_ev_set_direct (&midievent);
  snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, &midievent);
  

};


void 
GMO::sacaev(int canal,int nota, int velocity, int length )
{
     int cupi = sposi + 1;
     snd_seq_event_t ev;
     snd_seq_tick_time_t ttick;          
     snd_seq_ev_clear(&ev);
     ttick = atick;
     length += tick - ttick;
     snd_seq_ev_set_note(&ev, canal, nota, velocity, length);
     ttick +=  (cupi % 4 == 0 ) ? Rt[sp].swing : 0;

     snd_seq_ev_schedule_tick(&ev, queue_id,  0, ttick);
     if (grabacion) PonGraba(1,ttick,nota,canal,velocity,length,0,0,0);
     
     snd_seq_ev_set_source(&ev, pmidi_in); 
//   snd_seq_ev_set_dest(&ev,snd_seq_client_id(MidiOutPuerto[1].midi_out),pmidi_out);
     snd_seq_ev_set_subs (&ev);
     snd_seq_event_output_direct(MidiOutPuerto[1].midi_out, &ev);
     

};


void 
GMO::suenaev(int canal,int nota, int velocity )
{

     snd_seq_event_t ev;
          
     snd_seq_ev_clear(&ev);
     snd_seq_ev_set_noteon(&ev,canal,nota,velocity);
     if (grabacion) PonGraba(2,tick,nota,canal,velocity,0,0,0,0);
     snd_seq_ev_set_source(&ev, pmidi_in);
//     snd_seq_ev_set_dest(&ev,snd_seq_client_id(MidiOutPuerto[1].midi_out),pmidi_out);
     snd_seq_ev_set_subs (&ev);
     snd_seq_ev_set_direct (&ev);
     snd_seq_event_output_direct(MidiOutPuerto[1].midi_out, &ev);
};



void 
GMO::set_tempo() {

  snd_seq_queue_tempo_t *queue_tempo;

  snd_seq_queue_tempo_malloc(&queue_tempo);
  tempo = (int)(6e7 / ((double)bpm * (double)TICKS_PER_QUARTER) * (double)TICKS_PER_QUARTER);
  snd_seq_queue_tempo_set_tempo(queue_tempo, tempo);
  snd_seq_queue_tempo_set_ppq(queue_tempo, TICKS_PER_QUARTER);
  snd_seq_set_queue_tempo(MidiOutPuerto[1].midi_out, queue_id, queue_tempo);
  snd_seq_queue_tempo_free(queue_tempo);
}

snd_seq_tick_time_t 
GMO::get_tick() {

  snd_seq_queue_status_t *status;
  snd_seq_tick_time_t current_tick;
  
  snd_seq_queue_status_malloc(&status);
  snd_seq_get_queue_status(MidiOutPuerto[1].midi_out, queue_id, status);
  current_tick = snd_seq_queue_status_get_tick_time(status);
  snd_seq_queue_status_free(status);
  return(current_tick);
}

void 
GMO::init_queue() {

 queue_id = snd_seq_alloc_queue(MidiOutPuerto[1].midi_out);
 snd_seq_set_client_pool_output(MidiOutPuerto[1].midi_out, 2048);
}

void 
GMO::clear_queue() {

  snd_seq_remove_events_t *remove_ev;


  snd_seq_remove_events_malloc(&remove_ev);
  snd_seq_remove_events_set_queue(remove_ev, queue_id);
  snd_seq_remove_events_set_condition(remove_ev, SND_SEQ_REMOVE_OUTPUT | SND_SEQ_REMOVE_IGNORE_OFF);
  snd_seq_remove_events(MidiOutPuerto[1].midi_out, remove_ev);
  snd_seq_remove_events_free(remove_ev);

}
