/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.jni;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.misc.Info;

public class JNIEllipsoidLibrary {
    private long ellipsoidLibraryPtr;

    private native void jniDefineEllipsoid(long var1, String var3, String var4, double var5, double var7) throws CoordinateConversionException;

    private native void jniRemoveEllipsoid(long var1, String var3) throws CoordinateConversionException;

    private native long jniGetEllipsoidCount(long var1) throws CoordinateConversionException;

    private native long jniGetEllipsoidIndex(long var1, String var3) throws CoordinateConversionException;

    private native Info jniGetEllipsoidInfo(long var1, long var3);

    public JNIEllipsoidLibrary(long l) {
        this.ellipsoidLibraryPtr = l;
    }

    public synchronized void defineEllipsoid(String string, String string2, double d, double d2) throws CoordinateConversionException {
        if (this.ellipsoidLibraryPtr == 0L) {
            throw new CoordinateConversionException("defineEllipsoid called with null object");
        }
        this.jniDefineEllipsoid(this.ellipsoidLibraryPtr, string, string2, d, d2);
    }

    public synchronized void removeEllipsoid(String string) throws CoordinateConversionException {
        if (this.ellipsoidLibraryPtr == 0L) {
            throw new CoordinateConversionException("removeEllipsoid called with null object");
        }
        this.jniRemoveEllipsoid(this.ellipsoidLibraryPtr, string);
    }

    public synchronized long getEllipsoidCount() throws CoordinateConversionException {
        if (this.ellipsoidLibraryPtr == 0L) {
            throw new CoordinateConversionException("getEllipsoidCount called with null object");
        }
        return this.jniGetEllipsoidCount(this.ellipsoidLibraryPtr);
    }

    public synchronized long getEllipsoidIndex(String string) throws CoordinateConversionException {
        if (this.ellipsoidLibraryPtr == 0L) {
            throw new CoordinateConversionException("getEllipsoidIndex called with null object");
        }
        return this.jniGetEllipsoidIndex(this.ellipsoidLibraryPtr, string);
    }

    public synchronized Info getEllipsoidInfo(long l) throws CoordinateConversionException {
        if (this.ellipsoidLibraryPtr == 0L) {
            throw new CoordinateConversionException("getEllipsoidInfo called with null object");
        }
        return this.jniGetEllipsoidInfo(this.ellipsoidLibraryPtr, l);
    }
}

