static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 1995 Spencer Kimball and Peter Mattis                        \n"
" *                                                                            \n"
" * This is a plug-in for GIMP.                                                \n"
" *                                                                            \n"
" * Colormap-Rotation plug-in. Exchanges two color ranges.                     \n"
" *                                                                            \n"
" * Copyright (C) 1999 Sven Anders (anderss@fmi.uni-passau.de)                 \n"
" *                    Based on code from Pavel Grinfeld (pavel@ml.com)        \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" * Copyright (C) 2011 Mukund Sivaraman <muks@banu.com>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_color_rotate_gray_mode)                                      \n"
"  enum_value (GEGL_COLOR_ROTATE_GRAY_TREAT_AS,  \"treat-as\",                 \n"
"              N_(\"Treat as this\"))                                          \n"
"  enum_value (GEGL_COLOR_ROTATE_GRAY_CHANGE_TO, \"change-to\",                \n"
"              N_(\"Change to this\"))                                         \n"
"enum_end (GeglColorRotateGrayMode)                                            \n"
"                                                                              \n"
"property_boolean (src_clockwise, _(\"Clockwise\"), FALSE)                     \n"
"    description (_(\"Switch to clockwise\"))                                  \n"
"                                                                              \n"
"property_double (src_from, _(\"From\"), 0.0)                                  \n"
"    description (_(\"Start angle of the source color range\"))                \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (src_to, _(\"To\"), 90.0)                                     \n"
"    description (_(\"End angle of the source color range\"))                  \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_boolean (dest_clockwise, _(\"Clockwise\"), FALSE)                    \n"
"    description (_(\"Switch to clockwise\"))                                  \n"
"                                                                              \n"
"property_double (dest_from, _(\"From\"), 0.0)                                 \n"
"    description (_(\"Start angle of the destination color range\"))           \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (dest_to, _(\"To\"), 90.0)                                    \n"
"    description (_(\"End angle of the destination color range\"))             \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (threshold, _(\"Gray threshold\"), 0.0)                       \n"
"    description (_(\"Colors with a saturation less than this will treated \"  \n"
"                   \"as gray\"))                                              \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_enum   (gray_mode, _(\"Gray mode\"),                                 \n"
"    GeglColorRotateGrayMode, gegl_color_rotate_gray_mode,                     \n"
"    GEGL_COLOR_ROTATE_GRAY_CHANGE_TO)                                         \n"
"    description (_(\"Treat as this: Gray colors from above source range \"    \n"
"                   \"will be treated as if they had this hue and saturation\\n\"\n"
"                   \"Change to this: Change gray colors to this \"            \n"
"                   \"hue and saturation\"))                                   \n"
"                                                                              \n"
"property_double (hue, _(\"Hue\"), 0.0)                                        \n"
"    description (_(\"Hue value for above gray settings\"))                    \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (saturation, _(\"Saturation\"), 0.0)                          \n"
"    description (_(\"Saturation value for above gray settings\"))             \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE color-rotate.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define TWO_PI        (2 * G_PI)                                              \n"
"#define DEG_TO_RAD(d) (((d) * G_PI) / 180.0)                                  \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  /* gamma-corrected RGB because that's what the HSV conversion               \n"
"   * functions expect                                                         \n"
"   */                                                                         \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"rgb_to_hsv (gfloat  r,                                                        \n"
"            gfloat  g,                                                        \n"
"            gfloat  b,                                                        \n"
"            gfloat *h,                                                        \n"
"            gfloat *s,                                                        \n"
"            gfloat *v)                                                        \n"
"{                                                                             \n"
"  float min;                                                                  \n"
"  float delta;                                                                \n"
"                                                                              \n"
"  *v = MAX (MAX (r, g), b);                                                   \n"
"  min = MIN (MIN (r, g), b);                                                  \n"
"  delta = *v - min;                                                           \n"
"                                                                              \n"
"  if (delta == 0.0f)                                                          \n"
"    {                                                                         \n"
"      *h = 0.0f;                                                              \n"
"      *s = 0.0f;                                                              \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      *s = delta / *v;                                                        \n"
"                                                                              \n"
"      if (r == *v)                                                            \n"
"        {                                                                     \n"
"          *h = (g - b) / delta;                                               \n"
"          if (*h < 0.0f)                                                      \n"
"            *h += 6.0f;                                                       \n"
"        }                                                                     \n"
"      else if (g == *v)                                                       \n"
"        {                                                                     \n"
"          *h = 2.0f + (b - r) / delta;                                        \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          *h = 4.0f + (r - g) / delta;                                        \n"
"        }                                                                     \n"
"                                                                              \n"
"      *h /= 6.0f;                                                             \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"hsv_to_rgb (gfloat  h,                                                        \n"
"            gfloat  s,                                                        \n"
"            gfloat  v,                                                        \n"
"            gfloat *r,                                                        \n"
"            gfloat *g,                                                        \n"
"            gfloat *b)                                                        \n"
"{                                                                             \n"
"  if (s == 0.0)                                                               \n"
"    {                                                                         \n"
"      *r = v;                                                                 \n"
"      *g = v;                                                                 \n"
"      *b = v;                                                                 \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      int hi;                                                                 \n"
"      float frac;                                                             \n"
"      float w, q, t;                                                          \n"
"                                                                              \n"
"      h *= 6.0;                                                               \n"
"                                                                              \n"
"      if (h >= 6.0)                                                           \n"
"        h -= 6.0;                                                             \n"
"                                                                              \n"
"      hi = (int) h;                                                           \n"
"      frac = h - hi;                                                          \n"
"      w = v * (1.0 - s);                                                      \n"
"      q = v * (1.0 - (s * frac));                                             \n"
"      t = v * (1.0 - (s * (1.0 - frac)));                                     \n"
"                                                                              \n"
"      switch (hi)                                                             \n"
"        {                                                                     \n"
"        case 0:                                                               \n"
"          *r = v;                                                             \n"
"          *g = t;                                                             \n"
"          *b = w;                                                             \n"
"          break;                                                              \n"
"        case 1:                                                               \n"
"          *r = q;                                                             \n"
"          *g = v;                                                             \n"
"          *b = w;                                                             \n"
"          break;                                                              \n"
"        case 2:                                                               \n"
"          *r = w;                                                             \n"
"          *g = v;                                                             \n"
"          *b = t;                                                             \n"
"          break;                                                              \n"
"        case 3:                                                               \n"
"          *r = w;                                                             \n"
"          *g = q;                                                             \n"
"          *b = v;                                                             \n"
"          break;                                                              \n"
"        case 4:                                                               \n"
"          *r = t;                                                             \n"
"          *g = w;                                                             \n"
"          *b = v;                                                             \n"
"          break;                                                              \n"
"        case 5:                                                               \n"
"          *r = v;                                                             \n"
"          *g = w;                                                             \n"
"          *b = q;                                                             \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"angle_mod_2PI (gfloat angle)                                                  \n"
"{                                                                             \n"
"  if (angle < 0)                                                              \n"
"    return angle + TWO_PI;                                                    \n"
"  else if (angle > TWO_PI)                                                    \n"
"    return angle - TWO_PI;                                                    \n"
"  else                                                                        \n"
"    return angle;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"angle_inside_slice (gfloat   hue,                                             \n"
"                    gfloat   from,                                            \n"
"                    gfloat   to,                                              \n"
"                    gboolean cl)                                              \n"
"{                                                                             \n"
"  gint cw_ccw = cl ? -1 : 1;                                                  \n"
"                                                                              \n"
"  return angle_mod_2PI (cw_ccw * DEG_TO_RAD (to - hue)) /                     \n"
"         angle_mod_2PI (cw_ccw * DEG_TO_RAD (from - to));                     \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"is_gray (gfloat  s,                                                           \n"
"         gdouble threshold)                                                   \n"
"{                                                                             \n"
"  return (s <= threshold);                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"linear (gfloat A,                                                             \n"
"        gfloat B,                                                             \n"
"        gfloat C,                                                             \n"
"        gfloat D,                                                             \n"
"        gfloat x)                                                             \n"
"{                                                                             \n"
"  if (B > A)                                                                  \n"
"    {                                                                         \n"
"      if (A <= x && x <= B)                                                   \n"
"        return C + (D - C) / (B - A) * (x - A);                               \n"
"      else if (A <= x + TWO_PI && x + TWO_PI <= B)                            \n"
"        return C + (D - C) / (B - A) * (x + TWO_PI - A);                      \n"
"      else                                                                    \n"
"        return x;                                                             \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      if (B <= x && x <= A)                                                   \n"
"        return C + (D - C) / (B - A) * (x - A);                               \n"
"      else if (B <= x + TWO_PI && x + TWO_PI <= A)                            \n"
"        return C + (D - C) / (B - A) * (x + TWO_PI - A);                      \n"
"      else                                                                    \n"
"        return x;                                                             \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"left_end (gfloat   from,                                                      \n"
"          gfloat   to,                                                        \n"
"          gboolean cl)                                                        \n"
"{                                                                             \n"
"  gfloat alpha  = DEG_TO_RAD (from);                                          \n"
"  gfloat beta   = DEG_TO_RAD (to);                                            \n"
"  gint   cw_ccw = cl ? -1 : 1;                                                \n"
"                                                                              \n"
"  switch (cw_ccw)                                                             \n"
"    {                                                                         \n"
"    case -1:                                                                  \n"
"      if (alpha < beta)                                                       \n"
"        return alpha + TWO_PI;                                                \n"
"                                                                              \n"
"    default:                                                                  \n"
"      return alpha; /* 1 */                                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"right_end (gfloat   from,                                                     \n"
"           gfloat   to,                                                       \n"
"           gboolean cl)                                                       \n"
"{                                                                             \n"
"  gfloat alpha  = DEG_TO_RAD (from);                                          \n"
"  gfloat beta   = DEG_TO_RAD (to);                                            \n"
"  gint   cw_ccw = cl ? -1 : 1;                                                \n"
"                                                                              \n"
"  switch (cw_ccw)                                                             \n"
"    {                                                                         \n"
"    case 1:                                                                   \n"
"      if (beta < alpha)                                                       \n"
"        return beta + TWO_PI;                                                 \n"
"                                                                              \n"
"    default:                                                                  \n"
"      return beta; /* -1 */                                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"color_rotate (GeglProperties *o,                                              \n"
"              gfloat         *input,                                          \n"
"              gfloat         *output)                                         \n"
"{                                                                             \n"
"  gfloat   h, s, v;                                                           \n"
"  gboolean skip = FALSE;                                                      \n"
"                                                                              \n"
"  rgb_to_hsv (input[0], input[1], input[2],                                   \n"
"              &h, &s, &v);                                                    \n"
"                                                                              \n"
"  if (is_gray (s, o->threshold))                                              \n"
"    {                                                                         \n"
"      if (o->gray_mode == GEGL_COLOR_ROTATE_GRAY_TREAT_AS)                    \n"
"        {                                                                     \n"
"          if (angle_inside_slice (o->hue, o->src_from, o->src_to,             \n"
"                                  o->src_clockwise) <= 1)                     \n"
"            {                                                                 \n"
"              h = DEG_TO_RAD (o->hue) / TWO_PI;                               \n"
"              s = o->saturation;                                              \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              skip = TRUE;                                                    \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          skip = TRUE;                                                        \n"
"                                                                              \n"
"          h = DEG_TO_RAD (o->hue) / TWO_PI;                                   \n"
"          s = o->saturation;                                                  \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (! skip)                                                                 \n"
"    {                                                                         \n"
"      h = linear (left_end (o->src_from, o->src_to, o->src_clockwise),        \n"
"                  right_end (o->src_from, o->src_to, o->src_clockwise),       \n"
"                  left_end (o->dest_from, o->dest_to, o->dest_clockwise),     \n"
"                  right_end (o->dest_from, o->dest_to, o->dest_clockwise),    \n"
"                  h * TWO_PI);                                                \n"
"                                                                              \n"
"      h = angle_mod_2PI (h) / TWO_PI;                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  hsv_to_rgb (h, s, v,                                                        \n"
"              output, output + 1, output + 2);                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  gfloat         *input  = in_buf;                                            \n"
"  gfloat         *output = out_buf;                                           \n"
"                                                                              \n"
"  while (samples--)                                                           \n"
"    {                                                                         \n"
"      color_rotate (o, input, output);                                        \n"
"                                                                              \n"
"      output[3] = input[3];                                                   \n"
"                                                                              \n"
"      input  += 4;                                                            \n"
"      output += 4;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *filter_class;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_POINT_FILTER_CLASS (klass);                \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"categories\",   \"color\",                                              \n"
"    \"name\",         \"gegl:color-rotate\",                                  \n"
"    \"description\",  _(\"Replace a range of colors with another\"),          \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
