/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#define _C_RENDER_
#include <render.h>

int render_init()
{
  /* Don't care about initial size, 
     render_change_resolution() will be called soon. 
  */
  
  if ( ! plugin_render.name )
    {
      plugin_render.name = (char *) calloc( strlen( DEF_RPLUGIN )+1, sizeof( char ) );
      strcpy( plugin_render.name, DEF_RPLUGIN );
      mpav_debug( "INFO: no render plugin specified. Using: %s\n", plugin_render.name );
    }

  if ( ( plugin_render.p = dlopen( plugin_render.name, RTLD_LAZY ) ) == NULL )
    {
      mpav_fmsg( stderr, "ERROR: Could not load plugin \"%s\": %s\n", 
		 plugin_render.name, dlerror() );
      return( -2 );
    }

  if ( ( plugin_render.init = dlsym( plugin_render.p, "mpav_render_init" ) ) == NULL )
    {
      mpav_fmsg( stderr, "ERROR: Plugin \"%s\" (%p) doesn't provide \"mpav_render_init\": %s\n",
		 plugin_render.name, plugin_render.p, dlerror() );
      return( -3 );
    }

  if ( ( plugin_render.quit = dlsym( plugin_render.p, "mpav_render_quit" ) ) == NULL )
    {
      mpav_fmsg( stderr, "ERROR: Plugin \"%s\" (%p) doesn't provide \"mpav_render_quit\": %s\n",
		 plugin_render.name, plugin_render.p, dlerror() );
      return( -3 );
    }

  if ( ( plugin_render.set_resolution = dlsym( plugin_render.p, "mpav_render_set_resolution" ) ) == NULL )
    {
      mpav_fmsg( stderr, "ERROR: Plugin \"%s\" (%p) doesn't provide \"mpav_render_set_resolution\": %s\n",
		 plugin_render.name, plugin_render.p, dlerror() );
      return( -3 );
    }

  if ( ( plugin_render.render = dlsym( plugin_render.p, "mpav_render_render" ) ) == NULL )
    {
      mpav_fmsg( stderr, "ERROR: Plugin \"%s\" (%p) doesn't provide \"mpav_render_render\": %s\n",
		 plugin_render.name, plugin_render.p, dlerror() );
      return( -3 );
    }

  return( plugin_render.init( 1, 1 ) );
}

void render_quit()
{
  plugin_render.quit();

  dlclose( plugin_render.p );
}

int render_change_resolution()
{
  __width  = screen->w;
  __height = screen->h;

  return plugin_render.set_resolution( __width, __height );
}

inline int render_func()
{
  static long long int counter = 0;
  static int16_t   data[ 2 ][ 512 ];
  static uint32_t  *render_data = NULL;

  if ( data_counter <= counter )
    {
      mpav_debug( "repeated data (%lld), not re-rendering.\n", data_counter );
      if ( data_counter == 0 )
	counter = 0;
      return( 0 );
    }

  /* use data from importer */
  if ( SDL_mutexP( data_mutex ) )
    { the_end = 1; return( 0 ); }
  memcpy( data, sound_data, 2048 );
  SDL_mutexV( data_mutex );
  
  /* Render data */
  render_data = (uint32_t *) plugin_render.render( data );
  
  /* Update screen */
  if ( ( __width == screen->w ) && ( __height == screen->h ) )
    {
      SDL_LockSurface( screen );
      memcpy( screen->pixels, render_data, __width * __height * sizeof( uint32_t ) );
      SDL_UnlockSurface( screen );
    }

  counter = data_counter;
  return( 1 );
}

