import { Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
import * as GeneralGlyph from "../general-glyph/index";
export declare class BoundingBox {
    xMin: number;
    xMax: number;
    yMin: number;
    yMax: number;
    constructor(xMin: number, xMax: number, yMin: number, yMax: number);
    static Blank(): BoundingBox;
}
export declare class BoundingBoxBuilder {
    private box;
    addPoint(x: number, y: number): void;
    addBox(box: null | BoundingBox): void;
    getResultOpt(): BoundingBox | null;
    getResult(): BoundingBox;
}
export declare function evalBezier(x0: number, x1: number, x2: number, x3: number, t: number): number;
export declare function bezierCurveBoundingBox(x0: number, y0: number, x1: number, y1: number, x2: number, y2: number, x3: number, y3: number): BoundingBox | null;
export interface SimpleGlyphStat {
    eigenContours: number;
    eigenPoints: number;
    extent: BoundingBox;
    depth: number;
}
export interface ComplexGlyphStat extends SimpleGlyphStat {
    eigenReferences: number;
    totalContours: number;
    totalPoints: number;
}
export interface Sink {
    setNumGlyphs(count: number): void;
    setMetric(gid: number, horizontal: GeneralGlyph.Metric.T<OtVar.Value>, vertical: GeneralGlyph.Metric.T<OtVar.Value>, extent: BoundingBox): void;
    simpleGlyphStat(stat: SimpleGlyphStat): void;
    complexGlyphStat(stat: ComplexGlyphStat): void;
    instructionsStat(size: number): void;
    settle(): void;
}
export declare class Forward implements Sink {
    private readonly outer?;
    constructor(outer?: Data.Maybe<Sink>);
    setMetric(gid: number, horizontal: GeneralGlyph.Metric.T<OtVar.Value>, vertical: GeneralGlyph.Metric.T<OtVar.Value>, extent: BoundingBox): void;
    setNumGlyphs(count: number): void;
    simpleGlyphStat(st: SimpleGlyphStat): void;
    complexGlyphStat(st: ComplexGlyphStat): void;
    instructionsStat(size: number): void;
    settle(): void;
}
//# sourceMappingURL=stat.d.ts.map