"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.alignBufferSize = alignBufferSize;
const buffer_writer_1 = require("../handlers/buffer-writer");
function alignBufferSize(buf, packing) {
    if (packing <= 1)
        return buf;
    const bw = new buffer_writer_1.BufferWriter();
    bw.bytes(buf);
    while (bw.length % packing)
        bw.uint8(0);
    return bw.toBuffer();
}
//# sourceMappingURL=align.js.map