/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.cataloggen.config.DatasetSource;

public class CatalogGenConfig {
    private static Logger log = LoggerFactory.getLogger(CatalogGenConfig.class);
    private InvDataset parentDataset = null;
    private Type type = null;
    private DatasetSource datasetSource = null;
    private boolean isValid = true;
    private StringBuffer msgLog = new StringBuffer();
    public static final String CATALOG_GEN_CONFIG_NAMESPACE_URI_0_5 = "http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5";

    public CatalogGenConfig(InvDataset parentDataset, String typeName) {
        this(parentDataset, Type.getType(typeName));
    }

    public CatalogGenConfig(InvDataset parentDataset, Type type) {
        log.debug("CatalogGenConfig(): type " + type.toString() + ".");
        this.parentDataset = parentDataset;
        this.type = type;
    }

    public InvDataset getParentDataset() {
        return this.parentDataset;
    }

    public void setParentDataset(InvDataset parentDataset) {
        this.parentDataset = parentDataset;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public DatasetSource getDatasetSource() {
        return this.datasetSource;
    }

    public void setDatasetSource(DatasetSource dsSource) {
        this.datasetSource = dsSource;
    }

    public boolean validate(StringBuilder out) {
        log.debug("validate(): checking if valid");
        this.isValid = true;
        if (this.msgLog.length() > 0) {
            out.append(this.msgLog);
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** CatalogGenConfig (3): null value for type is not valid (set with bad string?).");
        }
        this.isValid &= this.getDatasetSource().validate(out);
        log.debug("validate(): isValid=" + this.isValid + " message is\n" + out.toString());
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("CatalogGenConfig[type:<").append(this.getType()).append("> child ").append(this.getDatasetSource().toString() + ")]");
        return tmp.toString();
    }

    public static class Type {
        private static HashMap hash = new HashMap(20);
        public static final Type CATALOG = new Type("Catalog");
        public static final Type AGGREGATION = new Type("Aggregation");
        private String type;

        private Type(String name) {
            this.type = name;
            hash.put(name, this);
        }

        public static Type getType(String name) {
            if (name == null) {
                return null;
            }
            return (Type)hash.get(name);
        }

        public String toString() {
            return this.type;
        }
    }
}

