/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.ui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import thredds.catalog.DataFormatType;
import thredds.catalog.ServiceType;
import thredds.ui.HtmlBrowser;
import ucar.nc2.constants.FeatureType;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PrefPanel;

public class CatalogSearcher
extends JPanel {
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String STATUS_WINDOW_SIZE = "StatusWindowSize";
    private PreferencesExt prefs;
    private PrefPanel queryPanel;
    private JSplitPane splitV;
    private HtmlBrowser htmlPanel;
    private boolean debugEvents = false;
    private String threddsServer = "http://motherlode.ucar.edu:8088/thredds/subset.html?";

    public CatalogSearcher(PreferencesExt prefs) {
        this.prefs = prefs;
        this.queryPanel = this.makeSearchPanel();
        JButton clear = new JButton("Clear");
        this.queryPanel.addButton(clear);
        this.htmlPanel = new HtmlBrowser();
        this.splitV = new JSplitPane(0, false, this.queryPanel, this.htmlPanel);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
        this.queryPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String queryString = CatalogSearcher.this.makeQuery().trim();
                if (queryString.length() == 0) {
                    return;
                }
                String resultPage = CatalogSearcher.this.doQuery(queryString);
                CatalogSearcher.this.htmlPanel.setContent(queryString, resultPage);
            }
        });
        this.htmlPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("datasetURL")) {
                    String urlString = (String)e.getNewValue();
                    System.out.println("***CatalogSearcher datasetURL= " + urlString);
                }
            }
        });
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public void save() {
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
    }

    private String makeQuery() {
        StringBuffer sbuff = new StringBuffer();
        Field.Text f = (Field.Text)this.queryPanel.getField("lucene");
        String value = f.getText().trim();
        if (value.length() > 0) {
            return value;
        }
        this.addEnumQuery("DataType", sbuff);
        this.addEnumQuery("DataFormatType", sbuff);
        this.addEnumQuery("ServiceType", sbuff);
        this.addTextQuery("name", sbuff);
        this.addTextQuery("keyword", sbuff);
        this.addTextQuery("summary", sbuff);
        System.out.println("Look for docs using query = " + sbuff.toString());
        return sbuff.toString();
    }

    private void addTextQuery(String fieldName, StringBuffer result) {
        Field.Text f = (Field.Text)this.queryPanel.getField(fieldName);
        String value = f.getText();
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        StringTokenizer stoker = new StringTokenizer(value);
        while (stoker.hasMoreTokens()) {
            String toke = stoker.nextToken();
            if (result.length() > 0) {
                result.append(" AND ");
            }
            result.append(fieldName);
            result.append(":");
            result.append(value);
        }
    }

    private void addEnumQuery(String fieldName, StringBuffer result) {
        Field.EnumCombo f = (Field.EnumCombo)this.queryPanel.getField(fieldName);
        String value = f.getValue().toString();
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        StringTokenizer stoker = new StringTokenizer(value);
        while (stoker.hasMoreTokens()) {
            String toke = stoker.nextToken();
            if (result.length() > 0) {
                result.append(" AND ");
            }
            result.append(fieldName);
            result.append(":");
            result.append(value);
        }
    }

    private String doQuery(String queryString) {
        try {
            IndexSearcher searcher = new IndexSearcher("index");
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Query query = QueryParser.parse(queryString, "contents", analyzer);
            System.out.println("Searching for: " + query.toString("contents"));
            Hits hits = searcher.search(query);
            System.out.println(" " + hits.length() + " total matching documents");
            String result = this.makePage(queryString, hits);
            searcher.close();
            return result;
        }
        catch (Exception e) {
            System.out.println("Lucene ERROR = " + e.getMessage());
            return null;
        }
    }

    private String makePage(String qs, Hits hits) throws IOException {
        StringBuffer buff = new StringBuffer(20000);
        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n");
        buff.append("<head>");
        buff.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        buff.append("</head>");
        buff.append("<body>\n");
        for (int i = 0; i < hits.length(); ++i) {
            Document doc = hits.doc(i);
            this.doOneDoc(buff, doc);
        }
        buff.append("</body></html>");
        System.out.println("html=" + buff.toString());
        return buff.toString();
    }

    private void doOneDoc(StringBuffer buff, Document doc) {
        buff.append("<h3>Dataset: " + doc.getField("name").stringValue() + "</h3><ul>\n");
        Enumeration e = doc.fields();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (f.name().equals("name") || f.name().equals("subsetURL")) continue;
            buff.append(" <li><b>" + f.name() + ":</b> " + f.stringValue() + "</li>\n");
        }
        String subsetURL = doc.getField("subsetURL").stringValue();
        buff.append(" <li><a href='" + this.threddsServer + subsetURL + "'>" + subsetURL + "</a>\n");
        buff.append("</ul>\n");
    }

    private PrefPanel makeSearchPanel() {
        PreferencesExt prefNode = (PreferencesExt)this.prefs.node("queryInput");
        PrefPanel pp = new PrefPanel("Query", null);
        int row = 0;
        pp.addHeading("Find Datasets that must have:", row++);
        pp.addEnumComboField("DataType", "Data type", Arrays.asList(FeatureType.values()), true, 0, row, null);
        pp.addEnumComboField("ServiceType", "Service type", ServiceType.getAllTypes(), true, 2, row, null);
        pp.addEnumComboField("DataFormatType", "Data format", DataFormatType.getAllTypes(), true, 4, row++, null);
        pp.addTextField("name", "name", "", 0, row++, null);
        pp.addTextField("keyword", "keyword", "", 0, row++, null);
        pp.addTextField("summary", "summary", "", 0, row++, null);
        pp.addSeparator();
        pp.addHeading("OR Enter a direct lucene query:", row++);
        pp.addTextField("lucene", "Lucene Query", "", 0, row++, null);
        pp.finish();
        return pp;
    }
}

