/* $Id: vhdl_sched.h 4798 2009-10-02 13:05:18Z potyra $
 *
 * Scheduler for VHDL processes.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __VHDL_SCHED_H_INCLUDED
#define __VHDL_SCHED_H_INCLUDED

#include "slset.h"
#include <stdbool.h>
#include "fauhdli.h"

/** scheduler instance */
struct vhdl_sched {
	/* FIXME: eventually use a map/hash_map to do a quick lookup between
	 *        vhdl process pointer and vhdl_sched_process pointer? */
	/** queue of runnable processes */
	struct slset *run_q;
	/** queue of sleeping processes */
	struct slset *wait_q;
};

extern
struct vhdl_sched *
vhdl_sched_create(const struct glue_vhdl_cb *callbacks);

extern void
vhdl_sched_destroy(
	struct vhdl_sched *sched, 
	const struct glue_vhdl_cb *callbacks
);

/** add a process to the list of runnable processes.
 *  @param sched scheduler instance.
 *  @param s process instance.
 *  @param run function to be called when process is run.
 *  @param callbacks callbacks (for malloc)
 */
extern void
vhdl_sched_add_process(
	struct vhdl_sched *sched, 
	void *s, 
	void (*run)(void *),
	const char *name,
	const struct glue_vhdl_cb *callbacks
);

/** run all processes in the run_q, then return.
 *  @param sched scheduler instance.
 */
extern void
vhdl_sched_run(
	struct vhdl_sched *sched,
	const struct glue_vhdl_cb *callbacks
);

/** check, if there are runnable processes.
 *  @param sched scheduler instance.
 *  @return true, if processes are in runnable state, false otherwise.
 */
extern bool
vhdl_sched_has_runnable(struct vhdl_sched *sched);

/** wakeup process s and put it in the runnable queue.
 *  @param sched scheduler instance
 *  @param s pointer of process instance
 *  @param callbacks callbacks (for malloc -> slset)
 */
extern void
vhdl_sched_wakeup(
	struct vhdl_sched *sched, 
	void *s, 
	const struct glue_vhdl_cb *callbacks
);

#endif /* __SCHEDULER_H_INCLUDED */
