/* $Id: constraint.h,v 1.7 2009-01-27 15:40:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONSTRAINT_H_INCLUDED
#define __CONSTRAINT_H_INCLUDED

#include "expr.h"

struct constraint {
	struct constraint *prev;
	struct constraint *next;

	const char *string;
	struct expr *expr;
};
struct constraint_list {
	struct constraint *first;
	struct constraint *last;
};

extern struct constraint *
constraint_new(void);
extern struct constraint *
constraint_dup(struct constraint *oc);
extern void
constraint_free(struct constraint *c);

extern struct constraint_list *
constraint_list_new(void);
extern struct constraint_list *
constraint_list_dup(struct constraint_list *ocl);
extern void
constraint_list_free(struct constraint_list *cl);

extern void
constraint_list_append_last(struct constraint_list *cl, struct constraint *c);

extern void
constraint_output(struct stmt *s, const char *string, struct expr *expr);
extern void
constraint_input(struct stmt *s, const char *string, struct expr *expr);
extern void
constraint_change(struct stmt *s, const char *string);

#endif /* ! __CONSTRAINT_H_INCLUDED */
