/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public final class HashtableOfType {
	// to avoid using Enumerations, walk the individual tables skipping nulls
	public char[] keyTable[];
	public ReferenceBinding valueTable[];

	public int elementSize; // number of elements in the table
	int threshold;
public HashtableOfType() {
	this(3);
}
public HashtableOfType(int size) {
	this.elementSize = 0;
	this.threshold = size; // size represents the expected number of elements
	int extraRoom = (int) (size * 1.75f);
	if (this.threshold == extraRoom)
		extraRoom++;
	this.keyTable = new char[extraRoom][];
	this.valueTable = new ReferenceBinding[extraRoom];
}
public boolean containsKey(char[] key) {
	int index = CharOperation.hashCode(key) % valueTable.length;
	int keyLength = key.length;
	char[] currentKey;
	while ((currentKey = keyTable[index]) != null) {
		if (currentKey.length == keyLength && CharOperation.equals(currentKey, key))
			return true;
		index = (index + 1) % keyTable.length;
	}
	return false;
}
public ReferenceBinding get(char[] key) {
	int index = CharOperation.hashCode(key) % valueTable.length;
	int keyLength = key.length;
	char[] currentKey;
	while ((currentKey = keyTable[index]) != null) {
		if (currentKey.length == keyLength && CharOperation.equals(currentKey, key))
			return valueTable[index];
		index = (index + 1) % keyTable.length;
	}
	return null;
}
public ReferenceBinding put(char[] key, ReferenceBinding value) {
	int index = CharOperation.hashCode(key) % valueTable.length;
	int keyLength = key.length;
	char[] currentKey;
	while ((currentKey = keyTable[index]) != null) {
		if (currentKey.length == keyLength && CharOperation.equals(currentKey, key))
			return valueTable[index] = value;
		index = (index + 1) % keyTable.length;
	}
	keyTable[index] = key;
	valueTable[index] = value;

	// assumes the threshold is never equal to the size of the table
	if (++elementSize > threshold)
		rehash();
	return value;
}
private void rehash() {
	HashtableOfType newHashtable = new HashtableOfType(elementSize < 100 ? 100 : elementSize * 2); // double the number of expected elements
	char[] currentKey;
	for (int i = keyTable.length; --i >= 0;)
		if ((currentKey = keyTable[i]) != null)
			newHashtable.put(currentKey, valueTable[i]);

	this.keyTable = newHashtable.keyTable;
	this.valueTable = newHashtable.valueTable;
	this.threshold = newHashtable.threshold;
}
public int size() {
	return elementSize;
}
public String toString() {
	String s = ""; //$NON-NLS-1$
	ReferenceBinding type;
	for (int i = 0, length = valueTable.length; i < length; i++)
		if ((type = valueTable[i]) != null)
			s += type.toString() + "\n"; //$NON-NLS-1$
	return s;
}
}
