/*
	Copyright (c) 2010 by Dennis Schridde

	This file is part of dovecot-metadata.

	dovecot-metadata is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	dovecot-metadata is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with dovecot-metadata.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DOVECOT_DICT_EXT_H
#define DOVECOT_DICT_EXT_H

#include "metadata-global.h"

#include <stdbool.h>

#include "dict.h"

enum dict_scope {
	DICT_SCOPE_SHARED,
	DICT_SCOPE_PRIVATE,
	DICT_SCOPE_INVALID
};

enum dict_scope
dict_get_scope(const char *key)
	ATTR_NONNULL(1);

const char *
dict_path_from_scope(enum dict_scope scope);

struct dict_iterate_multiscope_context;

enum dict_iterate_multiscope_flags {
	DICT_ITERATE_MULTISCOPE_FLAG_MULTISCOPE = 0x1000
};

struct dict_iterate_multiscope_context *
dict_iterate_multiscope_init(struct dict *dict, const char *path, enum dict_iterate_multiscope_flags flags)
	ATTR_NONNULL(1,2);
bool
dict_iterate_multiscope(struct dict_iterate_multiscope_context *ctx, const char **name, const char **value)
	ATTR_NONNULL(1,2,3);
int
dict_iterate_multiscope_deinit(struct dict_iterate_multiscope_context **ctx)
	ATTR_NONNULL(1);


#endif
