#
# dt - DITrack 'help' command
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: help.py 1696 2007-07-10 22:45:31Z vss $
# $HeadURL: https://svn.xiolabs.com/ditrack/src/tags/0.8/DITrack/Command/help.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import generic

def print_command_help(globals, cmd):
	table = globals.command_table.table
	cmds = globals.command_table.map

	if table.has_key(cmd):
		table[cmd].print_help(globals)
	else:
		print '"' + cmd + '": unknown command.'

	print

class Handler(generic.Handler):
	canonical_name = "help"
	description = """Describe the usage of this program or its commands.
usage: %s [COMMAND...]""" % canonical_name

	def run(self, opts, globals):

		self.check_options(opts)

		if len(opts.fixed) > 1:
			for cmd in opts.fixed[1:]:
				print_command_help(globals, cmd)
			return

		print \
"""%s

General usage:
	%s <command> [<options>] [<args>]

Available commands:""" % (globals.dt_title, globals.binname)

		cmds = globals.command_table.map
		keys = cmds.keys()
		keys.sort()

		for k in keys:
			print "\t%s" % (", ".join(cmds[k]))

		print "\nType '%s help <command>' for help on specific " \
			"command.\n" % globals.binname
