#ifndef RPC_ARGUMENT_FACTORY__
#define RPC_ARGUMENT_FACTORY__

#include "User.h"
#include "BackendUtil.h"
#include "SessionManager.h"

class Upload;
namespace dcqt_backend { namespace rpc_argument {
	
    inline boost::any createUser(const dcqt_backend::User& u) {
		list<boost::any> user;
        user.push_back(u.id);
        user.push_back(u.nick);
        user.push_back(u.flags);
        user.push_back(u.email);
        user.push_back(u.desc);
        user.push_back(u.connection);
        user.push_back(u.tag);
        user.push_back(u.shared);
        user.push_back(u.slots);
        return user;
    }
	
	inline list<boost::any> createUpload(Upload* t) {
        list<boost::any> ret;
		
		ret.push_back(t->getPos());
		ret.push_back(t->getStartPos());
		ret.push_back(t->getActual());
		ret.push_back(t->getSize());
		ret.push_back(t->getAverageSpeed());
		ret.push_back(t->getSecondsLeft());
		ret.push_back(t->getBytesLeft());
		ret.push_back(t->getFileName());
		ret.push_back(t->getLocalFileName());
		ret.push_back( t->getTTH() ? t->getTTH()->toBase32() : "");
		ret.push_back( SessionManager::instance()->getUserPtrMap()[t->getUser()].id);
		
		return ret;
	}
	
	inline list<boost::any> createDownload(Download* t) {
		list<boost::any> ret;
		
		ret.push_back(t->getPos());
		ret.push_back(t->getStartPos());
		ret.push_back(t->getActual());
		ret.push_back(t->getSize());
		ret.push_back(t->getAverageSpeed());
		ret.push_back(t->getSecondsLeft());
		ret.push_back(t->getBytesLeft());
		ret.push_back(t->getTargetFileName());
		
		ret.push_back(t->getTTH() ? t->getTTH()->toBase32() : "");
		ret.push_back(SessionManager::instance()->getUserPtrMap()[t->getUserConnection()->getUser()].id);
		
		return ret;
	}
	
	inline list<boost::any> createSearchRes(SearchResult* res, int userId) {
		//XmlRpcValue ret;
		list<boost::any> ret;     
		ret.push_back(static_cast<string>(res->getFile()));
		ret.push_back(static_cast<int>( res->getUtf8() ));
		ret.push_back(static_cast<string>( res->getFileName() ));
		ret.push_back(static_cast<string>( res->getUser()->getNick() ));
		ret.push_back(static_cast<string>( res->getHubName() ));
		ret.push_back(static_cast<int>( userId ));
		ret.push_back(res->getSize());
		ret.push_back(res->getSlots());
		ret.push_back(static_cast<int>( res->getFreeSlots() ));
		ret.push_back(static_cast<int>( res->getType() ));
		ret.push_back(res->getTTH() ? res->getTTH()->toBase32() : "");
		
		return ret;
	}
	
	inline list<boost::any> createQueueItem(QueueItem* item,int id) {
		list<boost::any> ret;
		ret.push_back(id);
		ret.push_back(item->getTarget());
		ret.push_back(static_cast<int64_t>(item->getSize()));
		ret.push_back(static_cast<int64_t>(item->getDownloadedBytes()));
		ret.push_back( (int)item->getStatus());
		ret.push_back((int)item->getPriority());
		if( item->getCurrent() )
			ret.push_back(SessionManager::instance()->getUserPtrMap()[item->getCurrent()->getUser()].id);
		else 
			ret.push_back(0);
		QueueItem::Source::List sources = item->getSources();
		QueueItem::Source::Iter sit = sources.begin();
		list<boost::any> slst;
		for(;sit!=sources.end();sit++) {
			::User::Ptr u = (*sit)->getUser();
			int uid = SessionManager::instance()->getUserPtrMap()[u].id;
			slst.push_back(uid);
		}
		ret.push_back(slst);
		return ret;
	}
	
	inline list<boost::any> createFinishedItem(FinishedItem* item,int id) {
		list<boost::any> ret;
		ret.push_back(id);
		ret.push_back(item->getTarget());
		ret.push_back(item->getUser());
		ret.push_back(item->getHub());
		return ret;
	}
	
	inline list<boost::any> createFavouriteHub(const FavoriteHubEntry* i) {
		list<boost::any> ret;
		ret.push_back(i->getNick());
		ret.push_back(i->getUserDescription());
		ret.push_back(i->getName());
		ret.push_back(i->getServer());
		ret.push_back(i->getDescription());
		ret.push_back(i->getPassword());
		ret.push_back(i->getConnect());
		return ret;
	}
	
	inline list<boost::any> createHubList( const HubEntry::List& hubList ){
		
		list< boost::any > hubs;
		// Go through all the hubs and add them to the list
		int i = 0;
		for(HubEntry::List::const_iterator it = hubList.begin();it!=hubList.end();it++,i++)	{
			
			list<boost::any> hub;
			hub.push_back((*it).getName());
			hub.push_back((*it).getServer());
			hub.push_back((*it).getDescription());
			hub.push_back((*it).getCountry());
			hub.push_back((*it).getRating());
			hub.push_back(static_cast<int>((*it).getReliability()));
			hub.push_back(static_cast<int64_t>((*it).getShared()));
			hub.push_back(static_cast<int64_t>((*it).getMinShare()));
			hub.push_back((*it).getUsers());
			hub.push_back((*it).getMinSlots());
			hub.push_back((*it).getMaxHubs());
			hub.push_back((*it).getMaxUsers());
			
			hubs.push_back(hub);
		}
		return hubs;
	}
}
}
#endif
