#!/usr/bin/env bash
# THIS FILE IS PART OF THE CYLC WORKFLOW ENGINE.
# Copyright (C) NIWA & British Crown (Met Office) & Contributors.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------
# Test validation fails for special implicit tasks
. "$(dirname "$0")/test_header"
set_test_number 2
cat >'flow.cylc' <<'__FLOW_CONFIG__'
[scheduling]
    initial cycle point = 20200101
    [[special tasks]]
        clock-trigger = foo(PT0M)
    [[graph]]
        T00 = bar
[runtime]
    [[bar]]
        script = true
__FLOW_CONFIG__
run_fail "${TEST_NAME_BASE}" cylc validate "${PWD}/flow.cylc"
cmp_ok "${TEST_NAME_BASE}.stderr" << '__ERR__'
WorkflowConfigError: implicit tasks detected (no entry under [runtime]):
    * foo
To allow implicit tasks, use 'flow.cylc[scheduler]allow implicit tasks'
See https://cylc.github.io/cylc-doc/latest/html/7-to-8/summary.html#backward-compatibility
__ERR__
exit
