/***************************************************************************
                          leveldaten.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de

Modified 2001-2003,2005,2006,2008,2010,2011 by the cuyo developers
Modified 2012 by Bernhard R. Link
Maintenance modifications 2012 by the cuyo developers

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEVELDATEN_H
#define LEVELDATEN_H

#include <vector>
#include <set>

#include "sdltools.h"

#include "sorte.h"
#include "bilddatei.h"
#include "version.h"

class Str;
class Code;
class Blop;
class DefKnoten;
class ListenKnoten;
class DatenDatei;
class Fehler;


/***** Konstanten, die irgend was einstellen *****/

/* Konstanten, die mit dem Layout zusammenhngen: siehe layout.h */

#define max_spielerzahl 2

#define max_farben_zahl 200 // Max. Anzahl der Farben in einem Level

/* Wofr gibt es wie viele Punkte */
#define punkte_fuer_normales 1
#define punkte_fuer_graues 0
#define punkte_fuer_gras 20
#define punkte_fuer_kettenreaktion 10

/* Pixel pro Schritt: Bonus-Hetzrand-Geschwindigkeit */
#define bonus_geschwindigkeit 32
/* Punkte pro Zeitschritt der Bonus-Animation */
#define punkte_fuer_zeitbonus 10



/***** Konstanten, die einfach nur was bedeuten *****/

#define zufallsgraue_keine (-1)
#define PlatzAnzahl_undefiniert (-1)


/* Zur bergabe an laden(), um den Titel-Level zu laden */
#define level_titel (-1)


/* Fr die codes in startdist */
#define distkey_leer (-1)
#define distkey_gras (-2)
#define distkey_grau (-3)
#define distkey_farbe (-4)
#define distkey_undef (-5)

/* nachbarschaft_... steht in sorte.h */



/* Zur Unterscheidung von lazy und eager */

enum LDTeil {
  ldteil_summary,
  ldteil_level,
  ldteile_anzahl
};



/** (Einziges globales) Objekt enthlt alle Informationen ber
    den aktuellen Level.
    
    Das Parsen der ld-Dateien:
    - Beim Aufruf des constructors von LevelDaten() wird ladLevelSummary()
      aufgerufen.
    - ladLevelSummary() bzw ladLevel  sucht die richtige Datei und erzeugt ein
      DatenDatei-Objekt
    - Der Constructor davon ffnet die Datei und ruft parse() auf.
    - parse() ruft den bison-Parser auf. Der erzeugt folgendes:
      - Einen Baum aus Knoten: DefKnoten, ListenKnoten, WortKnoten
      - Jeder DefKnoten enthlt noch eine Liste von Codeen (die
        in der level.descr in << >> definiert wurden)
      - Codeen sind auch wieder baumartig
    - Wenn in einem Code ein Name eines anderen Codes vorkommt,
      wird das schon beim Parsen aufgelst, indem in den CodeSpeichern
      der darberliegenden DefKnoten nachgeschaut wird
      
    
    @author Immi
*/


class LevelDaten {
  friend class Sorte;
  friend int yyparse();
	
 public:
  LevelDaten(const Version & version);
  ~LevelDaten();
  
  /** Ld die Levelconf (neu). Wird vom Konstruktor aufgerufen.
      Und, wenn sich Einstellungen verndert haben.
      Eine Vorbedingung ist also, da niemand grad auf irgendwelche Daten
      dieses Objekts angewiesen ist, insbesondere also, da grad kein
      Spiel luft.
      Bei aufJedenFall=false wird nur dann wirklich neu geladen,
      wenn version!=mVersion.
      Bei ldteil=ldteil_summary wird am Ende noch der inhalt aller in
      global= aufgefhrten Dateien nach ldteil_level geladen. */
  void ladLevelSummary(bool aufJedenFall, const Version & version);

 protected:
  /** Ld den level-spezifischen Teil */
  void ladLevelConfig();
 public:
  
  /** Wird whrend des Parsens (d. h. innerhalb von ladLevel*()) von
      DefKnoten aufgerufen, wenn ein neuer Level gefunden wurde. Fgt
      den Level in die Liste der Level ein. ladLevelSummary() kann sich
      danach immernoch entscheiden, ob es die Liste wieder lscht und
      durch die "level=..."-Liste ersetzt. */
  void levelGefunden(Str lna);

  /* Gibt Speicher frei */
  void entladLevel();
  
  /** fllt alle Daten in diesem Objekt fr Level nr aus; throwt bei Fehler */
  void ladLevel(int nr);

  /** Darf nur aufgerufen werden, wenn nr schon der letzte Level war.
      Erneuert alles, was seitdem vergessen worden sein knnte. */
  void erneuerLevel(int nr);

  /** Sollte am Anfang des Levels aufgerufen werden; kmmert sich
      um den Global-Blop */
  void startLevel() const;
  
  /** Sollte einmal pro Spielschritt aufgerufen werden (bevor
      Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich 
      um den Global-Blop */
  void spielSchritt() const;

  /** Liefert zurck, wie viele Level es gibt. */
  int getLevelAnz() const;

  /** Lifert zurck, ob die Level der Reihe nach gespielt werden mssen */
  int getAngeordnet() const;

  /** Liefert den Namen von Level nr zurck. Liefert "???" bei Fehler. */
  Str getLevelName(int nr) const;

  /** Liefert den internen Namen von Level nr zurck. */
  Str getIntLevelName(int nr) const;

  /** Liefert die Nummer des Levels mit dem angegebenen Namen zurck,
      oder 0, wenn der Level nicht existiert. */
  int getLevelNr(Str na) const;

  /** Wenn eine Sorte ihre Platzanzahl rausgefunden hat,
      teilt sie uns das mit */
  void neue_PlatzAnzahl(int);

  int zufallsSorte(int wv);

  int liesDistKey(const Str &);

  const Version & getVersion() const;

  /** Setzt AutoColor::gGame */
  void setSchriftFarbe(Color f);

 protected:
   
  /** Ld ein paar Sorten. Wird mehrfach von ladLevel() aufgerufen. */
  void ladSorten(const Str & ldKeyWort, int blopart);
 
 
 /** Die Objekte, mit denen man auf die Dateien zugreift. Hier stehen nur
     Pointer drauf, damit diese .h-Datei nicht so viel includen muss. */
  DatenDatei * mLevelConf[ldteile_anzahl];
  /** True, wenn zur Zeit der entsprechende Teil der LevelConf geladen ist. */
  bool mLCGeladen[ldteile_anzahl];
  /** Alle Level, die schon mal geladen wurden und daher noch vorhanden sind.
      Hier stehen die Dateinamen. */
  std::set<Str> mLevelCache;
  /** Liste der internen Levelnamen. */
  std::vector<Str> mIntLevelNamen;
  /** True falls die Level der Reihe nach gespielt werden mssen. */
  bool mAngeordnet;

  Version mVersion;
  
 public:

  /* Die ganzen nachfolgenden Variablen werden von ladLevel() gesetzt.
     Danach greifen alle anderen Objekte, die was mit dem Spiel zu tun
     haben, direkt darauf zu. */


  /***** Allgemeines *****/
  bool mLevelGeladen;
  int mLevelNummer; /* Nummer des geladenen Levels */
  int mSpielerZahl;
  /** Interner Level-Name vom aktuellen Level. (Wird von Aufnahme
      bentigt.) */
  Str mIntLevelName;
  Str mLevelName;
  Str mLevelAutor;
  /** Der Knoten zum aktuellen Level. */
  DefKnoten * mLevelKnoten;
  /** Beschreibungstext fr den Level */
  Str mBeschreibung;
  Color mHintergrundFarbe;
  bool mMitHintergrundbildchen;
  Bilddatei mHintergrundBild;
  /** Farbe der Schrift in dem Level:
      0 = abgedunkelt, 1 = normal, 2 = aufgehellt */
  Color mSchriftFarbe;
  bool mGrasBeiKettenreaktion;
  bool mFallPosZufaellig;
  Bilddatei mExplosionBild;
  int mPlatzAnzahlDefault;
  int mPlatzAnzahlMin;
  int mPlatzAnzahlMax;
  /* Gibt an, ob neben mPlatzAnzahlMin und mPlatzAnzahlMax noch andere
     PlatzAnzahlen vorkommen. */
  bool mPlatzAnzahlAndere;
  Str mMusik;
  
  /** Max. Anzahl der Bilder, die ein Blop gleichzeitig malt. Wird
      (ggf.) von den Sorten erhht, wenn man sie ldt. */
  int mStapelHoehe;
  /** Anzahl der Bilder, die Blops auf Nachbarfelder malen. Der Einfachheit
      halber wird das hier fr alle Sorten aufsummiert, statt alles schn
      nach relativen Koordinaten zu trennen, etc.
      Wird auch von den Sorten erhht, wenn man sie ldt. */
  int mNachbarStapelHoehe;
  
  /***** Die Sorten *****/
 protected:
  /** Das Array, in dem alle Sorten stehen. Allerdings soll die Index-
      Menge nicht bei 0 losgehen, sondern bei blop_min_sorte. Deshalb
      gibt es in public die Variable mSorten... */
  Sorte * mSortenIntern[max_farben_zahl - blopart_min_sorte];
 public:
  /** Wird ganz am Anfang auf mSortenIntern - blopart_min_sorte
      initialisiert. */
  Sorte * * const mSorten;
  int mAnzFarben;
  int mVerteilungSumme[anzahl_wv];
  int mKeineGrauenW;    /** Zhlt nicht zu mGrauSumme */
 
  /***** Hetzrand *****/
  Color hetzrandFarbe;
  int hetzrandZeit;
  bool mMitHetzbildchen;
  Bilddatei mHetzBild;
  int mHetzrandUeberlapp;
  int mHetzrandStop;

  /***** Gras *****/
  ListenKnoten * mAnfangsZeilen;
  int mDistKeyLen; /** Lnge der distKeys. 0, wenn es noch keinen gab. */


  /***** KI-Player-Nutzen-Funktion *****/
  /** Zusatzpunkte fr beide Blops gleiche Farbe & Senkrecht*/
  int mKINEinfarbigSenkrecht;
  /** Vorfaktor vor Bewertung der Blop-Hhe */
  int mKINHoehe;
  /** Punkte fr Blob mit gleicher Farbe benachbart */
  int mKINAnFarbe;
  /** Punkte fr Blob mit Gras benachbart */
  int mKINAnGras;
  /** Punkte fr Blob mit Grauem benachbart */
  int mKINAnGrau;
  /** Punkte fr Blob zwei ber gleicher Farbe */
  int mKINZweiUeber;
	
  /***** Sonderfeatures *****/
  bool mSpiegeln;
  int mNachbarschaft; // Default-Wert fr die Sorten
  /** true bei Sechseckraster. Wird direkt aus mNachbarschaft bestimmt. */
  bool mSechseck;
  bool mMitLeerBildchen;
  int mZufallsGraue;

 protected:

  bool mSammleLevel; /* Bestimmt, ob levelGefunden berhaupt was tun soll. */

};

/* Definition in leveldaten.cpp */
extern LevelDaten * ld;


#endif
