'\"
'\" Generated from file 'critcl_emap\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011-2018 Andreas Kupries
'\"
.TH "critcl::emap" n 1\&.2 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl::emap \- CriTcl Utilities: Enum en- and decoding
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBcritcl  ?3\&.1\&.11?\fR
.sp
package require \fBcritcl::emap  ?1\&.2?\fR
.sp
\fB::critcl::emap::def\fR \fIname\fR \fIdefinition\fR ?\fB-nocase\fR? ?\fB-mode\fR \fImode\fR?
.sp
.BE
.SH DESCRIPTION
.PP
\fIC Runtime In Tcl\fR, or \fICriTcl\fR , is a system for compiling C code
embedded in Tcl on the fly and either loading the resulting objects into Tcl for
immediate use or packaging them for distribution\&.  Use \fICriTcl\fR to improve
performance by rewriting in C those routines that are performance bottlenecks\&.
.PP
This document is the reference manpage for the
\fBcritcl::emap\fR package\&. This package provides convenience
commands for advanced functionality built on top of both critcl core
and package \fBcritcl::iassoc\fR\&.
.PP
C level libraries often use enumerations or integer values to encode
information, like the state of a system\&. Tcl bindings to such libraries now
have the task of converting a Tcl representation, i\&.e\&. a string into such
state, and back\&.
\fINote\fR here that the C-level information has to be something which
already exists\&. The package does \fInot\fR create these values\&. This is
in contrast to the package \fBcritcl::enum\fR which creates an
enumeration based on the specified symbolic names\&.
.PP
This package was written to make the declaration and management
of such enumerations and their associated conversions functions easy,
hiding all attendant complexity from the user\&.
.PP
Its intended audience are mainly developers wishing to write
Tcl packages with embedded C code\&.
.PP
This package resides in the Core Package Layer of CriTcl\&.
.PP
.PS
.nf
+----------------+
|Applications    |
| critcl         |
| critcl::app    |
+----------------+

*================*
|Core Packages   |
| critcl         |
| critcl::util   |
*================*

+----------------+
|Support Packages|
| stubs::*       |
| md5, platform  |
|  \&.\&.\&.           |
+----------------+

.fi
.PE
.PP
.SH API
.TP
\fB::critcl::emap::def\fR \fIname\fR \fIdefinition\fR ?\fB-nocase\fR? ?\fB-mode\fR \fImode\fR?
This command defines C functions for the conversion of the \fIname\fRd
state code into a Tcl string, and vice versa\&.
The underlying mapping tables are automatically initialized on first
access (if not fully constant), and finalized on interpreter
destruction\&.
.sp
The \fIdefinition\fR dictionary provides the mapping from the
Tcl-level symbolic names of the state to their C expressions (often
the name of the macro specifying the actual value)\&.
\fINote\fR here that the C-level information has to be something which
already exists\&. The package does \fInot\fR create these values\&. This is
in contrast to the package \fBcritcl::enum\fR which creates an
enumeration based on the specified symbolic names\&.
.sp
Further note that multiple strings can be mapped to the same C
expression\&. When converting to Tcl the first string for the mapping is
returned\&. An important thing to know: If all C expressions are
recognizable as integer numbers and their covered range is not too
large (at most 50) the package will generate code using direct and
fast mapping tables instead of using a linear search\&.
.sp
If the option \fB-nocase\fR is specified then the encoder
will match strings case-insensitively, and the decoder will always
return a lower-case string, regardless of the string's case in the
\fIdefinition\fR\&.
.sp
If the option \fB-mode\fR is specified its contents will
interpreted as a list of access modes to support\&.  The two allowed
modes are \fBc\fR and \fBtcl\fR\&. Both modes can be used
together\&. The default mode is \fBtcl\fR\&.
.sp
The package generates multiple things (declarations and
definitions) with names derived from \fIname\fR, which has to be a
proper C identifier\&. Some of the things are generated conditional on
the chosen \fImode\fRs\&.
.RS
.TP
\fIname\fR_encode
The \fBtcl\fR-mode function for encoding a Tcl string into the
equivalent state code\&.
Its signature is
.sp
.CS


int \fIname\fR_encode (Tcl_Interp* interp, Tcl_Obj* state, int* result);

.CE
.sp
The return value of the function is a Tcl error code,
i\&.e\&. \fBTCL_OK\fR, \fBTCL_ERROR\fR, etc\&.
.TP
\fIname\fR_encode_cstr
The \fBc\fR-mode function for encoding a C string into the
equivalent state code\&.
Its signature is
.sp
.CS


int \fIname\fR_encode_cstr (const char* state);

.CE
.sp
The return value of the function is the encoded state, or -1 if
the argument is not a vlaid state\&.
.TP
\fIname\fR_decode
The \fBtcl\fR-mode function for decoding a state code into the
equivalent Tcl string\&.
Its signature is
.sp
.CS


Tcl_Obj* \fIname\fR_decode (Tcl_Interp* interp, int state);

.CE
.TP
\fIname\fR_decode_cstr
The \fBc\fR-mode function for decoding a state code into the
equivalent C string\&.
Its signature is
.sp
.CS


const char* \fIname\fR_decode_cstr (int state);

.CE
.sp
The return value of the function is the C string for the state,
or \fBNULL\fR if the \fIstate\fR argument does not contain a valid
state value\&.
.TP
\fIname\fR\&.h
A header file containing the declarations for the conversion
functions, for use by other parts of the system, if necessary\&.
.sp
The generated file is stored in a place where it will not
interfere with the overall system outside of the package, yet also be
available for easy inclusion by package files (\fBcsources\fR)\&.
.TP
\fIname\fR
For mode \fBtcl\fR the command registers a new argument-type for
\fBcritcl::cproc\fR with critcl, encapsulating the encoder function\&.
.TP
\fIname\fR
For mode \fBtcl\fR the command registers a new result-type for
\fBcritcl::cproc\fR with critcl, encapsulating the decoder function\&.
.RE
.PP
.SH EXAMPLE
The example shown below is the specification for the possible modes of
entry (normal, no feedback, stars) used by the Tcl binding to the
linenoise library\&.
.CS


package require Tcl 8\&.5
package require critcl 3\&.1\&.11

critcl::buildrequirement {
    package require critcl::emap
}

critcl::emap::def hiddenmode {
            no  0 n 0 off 0 false 0 0 0
    all   1 yes 1 y 1 on  1 true  1 1 1
    stars 2
} -nocase

# Declarations: hiddenmode\&.h
# Encoder:      int      hiddenmode_encode (Tcl_Interp* interp, Tcl_Obj* state, int* result);
# Decoder:      Tcl_Obj* hiddenmode_decode (Tcl_Interp* interp, int state);
# ResultType:   hiddenmode
# ArgumentType: hiddenmode

.CE
.SH AUTHORS
Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such at \fIhttps://github\&.com/andreas-kupries/critcl\fR\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
C code, Embedded C Code, Tcl Interp Association, bitmask, bitset, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, flags, generate package, linker, on demand compilation, on-the-fly compilation, singleton
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) 2011-2018 Andreas Kupries

.fi
