/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.Parse;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class VendorFunctionLibrary
implements FunctionLibrary {
    private HashMap functionTable;

    public VendorFunctionLibrary() {
        this.init();
    }

    protected StandardFunction.Entry register(String string, Class clazz, int n, int n2, int n3, ItemType itemType, int n4) {
        StandardFunction.Entry entry = StandardFunction.makeEntry(string, clazz, n, n2, n3, itemType, n4);
        this.functionTable.put(string, entry);
        return entry;
    }

    protected void init() {
        this.functionTable = new HashMap(30);
        StandardFunction.Entry entry = this.register("evaluate", Evaluate.class, 0, 1, 10, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = this.register("evaluate-node", Evaluate.class, 3, 1, 1, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 16384);
        entry = this.register("eval", Evaluate.class, 2, 1, 10, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 16384);
        entry = this.register("expression", Evaluate.class, 1, 1, 1, Type.ANY_ATOMIC_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = this.register("parse", Parse.class, 0, 1, 1, NodeKindTest.DOCUMENT, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = this.register("serialize", Serialize.class, 0, 2, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.ITEM_TYPE, 16384);
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (string.equals("http://saxon.sf.net/")) {
            StandardFunction.Entry entry = (StandardFunction.Entry)this.functionTable.get(string2);
            if (entry == null) {
                return false;
            }
            return n2 == -1 || n2 >= entry.minArguments && n2 <= entry.maxArguments;
        }
        return false;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        if (string.equals("http://saxon.sf.net/")) {
            SystemFunction systemFunction;
            StandardFunction.Entry entry = (StandardFunction.Entry)this.functionTable.get(string2);
            if (entry == null) {
                return null;
            }
            Class clazz = entry.implementationClass;
            try {
                systemFunction = (SystemFunction)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Failed to load Saxon extension function: " + exception.getMessage()));
            }
            systemFunction.setDetails(entry);
            systemFunction.setFunctionNameCode(n);
            systemFunction.setArguments(expressionArray);
            this.checkArgumentCount(expressionArray.length, entry.minArguments, entry.maxArguments, string2);
            return systemFunction;
        }
        return null;
    }

    public Expression makeSaxonFunction(String string, StaticContext staticContext, Expression[] expressionArray) throws XPathException {
        String string2 = "http://saxon.sf.net/";
        int n = staticContext.getNamePool().allocate("saxon", string2, string);
        return this.bind(n, string2, string, expressionArray);
    }

    private int checkArgumentCount(int n, int n2, int n3, String string) throws XPathException {
        if (n2 == n3 && n != n2) {
            throw new StaticError("Function " + Err.wrap("saxon:" + string, 3) + " must have " + n2 + VendorFunctionLibrary.pluralArguments(n2));
        }
        if (n < n2) {
            throw new StaticError("Function " + Err.wrap("saxon:" + string, 3) + " must have at least " + n2 + VendorFunctionLibrary.pluralArguments(n2));
        }
        if (n > n3) {
            throw new StaticError("Function " + Err.wrap("saxon:" + string, 3) + " must have no more than " + n3 + VendorFunctionLibrary.pluralArguments(n3));
        }
        return n;
    }

    public static String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }
}

