/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#include "FileSystemComposite.h"
#include "Directory.h"
#include "File.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>

FileSystemComposite *
FileSystemComposite::CreateFromPath (string const &path)
{
    /* stat the path */
    struct stat statBuf;
    int statrv = lstat(path.c_str(), &statBuf);
    if (statrv)
	return NULL;
    
    /* FIXME: feed metadata into the composite constructors */
    if (S_ISDIR(statBuf.st_mode))
	return new Directory (path, statBuf.st_mode);

    if (S_ISREG(statBuf.st_mode))
	return new File (path, false, statBuf.st_mode);

    if (S_ISLNK(statBuf.st_mode))
	/* TODO: examine having a symlink child of File */
	return new File (path, true, statBuf.st_mode);

    throw (string) "FileSystemComposite::CreateFromPath: unsupported file type encountered";
}

bool
FileSystemComposite::Exists (string const &aPath)
{
    /* stat the path */
    struct stat statBuf;
    int statrv = stat(aPath.c_str(), &statBuf);
    if (statrv) {
	if (errno != ENOENT)
	    throw (string) "Could not stat '" + aPath + "'.";
	return false;
    }

    return true;
}
