/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#if defined(_WIN32) && !defined(__MINGW32__) // MSVC only
#pragma warning( disable : 4290)
#endif

#ifndef VTK_MANAGER_Component_REGISTRATION_ADDON_H
#define VTK_MANAGER_Component_REGISTRATION_ADDON_H

// SPECIFIC includes
#include "VtkMeshComponent.h"
class VtkMeshComponent;
#include "VtkMeshComponentAPI.h"

/** The Camera Calibration Addon class.
* IMPORTANT : All Camera Calibration Addon have to inherit from this class.
* Allows the data component and an addon to have a common generic class.
* 
*/
class VtkMeshComponentRegistrationAddon 
{
public:

	/** Default destructor. */
	~VtkMeshComponentRegistrationAddon();

protected:
	/** Default construtor. */
	VtkMeshComponentRegistrationAddon();
	
	/// The Component associated to the camera calibration addon
	VtkMeshComponent * myComponent;

};


/// The pointer that will receive the addon's instance created by the addon's constructor
typedef VtkMeshComponentRegistrationAddon * ( *PtrToVtkMeshComponentRegistrationAddon )( VtkMeshComponent * mdc );


// ####################   INLINES   ###########################################

// -------------------- constructor -------------------------------------------
inline VtkMeshComponentRegistrationAddon::VtkMeshComponentRegistrationAddon() {
	myComponent = NULL;
}

// -------------------- destructor --------------------------------------------
inline VtkMeshComponentRegistrationAddon::~VtkMeshComponentRegistrationAddon() {
}

#endif   // VTKMANAGERComponent_REGISTRATION_ADDON_H
