//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Item/ItemStackWidget.cpp
//! @brief     Implements class ItemStackWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Item/ItemStackWidget.h"
#include <QStackedWidget>
#include <QVBoxLayout>

ItemStackWidget::ItemStackWidget(QWidget* parent)
    : QWidget(parent)
    , m_stackedWidget(new QStackedWidget)
    , m_size_hint(QSize(1024, 1024))
{
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    m_stackedWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    auto* layout = new QVBoxLayout;
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setSpacing(0);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->addWidget(m_stackedWidget);
    setLayout(layout);
}

QSize ItemStackWidget::sizeHint() const
{
    return m_size_hint;
}

QSize ItemStackWidget::minimumSizeHint() const
{
    return QSize(25, 25);
}

void ItemStackWidget::setSizeHint(const QSize& size_hint)
{
    m_size_hint = size_hint;
}

void ItemStackWidget::hideWidgets()
{
    if (m_stackedWidget->currentWidget())
        m_stackedWidget->currentWidget()->hide();
}
