//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/GISASInstrumentEditor.cpp
//! @brief     Implements class GISASInstrumentEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Instrument/GISASInstrumentEditor.h"
#include "GUI/Model/Device/InstrumentItems.h"
#include "GUI/View/Device/BackgroundForm.h"
#include "GUI/View/Instrument/DetectorEditor.h"
#include "GUI/View/Instrument/GISASBeamEditor.h"
#include "GUI/View/Instrument/PolarizationAnalysisEditor.h"


GISASInstrumentEditor::GISASInstrumentEditor(QWidget* parent, GISASInstrumentItem* instrument)
    : QWidget(parent)
{
    ASSERT(instrument);
    auto* layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);

    auto* beamEditor = new GISASBeamEditor(this, instrument->beamItem());
    layout->addWidget(beamEditor);

    auto* detectorEditor = new DetectorEditor(this, instrument);
    layout->addWidget(detectorEditor);

    auto* polMatricesAnalysisEditor = new PolarizationAnalysisEditor(this, instrument);
    layout->addWidget(polMatricesAnalysisEditor);

    auto* backgroundForm = new BackgroundForm(this, instrument);
    layout->addWidget(backgroundForm);

    layout->addStretch();

    connect(beamEditor, &GISASBeamEditor::dataChanged, this, &GISASInstrumentEditor::dataChanged);
    connect(detectorEditor, &DetectorEditor::dataChanged, this,
            &GISASInstrumentEditor::dataChanged);
    connect(polMatricesAnalysisEditor, &PolarizationAnalysisEditor::dataChanged, this,
            &GISASInstrumentEditor::dataChanged);
    connect(backgroundForm, &BackgroundForm::dataChanged, this,
            &GISASInstrumentEditor::dataChanged);
}
