
#ifndef ERROR_NONE

#define ERROR_NONE 				0

// ERRROR numbers less than 0 are NOT trappable
// and are fatal at runtime
#define ERROR_NOSUCHLABEL		-1
#define ERROR_NOTARRAY 			-3
#define ERROR_ARGUMENTCOUNT 	-5
#define ERROR_MAXRECURSE 		-6
#define ERROR_STACKUNDERFLOW	-7
#define ERROR_UNSERIALIZEFORMAT	-11
#define ERROR_NOSUCHSUBROUTINE	-12
#define ERROR_NOSUCHFUNCTION	-13
#define ERROR_ONERRORSUB        -14


// ERRRORS and WARNINGS greater than 0 are trappable
// with the "ONERROR" and TRY/CATCH/ENDTRY statements
// 
// ERRORS from 1-65535 are trapable but by default cause execution to stop
// WARNINGS 65536+ are trapable but execution will continue by default
//
// trapable ERRORS
#define ERROR_FILENUMBER 				5
#define ERROR_FILEOPEN 					6
#define ERROR_FILENOTOPEN 				7
#define ERROR_FILEWRITE 				8
#define ERROR_FILERESET 				9
#define ERROR_ARRAYSIZELARGE 			10
#define ERROR_ARRAYSIZESMALL 			11
#define ERROR_ARRAYEVEN					12
#define ERROR_VARNOTASSIGNED 			13
#define ERROR_ARRAYNITEMS 				14
#define ERROR_ARRAYINDEX 				15
#define ERROR_STRSTART 					17
#define ERROR_RGB 						20
#define ERROR_POLYPOINTS 				23
#define ERROR_IMAGEFILE 				24
#define ERROR_SPRITENUMBER 				25
#define ERROR_SPRITENA 					26
#define ERROR_SPRITESLICE 				27
#define ERROR_FOLDER 					28
#define ERROR_INFINITY 					29
#define ERROR_DBOPEN 					30
#define ERROR_DBQUERY 					31
#define ERROR_DBNOTOPEN 				32
#define ERROR_DBCOLNO 					33
#define ERROR_DBNOTSET 					34
#define ERROR_NUMBERCONV				35
#define ERROR_NETSOCK 					36
#define ERROR_NETHOST 					37
#define ERROR_NETCONN 					38
#define ERROR_NETREAD 					39
#define ERROR_NETNONE 					40
#define ERROR_NETWRITE 					41
#define ERROR_NETSOCKOPT 				42
#define ERROR_NETBIND 					43
#define ERROR_NETACCEPT 				44
#define ERROR_NETSOCKNUMBER 			45
#define ERROR_PERMISSION 				46
#define ERROR_IMAGESAVETYPE 			47
#define ERROR_DIVZERO 					50
#define ERROR_FREEFILE 					53
#define ERROR_FREENET 					54
#define ERROR_FREEDB 					55
#define ERROR_DBCONNNUMBER 				56
#define ERROR_FREEDBSET 				57
#define ERROR_DBSETNUMBER 				58
#define ERROR_DBNOTSETROW 				59
#define ERROR_PENWIDTH 					60
#define ERROR_ARRAYINDEXMISSING			62
#define ERROR_IMAGESCALE 				63
#define ERROR_RADIXSTRING 				66
#define ERROR_RADIX 					67
#define ERROR_LOGRANGE 					68
#define ERROR_STRINGMAXLEN 				69
#define ERROR_PRINTERNOTON				71
#define ERROR_PRINTERNOTOFF				72
#define ERROR_PRINTEROPEN				73
#define ERROR_FILEOPERATION				78
#define ERROR_SERIALPARAMETER			79
#define ERROR_LONGRANGE					80
#define ERROR_INTEGERRANGE				81
#define ERROR_SLICESIZE					82
#define ERROR_ARRAYLENGTH2D				83
#define ERROR_EXPECTEDARRAY				84
#define ERROR_VARNULL      				85
#define ERROR_VARCIRCULAR				86
#define ERROR_IMAGERESOURCE				87
#define ERROR_SOUNDRESOURCE				88
#define ERROR_INVALIDRESOURCE			89
#define ERROR_SOUNDFILE      			90
#define ERROR_SOUNDNOTSEEKABLE			91
#define ERROR_SOUNDLENGTH   			92
#define ERROR_DOWNLOAD       			93
#define ERROR_EXPECTEDSOUND       		94
#define ERROR_TOOMANYSOUNDS       		95
#define ERROR_ENVELOPEODD       		96
#define ERROR_ENVELOPEMAX       		97
#define ERROR_HARMONICNUMBER       		98
#define ERROR_HARMONICLIST             	99
#define ERROR_WAVOBSOLETE              100
#define ERROR_SOUNDFILEFORMAT          101
#define ERROR_SOUNDERROR               102
#define ERROR_ONEDIMENSIONAL           103
#define ERROR_WAVEFORMLOGICAL          104
#define ERROR_STRING2NOTE              105
#define ERROR_ARRAYELEMENT             106
#define ERROR_SETTINGSGETACCESS        107
#define ERROR_SETTINGSSETACCESS        108
#define ERROR_INVALIDPROGNAME          109
#define ERROR_INVALIDKEYNAME           110
#define ERROR_SETTINGMAXLEN            111
#define ERROR_SETTINGMAXKEYS           112
#define ERROR_REFNOTASSIGNED           113
#define ERROR_UNEXPECTEDRETURN         114
#define ERROR_NEXTNOFOR                115
#define ERROR_SQRRANGE                 116
#define ERROR_ASINACOSRANGE            117
#define ERROR_STRINGCONV				118
#define ERROR_BOOLEANCONV				119
#define ERROR_ARRAYEXPR					120
#define ERROR_NUMBEREXPR				121
#define ERROR_STRINGEXPR				122
#define ERROR_ZEROORONE					123
#define ERROR_NOTMAP					124
#define ERROR_ARRAYORMAPEXPR			125
#define ERROR_MAPKEY					126
#define ERROR_RMDIR						127
#define ERROR_MKDIR						128







// Insert new error codes here


#define ERROR_NOTIMPLEMENTED 			65535


// trapable WARNINGS (same as error with warning bit set)
#define WARNING_START					65536
#define WARNING_NUMBERCONV				WARNING_START + ERROR_NUMBERCONV
#define WARNING_STRINGCONV				WARNING_START + ERROR_STRINGCONV
#define WARNING_BOOLEANCONV				WARNING_START + ERROR_BOOLEANCONV
#define WARNING_VARNOTASSIGNED 			WARNING_START + ERROR_VARNOTASSIGNED
#define WARNING_LONGRANGE 				WARNING_START + ERROR_LONGRANGE
#define WARNING_INTEGERRANGE 			WARNING_START + ERROR_INTEGERRANGE
#define WARNING_SOUNDNOTSEEKABLE		WARNING_START + ERROR_SOUNDNOTSEEKABLE
#define WARNING_SOUNDLENGTH     		WARNING_START + ERROR_SOUNDLENGTH
#define WARNING_WAVOBSOLETE             WARNING_START + ERROR_WAVOBSOLETE
#define WARNING_SOUNDFILEFORMAT         WARNING_START + ERROR_SOUNDFILEFORMAT
#define WARNING_SOUNDERROR              WARNING_START + ERROR_SOUNDERROR
#define WARNING_STRING2NOTE             WARNING_START + ERROR_STRING2NOTE
#define WARNING_ARRAYELEMENT            WARNING_START + ERROR_ARRAYELEMENT
#define WARNING_REFNOTASSIGNED          WARNING_START + ERROR_REFNOTASSIGNED
#define WARNING_MAPKEY					WARNING_START + ERROR_MAPKEY



//
#endif
