package org.basex.test.query.func;

import org.basex.test.query.*;

/**
 * XQuery functions tests.
 *
 * @author BaseX Team 2005-12, BSD License
 * @author Christian Gruen
 */
public final class FNFormatDETest extends QueryTest {
  /** Constructor. */
  static {
    doc = "<dummy/>";

    queries = new Object[][] {
      { "de0", str("null"), "format-integer(0, 'w', 'de')" },
      { "de1", str("eins"), "format-integer(1, 'w', 'de')" },
      { "de2", str("zwei"), "format-integer(2, 'w', 'de')" },
      { "de3", str("drei"), "format-integer(3, 'w', 'de')" },
      { "de4", str("vier"), "format-integer(4, 'w', 'de')" },
      { "de5", str("f\u00fcnf"), "format-integer(5, 'w', 'de')" },
      { "de6", str("sechs"), "format-integer(6, 'w', 'de')" },
      { "de7", str("sieben"), "format-integer(7, 'w', 'de')" },
      { "de8", str("acht"), "format-integer(8, 'w', 'de')" },
      { "de9", str("neun"), "format-integer(9, 'w', 'de')" },
      { "de10", str("zehn"), "format-integer(10, 'w', 'de')" },
      { "de11", str("elf"), "format-integer(11, 'w', 'de')" },
      { "de12", str("zw\u00f6lf"), "format-integer(12, 'w', 'de')" },
      { "de13", str("dreizehn"), "format-integer(13, 'w', 'de')" },
      { "de14", str("vierzehn"), "format-integer(14, 'w', 'de')" },
      { "de15", str("f\u00fcnfzehn"), "format-integer(15, 'w', 'de')" },
      { "de16", str("sechzehn"), "format-integer(16, 'w', 'de')" },
      { "de17", str("siebzehn"), "format-integer(17, 'w', 'de')" },
      { "de18", str("achtzehn"), "format-integer(18, 'w', 'de')" },
      { "de19", str("neunzehn"), "format-integer(19, 'w', 'de')" },
      { "de20", str("zwanzig"), "format-integer(20, 'w', 'de')" },
      { "de21", str("einundzwanzig"), "format-integer(21, 'w', 'de')" },
      { "de22", str("zweiundzwanzig"), "format-integer(22, 'w', 'de')" },
      { "de23", str("dreiundzwanzig"), "format-integer(23, 'w', 'de')" },
      { "de24", str("vierundzwanzig"), "format-integer(24, 'w', 'de')" },
      { "de25", str("f\u00fcnfundzwanzig"), "format-integer(25, 'w', 'de')" },
      { "de26", str("sechsundzwanzig"), "format-integer(26, 'w', 'de')" },
      { "de27", str("siebenundzwanzig"), "format-integer(27, 'w', 'de')" },
      { "de28", str("achtundzwanzig"), "format-integer(28, 'w', 'de')" },
      { "de29", str("neunundzwanzig"), "format-integer(29, 'w', 'de')" },
      { "de30", str("drei\u00dfig"), "format-integer(30, 'w', 'de')" },
      { "de31", str("einunddrei\u00dfig"), "format-integer(31, 'w', 'de')" },
      { "de32", str("zweiunddrei\u00dfig"), "format-integer(32, 'w', 'de')" },
      { "de33", str("dreiunddrei\u00dfig"), "format-integer(33, 'w', 'de')" },
      { "de34", str("vierunddrei\u00dfig"), "format-integer(34, 'w', 'de')" },
      { "de35", str("f\u00fcnfunddrei\u00dfig"), "format-integer(35, 'w', 'de')" },
      { "de36", str("sechsunddrei\u00dfig"), "format-integer(36, 'w', 'de')" },
      { "de37", str("siebenunddrei\u00dfig"), "format-integer(37, 'w', 'de')" },
      { "de38", str("achtunddrei\u00dfig"), "format-integer(38, 'w', 'de')" },
      { "de39", str("neununddrei\u00dfig"), "format-integer(39, 'w', 'de')" },
      { "de40", str("vierzig"), "format-integer(40, 'w', 'de')" },
      { "de41", str("einundvierzig"), "format-integer(41, 'w', 'de')" },
      { "de42", str("zweiundvierzig"), "format-integer(42, 'w', 'de')" },
      { "de43", str("dreiundvierzig"), "format-integer(43, 'w', 'de')" },
      { "de44", str("vierundvierzig"), "format-integer(44, 'w', 'de')" },
      { "de45", str("f\u00fcnfundvierzig"), "format-integer(45, 'w', 'de')" },
      { "de46", str("sechsundvierzig"), "format-integer(46, 'w', 'de')" },
      { "de47", str("siebenundvierzig"), "format-integer(47, 'w', 'de')" },
      { "de48", str("achtundvierzig"), "format-integer(48, 'w', 'de')" },
      { "de49", str("neunundvierzig"), "format-integer(49, 'w', 'de')" },
      { "de50", str("f\u00fcnfzig"), "format-integer(50, 'w', 'de')" },
      { "de51", str("einundf\u00fcnfzig"), "format-integer(51, 'w', 'de')" },
      { "de52", str("zweiundf\u00fcnfzig"), "format-integer(52, 'w', 'de')" },
      { "de53", str("dreiundf\u00fcnfzig"), "format-integer(53, 'w', 'de')" },
      { "de54", str("vierundf\u00fcnfzig"), "format-integer(54, 'w', 'de')" },
      { "de55", str("f\u00fcnfundf\u00fcnfzig"), "format-integer(55, 'w', 'de')" },
      { "de56", str("sechsundf\u00fcnfzig"), "format-integer(56, 'w', 'de')" },
      { "de57", str("siebenundf\u00fcnfzig"), "format-integer(57, 'w', 'de')" },
      { "de58", str("achtundf\u00fcnfzig"), "format-integer(58, 'w', 'de')" },
      { "de59", str("neunundf\u00fcnfzig"), "format-integer(59, 'w', 'de')" },
      { "de60", str("sechzig"), "format-integer(60, 'w', 'de')" },
      { "de61", str("einundsechzig"), "format-integer(61, 'w', 'de')" },
      { "de62", str("zweiundsechzig"), "format-integer(62, 'w', 'de')" },
      { "de63", str("dreiundsechzig"), "format-integer(63, 'w', 'de')" },
      { "de64", str("vierundsechzig"), "format-integer(64, 'w', 'de')" },
      { "de65", str("f\u00fcnfundsechzig"), "format-integer(65, 'w', 'de')" },
      { "de66", str("sechsundsechzig"), "format-integer(66, 'w', 'de')" },
      { "de67", str("siebenundsechzig"), "format-integer(67, 'w', 'de')" },
      { "de68", str("achtundsechzig"), "format-integer(68, 'w', 'de')" },
      { "de69", str("neunundsechzig"), "format-integer(69, 'w', 'de')" },
      { "de70", str("siebzig"), "format-integer(70, 'w', 'de')" },
      { "de71", str("einundsiebzig"), "format-integer(71, 'w', 'de')" },
      { "de72", str("zweiundsiebzig"), "format-integer(72, 'w', 'de')" },
      { "de73", str("dreiundsiebzig"), "format-integer(73, 'w', 'de')" },
      { "de74", str("vierundsiebzig"), "format-integer(74, 'w', 'de')" },
      { "de75", str("f\u00fcnfundsiebzig"), "format-integer(75, 'w', 'de')" },
      { "de76", str("sechsundsiebzig"), "format-integer(76, 'w', 'de')" },
      { "de77", str("siebenundsiebzig"), "format-integer(77, 'w', 'de')" },
      { "de78", str("achtundsiebzig"), "format-integer(78, 'w', 'de')" },
      { "de79", str("neunundsiebzig"), "format-integer(79, 'w', 'de')" },
      { "de80", str("achtzig"), "format-integer(80, 'w', 'de')" },
      { "de81", str("einundachtzig"), "format-integer(81, 'w', 'de')" },
      { "de82", str("zweiundachtzig"), "format-integer(82, 'w', 'de')" },
      { "de83", str("dreiundachtzig"), "format-integer(83, 'w', 'de')" },
      { "de84", str("vierundachtzig"), "format-integer(84, 'w', 'de')" },
      { "de85", str("f\u00fcnfundachtzig"), "format-integer(85, 'w', 'de')" },
      { "de86", str("sechsundachtzig"), "format-integer(86, 'w', 'de')" },
      { "de87", str("siebenundachtzig"), "format-integer(87, 'w', 'de')" },
      { "de88", str("achtundachtzig"), "format-integer(88, 'w', 'de')" },
      { "de89", str("neunundachtzig"), "format-integer(89, 'w', 'de')" },
      { "de90", str("neunzig"), "format-integer(90, 'w', 'de')" },
      { "de91", str("einundneunzig"), "format-integer(91, 'w', 'de')" },
      { "de92", str("zweiundneunzig"), "format-integer(92, 'w', 'de')" },
      { "de93", str("dreiundneunzig"), "format-integer(93, 'w', 'de')" },
      { "de94", str("vierundneunzig"), "format-integer(94, 'w', 'de')" },
      { "de95", str("f\u00fcnfundneunzig"), "format-integer(95, 'w', 'de')" },
      { "de96", str("sechsundneunzig"), "format-integer(96, 'w', 'de')" },
      { "de97", str("siebenundneunzig"), "format-integer(97, 'w', 'de')" },
      { "de98", str("achtundneunzig"), "format-integer(98, 'w', 'de')" },
      { "de99", str("neunundneunzig"), "format-integer(99, 'w', 'de')" },
      { "de100", str("einhundert"), "format-integer(100, 'w', 'de')" },
      { "de101", str("einhunderteins"), "format-integer(101, 'w', 'de')" },
      { "de109", str("einhundertneun"), "format-integer(109, 'w', 'de')" },
      { "de110", str("einhundertzehn"), "format-integer(110, 'w', 'de')" },
      { "de111", str("einhundertelf"), "format-integer(111, 'w', 'de')" },
      { "de190", str("einhundertneunzig"), "format-integer(190, 'w', 'de')" },
      { "de199", str("einhundertneunundneunzig"), "format-integer(199, 'w', 'de')" },
      { "de200", str("zweihundert"), "format-integer(200, 'w', 'de')" },
      { "de201", str("zweihunderteins"), "format-integer(201, 'w', 'de')" },
      { "de999", str("neunhundertneunundneunzig"), "format-integer(999, 'w', 'de')" },
      { "de1000", str("eintausend"), "format-integer(1000, 'w', 'de')" },
      { "de1001", str("eintausendeins"), "format-integer(1001, 'w', 'de')" },
      { "de1009", str("eintausendneun"), "format-integer(1009, 'w', 'de')" },
      { "de1010", str("eintausendzehn"), "format-integer(1010, 'w', 'de')" },
      { "de1011", str("eintausendelf"), "format-integer(1011, 'w', 'de')" },
      { "de1111", str("eintausendeinhundertelf"), "format-integer(1111, 'w', 'de')" },
      { "de9999", str("neuntausendneunhundertneunundneunzig"),
        "format-integer(9999, 'w', 'de')" },
      { "de999999", str("neunhundertneunundneunzigtausendneunhundertneunundneunzig"),
          "format-integer(999999, 'w', 'de')" },
      { "de999999999", str("neunhundertneunundneunzig millionen " +
          "neunhundertneunundneunzigtausendneunhundertneunundneunzig"),
          "format-integer(999999999, 'w', 'de')" },

      { "de0.", str("nullte"), "format-integer(0, 'w;o', 'de')" },
      { "de1.", str("erste"), "format-integer(1, 'w;o', 'de')" },
      { "de2.", str("zweite"), "format-integer(2, 'w;o', 'de')" },
      { "de3.", str("dritte"), "format-integer(3, 'w;o', 'de')" },
      { "de4.", str("vierte"), "format-integer(4, 'w;o', 'de')" },
      { "de5.", str("f\u00fcnfte"), "format-integer(5, 'w;o', 'de')" },
      { "de6.", str("sechste"), "format-integer(6, 'w;o', 'de')" },
      { "de7.", str("siebte"), "format-integer(7, 'w;o', 'de')" },
      { "de8.", str("achte"), "format-integer(8, 'w;o', 'de')" },
      { "de9.", str("neunte"), "format-integer(9, 'w;o', 'de')" },
      { "de10.", str("zehnte"), "format-integer(10, 'w;o', 'de')" },
      { "de11.", str("elfte"), "format-integer(11, 'w;o', 'de')" },
      { "de12.", str("zw\u00f6lfte"), "format-integer(12, 'w;o', 'de')" },
      { "de13.", str("dreizehnte"), "format-integer(13, 'w;o', 'de')" },
      { "de14.", str("vierzehnte"), "format-integer(14, 'w;o', 'de')" },
      { "de15.", str("f\u00fcnfzehnte"), "format-integer(15, 'w;o', 'de')" },
      { "de16.", str("sechzehnte"), "format-integer(16, 'w;o', 'de')" },
      { "de17.", str("siebzehnte"), "format-integer(17, 'w;o', 'de')" },
      { "de18.", str("achtzehnte"), "format-integer(18, 'w;o', 'de')" },
      { "de19.", str("neunzehnte"), "format-integer(19, 'w;o', 'de')" },
      { "de20.", str("zwanzigste"), "format-integer(20, 'w;o', 'de')" },
      { "de21.", str("einundzwanzigste"), "format-integer(21, 'w;o', 'de')" },
      { "de22.", str("zweiundzwanzigste"), "format-integer(22, 'w;o', 'de')" },
      { "de23.", str("dreiundzwanzigste"), "format-integer(23, 'w;o', 'de')" },
      { "de99.", str("neunundneunzigste"), "format-integer(99, 'w;o', 'de')" },
      { "de999.", str("neunhundertneunundneunzigste"),
        "format-integer(999, 'w;o', 'de')" },
      { "de9999.", str("neuntausendneunhundertneunundneunzigste"),
        "format-integer(9999, 'w;o', 'de')" },
      { "de999999.", str("neunhundertneunundneunzigtausendneunhundertneunundneunzigste"),
        "format-integer(999999, 'w;o', 'de')" },
      { "de100.", str("einhundertste"), "format-integer(100, 'w;o', 'de')" },
      { "de1000.", str("eintausendste"), "format-integer(1000, 'w;o', 'de')" },
      { "de10000.", str("zehntausendste"), "format-integer(10000, 'w;o', 'de')" },
      { "de100000.", str("einhunderttausendste"), "format-integer(100000, 'w;o', 'de')" },
      { "de1000000.", str("millionste"), "format-integer(1000000, 'w;o', 'de')" },
    };
  }
}
