#! /usr/bin/env python

# BalazarBrothers
# Copyright (C) 2003-2007 Jean-Baptiste LAMY -- jiba@tuxfamily
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os, os.path, glob, re, distutils.core, distutils.sysconfig
from distutils.core import setup

HERE = os.path.abspath(os.path.dirname(sys.argv[0]))


if   "--2d" in sys.argv:
  sys.argv.remove("--2d")
  mode          = "2d"
  name          = "Balazar3_2d"
  extra_descr   = " (2D SDL + Pygame version, 640x480, 800x480)"
  extra_modules = ["balazar3.sprites"]
  
  if "sdist" in sys.argv:
    s = open(os.path.join(os.path.dirname(__file__), "globdef.py")).read()
    s = re.sub(r"AVAILABLE_DRIVERS = .*", 'AVAILABLE_DRIVERS = ["2d", "2d800x480"]', s)
    open(os.path.join(os.path.dirname(__file__), "globdef.py"), "w").write(s)
    
elif "--3d" in sys.argv:
  sys.argv.remove("--3d")
  mode        = "3d"
  name        = "Balazar3_3d"
  extra_descr = " (3D OpenGL + OpenAL + Soya version)"
  extra_modules = []
  
  if "sdist" in sys.argv:
    s = open(os.path.join(os.path.dirname(__file__), "globdef.py")).read()
    s = re.sub(r"AVAILABLE_DRIVERS = .*", 'AVAILABLE_DRIVERS = ["3d"]', s)
    open(os.path.join(os.path.dirname(__file__), "globdef.py"), "w").write(s)
    
elif "--server" in sys.argv:
  sys.argv.remove("--server")
  mode        = "server"
  name        = "Balazar3_server"
  extra_descr = " (Server version)"
  extra_modules = []
  
  if "sdist" in sys.argv:
    s = open(os.path.join(os.path.dirname(__file__), "globdef.py")).read()
    s = re.sub(r"AVAILABLE_DRIVERS = .*", 'AVAILABLE_DRIVERS = ["dummy"]', s)
    open(os.path.join(os.path.dirname(__file__), "globdef.py"), "w").write(s)
    
else:
  mode          = ""
  name          = "Balazar3"
  extra_descr   = " (2D + 3D version, with full graphic sources)"
  if os.path.exists(os.path.join(os.path.dirname(__file__), "sprites")):
    extra_modules = ["balazar3.sprites"]
  else:
    extra_modules = []
    
  if "sdist" in sys.argv:
    s = open(os.path.join(os.path.dirname(__file__), "globdef.py")).read()
    s = re.sub(r"AVAILABLE_DRIVERS = .*", 'AVAILABLE_DRIVERS = ["3d", "2d", "2d800x480"]', s)
    open(os.path.join(os.path.dirname(__file__), "globdef.py"), "w").write(s)


if "--no-lang" in sys.argv:
  sys.argv.remove("--no-lang")
  no_lang = 1
else: no_lang = 0

if "sdist" in sys.argv:
  if   mode == "2d":
    sys.argv += ["-t", "MANIFEST_2d.in"]
  elif mode == "3d":
    sys.argv += ["-t", "MANIFEST_3d.in"]
  elif mode == "server":
    sys.argv += ["-t", "MANIFEST_server.in"]
  
data_files = []
def walker(dummy, dir, files):
  if "CVS"  in dir: return
  if ".svn" in dir: return
  dir2 = dir[len(HERE):]
  if dir2[0] == "/": dir2 = dir2[1:]
  dir2 = os.path.join("balazar3", dir2)
  files = map(lambda file: os.path.join(dir, file), files)
  files = filter(lambda file: os.path.isfile(file) and (not "CVS" in file) and (not ".svn" in file), files)
  data_files.append((dir2, files))

subdirs_2d = [
  "room_shots",
  "sounds",
  "sprites",
  ]
subdirs_3d = [
  "animated_models",
  "images",
  "materials",
  "models",
  "sounds",
  "worlds",
  ]
subdirs_all = list(set(subdirs_2d + subdirs_3d)) + [
  "scripts",
  "blender",
  ]

if   mode == "2d": subdirs = subdirs_2d
elif mode == "3d": subdirs = subdirs_3d
else:              subdirs = subdirs_all

for path in subdirs:
  path = os.path.abspath(os.path.join(HERE, path))
  os.path.walk(path, walker, None)
  

if not no_lang:
  data_files = data_files + [
    (os.path.join("balazar3", os.path.dirname(mo_file)), [mo_file])
    for mo_file
    in  glob.glob(os.path.join(".", "locale", "*", "LC_MESSAGES", "*"))
    ]

distutils.core.setup(
  name         = name,
  version      = "0.1",
  license      = "GPL",
  description  = "A dungeon game%s." % extra_descr,
  long_description  = """A dungeon game with Balazar%s.""" % extra_descr,
  author       = "Jiba (LAMY Jean-Baptiste)",
  author_email = "jibalamy@free.fr",
  url          = "http://home.gna.org/oomadness/en/balazar3/index.html",
  classifiers  = [
  "Topic :: Games/Entertainment",
  "Topic :: Games/Entertainment :: Role-Playing",
  "Natural Language :: French",
  "Natural Language :: English",
  "Programming Language :: Python",
  "Intended Audience :: End Users/Desktop",
  "License :: OSI Approved :: GNU General Public License (GPL)",
  ],
  
  
  scripts      = ["balazar3"],
  package_dir  = {"balazar3" : ""},
  packages     = ["balazar3", "balazar3.tofu", "balazar3.rooms"] + extra_modules,
  
  data_files   = data_files,
  )

