# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, os.path, time
import pygame, pygame.image
from pygame.locals import *

from balazar3.base import *
import balazar3.globdef as globdef


def init(): pass

class MainLoop(BaseMainLoop):
  def play_sound(self, name): pass
  def play_music(self, name): pass
    

class Level(BaseLevel): pass
  

class Animable(object):
  def get_model_name(self): return self.model_name
  def set_model_name(self, name): self.model_name = name
  
  def set_animation_name(self, name):
    self.animation_name = name
    self.animation_pos  = 0
    
  
class Character(BaseCharacter, Animable):
  def _init(self):
    self.animation_name = "attente"
    
  def begin_round(self):
    super(Character, self).begin_round()
    
    self.animation_pos += 1
    
  def do_physics(self):
    BaseCharacter.do_physics(self)
    
    if self.current_action == ACTION_STRIKE:
      if self.animation_pos == 20: self.animation_pos = 0
      
  def create_effect(self, attack): pass
  

class Monster(Character, BaseMonster): pass


class Hero(Character, BaseHero):
  def update_life            (self): pass
  def update_experience_curse(self): pass



class ItemOnGround(BaseItemOnGround): pass

class Chest(BaseChest, Animable): pass
