//
// BAGEL - Parallel electron correlation program.
// Filename: _spin2root_9.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root9(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[9] = {1.474021124075593e+00,4.946915352690749e-01,2.973656939488607e+00,5.036078349072694e+00,7.728623465656647e+00,
    1.115932229544608e+01,1.551236039651168e+01,2.114509255962330e+01,2.897615333485633e+01};
  constexpr double aw[9] = {2.528588711953442e-01,7.732532058348594e-02,2.322651177073763e-01,8.680414559073074e-02,1.436656004370934e-02,
    1.022487319404470e-03,2.748467642551893e-05,2.067763821624008e-07,1.967097882902517e-10};
  constexpr double x[3456] = {  9.046192143052866e-02, -2.061021626986450e-03,  3.354101150862142e-05, -4.511546761448832e-07,  5.073451378048431e-09,
 -4.431223894947505e-11,  1.962780888699505e-13,  2.676025319564373e-15, -9.140597253049773e-17,  1.590885843996236e-18, -1.998236868290505e-20,  1.702700366023436e-22,
  2.600911729804981e-01, -5.420852867577526e-03,  7.226231903860515e-05, -6.238829831536133e-07,  1.087438290722844e-09,  7.489949945520855e-11, -1.508338360514483e-12,
  1.390905707092456e-14,  2.929603150182266e-17, -3.317470531587862e-18,  5.725251630420324e-20, -4.019152936497961e-22,  4.967514110214928e-01, -8.995343277730045e-03,
  8.250158413761201e-05, -2.835163078571356e-08, -1.097696205623464e-08,  1.359441061097494e-10,  3.386907570239690e-13, -3.145746735736234e-14,  3.373535160227953e-16,
  2.505069613861666e-18, -1.114395010423010e-19,  9.309526548561441e-22,  7.802626395299804e-01, -1.154262614191540e-02,  4.740710521689177e-05,  9.015756506368316e-07,
 -1.158492692215273e-08, -9.372426442052445e-11,  2.809143759800964e-12,  3.429970997157564e-15, -6.563442313355823e-16,  3.248055042579250e-18,  1.399459979006160e-19,
 -1.703935032204278e-21,  1.085571701938177e+00, -1.212906365354242e-02, -1.759449226447123e-05,  1.182672607840532e-06,  4.440244332302603e-09, -2.043100200589525e-10,
 -1.246929556717405e-12,  4.245406313428482e-14,  3.619502884527562e-16, -9.608525362494987e-18, -1.082073306289776e-19,  2.278882801150550e-21,  1.384580355891014e+00,
 -1.048843891418575e-02, -7.344213781310283e-05,  4.589820053691917e-07,  1.450564917981278e-08,  4.679156839649721e-11, -2.452314397261757e-12, -3.300579274518518e-14,
  2.404143124491380e-16,  1.019289556796019e-17,  4.142388658569029e-20, -2.168522416033654e-21,  1.648554731998366e+00, -7.178763071007441e-03, -8.611719365272811e-05,
 -4.825775547859269e-07,  4.882383052141920e-09,  1.539513568671173e-10,  1.500902730678038e-12, -6.831010346303831e-15, -4.340005230450493e-16, -5.755561614657558e-18,
  2.333265802267615e-21,  1.409614002602479e-21,  1.851048386802479e+00, -3.433818743333253e-03, -5.455638802683130e-05, -6.694665537648951e-07, -5.883485985396959e-09,
 -1.704866976665802e-11,  6.246541546643012e-13,  1.619712632219471e-14,  2.293355653781612e-16,  1.803933286856885e-18, -7.124234027031174e-21, -5.412887171966931e-22,
  1.971079376954416e+00, -7.121256752709585e-04, -1.297537741784390e-05, -2.057208830001681e-07, -2.977166670318526e-09, -3.987711181731459e-11, -4.945905099258250e-13,
 -5.594426106138200e-15, -5.550769826508973e-17, -4.283589191804772e-19, -1.162477361625167e-21,  4.468737165191408e-23,  8.272206497766216e-02, -1.813034567807658e-03,
  2.858584639711948e-05, -3.767933100419097e-07,  4.238879998722154e-09, -3.898518389174630e-11,  2.378500875074842e-13,  5.274008735220918e-16, -4.677625945154255e-17,
  9.342310424600237e-19, -1.309303806714575e-20,  1.378506640741241e-22,  2.395170958915518e-01, -4.872303185965542e-03,  6.492354337078645e-05, -5.963338689647474e-07,
  2.255106648279332e-09,  4.338329588080389e-11, -1.120777319234178e-12,  1.334038124773468e-14, -5.355212688888057e-17, -1.417916319695023e-18,  3.738505266335585e-20,
 -4.533168920311388e-22,  4.620839677224408e-01, -8.339469106996676e-03,  8.119796626264757e-05, -1.820670600808430e-07, -8.241586729782189e-09,  1.347775743352893e-10,
 -3.830508958299702e-13, -1.999058654891186e-14,  3.584383369341795e-16, -1.007013903983644e-18, -6.261847847997609e-20,  1.151664604953638e-21,  7.349145619372389e-01,
 -1.112336343630881e-02,  5.706385800695984e-05,  7.048757471449882e-07, -1.278911779490743e-08, -2.738296965776270e-11,  2.635488398078619e-12, -1.478495027019827e-14,
 -4.591055921664680e-16,  7.106456594053362e-18,  4.978518663016653e-20, -2.146637279079467e-21,  1.036865103418100e+00, -1.221216258806830e-02, -3.115117605302835e-06,
  1.219824282557224e-06,  1.563826586560666e-10, -2.190071376286084e-10,  4.723236100988672e-14,  4.788560452205008e-14, -3.436379971239877e-17, -1.158968482144133e-17,
  1.437339300510240e-20,  2.985892757503295e-21,  1.341492044621567e+00, -1.104995047781562e-02, -6.652209883636047e-05,  6.950670650758863e-07,  1.478402496435906e-08,
 -2.193919141569017e-11, -3.212533107228893e-12, -1.933333402708518e-14,  6.104649576625829e-16,  9.548790744503421e-18, -8.110839933414430e-20, -3.170805909406366e-21,
  1.618427327553038e+00, -7.889290058922622e-03, -9.133171877330397e-05, -3.779657164861807e-07,  8.297224201180929e-09,  1.859210290600267e-10,  1.084984548328857e-12,
 -2.387449828049652e-14, -6.214760966917036e-16, -4.083383477661493e-18,  8.930277284099827e-20,  2.493714869875765e-21,  1.836387044413308e+00, -3.904024343504461e-03,
 -6.316295605536599e-05, -7.653457125481061e-07, -6.033278247531479e-09,  4.271245591161708e-12,  1.189967993397649e-12,  2.446325649664576e-14,  2.818458580968642e-16,
  8.664637365450646e-19, -4.469187797846697e-20, -1.219162518719247e-21,  1.968006404662941e+00, -8.266781694356485e-04, -1.575839867637171e-05, -2.604378884094941e-07,
 -3.907197374765442e-09, -5.384217811247021e-11, -6.784555186935560e-13, -7.621212942162688e-15, -7.108386336449806e-17, -4.115255727108684e-19,  2.756506562610023e-21,
  1.492567650679794e-22,  7.590021611635397e-02, -1.601338128718415e-03,  2.444654080829813e-05, -3.148963604551829e-07,  3.516701948224917e-09, -3.324097613943764e-11,
  2.360618649651768e-13, -5.213133648909628e-16, -2.122735342944383e-17,  5.188443558356263e-19, -7.994417964823182e-21,  9.443159248716823e-23,  2.210222801575509e-01,
 -4.380868413756141e-03,  5.800826348868926e-05, -5.546493225280515e-07,  2.882875614413782e-09,  2.073557962281974e-11, -7.770722415454684e-13,  1.106122124120956e-14,
 -8.223056470755523e-17, -2.919648778182816e-19,  1.979166647755291e-20, -3.349705072573663e-22,  4.300085218535108e-01, -7.700665542750094e-03,  7.830883930422856e-05,
 -2.930351057206464e-07, -5.676804994963775e-09,  1.201152327469984e-10, -7.905484530429599e-13, -9.488937241208058e-15,  2.886657813039505e-16, -2.574537539243802e-18,
 -1.824770806351681e-20,  8.173924744770946e-22,  6.913827617224170e-01, -1.063651727995154e-02,  6.428722153375178e-05,  4.991377707471865e-07, -1.274533318303564e-08,
  2.948657833752149e-11,  2.055999298862571e-12, -2.517519858941931e-14, -1.888595113476032e-16,  7.368177493455328e-18, -3.119625307020191e-20, -1.406638744900560e-21,
  9.880589422233290e-01, -1.217881968067911e-02,  1.139467093521819e-05,  1.187795640549809e-06, -4.106063457530628e-09, -2.022836194453833e-10,  1.312141964114383e-12,
  4.046768746260878e-14, -4.113392415918052e-16, -8.605445121023746e-18,  1.263485422311114e-19,  1.837474702218303e-21,  1.296286312134491e+00, -1.154480409789977e-02,
 -5.679047622718834e-05,  9.237715064080110e-07,  1.354303822343099e-08, -1.030400167359255e-10, -3.434731024411021e-12,  4.806286191200340e-15,  8.629551327517054e-16,
  3.630221766083419e-18, -2.077029093553936e-19, -2.191614226051131e-21,  1.585383703144034e+00, -8.635538824360200e-03, -9.494420457098167e-05, -2.143171146524911e-07,
  1.220981071041769e-08,  2.015859206224537e-10,  1.221927642932295e-13, -4.519876139936612e-14, -6.761889240175893e-16,  1.831692437060883e-18,  2.072023909244038e-19,
  2.569876400195690e-21,  1.819699879447690e+00, -4.447687832579652e-03, -7.291777287442954e-05, -8.593915954187983e-07, -5.601443018245233e-09,  4.208289476303548e-11,
  2.002753055321962e-12,  3.351618003641307e-14,  2.655960598022451e-16, -2.252344923199505e-18, -1.177857600256644e-19, -2.106408235127362e-21,  1.964426148360646e+00,
 -9.663971027315942e-04, -1.929735565628143e-05, -3.325298442137653e-07, -5.165537711300734e-09, -7.295542845527040e-11, -9.256801760433739e-13, -1.009550113086966e-14,
 -8.181296971352770e-17, -1.103230724309494e-19,  1.413441151916290e-20,  4.032286138892523e-22,  6.986336241301226e-02, -1.419972840533779e-03,  2.098442950767002e-05,
 -2.636460037901064e-07,  2.907024050515503e-09, -2.781217001484819e-11,  2.143668914678601e-13, -9.560099060251515e-16, -7.407049281237461e-18,  2.709532633481406e-19,
 -4.658478582185115e-21,  5.898733460894329e-23,  2.043859262665088e-01, -3.942615895648181e-03,  5.163990547989819e-05, -5.061190450227182e-07,  3.134616510187563e-09,
  5.500153340134937e-12, -5.048428670966994e-13,  8.388117829007102e-15, -8.166662853697586e-17,  2.460729488102140e-19,  8.093769020274038e-21, -2.006700014679416e-22,
  4.004345823637541e-01, -7.089629102862731e-03,  7.432317744520831e-05, -3.657491121864185e-07, -3.480734857667706e-09,  9.890852307543756e-11, -9.414854075198735e-13,
 -1.812959731908197e-15,  1.903154032064504e-16, -2.716228466171813e-18,  7.983291992603046e-21,  3.841705891091058e-22,  6.498984079447131e-01, -1.010166661647814e-02,
  6.908079068446909e-05,  3.023623939652215e-07, -1.172178848165125e-08,  6.992261399484767e-11,  1.304035809684192e-12, -2.731762929781136e-14,  4.189567702074496e-17,
  5.198615610925510e-18, -6.953680889390732e-20, -3.541732996324764e-22,  9.396142847918766e-01, -1.203205953398240e-02,  2.512705279688343e-05,  1.091799474820006e-06,
 -7.753805107025690e-09, -1.589305717349532e-10,  2.222084420929442e-12,  2.344680355843561e-14, -6.160182054313511e-16, -2.526217575272690e-18,  1.624776516971897e-19,
 -2.143260819805288e-22,  1.249273612689227e+00, -1.195128843014364e-02, -4.448733885059201e-05,  1.119597674127889e-06,  1.068522089529214e-08, -1.806786524745298e-10,
 -2.906215233483469e-12,  3.276389755149433e-14,  8.277140641117066e-16, -5.830213767372047e-18, -2.433989655090757e-19,  7.823295004343172e-22,  1.549311243510272e+00,
 -9.401753478492798e-03, -9.621158396224326e-05,  1.298004341797482e-08,  1.615619121418531e-08,  1.870098235878236e-10, -1.423826383468539e-12, -6.398643069764478e-14,
 -4.379275710339979e-16,  1.188741839237508e-17,  2.779931733218749e-19,  1.492203344711637e-22,  1.800675086753342e+00, -5.073721821463878e-03, -8.373106560090660e-05,
 -9.393347938205270e-07, -4.198597749561348e-09,  1.022586334091590e-10,  3.040406018248796e-12,  3.961448124663905e-14,  7.548748979309649e-17, -9.011206012555250e-18,
 -2.231066246381282e-19, -2.481138526519162e-21,  1.960224389735506e+00, -1.138261640170654e-03, -2.383594149049008e-05, -4.281598356819395e-07, -6.871233240449424e-09,
 -9.885844882592421e-11, -1.244587523748964e-12, -1.262557228230666e-14, -7.013369288150766e-17,  9.470383573789566e-19,  4.286280713850925e-20,  9.746741560281021e-22,
  6.450024761908721e-02, -1.264002207271656e-03,  1.808227542504885e-05, -2.213135111081969e-07,  2.399955992685011e-09, -2.300752416607510e-11,  1.855172102044157e-13,
 -1.068346729683820e-15, -4.554998116318817e-19,  1.285333711175914e-19, -2.640433152467976e-21,  3.456397634239234e-23,  1.894044459097467e-01, -3.552933291774407e-03,
  4.586910343867614e-05, -4.556688058289831e-07,  3.140996954895894e-09, -4.082945828953545e-12, -3.048752521447533e-13,  5.963708721472015e-15, -6.881195027467027e-17,
  4.252027465987184e-19,  1.579611842033743e-21, -1.021175487532123e-22,  3.732362913726148e-01, -6.513404075217774e-03,  6.966132051892894e-05, -4.068492112019669e-07,
 -1.729449173179788e-09,  7.630444880747999e-11, -9.210880514699908e-13,  2.800880282355470e-15,  1.013926926215738e-16, -2.161989527432173e-18,  1.747192549750167e-20,
  7.489039558788697e-23,  6.106156649937221e-01, -9.537579165357813e-03,  7.163480531035716e-05,  1.274465430577558e-07, -1.007087871456364e-08,  9.234551215571772e-11,
  5.821186037389995e-13, -2.353456227876251e-14,  1.775131698772755e-16,  2.350148769690542e-18, -6.770606689680835e-20,  3.556761019690416e-22,  8.919677851715417e-01,
 -1.178096757776154e-02,  3.738928506234344e-05,  9.453897940356382e-07, -1.035764759364584e-08, -9.999019150755763e-11,  2.597622623446024e-12,  3.482769650769091e-15,
 -5.970713074386326e-16,  3.269479695552456e-18,  1.165209445908034e-19, -1.683172285537719e-21,  1.200845463135936e+00, -1.225083756886032e-02, -3.015693415105191e-05,
  1.258225556746963e-06,  6.462873966882256e-09, -2.366844871678818e-10, -1.662279070185445e-12,  5.413974694581713e-14,  4.597651752686577e-16, -1.391529460815749e-17,
 -1.391305517577104e-19,  3.722148638845982e-21,  1.510172390484346e+00, -1.016615955189120e-02, -9.438913728140542e-05,  2.989121750490669e-07,  1.940331853145511e-08,
  1.302260738946187e-10, -3.332303685170230e-12, -6.907128368836543e-14,  1.798173228213469e-16,  2.179787187340146e-17,  1.810154863173315e-19, -4.806059618514073e-21,
  1.778967740374319e+00, -5.789617366545196e-03, -9.532478253827029e-05, -9.858087299530751e-07, -1.333983874401574e-09,  1.884454400170844e-10,  4.121214825380478e-12,
  3.491912494663028e-14, -4.332554291125425e-16, -1.978629325953123e-17, -3.012038045065243e-19, -4.506220884849475e-22,  1.955254577267799e+00, -1.351531242093339e-03,
 -2.970433987409806e-05, -5.556640815693672e-07, -9.176864374339436e-09, -1.331786421204018e-10, -1.621474129164414e-12, -1.389325884131382e-14,  7.695208989311253e-18,
  3.808023871678186e-18,  1.086297821335606e-19,  2.138857693253612e-21,  5.971761276430832e-02, -1.129347714554199e-03,  1.564247997071922e-05, -1.863636567973508e-07,
  1.981913827013565e-09, -1.891210789701366e-11,  1.559654863682349e-13, -1.026592219593174e-15,  2.593221650016549e-18,  4.869076816335131e-20, -1.443503389902327e-21,
  2.201951718368994e-23,  1.758931825981928e-01, -3.207006740428561e-03,  4.069877569155397e-05, -4.064112014796453e-07,  2.998468689560461e-09, -9.630583011623103e-12,
 -1.663754553339058e-13,  4.011356044201351e-15, -5.325339622934803e-17,  4.198106905352850e-19, -1.360106515366303e-21, -3.443619001304865e-23,  3.482658148254933e-01,
 -5.976004347957108e-03,  6.465965994672646e-05, -4.234803972322777e-07, -4.164613968346360e-10,  5.543906837266537e-11, -8.079581223618843e-13,  4.938087906760407e-15,
  3.643534648413716e-17, -1.449591187564448e-18,  1.716737456882832e-20, -5.991023933381193e-23,  5.736175139128692e-01, -8.960978333430092e-03,  7.226018382400947e-05,
 -1.836482793759453e-08, -8.134052528027336e-09,  9.911100755715614e-11,  1.188010939427419e-14, -1.698586337910788e-14,  2.181211556593577e-16,  5.660320688966940e-20,
 -4.516816333625499e-20,  6.077667069697559e-22,  8.455098430703245e-01, -1.143942183275040e-02,  4.768460796145567e-05,  7.670522933804891e-07, -1.173671468293684e-08,
 -3.849892571624684e-11,  2.450867480079372e-12, -1.299595940520685e-14, -4.147804230856632e-16,  6.308840499385889e-18,  3.445443776414860e-20, -1.824420148781455e-21,
  1.151457219983769e+00, -1.243031149810917e-02, -1.459955808392503e-05,  1.322133492800936e-06,  1.459541332919228e-09, -2.572185356672689e-10, -2.136571605995963e-14,
  6.011017396297611e-14, -9.804274053108417e-17, -1.582430118306226e-17,  4.775797272609882e-20,  4.280691795692476e-21,  1.468027915805810e+00, -1.090148063429135e-02,
 -8.886934648363399e-05,  6.252199429605886e-07,  2.105801482864490e-08,  2.845617891000552e-11, -5.060648040573387e-12, -4.986719526241502e-14,  1.030517587789231e-15,
  2.337937795271688e-17, -1.313781997742247e-19, -8.743929986241015e-21,  1.754209064139556e+00, -6.599574433356598e-03, -1.071399473212293e-04, -9.713321355986544e-07,
  3.492022156516660e-09,  2.967801003599285e-10,  4.781397983342761e-12,  7.384106362257445e-15, -1.353012552826516e-15, -3.058948728452930e-17, -1.877459760832335e-19,
  6.587839489807079e-21,  1.949327143490472e+00, -1.618550760742983e-03, -3.734839082046307e-05, -7.260467034532408e-07, -1.226029411599417e-08, -1.765725704612452e-10,
 -1.979236397875007e-12, -1.040057326624996e-14,  2.503640974701163e-16,  1.056255088314374e-17,  2.437001250402137e-19,  4.138807216127505e-21,  5.543706270894172e-02,
 -1.012641722592740e-03,  1.358453036401175e-05, -1.574851810933970e-07,  1.638829106457511e-09, -1.550322710458678e-11,  1.285774246157353e-13, -9.248638105690497e-16,
  3.533666651531259e-18,  9.820778582706938e-21, -4.851901700725316e-22,  2.399766457613524e-23,  1.636865793480969e-01, -2.900124560971729e-03,  3.610273169876905e-05,
 -3.601586509599739e-07,  2.774087189882182e-09, -1.245480665745134e-11, -7.572965175608128e-14,  2.536688576852602e-15, -3.931770931723161e-17,  3.535342800258541e-19,
 -1.483759841389090e-21,  3.023113313188709e-23,  3.253641103324921e-01, -5.479089741573269e-03,  5.957122475563982e-05, -4.222782971781108e-07,  5.101027092098911e-10,
  3.779540427758270e-11, -6.603008046876978e-13,  5.396079169343304e-15, -4.065019594271863e-18, -8.178453715208603e-19,  1.463793987013241e-20, -3.094517608521882e-23,
  5.389254421518904e-01, -8.385840832936848e-03,  7.132399244119217e-05, -1.327840187121983e-07, -6.183462015680893e-09,  9.446833939378585e-11, -3.678768830915939e-13,
 -1.026867200482762e-14,  1.942397136365906e-16, -1.199651171869589e-18, -1.743538173669727e-20,  6.401370041999010e-22,  8.005688466781904e-01, -1.102435731427856e-02,
  5.574705703473490e-05,  5.761530075223111e-07, -1.195479801363190e-08,  1.467109462047227e-11,  1.936346539853709e-12, -2.251408556127886e-14, -1.803017818870354e-16,
  6.302582581403076e-18, -2.780447324909654e-20, -8.812529020105746e-22,  1.101602911383889e+00, -1.248363692076472e-02,  1.237839228419212e-06,  1.304862656047526e-06,
 -3.557616965076015e-09, -2.383933004847792e-10,  1.536805867745974e-12,  4.857162220757269e-14, -5.916883870033153e-16, -1.058699760520132e-17,  1.998977546101562e-19,
  2.368746911179244e-21,  1.423055687226110e+00, -1.157669874080821e-02, -7.934884786637825e-05,  9.597038442795459e-07,  2.032185000428623e-08, -1.053057239799881e-10,
 -5.880339645820140e-12, -5.192175227082512e-15,  1.685361111600354e-15,  1.060388723619032e-17, -4.876452191502232e-19, -6.007112380688190e-21,  1.726024692663533e+00,
 -7.501876565634257e-03, -1.182446763614944e-04, -8.617711527217692e-07,  1.056217040959826e-08,  4.080703769268276e-10,  4.210331905347208e-12, -5.422385802259091e-14,
 -2.490281832295763e-15, -2.904061435028040e-17,  3.507464165155412e-19,  1.817057301329324e-20,  1.942195103218290e+00, -1.955808495017634e-03, -4.736305772432023e-05,
 -9.531214354699677e-07, -1.628390531266408e-08, -2.262352962389529e-10, -2.085438556009744e-12,  5.975393156576206e-15,  8.564620459126846e-16,  2.466348584975345e-17,
  4.782897195646738e-19,  6.413194315878122e-21,  5.159247899254638e-02, -9.111015252208295e-04,  1.184232326938960e-05, -1.335853382864826e-07,  1.357592665206772e-09,
 -1.271509819909028e-11,  1.043036185908073e-13, -8.076267415940054e-16,  3.820629378525359e-18,  1.468682409196485e-20,  8.095399668648453e-22,  3.462198286220508e-23,
  1.526373923702017e-01, -2.627855233781467e-03,  3.203866035171249e-05, -3.178430377853672e-07,  2.511883065888527e-09, -1.355072638466478e-11, -2.046398323654474e-14,
  1.474521301487652e-15, -2.715389959819174e-17,  3.408579337159363e-19,  1.315971331130114e-21,  9.287342734812454e-23,  3.043690626948168e-01, -5.022598446033543e-03,
  5.457514995113089e-05, -4.088796242046894e-07,  1.119600101307912e-09,  2.372337292890820e-11, -5.146582386055833e-13,  4.907198311682906e-15, -2.299717617001163e-17,
 -2.260902007000718e-19,  1.583172460490768e-20,  8.643166186501437e-23,  5.065109815200298e-01, -7.823164388657740e-03,  6.919752917582425e-05, -2.171698568789522e-07,
 -4.402227535181671e-09,  8.284804129051558e-11, -5.755124619947597e-13, -4.823327513379917e-15,  1.453131682775306e-16, -1.331156765970144e-18,  1.086329131852772e-20,
  6.369359542457347e-22,  7.574026160417954e-01, -1.055393961658722e-02,  6.153048637705876e-05,  3.895251439549359e-07, -1.125022751922728e-08,  5.312722025698270e-11,
  1.257427667196547e-12, -2.492138681622310e-14,  2.066143417673706e-17,  4.791722206060960e-18, -3.858293409294723e-20,  3.581883301985142e-22,  1.051785513822850e+00,
 -1.241241568382391e-02,  1.640497386033752e-05,  1.212221826524326e-06, -7.858826204971816e-09, -1.876222032818631e-10,  2.586403478969702e-12,  2.524234490539391e-14,
 -8.104776845704162e-16, -1.237533968095161e-18,  2.503119624518470e-19,  1.979692872467815e-23,  1.375559778235930e+00, -1.216010586763280e-02, -6.597570855410909e-05,
  1.260399890851434e-06,  1.682514729274105e-08, -2.418761700774502e-10, -5.242402942494441e-12,  5.071506145473691e-14,  1.675579257131272e-15, -1.154413174978213e-17,
 -5.443344028501121e-19,  4.188428788055110e-21,  1.694064691597257e+00, -8.485673404600826e-03, -1.272866758718183e-04, -6.226842030571534e-07,  1.956092755013697e-08,
  4.810671835073916e-10,  1.448502783384672e-12, -1.461914353766978e-13, -3.064491117079537e-15,  3.666861530404359e-18,  1.326635996178800e-18,  2.355992280366664e-20,
  1.933534895095702e+00, -2.385253003925309e-03, -6.052157873220515e-05, -1.252456462446323e-06, -2.127555144556078e-08, -2.702146816591638e-10, -1.371343237566849e-12,
  5.184883176289187e-14,  2.158730517180929e-15,  4.957693416052449e-17,  7.590632522660382e-19,  5.080253423589110e-21,  4.812789448061255e-02, -8.224242505195804e-04,
  1.036165632904379e-05, -1.137696904446779e-07,  1.126566400234564e-09, -1.046857169020559e-11,  8.354325996695735e-14, -6.676399218675920e-16,  5.302131100765638e-18,
  7.730533772267220e-20,  2.241630641429500e-21,  2.283466105111199e-23,  1.426153711959258e-01, -2.386139892025307e-03,  2.845668918324810e-05, -2.798352886615185e-07,
  2.238844047534291e-09, -1.363270249478969e-11,  1.062347023424777e-14,  8.205182174340757e-16, -1.289465419428410e-17,  4.795568366343577e-19,  5.476822074226191e-21,
  7.088337097154349e-23,  2.851212687094349e-01, -4.605287012157691e-03,  4.978968350409613e-05, -3.877962286157984e-07,  1.481234005002255e-09,  1.293429406542205e-11,
 -3.878622313922214e-13,  4.171924291222918e-15, -1.865739982354122e-17,  4.976778763804341e-19,  2.022318837155214e-20,  6.234006568417528e-23,  4.763074487188811e-01,
 -7.281084852415482e-03,  6.622102192718147e-05, -2.751372707404349e-07, -2.891786088780879e-09,  6.790060188975823e-11, -6.517627908790757e-13, -8.032692324374507e-16,
  1.116459635682596e-16, -3.772616308293172e-19,  3.499908530773945e-20,  3.756544234906241e-22,  7.161967476455332e-01, -1.004596833987358e-02,  6.516450084209591e-05,
  2.194275819024027e-07, -9.941395124888043e-09,  7.515641357533827e-11,  5.929507047604324e-13, -2.175181035890554e-14,  1.714301315081440e-16,  3.793406029420736e-18,
 -7.960834546574870e-21,  8.020718270161007e-22,  1.002487094546196e+00, -1.222538914058800e-02,  3.008481266542925e-05,  1.060021452957980e-06, -1.094835470046605e-08,
 -1.199704158881291e-10,  2.937025448050033e-12,  4.962286638465151e-16, -6.794252346865206e-16,  8.270364974432059e-18,  2.130699665267122e-19, -1.657357848401563e-21,
  1.325965457434522e+00, -1.262324514829364e-02, -4.941590982869949e-05,  1.484651482888797e-06,  1.087364483726698e-08, -3.451163814002560e-10, -3.161112788049562e-12,
  9.403536795790262e-14,  9.413652423542233e-16, -2.654943171927420e-17, -1.426753450918264e-19,  1.265313579535469e-20,  1.658046568710833e+00, -9.527799288977403e-03,
 -1.325616857161965e-04, -2.324353342229137e-07,  2.914308533786359e-08,  4.561651938761883e-10, -3.913951286619218e-12, -2.300509260071515e-13, -1.757263778451930e-15,
  7.370398372979846e-17,  2.018494787546353e-18,  1.882712162479853e-21,  1.922921628931927e+00, -2.935749737428867e-03, -7.777590632460485e-05, -1.637230582578642e-06,
 -2.684324405031998e-08, -2.760331222857866e-10,  1.359374082666095e-12,  1.556145302685684e-13,  4.516639088372748e-15,  8.109056235593593e-17,  6.899335569610972e-19,
 -1.276687231379086e-20,  4.499574996072685e-02, -7.447007534386571e-04,  9.097997595925346e-06, -9.731663080923213e-08,  9.358435035616857e-10, -8.665465280139113e-12,
  6.777342598757530e-14, -4.351004089936452e-16,  9.793461249248851e-18,  1.696837981618167e-19,  1.799337056684745e-21, -5.663345532755230e-23,  1.335056837264856e-01,
 -2.171330102407864e-03,  2.530466183920076e-05, -2.461739708102245e-07,  1.970433139930452e-09, -1.313110465007073e-11,  3.074042966120896e-14,  7.297786232774629e-16,
  8.629717878273740e-18,  7.096267349880184e-19,  4.287718058559479e-21, -1.681717521868606e-22,  2.674678738940219e-01, -4.225164300132360e-03,  4.528533170165000e-05,
 -3.624939996077726e-07,  1.656036953744802e-09,  4.982080716739287e-12, -2.755940806757779e-13,  4.017788273509055e-15,  1.363672334408663e-17,  1.260994498924659e-18,
  1.445811474034677e-20, -4.169243225157832e-22,  4.482207538873189e-01, -6.765212153348971e-03,  6.268382100509130e-05, -3.113920954001996e-07, -1.689948630624832e-09,
  5.238979588927688e-11, -6.242258047261117e-13,  2.841920144828184e-15,  1.252376872335797e-16,  1.119305856952798e-18,  3.233423459599873e-20, -6.550967104378454e-22,
  6.770685210483297e-01, -9.516705584649386e-03,  6.689483029546942e-05,  7.296917579110548e-08, -8.341555718843064e-09,  8.282400249782016e-11,  8.113446251902001e-14,
 -1.408602881276094e-14,  3.086789416350842e-16,  3.921387688780540e-18,  4.089065719622379e-21, -6.082480572827280e-22,  9.541430432031718e-01, -1.193696517669062e-02,
  4.168716886946301e-05,  8.694469845075767e-07, -1.265308005261491e-08, -5.144207950423602e-11,  2.702039580515159e-12, -1.501206437252652e-14, -2.509409327992161e-16,
  1.475586041768946e-17,  9.409429557244134e-20, -4.030470740757449e-21,  1.274798111596218e+00, -1.294489822887330e-02, -3.079478306219060e-05,  1.600234065964094e-06,
  3.439711464418049e-09, -3.868784847487556e-10, -2.515634912950789e-13,  1.088598689824565e-13,  1.653901104452732e-17, -2.140979946256890e-17,  3.626859090612534e-19,
  7.580113891518082e-21,  1.617808769164897e+00, -1.059087375111883e-02, -1.322748168732531e-04,  2.994690677157353e-07,  3.678484898509864e-08,  2.815771608983186e-10,
 -1.063564745567348e-11, -2.288974353450419e-13,  2.243437427011233e-15,  1.419010071594375e-16,  9.982943576061399e-19, -5.127290337217611e-20,  1.909798950021353e+00,
 -3.644244798743621e-03, -1.001712308204666e-04, -2.107303765721867e-06, -3.158830177700834e-08, -1.719421215759089e-10,  8.206914344923897e-12,  3.503318435237213e-13,
  7.678577336170259e-15,  8.363832774889614e-17, -1.006855865575021e-18, -7.421588404185009e-20,  4.215546154446791e-02, -6.763460365619681e-04,  8.014596451610383e-06,
 -8.364466175633289e-08,  7.780212816024206e-10, -7.143705715147401e-12,  6.095585835768424e-14, -1.728822346620494e-17,  1.623755925159785e-17,  1.516279432831554e-19,
 -3.774321704866074e-21, -2.019446655528671e-22,  1.252072593901783e-01, -1.980192861476504e-03,  2.253122010018337e-05, -2.167001126622804e-07,  1.717108107433137e-09,
 -1.209262339620050e-11,  5.899820557369751e-14,  1.426152191406066e-15,  3.437809317894523e-17,  6.098751827828736e-19, -1.257076266945934e-20, -6.147373815821870e-22,
  2.512648756560031e-01, -3.879825483056094e-03,  4.109661519905095e-05, -3.355199460601607e-07,  1.699092067417320e-09, -1.881100448393825e-13, -1.496461502328051e-13,
  5.241464537749098e-15,  6.274376968140423e-17,  1.217419512984952e-18, -2.348351592567590e-20, -1.344393188559929e-21,  4.221386302032369e-01, -6.279073558568255e-03,
  5.881691605477345e-05, -3.308271441448909e-07, -7.829965152930378e-10,  3.886035537225292e-11, -4.811759142509870e-13,  7.658513854724460e-15,  1.774069792080263e-16,
  1.338297595564527e-18, -3.458364170873581e-20, -2.444444077520540e-21,  6.400745246316484e-01, -8.980187323552985e-03,  6.702436318366553e-05, -4.725042800909835e-08,
 -6.691231003972227e-09,  8.128390077935121e-11, -1.540778963553043e-13, -2.018958002674651e-15,  4.388351235434769e-16,  2.706985383876305e-18, -8.767524508662065e-20,
 -3.704087608088144e-21,  9.071233212148051e-01, -1.156523206194721e-02,  5.088288293854367e-05,  6.621376557259561e-07, -1.307002267828345e-08,  7.962468737796856e-12,
  2.251996061273406e-12, -1.422753444347011e-14,  2.953694291643874e-16,  1.386369368163472e-17, -1.684391896487085e-19, -8.057643644325736e-21,  1.222647969046130e+00,
 -1.311409472211524e-02, -1.151534785696571e-05,  1.594070233332689e-06, -4.113649771479883e-09, -3.568800714313879e-10,  2.710483466546288e-12,  1.002388620321138e-13,
 -4.547027562842937e-16, -4.977957376716224e-18,  3.266235571983211e-19, -1.027928853585550e-20,  1.573366200664696e+00, -1.162436440999087e-02, -1.250143938141251e-04,
  9.172391291941754e-07,  3.940725274112006e-08, -3.760681357532624e-11, -1.524701035219383e-11, -7.301121191883341e-14,  7.388252768356402e-15,  1.220776087688235e-16,
 -2.266295856926984e-18, -8.800645894393015e-20,  1.893446711884534e+00, -4.555530368808953e-03, -1.285597839268588e-04, -2.625659390907613e-06, -3.210924675179201e-08,
  1.728138760114517e-10,  2.180751157437472e-11,  6.282216148286434e-13,  8.893003927084855e-15, -5.395153014577138e-17, -6.748386096144188e-18, -1.926220929781758e-19,
  3.957223904618178e-02, -6.160429252833302e-04,  7.081095391891537e-06, -7.225888530991001e-08,  6.500569001724876e-10, -5.624332868641934e-12,  6.824641543503515e-14,
  5.407300549042824e-16,  1.648111700477622e-17, -2.143836857244737e-19, -1.519071230463237e-20, -2.884093064382892e-22,  1.176311541167299e-01, -1.809895456375946e-03,
  2.008797216138197e-05, -1.910682411401183e-07,  1.493360998313585e-09, -1.005780148753966e-11,  1.165971404170973e-13,  2.720172866824860e-15,  3.966531928155276e-17,
 -5.491203571593797e-19, -4.743492564245723e-20, -8.823851628113696e-22,  2.363782708520028e-01, -3.566696653711455e-03,  3.723287955085947e-05, -3.085052982574895e-07,
  1.672613137372608e-09, -1.760747800786963e-12,  2.977278831770780e-14,  7.638034447562480e-15,  7.311495914693062e-17, -1.145191076461149e-18, -9.891765398910284e-20,
 -1.899824528257385e-21,  3.979380363322238e-01, -5.824575506466285e-03,  5.479566597386941e-05, -3.376800030973402e-07, -1.004510037471917e-10,  3.055610461445504e-11,
 -1.832846740253871e-13,  1.359973463904076e-14,  1.704232192759792e-16, -2.651335943735048e-18, -1.730318964127566e-19, -3.505470250049449e-21,  6.052201659569901e-01,
 -8.447958183664917e-03,  6.586801453529730e-05, -1.414954428230763e-07, -5.098644117025875e-09,  7.855144143374747e-11, -6.296124246453250e-15,  1.253449244260873e-14,
  4.260339061680572e-16, -4.885421437168833e-18, -3.071179176657207e-19, -5.690497207594048e-21,  8.617218619520971e-01, -1.112991083094870e-02,  5.758826815661726e-05,
  4.571169651831705e-07, -1.239531378874284e-08,  5.869423158190979e-11,  2.047365661747765e-12,  1.150545372958053e-15,  5.781038689151744e-16, -9.648951170636836e-19,
 -5.892706507069975e-19, -1.013862191107428e-20,  1.170126233654273e+00, -1.313133592869321e-02,  6.997025760563204e-06,  1.475608739591406e-06, -1.038235336379558e-08,
 -2.598957421853883e-10,  5.297797259739687e-12,  8.414038448084912e-14, -5.550997163501923e-16, -5.983854208413170e-18, -4.761235005650409e-19, -2.351592803240827e-20,
  1.524953115502259e+00, -1.256992098540907e-02, -1.103142956587660e-04,  1.521685960665480e-06,  3.498267458271198e-08, -3.980998693160272e-10, -1.348830342995610e-11,
  2.089004161798470e-13,  9.262780202684996e-15, -3.974840537643449e-17, -5.497652413164860e-18, -4.335324687317581e-20,  1.872956371680911e+00, -5.718294679407105e-03,
 -1.629263718645434e-04, -3.076805676823549e-06, -2.184399457360093e-08,  9.353301952844720e-10,  4.261301668695363e-11,  8.112084447929692e-13, -2.153878931141562e-16,
 -5.196229783912341e-16, -1.675923122764676e-17, -2.139554320115197e-19,  3.721611231085920e-02, -5.626937145136438e-04,  6.272986798969614e-06, -6.266279209667551e-08,
  5.554363192614180e-10, -3.757049821941324e-12,  8.863798436411675e-14,  8.042870714990681e-16, -4.927417129791846e-18, -1.035207255796716e-18, -2.388325119826480e-20,
 -1.019879772935457e-23,  1.106990133663749e-01, -1.657970922716223e-03,  1.793244645262415e-05, -1.686035711024253e-07,  1.326967870634305e-09, -6.235219988465100e-12,
  2.045329083319873e-13,  3.236321565211409e-15, -2.268501921414457e-17, -3.099278691411495e-18, -7.406140092901034e-20, -3.211627295493456e-23,  2.226844034400711e-01,
 -3.283188967230987e-03,  3.369055896603392e-05, -2.819097002780497e-07,  1.662959435667097e-09,  1.715291729741079e-12,  2.638540664166563e-13,  8.402241614985563e-15,
 -5.749856315309511e-17, -6.510306594779893e-18, -1.566015421377826e-19, -9.855659152736079e-23,  3.754908228178226e-01, -5.402400566722227e-03,  5.075363240074373e-05,
 -3.344983448283045e-07,  5.001404221081204e-10,  3.119991729866635e-11,  2.483258344048582e-13,  1.590865672618917e-14, -8.325794203149412e-17, -1.218698238210483e-17,
 -2.808098254402648e-19, -2.609927584911847e-22,  5.724696681163907e-01, -7.929072640036342e-03,  6.373280311145630e-05, -2.103696905881218e-07, -3.493772546536025e-09,
  8.389352069122695e-11,  4.894869673437562e-13,  2.052370744955649e-14, -2.581693753832112e-17, -2.143270041111685e-17, -4.826352948885681e-19, -3.665647293048439e-22,
  8.181537517206132e-01, -1.065052783586249e-02,  6.193122391219934e-05,  2.708991764388067e-07, -1.071744343854868e-08,  1.100927694362965e-10,  2.296174060358888e-12,
  1.374143726736570e-14,  2.338295350205163e-17, -3.193297432912531e-17, -8.904825876754810e-19, -4.501143287416749e-22,  1.117820542157407e+00, -1.300770084559069e-02,
  2.356056422804728e-05,  1.275576763434494e-06, -1.412982405953367e-08, -1.068648542212536e-10,  7.334881077646296e-12,  5.727448657676605e-14, -1.353123424861867e-15,
 -4.415772038846837e-17, -1.325686293861806e-18, -8.449835036314304e-21,  1.473036557398292e+00, -1.337058630694147e-02, -8.900863136664207e-05,  2.002683005218858e-06,
  2.441903084748757e-08, -6.210345636074184e-10, -4.020149579002908e-12,  4.379973662840026e-13,  3.685006412956110e-15, -2.673835304546492e-16, -5.059076512318537e-18,
  6.877139865961170e-20,  1.847236520468492e+00, -7.173513807223426e-03, -2.011272612951016e-04, -3.213650500766558e-06,  8.834125457380274e-09,  2.207555497698736e-09,
  6.141469342051537e-11,  3.627551057242116e-13, -3.234055927772079e-14, -1.264518624529858e-15, -1.592918160214169e-17,  4.214994284640519e-19,  3.506114961653893e-02,
 -5.153714802544478e-04,  5.572268993263246e-06, -5.425452311025641e-08,  5.031309628590295e-10, -1.418124939875036e-12,  1.020932367099978e-13, -1.213862890731661e-16,
 -5.736278775353187e-17, -1.751946209615550e-18, -4.193402923013898e-21,  1.051306576731929e-21,  1.043417343637235e-01, -1.522250990205580e-03,  1.603341856835874e-05,
 -1.480751922449268e-07,  1.257757365200148e-09, -4.439270063160180e-13,  2.643200332579946e-13,  1.921739629686132e-16, -1.813793610099540e-16, -5.331390163935161e-18,
 -1.374220547023778e-20,  3.224222135637447e-21,  2.100699166605041e-01, -3.026738622524246e-03,  3.046973594073537e-05, -2.546107775785590e-07,  1.777499385601170e-09,
  1.040458384619364e-11,  4.298751003296330e-13,  1.682573496834975e-15, -3.918332519996916e-16, -1.125718296589350e-17, -3.037309642698092e-20,  6.794329374867382e-21,
  3.546681148907291e-01, -5.012241152620217e-03,  4.680969455236121e-05, -3.210401992453239e-07,  1.216265604861705e-09,  4.172333840942122e-11,  5.756870400625679e-13,
  4.193136750772666e-15, -7.018821626890554e-16, -2.074278925080346e-17, -5.554040000562655e-20,  1.225713812538053e-20,  5.417559471803414e-01, -7.430125673816934e-03,
  6.093090927329589e-05, -2.520255047594776e-07, -1.655859477962159e-09,  1.016015873728223e-10,  9.111185171114417e-13,  3.861104160631357e-15, -1.106722170924978e-15,
 -3.617796245765217e-17, -1.003343556941143e-19,  2.076761650193134e-20,  7.765592586652293e-01, -1.014480263343753e-02,  6.423582635061265e-05,  1.201455028578000e-07,
 -7.938286538949564e-09,  1.686016350282851e-10,  2.471513319599524e-12, -1.036576198931230e-14, -1.700925006194876e-15, -5.969217201970053e-17, -2.375836386185576e-19,
  3.518038186224941e-20,  1.066258092691022e+00, -1.276192997979961e-02,  3.747270352287779e-05,  1.042400659539368e-06, -1.440972009109656e-08,  8.168545425699238e-11,
  8.020168211799653e-12, -2.159461165456189e-14, -3.856273496318680e-15, -8.946120881543591e-17, -4.609616298435624e-19,  5.713938095502491e-20,  1.418290393321900e+00,
 -1.398084138736345e-02, -6.304737555117688e-05,  2.293062975222869e-06,  1.205350871152925e-08, -5.671296844963563e-10,  8.214175906419959e-12,  3.709609869718914e-13,
 -8.519660167434128e-15, -3.723638375152549e-16,  7.422901043043458e-19,  1.971406475384901e-19,  1.815088671714589e+00, -8.930501827535990e-03, -2.371234619385896e-04,
 -2.638233256901166e-06,  6.775275299298116e-08,  3.641323305423380e-09,  4.968979106001783e-11, -1.463138622153821e-12, -8.113837522619190e-14, -1.112487683664013e-15,
  3.474464538068075e-17,  1.911133777545608e-18,  3.308488807753221e-02, -4.732620078769624e-04,  4.968996814457467e-06, -4.630382221970311e-08,  4.976806597271503e-10,
  7.271944568396839e-13,  6.393657966060262e-14, -2.881847751273749e-15, -1.083514513866253e-16, -5.674271802347768e-19,  7.263873304458385e-20,  2.247665490464183e-21,
  9.849849624031509e-02, -1.400747623006509e-03,  1.437805614699207e-05, -1.276896437604053e-07,  1.308621981669356e-09,  5.135684117379427e-12,  1.608372820269927e-13,
 -8.430901660356119e-15, -3.368414552154053e-16, -1.727717367944394e-18,  2.224307898278646e-19,  6.924686488143194e-21,  1.984318354789990e-01, -2.794699156174848e-03,
  2.759370139462557e-05, -2.239597119058715e-07,  2.083690929662779e-09,  1.950487317077128e-11,  2.430813189661186e-13, -1.681861373817691e-14, -7.210048002516143e-16,
 -3.689640239508635e-18,  4.698005253509536e-19,  1.472518298981725e-20,  3.353442631266119e-01, -4.652774422597154e-03,  4.310392278917549e-05, -2.941680038919085e-07,
  2.182407789748352e-09,  5.373732415423608e-11,  2.709892802070414e-13, -2.927516519128470e-14, -1.311176860382988e-15, -7.036363555611234e-18,  8.537082262334353e-19,
  2.693058270000336e-20,  5.129907623904794e-01, -6.955064027419460e-03,  5.781844003084821e-05, -2.611254122352108e-07,  5.778791513051577e-10,  1.195869155432535e-10,
  3.350929988409557e-13, -5.084322182989291e-14, -2.179879578294419e-15, -1.309605967331179e-17,  1.450057450895265e-18,  4.623305877986443e-20,  7.370142671276191e-01,
 -9.627032067066402e-03,  6.503662214560187e-05,  2.309732870203651e-08, -4.036761339119116e-09,  2.163251184003851e-10,  1.105139919799638e-12, -9.707415593542481e-14,
 -3.509802028438571e-15, -2.322530607681289e-17,  2.398058050412891e-18,  7.913259750434083e-20,  1.015883871822547e+00, -1.241584262772561e-02,  4.868471876109586e-05,
  8.348784676146087e-07, -1.098482160964258e-08,  2.500192853171110e-10,  5.215161361873709e-12, -1.934754697142009e-13, -6.546101184775648e-15, -2.962347424104491e-17,
  4.092387800381819e-18,  1.407921436840245e-19,  1.361536140305184e+00, -1.437265251438369e-02, -3.470511202856642e-05,  2.408713952997427e-06,  3.314108983957498e-09,
 -2.878706276884472e-10,  1.291994429470547e-11, -9.106823901847477e-14, -1.894056158841354e-14, -1.305280291709771e-16,  1.216079532085441e-17,  3.014146023666925e-19,
  1.775405916536315e+00, -1.092983204318884e-02, -2.597163792393292e-04, -9.263350907245874e-07,  1.475619273677082e-07,  4.025806454710324e-09, -3.071348476300873e-11,
 -4.254778440720280e-12, -7.428806002495052e-14,  2.074808791037112e-15,  1.188443923290768e-16,  1.018000214988426e-18,  3.126801795326327e-02, -4.355957656512715e-04,
  4.461786316668132e-06, -3.817569899810121e-08,  5.190164280661417e-10,  9.073985537385598e-13, -6.329263742034089e-14, -5.932602112090683e-15, -5.476281603716814e-17,
  4.002094092784204e-18,  1.372573025068642e-19, -3.566867737385500e-22,  9.311636416067769e-02, -1.291487650567252e-03,  1.297520483174268e-05, -1.058224449318958e-07,
  1.424546658560278e-09,  4.963248155880372e-12, -2.199185083645213e-13, -1.792443734947126e-14, -1.718380752473513e-16,  1.231228768306344e-17,  4.227295110359677e-19,
 -1.047513436912959e-21,  1.876783577607588e-01, -2.584102126761554e-03,  2.511956837503114e-05, -1.873899722745012e-07,  2.480559669242461e-09,  1.711812575217812e-11,
 -5.378800244603472e-13, -3.718785910772169e-14, -3.724960514336226e-16,  2.609306563115253e-17,  8.997453738769160e-19, -2.065126051379702e-21,  3.174014179568962e-01,
 -4.321387245175120e-03,  3.981906131433443e-05, -2.506623725733199e-07,  3.231338937346315e-09,  4.572103570979974e-11, -1.114224508722318e-12, -6.648968142484609e-14,
 -6.868489833188013e-16,  4.735402266829216e-17,  1.650291157396592e-18, -3.374367523115339e-21,  4.860762173022394e-01, -6.504711717026388e-03,  5.481908757838477e-05,
 -2.329351972523245e-07,  2.893911649976861e-09,  1.027245810153791e-10, -2.033772988695282e-12, -1.131429345558013e-13, -1.152920484516710e-15,  7.997906853113720e-17,
  2.841197745431350e-18, -4.850740180084583e-21,  6.995473686933135e-01, -9.106395766527895e-03,  6.507062297203825e-05, -6.592280295281057e-09,  2.688890641095849e-10,
  1.975955252035242e-10, -3.140500323089057e-12, -1.976976001549873e-13, -1.835131172051269e-15,  1.334506358864062e-16,  4.833461555851109e-18, -5.998590365190681e-21,
  9.670592328866421e-01, -1.198886524779820e-02,  5.782970055561664e-05,  7.036580739785441e-07, -5.293037390886354e-09,  2.869467034252818e-10, -3.000701915403413e-12,
 -3.766335555396682e-13, -3.252423699216937e-15,  2.440728789626958e-16,  8.549932367195054e-18, -7.238877593814262e-21,  1.303674133026288e+00, -1.453411119597872e-02,
 -5.623191473229999e-06,  2.430411127651257e-06,  9.277829055110506e-11, -7.724915783715158e-11,  1.989994453720764e-12, -6.543825473272522e-13, -1.203028493016646e-14,
  5.726871141912464e-16,  2.033091270839955e-17, -7.665466840313684e-20,  1.727524864748625e+00, -1.300624794145605e-02, -2.542588737628035e-04,  1.994608472004977e-06,
  2.100832901480622e-07,  1.692795976296889e-09, -1.652966966956725e-10, -4.524868511970557e-12,  8.212211248257354e-14,  6.040206042817138e-15,  2.965871705937026e-17,
 -5.568975140207265e-18,  2.959432221294691e-02, -4.015921810247604e-04,  4.053676580088654e-06, -2.986677043153283e-08,  5.081897832152652e-10, -2.634920459934434e-12,
 -2.254853784762880e-13, -4.470668493258392e-15,  1.658846654154618e-16,  7.118600800189162e-18, -3.428454094010187e-20, -7.296719357666315e-21,  8.815052789336780e-02,
 -1.192373202590688e-03,  1.184395926466751e-05, -8.269784318566060e-08,  1.429303594908371e-09, -6.441457316264528e-12, -7.112022506737602e-13, -1.352739402138982e-14,
  5.076966743662373e-16,  2.194405495578423e-17, -1.045584103593815e-19, -2.250673618179605e-20,  1.777305996023614e-01, -2.391445933855477e-03,  2.311705167340859e-05,
 -1.460283490332875e-07,  2.607059965828105e-09, -8.535400302790356e-12, -1.560133642783522e-12, -2.809679967006622e-14,  1.071336535081696e-15,  4.670763029629616e-17,
 -2.187848829549225e-19, -4.799786283891314e-20,  3.007352402343744e-01, -4.013930808893952e-03,  3.714500632088886e-05, -1.937517815436621e-07,  3.722955822553186e-09,
 -3.847157680145041e-12, -2.945230416762178e-12, -5.018788892036397e-14,  1.947236131284115e-15,  8.546484043708505e-17, -3.909508936585824e-19, -8.824061508979975e-20,
  4.609180614597558e-01, -6.076419361805624e-03,  5.235785387727384e-05, -1.739594497731953e-07,  4.196125888486968e-09,  1.511832436157942e-11, -5.143571360986653e-12,
 -8.494417567499642e-14,  3.335383476056380e-15,  1.462574123529850e-16, -6.513240224658815e-19, -1.524752258770002e-19,  6.641628686061359e-01, -8.585809928142502e-03,
  6.512919603198912e-05,  2.329788961437812e-08,  3.007838105741224e-09,  5.484450093586614e-11, -8.533652378536684e-12, -1.470367063183001e-13,  5.723319375606557e-15,
  2.472824943277869e-16, -1.092228418741750e-18, -2.621103157162743e-19,  9.200810133827766e-01, -1.149349925569618e-02,  6.593214116052701e-05,  6.572969925359979e-07,
 -1.146667245217618e-09,  8.694282716495281e-11, -1.325348219276565e-11, -2.825562694058165e-13,  1.040295560443262e-14,  4.437828358713932e-16, -2.163401836071056e-18,
 -4.794157568237092e-19,  1.245632290162649e+00, -1.446254541678133e-02,  2.348980162040909e-05,  2.415413958057400e-06, -2.583749279874787e-09, -2.686870877960797e-10,
 -1.762861659423012e-11, -5.769587858755425e-13,  1.965511742952890e-14,  1.009963541105856e-15, -6.486362816405890e-18, -1.124754739237746e-18,  1.671665396997458e+00,
 -1.488644567907375e-02, -2.098358051349116e-04,  5.376055361929140e-06,  1.963795579005635e-07, -3.302133212179277e-09, -2.240764326766258e-10,  1.251797015100529e-12,
  2.509468924837165e-13,  1.352054181756909e-15, -2.574552958409562e-16, -4.437630196910211e-18,  2.805072970377465e-02, -3.704642187092921e-04,  3.741285930110631e-06,
 -2.248031288240758e-08,  3.952531366620832e-10, -8.737925461004749e-12, -2.435443486821834e-13,  4.011755692582695e-15,  3.165375741904593e-16, -7.953353382161118e-19,
 -3.292071816360150e-19, -2.801678055647479e-21,  8.356478116482581e-02, -1.101218545386405e-03,  1.098128952036369e-05, -6.187411328949230e-08,  1.111423397412382e-09,
 -2.556916207843777e-11, -7.613556127332435e-13,  1.250896202903390e-14,  9.724681639015019e-16, -2.448652204541392e-18, -1.016045556708868e-18, -8.675547131493093e-21,
  1.685245566891126e-01, -2.212836932089224e-03,  2.160224341395795e-05, -1.078948007678526e-07,  2.024243374650590e-09, -5.015984816784280e-11, -1.651430739255363e-12,
  2.703802237192741e-14,  2.061320756241086e-15, -5.239853871264473e-18, -2.168273114843981e-18, -1.859543912709219e-20,  2.852605002973310e-01, -3.725090738157198e-03,
  3.516148273948940e-05, -1.389579447229885e-07,  2.872752749450925e-09, -8.181841977781431e-11, -3.083679830808228e-12,  5.029677545990861e-14,  3.758488834360002e-15,
 -9.815610470930385e-18, -3.988039467693387e-18, -3.434241460880823e-20,  4.374384718650496e-01, -5.664788764514758e-03,  5.065986026952024e-05, -1.116435793064776e-07,
  3.152597172600220e-09, -1.204667490338658e-10, -5.352702744188137e-12,  8.708338362060480e-14,  6.426593292676719e-15, -1.786930899613961e-17, -6.890538255964868e-18,
 -5.931776473869902e-20,  6.308646342448051e-01, -8.062833955884445e-03,  6.569496106509739e-05,  6.814078631142268e-08,  1.862031030966431e-09, -1.713407332740622e-10,
 -8.947392211606502e-12,  1.461238080014652e-13,  1.090020710458866e-14, -3.440818908062907e-17, -1.183790872185596e-17, -1.000662847725164e-19,  8.752114653686628e-01,
 -1.093479388530085e-02,  7.370568846920668e-05,  6.337400931337489e-07, -2.978093334268651e-09, -2.753824209619848e-10, -1.447599420416569e-11,  2.453918277625819e-13,
  1.945165006013446e-14, -7.681783307505821e-17, -2.163968959567878e-17, -1.671922298184336e-19,  1.188339772592256e+00, -1.415996835707593e-02,  5.196386876452996e-05,
  2.304275228258333e-06, -1.300159633887094e-08, -7.852536317712187e-10, -2.045308371166575e-11,  4.832890295064188e-13,  3.913917927465717e-14, -2.233195491671909e-16,
 -4.873956886917842e-17, -2.342883390809056e-19,  1.609237373285121e+00, -1.626045864632707e-02, -1.295249909667095e-04,  7.725665297949769e-06,  8.400123337673615e-08,
 -7.383211387610822e-09, -8.451639575119786e-11,  7.929134407310314e-12,  1.040441188113427e-13, -8.717845605446858e-15, -1.382832543882849e-16,  9.569054998355573e-18,
  2.662715689346142e-02, -3.415205531000141e-04,  3.502822071977065e-06, -1.781437232283398e-08,  1.766105996873618e-10, -1.220858656228641e-11, -1.185057582777963e-14,
  1.118186995327044e-14,  6.423610081046235e-17, -1.169144517869985e-17, -1.030708741676302e-19,  1.186267521969227e-20,  7.933127361626470e-02, -1.016080358870294e-03,
  1.032587495094508e-05, -4.899670032144911e-08,  4.624782774914612e-10, -3.648669232287469e-11, -4.467777098687788e-14,  3.449896042743105e-14,  1.941220022557906e-16,
 -3.605516392959328e-17, -3.158428354611898e-19,  3.672172431962857e-20,  1.600113061916010e-01, -2.044735778420551e-03,  2.046276123724738e-05, -8.530264153312030e-08,
  7.215994663340682e-10, -7.403389840268366e-11, -1.187224199940313e-13,  7.351340779724086e-14,  4.004582192590117e-16, -7.685931288060522e-17, -6.652361730184635e-19,
  7.875356797611675e-20,  2.709130705529724e-01, -3.449834635710514e-03,  3.370461168975079e-05, -1.093977794760419e-07,  6.751665890231302e-10, -1.267733894652471e-10,
 -2.643565682569915e-13,  1.346408703986727e-13,  7.002162901510075e-16, -1.411853477451393e-16, -1.195317775209746e-18,  1.459508194558933e-19,  4.155823086581104e-01,
 -5.264233996004398e-03,  4.952388556081076e-05, -8.623606176029389e-08, -2.333155626953681e-10, -1.989448149927643e-10, -5.111179202524094e-13,  2.302130710170243e-13,
  1.121584055024662e-15, -2.435833784940026e-16, -1.977844297091030e-18,  2.550477384358291e-19,  5.996698843377786e-01, -7.533823641734973e-03,  6.654593720983630e-05,
  6.090444339502253e-08, -3.193925636806260e-09, -3.019962417940482e-10, -8.083054793068944e-13,  3.857453139160151e-13,  1.702575488031297e-15, -4.173966174541730e-16,
 -3.109874108678086e-18,  4.455574414324970e-19,  8.326979150628040e-01, -1.031606367396328e-02,  8.079101226898439e-05,  5.266625222882307e-07, -1.107259963883224e-08,
 -4.785354955372718e-10, -4.829062292341111e-13,  6.621561251857051e-13,  2.385089013214992e-15, -7.551775440342754e-16, -4.552539739022580e-18,  8.335089967015679e-19,
  1.132699700752165e+00, -1.363852304283047e-02,  7.778058655365264e-05,  1.950860043676392e-06, -3.186746527818927e-08, -9.927239428340887e-10,  6.837554294195772e-12,
  1.257899186256766e-12,  6.757273179806393e-16, -1.604526631316274e-15, -3.606158941460198e-18,  1.919755095756625e-18,  1.542727321770019e+00, -1.691452813265897e-02,
 -3.376879201972186e-05,  7.856501024136991e-06, -6.531807811267267e-08, -6.677318425355862e-09,  1.344863639010565e-10,  6.062648414342659e-12, -1.998039848833267e-13,
 -5.358730905242325e-15,  2.661945528783029e-16,  4.393558574052728e-18,  2.531580981195328e-02, -3.143231578825243e-04,  3.298186379753028e-06, -1.685185184704516e-08,
 -4.551395329961405e-11, -8.894811852698727e-12,  2.671775167518860e-13,  6.755591684283003e-15, -3.035387660455421e-16, -5.638488515189588e-18,  3.465355065728033e-19,
  4.147102539541510e-21,  7.542854841211738e-02, -9.357536174504071e-04,  9.758936280859346e-06, -4.716769321194372e-08, -2.012528471274299e-10, -2.647095589355644e-11,
  8.146319170032269e-13,  2.074683829247514e-14, -9.375276130666584e-16, -1.723720985334874e-17,  1.072042764562499e-18,  1.264858995224151e-20,  1.521534159476683e-01,
 -1.885042012774581e-03,  1.946094168590334e-05, -8.506455757779038e-08, -6.243185599140225e-10, -5.330155998471981e-11,  1.706938775208313e-12,  4.386453932298990e-14,
 -2.002597031510173e-15, -3.620044900631332e-17,  2.296616621516409e-18,  2.643459794502120e-20,  2.576447016865909e-01, -3.185453788722764e-03,  3.237534620816580e-05,
 -1.179570820825963e-07, -1.625391953922299e-09, -9.005218968362522e-11,  3.064226411737827e-12,  7.933270528977826e-14, -3.686079940585382e-15, -6.490849312457226e-17,
  4.248644967986847e-18,  4.692335402543013e-20,  3.953107203625145e-01, -4.872541618287157e-03,  4.833912706019915e-05, -1.203068749840417e-07, -3.826365625217618e-09,
 -1.378941147445779e-10,  5.140467478853416e-12,  1.328617345054594e-13, -6.366078439466003e-15, -1.076012863547735e-16,  7.401548252875857e-18,  7.612034073345286e-20,
  5.706021352478752e-01, -6.999849301548669e-03,  6.677735205338802e-05, -3.596726572367024e-08, -8.580068126162101e-09, -1.994011379516539e-10,  8.551188950146927e-12,
  2.144783638492187e-13, -1.088784371826600e-14, -1.717236990217639e-16,  1.285146537502344e-17,  1.153410091081748e-19,  7.927611645027677e-01, -9.648168177026262e-03,
  8.574701731581583e-05,  2.784446470494645e-07, -1.931825216159687e-08, -2.836030842242999e-10,  1.520451213387731e-11,  3.393522867320792e-13, -1.954025432363174e-14,
 -2.675146331912940e-16,  2.368325434280450e-17,  1.528574932520477e-19,  1.079524279769495e+00, -1.293269871681208e-02,  9.753668960707637e-05,  1.302418571669401e-06,
 -4.743264326232409e-08, -4.539315127685593e-10,  3.439499855983544e-11,  4.823751984843335e-13, -4.131212306869139e-14, -3.441455968857216e-16,  5.187907531755840e-17,
  1.691239009392477e-20,  1.475089254377540e+00, -1.683411494501136e-02,  5.052268667578825e-05,  5.961606513574013e-06, -1.570456592579811e-07, -2.235782258963179e-09,
  2.011703537823712e-10, -1.266648014019881e-12, -1.967409765433598e-13,  4.647584986687011e-15,  1.440422123559185e-16, -7.454562196910586e-18,  2.410997525807957e-02,
 -2.887699583938104e-04,  3.086977704464326e-06, -1.861171176773489e-08, -1.500748431121041e-10, -1.399265421490800e-12,  3.094059800264491e-13, -3.489347168420621e-15,
 -2.603686080530926e-16,  6.829886890889503e-18,  1.761662306006242e-19, -9.155559161948039e-21,  7.183797142463695e-02, -8.600335350091205e-04,  9.159956727186225e-06,
 -5.342864057405710e-08, -5.069493089473896e-10, -3.607833019812249e-12,  9.426965897103739e-13, -1.079694678744955e-14, -7.985969641048763e-16,  2.117185551536447e-17,
  5.378773457982432e-19, -2.836750990500629e-20,  1.449178315772797e-01, -1.733672439739915e-03,  1.835307015075646e-05, -1.010777613748122e-07, -1.221359273685560e-09,
 -5.391290006337455e-12,  1.971222237984638e-12, -2.316587859665748e-14, -1.686166625851298e-15,  4.549651222308286e-17,  1.126975593912106e-18, -6.091126713396192e-20,
  2.454111587616455e-01, -2.932663269003432e-03,  3.075878228653547e-05, -1.538763410652492e-07, -2.584763438335675e-09, -4.143399130416459e-12,  3.520792559573174e-12,
 -4.306491885935071e-14, -3.048041959059500e-15,  8.452138064682755e-17,  2.012179582160255e-18, -1.130177968703302e-19,  3.765831513363420e-01, -4.492805651145093e-03,
  4.646121703676608e-05, -1.960632724965165e-07, -5.175774387086953e-09,  5.596989092110962e-12,  5.837808922877980e-12, -7.593330478698929e-14, -5.117040466404601e-15,
  1.480364388035200e-16,  3.309607447977387e-18, -1.975348589823990e-19,  5.436648478396785e-01, -6.469914221976236e-03,  6.543035932098662e-05, -1.927061444870251e-07,
 -1.024402150068183e-08,  3.638001549842415e-11,  9.455601535705835e-12, -1.354923622982592e-13, -8.347852660596520e-15,  2.587304290683788e-16,  5.199722524974214e-18,
 -3.438173456633888e-19,  7.555537947556957e-01, -8.954372846944768e-03,  8.711649452417172e-05, -5.428772165944651e-08, -2.095085177134164e-08,  1.222255194388055e-10,
  1.577671998522206e-11, -2.655579328941326e-13, -1.368485086555855e-14,  4.807318822673865e-16,  7.810379762834976e-18, -6.318954067780473e-19,  1.029434313693360e+00,
 -1.210317757796889e-02,  1.084638998680619e-04,  5.176113339174698e-07, -4.793334883444593e-08,  3.862846052480881e-10,  3.016867321145152e-11, -6.807781970977834e-13,
 -2.273075909747027e-14,  1.073356137649066e-15,  8.829018744840544e-18, -1.346067491886639e-18,  1.408951474698656e+00, -1.618829095207953e-02,  1.063008203025817e-04,
  3.330864044940113e-06, -1.592798927025922e-07,  1.633943149220667e-09,  1.069995381135716e-10, -4.394168164342011e-12, -2.559263090503603e-16,  4.556527011647013e-15,
 -1.074653321420863e-16, -2.272677328173548e-18,  2.300281517685825e-02, -2.650080474453205e-04,  2.849488872738130e-06, -2.088025148446299e-08, -1.155040137819773e-10,
  4.168940745843009e-12,  1.372009750745468e-13, -7.298311300979539e-15,  1.938419279568503e-17,  6.521459894861440e-18, -1.458745337630311e-19, -3.351631824727425e-21,
  6.854014334433961e-02, -7.894545303582634e-04,  8.471362486832382e-06, -6.103254940123548e-08, -3.889356164098893e-10,  1.329400298685607e-11,  4.128318625675225e-13,
 -2.238770452187703e-14,  6.376923519446035e-17,  1.999631967528580e-17, -4.533420842077820e-19, -1.016423674082410e-20,  1.382686484827326e-01, -1.592024781922582e-03,
  1.702683457293687e-05, -1.192204675266913e-07, -9.330042026928783e-10,  2.973296318923554e-11,  8.455571734641522e-13, -4.731122308061136e-14,  1.500294748991231e-16,
  4.220237099352230e-17, -9.780778486614809e-19, -2.104997542370765e-20,  2.341599850410404e-01, -2.694661304727853e-03,  2.867475452427467e-05, -1.918730947812694e-07,
 -1.964089342524523e-09,  5.799358418672217e-11,  1.462528968543814e-12, -8.577100196922186e-14,  3.155085959302149e-16,  7.625047730455736e-17, -1.827296650365667e-18,
 -3.687351100336041e-20,  3.593384877083178e-01, -4.131881500623984e-03,  4.363730928287874e-05, -2.713546796062005e-07, -3.907714668511417e-09,  1.071137606838874e-10,
  2.307143309010690e-12, -1.450914980613831e-13,  6.493952860660527e-16,  1.279513187384641e-16, -3.224627103012339e-18, -5.872193925590507e-20,  5.188136611919154e-01,
 -5.958380409772268e-03,  6.219383725188149e-05, -3.401739019168706e-07, -7.670923193342144e-09,  1.969376939627813e-10,  3.444762983926732e-12, -2.412185178909565e-13,
  1.394971188873735e-15,  2.087063934575402e-16, -5.689205381033092e-18, -8.682064956604074e-20,  7.211183908630152e-01, -8.265441308830281e-03,  8.459248921014949e-05,
 -3.525750665498568e-07, -1.550637259230254e-08,  3.790324853995916e-10,  4.949033791430710e-12, -4.157329798673942e-13,  3.381573618727227e-15,  3.424714080330612e-16,
 -1.067429070097101e-17, -1.125065465317100e-19,  9.827790094049121e-01, -1.122285274209938e-02,  1.104357530804296e-04, -1.556761520387380e-07, -3.478395970380492e-08,
  8.349746831039831e-10,  6.631275318843359e-12, -8.198659684111512e-13,  1.082699414513990e-14,  5.729073781859522e-16, -2.376459224752273e-17, -4.106921294964567e-20,
  1.346095275989871e+00, -1.521813891928999e-02,  1.323999508726186e-04,  1.143122259311421e-06, -1.103654431621477e-07,  2.843975825680960e-09,  2.076020621290364e-12,
 -2.680343712100865e-12,  8.037390919610033e-14,  1.383102353385808e-16, -8.058838688898986e-17,  2.208781693444932e-18,  2.198675297041525e-02, -2.432386379585554e-04,
  2.590986893556054e-06, -2.194824773084144e-08, -1.462765445355451e-11,  5.252125118985662e-12, -3.208936037819164e-14, -4.179287221073116e-15,  1.368810315368915e-16,
  1.898439490117775e-19, -1.243681101417540e-19,  2.915295910181719e-21,  6.551310900433964e-02, -7.246962946907368e-04,  7.711595453948445e-06, -6.479194836441671e-08,
 -7.123544377377371e-11,  1.643784163620995e-11, -1.048357382601369e-13, -1.271966576966840e-14,  4.212544428772628e-16,  4.729613581806171e-19, -3.808047042331947e-19,
  9.052661791059038e-21,  1.321636256712690e-01, -1.461736250032293e-03,  1.552864223549374e-05, -1.287141925934537e-07, -2.350224157076539e-10,  3.578085525709747e-11,
 -2.427167255447420e-13, -2.653276155464307e-14,  8.947309560175995e-16,  6.159383856436759e-19, -8.017993560975622e-19,  1.950179030368868e-20,  2.238249264256836e-01,
 -2.474910742512494e-03,  2.622605678756609e-05, -2.128812769761551e-07, -6.330643537363306e-10,  6.740549952156417e-11, -4.945466699829984e-13, -4.714499790663878e-14,
  1.633552798360768e-15,  4.041861146411129e-20, -1.443319589948856e-18,  3.633783886390470e-20,  3.434872664452775e-01, -3.796695115411132e-03,  4.008278074835997e-05,
 -3.150252285765135e-07, -1.514058912057321e-09,  1.193853546648233e-10, -9.625629291610288e-13, -7.732267238667554e-14,  2.789264583224688e-15, -2.730503333676767e-18,
 -2.407782035967482e-18,  6.381812994445322e-20,  4.959468603647755e-01, -5.478926793761194e-03,  5.751397665880905e-05, -4.290395914425109e-07, -3.402989208213797e-09,
  2.088979697804761e-10, -1.883998047450524e-12, -1.223180116516703e-13,  4.692469390259539e-15, -1.193888762201620e-17, -3.888940764531356e-18,  1.115571346399152e-19,
  6.893781452926957e-01, -7.609243013647776e-03,  7.913401695950770e-05, -5.371997902216852e-07, -7.580272413399894e-09,  3.787367040344431e-10, -3.919606135805248e-12,
 -1.930050115039380e-13,  8.199859117960554e-15, -4.247493733046592e-17, -6.263010006959816e-18,  2.051682341829067e-19,  9.396310830396507e-01, -1.035501030303542e-02,
  1.057882475681225e-04, -5.768959307950855e-07, -1.809241066810716e-08,  7.705392044950076e-10, -9.617091313189147e-12, -3.136356183700756e-13,  1.632743256098518e-14,
 -1.695205314469507e-16, -9.999113148838495e-18,  4.328074250765595e-19,  1.287391208361489e+00, -1.412985422191193e-02,  1.373507532982630e-04, -1.853917745094513e-07,
 -5.761101687158387e-08,  2.270878304625290e-09, -3.956379822977413e-11, -4.646483214551914e-13,  4.984441767338742e-14, -1.289647071885062e-15,  2.224975472092373e-19,
  1.091178603509261e-18,  2.105359050931880e-02, -2.235606880284967e-04,  2.329446841042505e-06, -2.141488170106419e-08,  7.571534925626032e-11,  3.551134058226387e-12,
 -9.209806921059890e-14, -3.904736928186630e-16,  8.588104562266619e-17, -2.210057521590567e-18, -4.280602400630312e-21,  1.869221773229404e-21,  6.273278903007527e-02,
 -6.661093151759789e-04,  6.937393384396453e-06, -6.353272509863077e-08,  2.111332505729450e-10,  1.110180529062123e-11, -2.860031793293530e-13, -1.104736191379259e-15,
  2.620925642898668e-16, -6.812288081060906e-18, -1.102402403640552e-20,  5.707406949722660e-21,  1.265553342809344e-01, -1.343698011337825e-03,  1.398354668259723e-05,
 -1.272620727145065e-07,  3.783058563942996e-10,  2.411792408685276e-11, -6.156090167794394e-13, -2.019806464848677e-15,  5.490531942334576e-16, -1.450389323719686e-17,
 -1.596780764286783e-20,  1.196128830006400e-20,  2.143286058782026e-01, -2.275396323292317e-03,  2.365212877434679e-05, -2.132161301343427e-07,  5.187672047415860e-10,
  4.528459889001839e-11, -1.143554402754234e-12, -2.823185780109574e-15,  9.815265154802363e-16, -2.656602569273490e-17, -8.629771835352494e-21,  2.137539276141092e-20,
  3.289175125319958e-01, -3.491395532141364e-03,  3.623026868260612e-05, -3.219649466551036e-07,  5.170283844384419e-10,  7.977126232633109e-11, -1.993324874866841e-12,
 -2.744221003333095e-15,  1.623238289819908e-15, -4.554158002151847e-17,  3.732310009240483e-20,  3.525490311032052e-20,  4.749178559593071e-01, -5.040037516433881e-03,
  5.216625358830528e-05, -4.533934154370192e-07,  1.282545823088643e-10,  1.383165510723648e-10, -3.430463936654339e-12,  3.218819778275663e-16,  2.597151457298912e-15,
 -7.694810544617812e-17,  1.957739648234292e-19,  5.588047859348245e-20,  6.601642879917868e-01, -7.003482890271632e-03,  7.218951952413981e-05, -6.043330862619948e-07,
 -1.241662353096492e-09,  2.467481651368431e-10, -6.126837768587821e-12,  1.324569577080320e-14,  4.164281335861590e-15, -1.348735923577762e-16,  7.168619997380129e-19,
  8.689021886900187e-20,  8.998542904308635e-01, -9.540237543918792e-03,  9.759075768647998e-05, -7.576450033033735e-07, -5.427145562883814e-09,  4.858373546583472e-10,
 -1.235639832301426e-11,  6.700902365196683e-14,  6.939857000747422e-15, -2.669427619314526e-16,  2.783844901681656e-18,  1.271230212001090e-19,  1.233037306450478e+00,
 -1.305251130326527e-02,  1.309216070256640e-04, -7.971333276143953e-07, -2.198694013535479e-08,  1.304431933951184e-09, -3.680372804914941e-11,  4.557682354151418e-13,
  1.107487631304658e-14, -7.513197474213442e-16,  1.820514170135241e-17, -6.890646036544091e-20,  2.019502658466870e-02, -2.059278145746367e-04,  2.081692925616424e-06,
 -1.975440735448066e-08,  1.250481986154364e-10,  1.448656621560881e-12, -7.602167776325357e-14,  1.172131707881520e-15,  1.699404810332050e-17, -1.386416854519490e-18,
  3.164395163028896e-20, -1.450101923297164e-24,  6.017462185448357e-02, -6.135878518500849e-04,  6.201394659446901e-06, -5.874756992473709e-08,  3.659807131014155e-10,
  4.594443972653128e-12, -2.347664645124683e-13,  3.639765063230070e-15,  5.073836967153860e-17, -4.233445070483058e-18,  9.755552258728583e-20, -3.632948590126458e-23,
  1.213947941284954e-01, -1.237803845893016e-03,  1.250605686746427e-05, -1.181426279261528e-07,  7.166021416806154e-10,  1.018367121595647e-11, -5.009174365227386e-13,
  7.836151656951146e-15,  1.024474011087083e-16, -8.875885924008101e-18,  2.077336810307170e-19, -1.867335644913954e-22,  2.055895280732928e-01, -2.096213330920417e-03,
  2.116845043175326e-05, -1.991355772538943e-07,  1.158307272700775e-09,  1.959023555608452e-11, -9.188925124845491e-13,  1.456980404290436e-14,  1.727361490866388e-16,
 -1.588396074255476e-17,  3.804746759310518e-19, -6.394172975502674e-22,  3.155074827695219e-01, -3.216762470070581e-03,  3.246069490799044e-05, -3.034677191358957e-07,
  1.651971975879840e-09,  3.543387574351107e-11, -1.573941558261593e-12,  2.545579748659736e-14,  2.598538606458783e-16, -2.630043893098448e-17,  6.518188354090748e-19,
 -1.835864923080841e-21,  4.555581985839804e-01, -4.644253716852112e-03,  4.681498979323268e-05, -4.335434777147795e-07,  2.110180999818046e-09,  6.307190603303993e-11,
 -2.642725330821342e-12,  4.402679622268141e-14,  3.515205364596775e-16, -4.212748252813637e-17,  1.098942613956054e-18, -4.939372917021109e-21,  6.332594135778191e-01,
 -6.454987767845756e-03,  6.495617438687599e-05, -5.923667181716891e-07,  2.312867535680699e-09,  1.150633903005981e-10, -4.549598561232107e-12,  7.941117843030544e-14,
  3.876923763794577e-16, -6.757031151766332e-17,  1.914207621057906e-18, -1.362296682006585e-20,  8.631959746982106e-01, -8.796716203635089e-03,  8.824907084452940e-05,
 -7.818732994717580e-07,  1.571473046079654e-09,  2.289674580044925e-10, -8.621631704244206e-12,  1.632902287382934e-13,  2.456226263742198e-17, -1.122711766711077e-16,
  3.715457970849717e-18, -4.370531080640167e-20,  1.182855231759953e+00, -1.204768685806351e-02,  1.199637140320469e-04, -9.834207247504290e-07, -3.579166066358506e-09,
  5.940814888473010e-10, -2.221314565435057e-11,  5.054130430371155e-13, -4.533514219270580e-15, -1.760256559637482e-16,  9.532232891107118e-18, -2.243977464162812e-19,
  1.940317125932466e-02, -1.901868536149572e-04,  1.857311693753833e-06, -1.760922590991396e-08,  1.385873850416913e-10,  4.175971773207223e-14, -4.142269541588931e-14,
  1.147475362347643e-15, -1.217138673386958e-17, -3.252374863326088e-19,  1.863524746952643e-20, -4.031147995682459e-22,  5.781517540405223e-02, -5.666918566007470e-04,
  5.533697857998801e-06, -5.242649700201874e-08,  4.102265760219297e-10,  2.516687554206671e-13, -1.278997030621044e-13,  3.532338110462121e-15, -3.793583759957137e-17,
 -9.781411363237512e-19,  5.688323189450569e-20, -1.241563789301688e-21,  1.166349875229782e-01, -1.143219699920215e-03,  1.116195722036062e-05, -1.056227708974565e-07,
  8.186918006470423e-10,  9.250030992694876e-13, -2.727546449600503e-13,  7.501456910823874e-15, -8.215605299711556e-17, -1.999565153659851e-18,  1.191887388864132e-19,
 -2.639426682209115e-21,  1.975287107650735e-01, -1.936086469465289e-03,  1.889946245304686e-05, -1.785222842682618e-07,  1.363977078982054e-09,  2.629121381100144e-12,
 -4.996831760708469e-13,  1.367603707862844e-14, -1.540629153438144e-16, -3.439713383659186e-18,  2.130759472382609e-19, -4.821550982817302e-21,  3.031374305399721e-01,
 -2.971152261779883e-03,  2.899509146181841e-05, -2.731694252612592e-07,  2.042409015959202e-09,  6.448305152728990e-12, -8.534061727060067e-13,  2.324931910857280e-14,
 -2.724030153016159e-16, -5.351993192103865e-18,  3.521936126304654e-19, -8.225440508075966e-21,  4.376981853363657e-01, -4.289894315912198e-03,  4.184667689237918e-05,
 -3.927082897491516e-07,  2.838889209704892e-09,  1.459466776709982e-11, -1.424371925984613e-12,  3.869765159962493e-14, -4.789948554593620e-16, -7.721578266748559e-18,
  5.624007637556726e-19, -1.377037378587512e-20,  6.084348161996647e-01, -5.963002752324151e-03,  5.812860682541955e-05, -5.421260561901536e-07,  3.701842758401100e-09,
  3.219822934583596e-11, -2.422217086756857e-12,  6.598163981034459e-14, -8.842905792679118e-16, -1.007713699992183e-17,  8.967162088359225e-19, -2.367789406133804e-20,
  8.293626521895312e-01, -8.127543539867181e-03,  7.913631915725170e-05, -7.298200046048129e-07,  4.439983409645370e-09,  7.418869301666865e-11, -4.466353227750109e-12,
  1.237748002333842e-13, -1.880272785194406e-15, -8.786393850391145e-18,  1.469919938477808e-18, -4.467543458055525e-20,  1.136508770334312e+00, -1.113541756100930e-02,
  1.081296493552927e-04, -9.701364168060533e-07,  4.016152399757528e-09,  2.107220732353877e-10, -1.062351912527454e-11,  3.150796918771269e-13, -6.097519397758045e-15,
  4.058193212661853e-17,  2.205132296122028e-18, -1.041279232935113e-19,  1.867085545187078e-02, -1.761361439247186e-04,  1.659185692817239e-06, -1.542912386511529e-08,
  1.318263112960120e-10, -6.173409784353551e-13, -1.567101887909248e-14,  6.820899304100868e-16, -1.437000901467338e-17,  1.091572049885324e-19,  4.524985923746845e-21,
 -2.146629926781024e-22,  5.563311958643405e-02, -5.248277090964674e-04,  4.943672803809084e-06, -4.595850883112796e-08,  3.917773515392231e-10, -1.787594566162918e-12,
 -4.873743650108451e-14,  2.094472421425551e-15, -4.419476799316350e-17,  3.425820596347093e-19,  1.363385140808781e-20, -6.547122328073509e-22,  1.122329864327699e-01,
 -1.058771825010580e-03,  9.972717742020732e-06, -9.266587618134172e-08,  7.870289393651073e-10, -3.436660725951798e-12, -1.050211286961855e-13,  4.429790510051862e-15,
 -9.372681092076231e-17,  7.498394466999327e-19,  2.795792693661777e-20, -1.369966985644972e-21,  1.900737130317314e-01, -1.793088472632459e-03,  1.688809083277666e-05,
 -1.568103711535318e-07,  1.324470766852699e-09, -5.390555804985648e-12, -1.949165304053837e-13,  8.026244529598884e-15, -1.705795465962582e-16,  1.426932564239349e-18,
  4.833542516142862e-20, -2.443948066172716e-21,  2.916967714277125e-01, -2.751744534362070e-03,  2.591433951790245e-05, -2.403698396026927e-07,  2.013741464308735e-09,
 -7.303998795123156e-12, -3.378612457359617e-13,  1.351960992680859e-14, -2.894033955484374e-16,  2.572127287168727e-18,  7.583407578827159e-20, -4.026465840979164e-21,
  4.211794153240710e-01, -3.973186909124076e-03,  3.741125378163196e-05, -3.464730415091180e-07,  2.867134636839330e-09, -8.448886481702821e-12, -5.725915406492498e-13,
  2.218998842007461e-14, -4.806681611020068e-16,  4.635966974364002e-18,  1.111040768085691e-19, -6.396272947251751e-21,  5.854731250166452e-01, -5.522957750501028e-03,
  5.199106309546556e-05, -4.803350458898475e-07,  3.896924059283720e-09, -7.096857837325990e-12, -9.867898286987538e-13,  3.698900767139594e-14, -8.178670955626052e-16,
  8.830695905811722e-18,  1.503861755653656e-19, -1.010690320639111e-20,  7.980650053175512e-01, -7.528196392906938e-03,  7.083773989265925e-05, -6.516786402992788e-07,
  5.097374191741993e-09,  1.813477469462478e-12, -1.829336552400570e-12,  6.657789902991249e-14, -1.531351520661292e-15,  1.952535918072906e-17,  1.564516035711479e-19,
 -1.626693319681591e-20,  1.093625311554544e+00, -1.031561087066322e-02,  9.697505361818782e-05, -8.833908997642069e-07,  6.288931145741661e-09,  4.134700846752701e-11,
 -4.234764325521417e-12,  1.532249215340875e-13, -3.880745906531280e-15,  6.606033796364848e-17, -3.424984223906029e-19, -2.312531644698999e-20,  1.799173448576613e-02,
 -1.635684420624502e-04,  1.486233505128091e-06, -1.343349822320693e-08,  1.170155590613693e-10, -8.117358626790712e-13, -2.259806404921013e-15,  3.051329305711637e-16,
 -8.927684155341718e-18,  1.579714330074444e-19, -8.889036776153952e-22, -5.102224999444114e-23,  5.360956111577393e-02, -4.873808137882682e-04,  4.428443579002199e-06,
 -4.002240250784933e-08,  3.483109953088349e-10, -2.399389938753014e-12, -7.559181822265961e-15,  9.373711861249135e-16, -2.735876539891739e-17,  4.857579431538227e-19,
 -2.816598393967004e-21, -1.537482937585382e-22,  1.081507144485833e-01, -9.832299008321415e-04,  8.933671561497624e-06, -8.072377733882937e-08,  7.015116654963393e-10,
 -4.777500581663619e-12, -1.794799424061882e-14,  1.983408558883717e-15, -5.768729998788169e-17,  1.029956318634922e-18, -6.253819790848335e-21, -3.153487079414439e-22,
  1.831601471319949e-01, -1.665159896019709e-03,  1.512931806516420e-05, -1.366694834859162e-07,  1.185130948405199e-09, -7.932165024031115e-12, -3.722899642626942e-14,
  3.594157460170127e-15, -1.040919248726203e-16,  1.874069964828907e-18, -1.212944658470241e-20, -5.454231943904461e-22,  2.810869103417052e-01, -2.555433230483354e-03,
  2.321728190067198e-05, -2.096480656551094e-07,  1.812244439419815e-09, -1.181732594591450e-11, -7.252765624296266e-14,  6.049465029659816e-15, -1.744122830158014e-16,
  3.179022891509684e-18, -2.238828607886622e-20, -8.564780716633837e-22,  4.058599948707959e-01, -3.689764488235547e-03,  3.352133398599314e-05, -3.025152075388123e-07,
  2.602807671427395e-09, -1.629991388414453e-11, -1.380188655584920e-13,  9.901678989544499e-15, -2.843928099238532e-16,  5.279987769280186e-18, -4.151160547468322e-20,
 -1.257554052327970e-21,  5.641781191171200e-01, -5.129042965839677e-03,  4.659313795505635e-05, -4.201035806598547e-07,  3.588103116518380e-09, -2.099154845106107e-11,
 -2.655093721095443e-13,  1.638757793961859e-14, -4.702089385988534e-16,  8.985974010832583e-18, -8.170268955360228e-20, -1.714055176354126e-21,  7.690380409006091e-01,
 -6.991398532693336e-03,  6.350192447918635e-05, -5.716732425414388e-07,  4.819804681462149e-09, -2.459324198067947e-11, -5.433075258421610e-13,  2.897269451594843e-14,
 -8.373933502421759e-16,  1.682770743432737e-17, -1.872341098071856e-19, -1.857628917331712e-21,  1.053849791556951e+00, -9.580469334359335e-03,  8.699093848893772e-05,
 -7.804414644232720e-07,  6.383379436226560e-09, -2.076968092183413e-11, -1.352437669085823e-12,  6.314472632122564e-14, -1.893598284437566e-15,  4.246665886293191e-17,
 -6.521149802945185e-19,  2.860896236851766e-21,  1.736026280591278e-02, -1.522927944001543e-04,  1.335726408726646e-06, -1.169168551604333e-08,  1.007848293579604e-10,
 -7.907994065199168e-13,  3.072478922122508e-15,  1.006919854126760e-16, -4.200343159051712e-18,  1.005491747295066e-19, -1.567628213722195e-21,  6.974071502185789e-24,
  5.172798016389174e-02, -4.537832732347985e-04,  3.980017607780226e-06, -3.483584492293909e-08,  3.001886108291003e-10, -2.349641516673948e-12,  8.850818952984214e-15,
  3.112963839453816e-16, -1.285615211662020e-17,  3.078475061468193e-19, -4.820715959814994e-21,  2.231823978424804e-23,  1.043548582958603e-01, -9.154517923728555e-04,
  8.029145864254971e-06, -7.027184808857728e-08,  6.052119206970845e-10, -4.718378254915892e-12,  1.686437385835240e-14,  6.648089171395889e-16, -2.705182889467761e-17,
  6.481992397978860e-19, -1.022255407162824e-20,  5.027231249897910e-23,  1.767316287306327e-01, -1.550375358357930e-03,  1.359774320232376e-05, -1.189968782650894e-07,
  1.024008529156696e-09, -7.936265214535342e-12,  2.606259333017056e-14,  1.219054343930332e-15, -4.865367582593345e-17,  1.167370889629111e-18, -1.860402660560370e-20,
  9.930936306792695e-23,  2.712213924221553e-01, -2.379283484403733e-03,  2.086750764362644e-05, -1.825899757473782e-07,  1.569373979503795e-09, -1.205776832491001e-11,
  3.440588380743424e-14,  2.080533188296003e-15, -8.110748800974896e-17,  1.951096570043571e-18, -3.156731142211630e-20,  1.873117219850923e-22,  3.916152529359258e-01,
 -3.435432127510106e-03,  3.012989777326097e-05, -2.635803638594816e-07,  2.261524552412378e-09, -1.715143349606394e-11,  3.770269534943216e-14,  3.457089661069551e-15,
 -1.311782093408602e-16,  3.171181737087929e-18, -5.244983331412415e-20,  3.557716079866502e-22,  5.443768433311781e-01, -4.775520363702579e-03,  4.188173745651697e-05,
 -3.662697964462151e-07,  3.134108017778190e-09, -2.328381986684465e-11,  2.630860721703428e-14,  5.805607292264763e-15, -2.139133391728267e-16,  5.221035311727170e-18,
 -8.929763057196161e-20,  7.181325116879126e-22,  7.420468275506552e-01, -6.509553278845266e-03,  5.708665742871567e-05, -4.989717732560222e-07,  4.249787197568279e-09,
 -3.041968718942013e-11, -2.686177561970072e-14,  1.036665941036403e-14, -3.710970258036327e-16,  9.241250856269829e-18, -1.671635074883096e-19,  1.684946452042926e-21,
  1.016862853957068e+00, -8.920307223530989e-03,  7.822040666080707e-05, -6.828997842696014e-07,  5.756591338876603e-09, -3.761762950181151e-11, -2.367195197999851e-13,
  2.234571009035909e-14, -7.864171322372130e-16,  2.063526717235907e-17, -4.190708831291375e-19,  5.926072321811304e-21,  1.677161183679602e-02, -1.421419427610413e-04,
  1.204594623290345e-06, -1.020092556513925e-08,  8.586879197689397e-11, -6.954832245248155e-13,  4.472956348322879e-15,  1.298540032434260e-17, -1.593997440639622e-18,
  4.807075145291942e-20, -1.007456754839139e-21,  1.427460068082832e-23,  4.997399050104911e-02, -4.235370863644058e-04,  3.589298542640512e-06, -3.039498257650078e-08,
  2.558245550175739e-10, -2.070139558273980e-12,  1.322389415988682e-14,  4.279412768940802e-17, -4.884091944811025e-18,  1.468960219864934e-19, -3.082913878169100e-21,
  4.389849866497014e-23,  1.008163999562997e-01, -8.544340604331236e-04,  7.240954742297487e-06, -6.131658811325269e-08,  5.159757191828731e-10, -4.169194275835286e-12,
  2.633937066190141e-14,  9.969108985023768e-17, -1.029225623029387e-17,  3.083403906012995e-19, -6.486213066412692e-21,  9.309426335358155e-23,  1.707390250756325e-01,
 -1.447038528555619e-03,  1.226298271327686e-05, -1.038396694459669e-07,  8.735407652634607e-10, -7.043123772385453e-12,  4.375818550178806e-14,  2.024881234757349e-16,
 -1.854153499474066e-17,  5.526970051273339e-19, -1.166842315927529e-20,  1.694340146488313e-22,  2.620248407091831e-01, -2.220698829148868e-03,  1.881931810525823e-05,
 -1.593490901519788e-07,  1.339924179901048e-09, -1.076957164786298e-11,  6.526391156670703e-14,  3.859957412663774e-16, -3.095333127511427e-17,  9.173244970516864e-19,
 -1.947320034748467e-20,  2.875104876382494e-22,  3.783364053019106e-01, -3.206455285859089e-03,  2.717295113078337e-05, -2.300654427725561e-07,  1.933331500410362e-09,
 -1.546742600881351e-11,  9.022048287257343e-14,  7.182807257074024e-16, -5.008300028141473e-17,  1.475286472712260e-18, -3.158714222242950e-20,  4.776776749339951e-22,
  5.259181905641409e-01, -4.457229880519086e-03,  3.777223998102101e-05, -3.197718243720288e-07,  2.684567854733315e-09, -2.132451256507839e-11,  1.167753155410147e-13,
  1.348440421316896e-15, -8.148837714904063e-17,  2.388258949670530e-18, -5.185752665209649e-20,  8.128809496695058e-22,  7.168856502651432e-01, -6.075700783620290e-03,
  5.148700453697289e-05, -4.357992939618863e-07,  3.652671600754047e-09, -2.865805700585722e-11,  1.388427728487898e-13,  2.675662841278451e-15, -1.400672790696331e-16,
  4.101691234735261e-18, -9.136160284611264e-20,  1.518617431789598e-21,  9.823833848774638e-01, -8.325815675635933e-03,  7.055288965304132e-05, -5.969525040822675e-07,
  4.985940302313265e-09, -3.805157292904295e-11,  1.280697028043345e-13,  6.311279663260323e-15, -2.871459666039915e-16,  8.543939252149585e-18, -2.017295252684106e-19,
  3.769067142627989e-21,  1.622157393730609e-02, -1.329724928740287e-04,  1.089986923145586e-06, -8.932431571095067e-09,  7.303816656785121e-11, -5.881829125735720e-13,
  4.333928491839907e-15, -1.695252872090055e-17, -4.484947195498531e-19,  1.905536558949388e-20, -4.819558228478744e-22,  9.142530670013807e-24,  4.833505514395018e-02,
 -3.962151065613089e-04,  3.247807943966382e-06, -2.661562346680420e-08,  2.176192082989326e-10, -1.751923006285278e-12,  1.288020928978636e-14, -4.912615739007131e-17,
 -1.384715672182909e-18,  5.820498810574220e-20, -1.471501491337860e-21,  2.796697271077563e-23,  9.751004899343707e-02, -7.993153849575640e-04,  6.552050178645474e-06,
 -5.369330637107183e-08,  4.389846592750012e-10, -3.532113689318042e-12,  2.587562559799097e-14, -9.460077377481771e-17, -2.950882934442318e-18,  1.220765638878727e-19,
 -3.084619141755269e-21,  5.880714202772900e-23,  1.651395086688582e-01, -1.353691697323210e-03,  1.109630578490307e-05, -9.093192829740534e-08,  7.433603969166886e-10,
 -5.976428431037877e-12,  4.355024357084259e-14, -1.489078813170577e-16, -5.393737162280098e-18,  2.185113591268413e-19, -5.518878947066534e-21,  1.057058052665374e-22,
  2.534315376105076e-01, -2.077444386815896e-03,  1.702893545034899e-05, -1.395463269440988e-07,  1.140604867640373e-09, -9.159748448019385e-12,  6.623271595925799e-14,
 -2.033925231808306e-16, -9.162504576604916e-18,  3.617752487725148e-19, -9.137121043554003e-21,  1.762102854676380e-22,  3.659285787962443e-01, -2.999611675378609e-03,
  2.458795028569086e-05, -2.014851489973902e-07,  1.646508622029466e-09, -1.320057312923538e-11,  9.436429982048624e-14, -2.403803004731049e-16, -1.511967650526524e-17,
  5.793012333064600e-19, -1.464660035546673e-20,  2.853663041532632e-22,  5.086703136648315e-01, -4.169702184380291e-03,  3.417913995866983e-05, -2.800699599388865e-07,
  2.287929353803155e-09, -1.829673374140209e-11,  1.284729373224054e-13, -2.197072817561823e-16, -2.511735176827631e-17,  9.303368770399936e-19, -2.360489369827596e-20,
  4.673418767041258e-22,  6.933748652502432e-01, -5.683771875896167e-03,  4.658979266053148e-05, -3.817429025472277e-07,  3.116780443723705e-09, -2.481906513518264e-11,
  1.688760220651095e-13, -3.116165105496146e-17, -4.400795408518266e-17,  1.572204019062036e-18, -4.027130084496272e-20,  8.197530883985823e-22,  9.501654400180031e-01,
 -7.788746622667916e-03,  6.384366295260872e-05, -5.230541534888589e-07,  4.265620308329692e-09, -3.365982003706290e-11,  2.129612703285321e-13,  7.709095190813026e-16,
 -9.086352377189804e-17,  3.142394831992253e-18, -8.280842075499859e-20,  1.789826352471175e-21,  1.570647180488084e-02, -1.246623460390998e-04,  9.894390182181854e-07,
 -7.852462340731783e-09,  6.227008414372527e-11, -4.909679286745507e-13,  3.739010702325664e-15, -2.335917601361487e-17, -2.713366785355562e-20,  6.250755213449510e-21,
 -1.933930767479707e-22,  4.337568292649629e-24,  4.680021704662635e-02, -3.714535569257815e-04,  2.948208595347347e-06, -2.339776454420710e-08,  1.855416152933326e-10,
 -1.462727482107452e-12,  1.113080639977341e-14, -6.916146031068009e-17, -9.699612287461806e-20,  1.913102063853116e-20, -5.898443772880883e-22,  1.323604464939003e-23,
  9.441370132688402e-02, -7.493620130946542e-04,  5.947648308567537e-06, -4.720199620883308e-08,  3.742973354851660e-10, -2.950232004003806e-12,  2.242190640845434e-14,
 -1.380943739181648e-16, -2.481042095957880e-19,  4.024028033803909e-20, -1.234294258691494e-21,  2.772184841390872e-23,  1.598956458740244e-01, -1.269092512968771e-03,
  1.007272021489953e-05, -7.993928970301965e-08,  6.338713253809322e-10, -4.994810184015771e-12,  3.789028870117084e-14, -2.302949618082019e-16, -5.516365723138550e-19,
  7.228975314976468e-20, -2.202389217162587e-21,  4.953788308583862e-23,  2.453840378385157e-01, -1.947614255643298e-03,  1.545810549333478e-05, -1.226782416339179e-07,
  9.727162136449823e-10, -7.661783202024876e-12,  5.796622284543810e-14, -3.455117855810414e-16, -1.138480248895569e-18,  1.201770011746973e-19, -3.631314135005483e-21,
  8.187768259123873e-23,  3.543088332226647e-01, -2.812150789924636e-03,  2.231987138822217e-05, -1.771331122318797e-07,  1.404385686083095e-09, -1.105549470689209e-11,
  8.331553180431893e-14, -4.822268633150173e-16, -2.262008120326984e-18,  1.932180248878425e-19, -5.783764701742671e-21,  1.309458993788468e-22,  4.925179290998221e-01,
 -3.909116844435861e-03,  3.102639958375519e-05, -2.462264250369293e-07,  1.951971003685754e-09, -1.535270237882557e-11,  1.150106824619376e-13, -6.349570954062736e-16,
 -4.468517896794810e-18,  3.112023211987849e-19, -9.223921668966462e-21,  2.103420671894600e-22,  6.713573508639039e-01, -5.328565734987504e-03,  4.229241506473213e-05,
 -3.356278379434009e-07,  2.660222821875059e-09, -2.089289937865482e-11,  1.549398876482908e-13, -7.840087711958862e-16, -9.183088068688142e-18,  5.253078342011865e-19,
 -1.543787900976007e-20,  3.569736861121154e-22,  9.199937728561369e-01, -7.301993011941127e-03,  5.795520507093678e-05, -4.599095289173508e-07,  3.643956291867342e-09,
 -2.853324355678103e-11,  2.070638860607256e-13, -8.354259283794948e-16, -2.187880966389385e-17,  1.033040127451565e-18, -3.036221117587026e-20,  7.258650214256719e-22
  };
  constexpr double w[3456] = {  6.052219858902943e-04, -4.681651985445900e-05,  2.264333979335061e-06, -8.708113127778041e-08,  2.899394369641857e-09,
 -8.709314366095504e-11,  2.416583871550480e-12, -6.287664311548651e-14,  1.549944988180350e-15, -3.646743358163479e-17,  8.235119278616209e-19, -1.791785831645812e-20,
  4.302331655690900e-03, -4.772238480825293e-04,  3.250869961768858e-05, -1.715587364102560e-06,  7.645388569222245e-08, -3.006482629700976e-09,  1.071006098552018e-10,
 -3.516320605874511e-12,  1.076953271815755e-13, -3.104361374085867e-15,  8.479077070464374e-17, -2.204772427974781e-18,  1.311761393002909e-02, -2.066756333049982e-03,
  1.909307712548910e-04, -1.319254881368193e-05,  7.490840558539812e-07, -3.671194616505860e-08,  1.599870071456481e-09, -6.323443719473553e-11,  2.298768466090550e-12,
 -7.766316596335556e-14,  2.457930412525998e-15, -7.327478142023152e-17,  2.597370158938424e-02, -5.523995832611458e-03,  6.607217667337328e-04, -5.730078841428292e-05,
  3.986250910692074e-06, -2.346942850668267e-07,  1.208503621127078e-08, -5.563883051334474e-10,  2.326619065292155e-11, -8.941038091492592e-13,  3.186412312901306e-14,
 -1.059717056743961e-15,  3.876274918831672e-02, -1.048576788920291e-02,  1.551363881513179e-03, -1.624151334041152e-04,  1.337049451603675e-05, -9.161790008590951e-07,
  5.413255551836220e-08, -2.824660615959107e-09,  1.324249066836262e-10, -5.650374079268846e-12,  2.216385009812106e-13, -8.047899455996852e-15,  4.649419920604883e-02,
 -1.511130846494800e-02,  2.645989224851948e-03, -3.221413804597504e-04,  3.036680976296511e-05, -2.351068606657871e-06,  1.551439802134654e-07, -8.949635431473806e-09,
  4.596676705802082e-10, -2.131450425119510e-11,  9.019984809743935e-13, -3.509812019141782e-14,  4.555649324238214e-02, -1.689940691705846e-02,  3.357014503483644e-03,
 -4.582876850362933e-04,  4.790230808686967e-05, -4.071255325336350e-06,  2.923031159689523e-07, -1.820114220243086e-08,  1.001982562931246e-09, -4.948332396985867e-11,
  2.217553882299965e-12, -9.089534755307932e-14,  3.497188360658966e-02, -1.415032946256111e-02,  3.062691039797494e-03, -4.523726944619099e-04,  5.078515766251128e-05,
 -4.604373435685746e-06,  3.504766829255479e-07, -2.300913536038957e-08,  1.328846135714426e-09, -6.853930499651527e-11,  3.194960836656632e-12, -1.357124055399167e-13,
  1.660397262653865e-02, -7.038131643412810e-03,  1.596741891160093e-03, -2.463527783669853e-04,  2.877600561575989e-05, -2.704441360462148e-06,  2.126638679128527e-07,
 -1.437857889921271e-08,  8.528172522988092e-10, -4.505988498411757e-11,  2.146817301347085e-12, -9.300627653404222e-14,  4.485285145179561e-04, -3.220762549668693e-05,
  1.449005715005905e-06, -5.198582289323661e-08,  1.619445049908661e-09, -4.563589184680126e-11,  1.190792119375374e-12, -2.919976887820283e-14,  6.797075409348625e-16,
 -1.512930775217890e-17,  3.237653149555546e-19, -6.686617818008670e-21,  2.807493656113417e-03, -2.825112063383883e-04,  1.765225415022980e-05, -8.612973421576980e-07,
  3.570002164562943e-08, -1.311954433724782e-09,  4.384932084573304e-11, -1.355351673873914e-12,  3.919773319781253e-14, -1.069826127241504e-15,  2.773575065017448e-17,
 -6.861516315560310e-19,  7.130963074039552e-03, -1.013528530564353e-03,  8.571460032552739e-05, -5.474805708590754e-06,  2.894424471797224e-07, -1.328358119945853e-08,
  5.446660610576202e-10, -2.033771651481120e-11,  7.009594385998281e-13, -2.252372611136936e-14,  6.799359744156214e-16, -1.938610899755857e-17,  1.125773313165136e-02,
 -2.180000816390648e-03,  2.404266198546514e-04, -1.940572625734911e-05,  1.265487534310401e-06, -7.024873518304217e-08,  3.427144207676214e-09, -1.501123709715885e-10,
  5.993717903734712e-12, -2.206439884929146e-13,  7.554346446974083e-15, -2.420147573660913e-16,  1.304474392327374e-02, -3.273343612980765e-03,  4.529354754464608e-04,
 -4.468156341821449e-05,  3.487327709808440e-06, -2.277100738596384e-07,  1.287635196379948e-08, -6.454327459079785e-10,  2.916222558818083e-11, -1.202673922548079e-12,
  4.571469485274753e-14, -1.612373526438681e-15,  1.210604745107980e-02, -3.732614643435060e-03,  6.225095162129615e-04, -7.255218794348732e-05,  6.576514797176693e-06,
 -4.915043145271395e-07,  3.141266005084235e-08, -1.760100678979783e-09,  8.803181473546102e-11, -3.983902283304437e-12,  1.648712528924853e-13, -6.285289020274515e-15,
  9.394172939577242e-03, -3.377425575757062e-03,  6.510586261552861e-04, -8.649220472552695e-05,  8.821473560544547e-06, -7.333383983528793e-07,  5.160825025157462e-08,
 -3.155734016586681e-09,  1.708790761542514e-10, -8.312738555294477e-12,  3.674312113873434e-13, -1.487212788931075e-14,  6.005871360230707e-03, -2.395036365782782e-03,
  5.109376380698530e-04, -7.447024805295812e-05,  8.259887380356145e-06, -7.407080287050413e-07,  5.582283991634607e-08, -3.631763810979845e-09,  2.080180441191625e-10,
 -1.064832392200410e-11,  4.929413737312488e-13, -2.080598299251179e-14,  2.554436876240045e-03, -1.077787012784734e-03,  2.433464265450745e-04, -3.737427717468711e-05,
  4.347166291440976e-06, -4.069543412985745e-07,  3.188425731232860e-08, -2.148444607746543e-09,  1.270253354509786e-10, -6.691778717279119e-12,  3.179406124581606e-13,
 -1.373852786217506e-14,  3.394728097184905e-04, -2.273090887891899e-05,  9.548871990316610e-07, -3.206308291092466e-08,  9.371439566770196e-10, -2.483649828528683e-11,
  6.107955464026047e-13, -1.414364252108431e-14,  3.114565317848718e-16, -6.569006754058547e-18,  1.334072178368713e-19, -2.618569527466966e-21,  1.905906511025571e-03,
 -1.746028029920869e-04,  1.003323878881654e-05, -4.535737896796621e-07,  1.751615880481098e-08, -6.024054602371515e-10,  1.891183485869410e-11, -5.508087383615873e-13,
  1.505228831780845e-14, -3.891700170214904e-16,  9.579590497076130e-18, -2.255013253173787e-19,  4.121550617406045e-03, -5.282552018615044e-04,  4.089990667920286e-05,
 -2.414901603138807e-06,  1.188556463038138e-07, -5.106370310159356e-09,  1.969067659260051e-10, -6.941741697595163e-12,  2.266652130275889e-13, -6.921265993686024e-15,
  1.990979704525042e-16, -5.423318113539306e-18,  5.284377254893318e-03, -9.273781889640933e-04,  9.402034386866695e-05, -7.044838393832712e-06,  4.296488584509370e-07,
 -2.243752331780357e-08,  1.034859104415228e-09, -4.303279521508199e-11,  1.637206428483379e-12, -5.761469210293921e-14,  1.891204029652121e-15, -5.824497588076928e-17,
  4.793016344013026e-03, -1.107317068523363e-03,  1.425079436209478e-04, -1.318558887571617e-05,  9.717127799111424e-07, -6.023946509184624e-08,  3.248974807815649e-09,
 -1.559470460781244e-10,  6.770472209720883e-12, -2.691188756143986e-13,  9.886319338478236e-15, -3.378459418537148e-16,  3.418073240781875e-03, -9.918918280736714e-04,
  1.565570483000082e-04, -1.737311749247671e-05,  1.507203876064756e-06, -1.082815208518642e-07,  6.677400256795765e-09, -3.621772306918296e-10,  1.758462121547800e-11,
 -7.744553225512629e-13,  3.126020827937687e-14, -1.164704328548448e-15,  2.056952899828495e-03, -7.124196977329230e-04,  1.325687267631196e-04, -1.706091870841349e-05,
  1.691213945244102e-06, -1.370392717219338e-07,  9.423911712934883e-09, -5.643302230719393e-10,  2.998302543710737e-11, -1.433570558873726e-12,  6.237220729047203e-14,
 -2.488417667084619e-15,  1.065652901490155e-03, -4.175157365935836e-04,  8.753447126540577e-05, -1.255741749089459e-05,  1.372985413100819e-06, -1.215402667611826e-07,
  9.053248535458702e-09, -5.827788588744512e-10,  3.305972240732631e-11, -1.677495515359860e-12,  7.703454075515823e-14, -3.227665449899142e-15,  3.974300815945520e-04,
 -1.667684182072203e-04,  3.744134571715087e-05, -5.719938982672322e-06,  6.620467392345353e-07, -6.169592823875362e-08,  4.813557918654186e-09, -3.230941330084840e-10,
  1.903410354186276e-11, -9.993797907295090e-13,  4.733481384399058e-14, -2.039449329142721e-15,  2.617064570715066e-04, -1.640910784591414e-05,  6.459593546212672e-07,
 -2.036300377579100e-08,  5.599385276435631e-10, -1.399002588548919e-11,  3.249724339383328e-13, -7.120211557011541e-15,  1.485946197779567e-16, -2.974546319749790e-18,
  5.741318654646109e-20, -1.072469046977283e-21,  1.339248721495184e-03, -1.121220367789286e-04,  5.941914423651814e-06, -2.494467178900929e-07,  8.992302938530756e-09,
 -2.898771782698251e-10,  8.559308999354176e-12, -2.351599242994413e-13,  6.077821947794236e-15, -1.489631457647530e-16,  3.483393291356787e-18, -7.805331617795570e-20,
  2.516565493337339e-03, -2.910129958204137e-04,  2.064219177955568e-05, -1.127291447278031e-06,  5.166932242573597e-08, -2.078384125039254e-09,  7.536813169499311e-11,
 -2.508067784352334e-12,  7.755751536474043e-14, -2.249373310026620e-15,  6.162074382311056e-17, -1.602440322828236e-18,  2.672797298189447e-03, -4.235141321492416e-04,
  3.938326998990007e-05, -2.734419239503795e-06,  1.556958365385212e-07, -7.636388187951636e-09,  3.324110542978872e-10, -1.310057895051247e-11,  4.741032368845171e-13,
 -1.592147884398244e-14,  5.001829831931928e-16, -1.478286084164633e-17,  1.921616967716774e-03, -4.058059737144610e-04,  4.832951091501196e-05, -4.176609068792606e-06,
  2.895558663858704e-07, -1.698500532306060e-08,  8.710113921908136e-10, -3.991583488832128e-11,  1.660515697961520e-12, -6.344638982371524e-14,  2.246836784134262e-15,
 -7.421102296673822e-17,  1.051658139333018e-03, -2.848065375131812e-04,  4.226367586751645e-05, -4.440913083297804e-06,  3.669683722935997e-07, -2.523518431650267e-08,
  1.495757793527228e-09, -7.825827133549005e-11,  3.676641076854989e-12, -1.571145333647733e-13,  6.168415621788905e-15, -2.240421290355807e-16,  4.820289358124397e-04,
 -1.596945461523322e-04,  2.851405586482350e-05, -3.536728573026583e-06,  3.392374297403355e-07, -2.668966229596597e-08,  1.787320740359417e-09, -1.044930561046526e-10,
  5.432267430909720e-12, -2.546408304358952e-13,  1.088070159348453e-14, -4.270038945549832e-16,  1.965585543628591e-04, -7.536235919029386e-05,  1.547216373146001e-05,
 -2.177817779247666e-06,  2.340894952467697e-07, -2.040738220724872e-08,  1.499291285099253e-09, -9.531911606628271e-11,  5.346610891170375e-12, -2.685290105818304e-13,
  1.221689569242325e-14, -5.075379581977398e-16,  6.266125970743922e-05, -2.612079976029749e-05,  5.825124902925648e-06, -8.843464747570839e-07,  1.017693724385095e-07,
 -9.433866889973278e-09,  7.324734096035498e-10, -4.894573934946577e-11,  2.871626600317283e-12, -1.501997718116566e-13,  7.088949783360384e-15, -3.044299594257940e-16,
  2.050478673094544e-04, -1.208536682318875e-05,  4.473322521370227e-07, -1.327787273672324e-08,  3.443909559693937e-10, -8.130875268674620e-12,  1.787748952119912e-13,
 -3.713436596375214e-15,  7.357508511615845e-17, -1.400151317685791e-18,  2.572326203849240e-20, -4.579118656387743e-22,  9.698248610305603e-04, -7.449205983166050e-05,
  3.651363672161722e-06, -1.426873868845689e-07,  4.811238972781074e-09, -1.456272534811056e-10,  4.050316397873916e-12, -1.051038722123643e-13,  2.571874909424954e-15,
 -5.980840994271852e-17,  1.329595322919190e-18, -2.837565008588174e-20,  1.613471168658466e-03, -1.685529529587247e-04,  1.096667809170636e-05, -5.544896545777186e-07,
  2.368607645201656e-08, -8.925123888581644e-10,  3.044588419088581e-11, -9.564968195681681e-13,  2.801078044675606e-14, -7.714803598477238e-16,  2.012063148755476e-17,
 -4.993053626901675e-19,  1.448459265437142e-03, -2.066558795062534e-04,  1.760213053466666e-05, -1.131158261157886e-06,  6.006450099905830e-08, -2.763609514858830e-09,
  1.134016040986509e-10, -4.230373640185651e-12,  1.454327952007074e-13, -4.654286844300493e-15,  1.397392070620307e-16, -3.957474032240396e-18,  8.388201025914765e-04,
 -1.608519689807048e-04,  1.764966617786590e-05, -1.419480804000208e-06,  9.228180897718860e-08, -5.106883567911140e-09,  2.483122691021592e-10, -1.083571761930204e-11,
  4.308287736145759e-13, -1.578483257105222e-14,  5.375844386287625e-16, -1.712211230067914e-17,  3.538720551988702e-04, -8.864845067762873e-05,  1.228636571303366e-05,
 -1.215755241778431e-06,  9.523497894452664e-08, -6.242031233397134e-09,  3.542508162627537e-10, -1.781569764110860e-11,  8.072679568011253e-13, -3.337109672331323e-14,
  1.270763030321146e-15, -4.487547721666529e-17,  1.218707332679729e-04, -3.830512868665660e-05,  6.518746292599891e-06, -7.748591690710103e-07,  7.156575962081299e-08,
 -5.443464551342270e-09,  3.536370691864622e-10, -2.011640343982412e-11,  1.020159967358675e-12, -4.675393004647979e-14,  1.957104301861677e-15, -7.537730728833289e-17,
  3.796224680249022e-05, -1.417314916075118e-05,  2.836868227089757e-06, -3.903134356938434e-07,  4.111019447379072e-08, -3.519437664698415e-09,  2.543947982049957e-10,
 -1.593852126779123e-11,  8.822880447685007e-13, -4.378522551063444e-14,  1.970503837611205e-15, -8.105783547234999e-17,  1.003769482318209e-05, -4.150818829479170e-06,
  9.182110490292969e-07, -1.383613790519145e-07,  1.581430530424397e-08, -1.456892197762942e-09,  1.124786572534302e-10, -7.477262027622343e-12,  4.366060892711003e-13,
 -2.273677000826822e-14,  1.068770288912250e-15, -4.572634707483178e-17,  1.629722643972154e-04, -9.061374657178369e-06,  3.163618327379217e-07, -8.866534185627518e-09,
  2.174577199901419e-10, -4.862285292427855e-12,  1.013992512447367e-13, -2.000543438799871e-15,  3.769612773236863e-17, -6.830804099691810e-19,  1.196285331886546e-20,
 -2.032104353833982e-22,  7.210277623624937e-04, -5.101289393323072e-05,  2.319608191633328e-06, -8.458188507363804e-08,  2.673180277868517e-09, -7.610965050486936e-11,
  1.997052687756113e-12, -4.901390070860729e-14,  1.136874770279204e-15, -2.511030731804285e-17,  5.311571943224004e-19, -1.080447496631822e-20,  1.080169289823019e-03,
 -1.021299024415489e-04,  6.105095898122307e-06, -2.861780456907085e-07,  1.140533751501780e-08, -4.029214369623781e-10,  1.293770152571823e-11, -3.838867579508836e-13,
  1.064917588503784e-14, -2.785643085176088e-16,  6.916416803701012e-18, -1.637594780924375e-19,  8.360335654815066e-04, -1.072042430327429e-04,  8.358512791869519e-06,
 -4.969013510270888e-07,  2.459250095432035e-08, -1.060776182293367e-09,  4.100073483482610e-11, -1.446516088639701e-12,  4.719503019430529e-14, -1.437870702620647e-15,
  4.121213660295399e-17, -1.117085223490762e-18,  3.972664302626275e-04, -6.876571745344016e-05,  6.926689584102115e-06, -5.169136343203892e-07,  3.142932912806203e-08,
 -1.636845784009907e-09,  7.528460682144071e-11, -3.121100862209007e-12,  1.183403050374448e-13, -4.148477414483338e-15,  1.355832102063227e-16, -4.155437240694028e-18,
  1.304840284309783e-04, -2.996589004571246e-05,  3.854200207914728e-06, -3.572672856150174e-07,  2.640926911380577e-08, -1.643095038124102e-09,  8.895246895081015e-11,
 -4.285258630472609e-12,  1.866780616179899e-13, -7.442699535408379e-15,  2.741178654148696e-16, -9.386823088645321e-18,  3.350343195621357e-05, -9.897678309216223e-06,
  1.593566135338085e-06, -1.804152424464880e-07,  1.596036800002993e-08, -1.168250326153753e-09,  7.332624020642188e-11, -4.043552911321972e-12,  1.993723083742125e-13,
 -8.906580823513842e-15,  3.642367920869450e-16, -1.373334956312159e-17,  7.742454927466196e-06, -2.797348109565506e-06,  5.429505581874906e-07, -7.268695601171663e-08,
  7.472604435779222e-09, -6.261068662031923e-10,  4.439586449139686e-11, -2.734056272964812e-12,  1.490199656977327e-13, -7.292708188877227e-15,  3.240686647203790e-16,
 -1.317854579795071e-17,  1.639071721227084e-06, -6.711118693730969e-07,  1.470051104026774e-07, -2.195311606767473e-08,  2.488841526818146e-09, -2.276041779823895e-10,
  1.745533854366911e-11, -1.153369783157482e-12,  6.697512987170306e-14, -3.470183556437438e-15,  1.623626802979365e-16, -6.916861273222006e-18,  1.311894358588143e-04,
 -6.903542269590005e-06,  2.280118555889044e-07, -6.049806193704799e-09,  1.406294141943871e-10, -2.984382856528563e-12,  5.914457425951151e-14, -1.110382155766403e-15,
  1.993142295374157e-17, -3.444380437157922e-19,  5.759736849550574e-21, -9.345809224941504e-23,  5.485544784498884e-04, -3.588967090659632e-05,  1.518336402499245e-06,
 -5.178646027240065e-08,  1.537286137891735e-09, -4.124689514164592e-11,  1.022700442547629e-12, -2.377406042887452e-14,  5.233713033868376e-16, -1.099160387023932e-17,
  2.214500619036039e-19, -4.297078047603222e-21,  7.512727512410411e-04, -6.444195400077398e-05,  3.546048756916819e-06, -1.543534746162630e-07,  5.746968338180944e-09,
 -1.905511943285198e-10,  5.764294321966652e-12, -1.616498544793596e-13,  4.249889665012697e-15, -1.056205371672324e-16,  2.497086973139730e-18, -5.641484159627524e-20,
  5.108729138944277e-04, -5.882099677956642e-05,  4.198273383677629e-06, -2.308982148784963e-07,  1.065035352842734e-08, -4.305842777045401e-10,  1.567120444814111e-11,
 -5.226383206653110e-13,  1.617365961734020e-14, -4.687741734563174e-16,  1.281643072137998e-17, -3.322077179244031e-19,  2.031884942576052e-04, -3.158690139195070e-05,
  2.912743476292426e-06, -2.012420925421370e-07,  1.142040117476305e-08, -5.586502505218052e-10,  2.425856352217514e-11, -9.536457237069453e-13,  3.441691860651824e-14,
 -1.152215281709869e-15,  3.607022767963318e-17, -1.061819328815086e-18,  5.273412472585923e-05, -1.100402168717967e-05,  1.305669157993748e-06, -1.128313780451868e-07,
  7.837536321730562e-09, -4.611211734527651e-10,  2.373030698539343e-11, -1.091526379359849e-12,  4.557444898453022e-14, -1.747374247166742e-15,  6.207456891377935e-17,
 -2.055891297192188e-18,  1.008549711612522e-05, -2.771511329471154e-06,  4.188529793170737e-07, -4.487400520078911e-08,  3.781319163438548e-09, -2.650627241984356e-10,
  1.600423274931004e-11, -8.522365596442629e-13,  4.071125539845615e-14, -1.767102869487378e-15,  7.039391689618673e-17, -2.591337400642804e-18,  1.683822042610814e-06,
 -5.841887411475505e-07,  1.092411175502305e-07, -1.415278872234495e-08,  1.413614338896527e-09, -1.154608531881909e-10,  8.003665765109497e-12, -4.830213128588611e-13,
  2.585359355382880e-14, -1.244707355678505e-15,  5.450062894122915e-17, -2.186910824663756e-18,  2.739907976950938e-07, -1.108014212358113e-07,  2.397839038670711e-08,
 -3.541789345518392e-09,  3.976124415439407e-10, -3.604303218489677e-11,  2.742408428578843e-12, -1.799153050281915e-13,  1.038000840951148e-14, -5.346541398152930e-16,
  2.488074730072835e-17, -1.054732067881173e-18,  1.068122651137661e-04, -5.335669791461945e-06,  1.671686857218297e-07, -4.209519039589357e-09,  9.294717612864240e-11,
 -1.875975496862175e-12,  3.539494999251496e-14, -6.334558293414758e-16,  1.085051704237916e-17, -1.790161793015388e-19,  2.864732953184850e-21, -4.443893029598465e-23,
  4.258707570342690e-04, -2.586561889712005e-05,  1.021029705934845e-06, -3.265221192263808e-08,  9.123023748335030e-10, -2.311020559627682e-11,  5.423494911064675e-13,
 -1.195916078791899e-14,  2.502060377969167e-16, -5.002191671065951e-18,  9.609374746678790e-20, -1.780352191256753e-21,  5.403891982013612e-04, -4.216681331819811e-05,
  2.140475202987361e-06, -8.667502655963717e-08,  3.019437781037712e-09, -9.408265462906502e-11,  2.684101568736334e-12, -7.120098313925558e-14,  1.775334145625480e-15,
 -4.194201317411098e-17,  9.445826177523215e-19, -2.036833192330499e-20,  3.285813872527590e-04, -3.396377916607567e-05,  2.220501332120305e-06, -1.130439523822241e-07,
  4.861421060453798e-09, -1.842523204722679e-10,  6.314588226503829e-12, -1.990476328208384e-13,  5.840975758796482e-15, -1.609932350756928e-16,  4.196581999193430e-18,
 -1.039591328064289e-19,  1.116293391384861e-04, -1.551928302994719e-05,  1.307636463877035e-06, -8.351463026032775e-08,  4.417234667420180e-09, -2.026652699706557e-10,
  8.296715223535130e-12, -3.088226743245117e-13,  1.059252924125229e-14, -3.381415242454425e-16,  1.012350865251780e-17, -2.857803050772572e-19,  2.332124178966697e-05,
 -4.384326548321029e-06,  4.773968093514055e-07, -3.829759971555349e-08,  2.490559814336504e-09, -1.380998697122344e-10,  6.734506395557725e-12, -2.948871468828311e-13,
  1.176748695318844e-14, -4.327122916531468e-16,  1.478836401832640e-17, -4.725297255138559e-19,  3.343502112441506e-06, -8.450841828196228e-07,  1.189124661139118e-07,
 -1.197632780296710e-08,  9.558759595785058e-10, -6.385079722267528e-11,  3.692238626539287e-12, -1.891013626057608e-13,  8.719933651834770e-15, -3.665263909977667e-16,
  1.417876426569024e-17, -5.081444856922253e-19,  3.947381014444071e-07, -1.302566365360495e-07,  2.328590350533457e-08, -2.900931061362235e-09,  2.800032082781469e-10,
 -2.219176030964388e-11,  1.497854282572524e-12, -8.827542396406831e-14,  4.625652920611302e-15, -2.184916238310998e-16,  9.403701500420286e-18, -3.715226686370491e-19,
  4.714611785251515e-08, -1.876731910329724e-08,  4.000440188586651e-09, -5.829677243062618e-10,  6.466717731813750e-11, -5.800012898577936e-12,  4.371408398517904e-13,
 -2.843577060968413e-14,  1.628051847766255e-15, -8.327855188900753e-17,  3.851127094249752e-18, -1.623216903395810e-19,  8.785663809018238e-05, -4.177674520254748e-06,
  1.244738203502034e-07, -2.981759079161259e-09,  6.266588400427555e-11, -1.205351704315061e-12,  2.168840440019019e-14, -3.705607307849797e-16,  6.071830754865465e-18,
 -9.562048860022717e-20,  1.467976897933668e-21, -2.185595824162133e-23,  3.365723695099695e-04, -1.904757971376632e-05,  7.035462654222048e-07, -2.114525450934725e-08,
  5.571941971302796e-10, -1.335057214998075e-11,  2.970314072039132e-13, -6.221928938057323e-15,  1.238888650161800e-16, -2.360378340585253e-18,  4.328543703846185e-20,
 -7.665708405365469e-22,  4.003782038677908e-04, -2.850534307464618e-05,  1.337875547001389e-06, -5.049512829832036e-08,  1.648568917310187e-09, -4.834023079330694e-11,
  1.302182201845790e-12, -3.270808909683425e-14,  7.741181261045189e-16, -1.739737775964210e-17,  3.734421092091841e-19, -7.689279633226917e-21,  2.212180073387554e-04,
 -2.053821025356560e-05,  1.231344085035997e-06, -5.808105013009754e-08,  2.330468618236618e-09, -8.284678644086237e-11,  2.674516956055131e-12, -7.969820167022488e-14,
  2.217736545838713e-15, -5.812429295919221e-17,  1.444220444700737e-18, -3.418058646835957e-20,  6.549093027888214e-05, -8.115392661957695e-06,  6.241605462348223e-07,
 -3.681804431426026e-08,  1.813464982789529e-09, -7.796792434477694e-11,  3.006218357200653e-12, -1.058392838063206e-13,  3.446299608543220e-15, -1.047783519099058e-16,
  2.996249700113720e-18, -8.100510250396730e-20,  1.124923804273551e-05, -1.890226547217014e-06,  1.880580065665563e-07, -1.395559744722392e-08,  8.470347402352279e-10,
 -4.413775760068650e-11,  2.034064103997431e-12, -8.456664153402125e-14,  3.217144997231182e-15, -1.131808582578239e-16,  3.712382493116031e-18, -1.141769677524511e-19,
  1.225389944456397e-06, -2.815009316090485e-07,  3.658501628827398e-08, -3.441550220745433e-09,  2.587385197721354e-10, -1.638944883124183e-11,  9.036788988899064e-13,
 -4.433592639959116e-14,  1.966237850135561e-15, -7.976117264669952e-17,  2.986827096728162e-18, -1.039062776620095e-19,  1.009122175824069e-07, -3.130462269085578e-08,
  5.302122097716296e-09, -6.305246233534170e-10,  5.845194450646731e-11, -4.471707960217255e-12,  2.925490330164501e-13, -1.676992280027590e-14,  8.572662259821887e-16,
 -3.960385562822976e-17,  1.670793602786572e-18, -6.483156344940023e-20,  8.411389671868104e-09, -3.280659528495269e-09,  6.860554206664928e-10, -9.830741501502802e-11,
  1.074543460435288e-11, -9.513486731206786e-13,  7.088485970823615e-14, -4.564236425385455e-15,  2.589462202192513e-16, -1.313749199516449e-17,  6.030445728604887e-19,
 -2.524793023130168e-20,  7.293276747985822e-05, -3.309627703406140e-06,  9.399594631639627e-08, -2.146849353149618e-09,  4.302494681935138e-11, -7.902003370050165e-13,
  1.358646088599842e-14, -2.216527695068774e-16,  3.489672175311948e-18, -5.241506503829268e-20,  7.693173552615573e-22, -1.118491333190234e-23,  2.702218061898159e-04,
 -1.430066591118732e-05,  4.955927144442878e-07, -1.403098293042811e-08,  3.493797966431161e-10, -7.932423159754665e-12,  1.675937633711977e-13, -3.339227980042107e-15,
  6.338406218812326e-17, -1.152047713316192e-18,  2.018428175055473e-20, -3.423286036130116e-22,  3.044736156913985e-04, -1.984150352599752e-05,  8.630485666162678e-07,
 -3.042195199919516e-08,  9.324458028967064e-10, -2.576849293487261e-11,  6.562765254502967e-13, -1.562636306680998e-14,  3.513771462646977e-16, -7.518425713296727e-18,
  1.539294263045908e-19, -3.028004484465502e-21,  1.551059453853919e-04, -1.294798546730008e-05,  7.129418517041355e-07, -3.119727174741297e-08,  1.169149717743686e-09,
 -3.901486729377980e-11,  1.187134068571105e-12, -3.345727542697726e-14,  8.830733027451460e-16, -2.201093924833678e-17,  5.213308837486332e-19, -1.178649920898711e-20,
  4.078479009048948e-05, -4.493379829484048e-06,  3.153794370026732e-07, -1.717844851167891e-08,  7.877067980822180e-10, -3.172225399970233e-11,  1.151356239912526e-12,
 -3.831573894950927e-14,  1.183494367922438e-15, -3.424013481149526e-17,  9.343513850467660e-19, -2.416778149511680e-20,  5.891123980413446e-06, -8.783827293161918e-07,
  7.958317888067176e-08, -5.448233559035731e-09,  3.078787431819970e-10, -1.504182139137858e-11,  6.536214716607349e-13, -2.574507608174142e-14,  9.316883034027788e-16,
 -3.129196985053342e-17,  9.830043370647519e-19, -2.903976019036871e-20,  4.972930236462358e-07, -1.025676583285296e-07,  1.221946720675863e-08, -1.067156142722553e-09,
  7.518149306844160e-11, -4.495152700227878e-12,  2.353383026574501e-13, -1.101756993045458e-14,  4.682325595821349e-16, -1.826911855882847e-17,  6.601623043361312e-19,
 -2.222691404917028e-20,  2.846187526981275e-08, -8.185786613049032e-09,  1.300254469088632e-09, -1.464011412251714e-10,  1.294659288011597e-11, -9.504882319274748e-13,
  5.996834803438432e-14, -3.328790479642621e-15,  1.653535917546601e-16, -7.445151190314955e-18,  3.069154410985250e-19, -1.166378169204313e-20,  1.570835462338883e-09,
 -5.964376680545266e-10,  1.217095598138283e-10, -1.707440744778056e-11,  1.832411668374052e-12, -1.596660832409951e-13,  1.173158920368763e-14, -7.461324580699009e-16,
  4.186991041511356e-17, -2.103576431094614e-18,  9.571568997424879e-20, -3.975842841905534e-21,  6.105010250911913e-05, -2.650101742143348e-06,  7.189474198566582e-08,
 -1.569069041813669e-09,  3.003750132003195e-11, -5.275348401494715e-13,  8.697219006534405e-15, -1.350844419225337e-16,  2.054937861741736e-18, -2.968500661434613e-20,
  4.049020147428851e-22, -5.960607473041689e-24,  2.200021507781154e-04, -1.092516013066964e-05,  3.561559923158235e-07, -9.519658887278848e-09,  2.244205405260148e-10,
 -4.836358203419824e-12,  9.721755992238520e-14, -1.844012214475063e-15,  3.342888291429708e-17, -5.806751550334683e-19,  9.710415772616034e-21, -1.582393639039519e-22,
  2.369169314905804e-04, -1.417800726710622e-05,  5.729071666810190e-07, -1.889872873979034e-08,  5.447832541068759e-10, -1.421100232369060e-11,  3.426366201849197e-13,
 -7.743595038224818e-15,  1.655933790440873e-16, -3.376476070262556e-18,  6.599826252649148e-20, -1.240925002265458e-21,  1.127318332009496e-04, -8.474532913984884e-06,
  4.293276641470562e-07, -1.745443581788054e-08,  6.117326697612632e-10, -1.918203254636712e-11,  5.505520574284206e-13, -1.468569995540883e-14,  3.678163534873265e-16,
 -8.721894480717392e-18,  1.969816518446026e-19, -4.254271589559883e-21,  2.680108758479898e-05, -2.620659315565873e-06,  1.679458254304935e-07, -8.449512992794803e-09,
  3.607677525074431e-10, -1.360891272117713e-11,  4.648728494897909e-13, -1.461944164830637e-14,  4.281665181307317e-16, -1.178147709333065e-17,  3.066033532077531e-19,
 -7.581796070271972e-21,  3.330678487279833e-06, -4.378255495310936e-07,  3.604574492218677e-08, -2.272108826953943e-09,  1.193360634682802e-10, -5.457108958141893e-12,
  2.232089517344490e-13, -8.315001734263500e-15,  2.857448200622323e-16, -9.145917834344612e-18,  2.746715160478339e-19, -7.779950955129437e-21,  2.232889463395009e-07,
 -4.084435364808536e-08,  4.431050625208999e-09, -3.573292570046399e-10,  2.348093031290221e-11, -1.319660758103851e-12,  6.534781169066449e-14, -2.908760515158657e-15,
  1.180597302136616e-16, -4.416318225599362e-18,  1.535260691703501e-19, -4.988254853034460e-21,  8.952708711749630e-09, -2.348790126599592e-09,  3.460526772945679e-10,
 -3.656946420262886e-11,  3.062502650742200e-12, -2.144211360574452e-13,  1.297539491017143e-14, -6.940983557319866e-16,  3.335985234306485e-17, -1.458311501024762e-18,
  5.853986368020998e-20, -2.172073591986273e-21,  3.109275317191434e-10, -1.138928384537036e-10,  2.251553133275246e-11, -3.074701718917615e-12,  3.224785553144671e-13,
 -2.754881634577715e-14,  1.989721777542244e-15, -1.246603460369371e-16,  6.903445156152278e-18, -3.427866769733246e-19,  1.543481579266973e-20, -6.351552400820735e-22,
  5.149132501617861e-05, -2.142822972535446e-06,  5.563486011139032e-08, -1.162697381223585e-09,  2.130234735535569e-11, -3.576465819680526e-13,  5.694418476047036e-15,
 -8.375333156798248e-17,  1.223402637073720e-18, -1.779121743370508e-20,  2.102963869771672e-22, -3.121322905001602e-24,  1.813539383123383e-04, -8.478420177493690e-06,
  2.606398855185908e-07, -6.591579591090424e-09,  1.473949016184727e-10, -3.018783655894925e-12,  5.788354384156223e-14, -1.045564422294052e-15,  1.811280535558916e-17,
 -3.023617130252123e-19,  4.803101661989835e-21, -7.531424148102951e-23,  1.881190887886536e-04, -1.037273251674254e-05,  3.903113425454359e-07, -1.207338346146290e-08,
  3.279102620525971e-10, -8.087216847889486e-12,  1.848243878038705e-13, -3.970334655982465e-15,  8.083419989901236e-17, -1.571546405969899e-18,  2.937104141097907e-20,
 -5.281850688717459e-22,  8.457800302144555e-05, -5.736434019198558e-06,  2.679346067595235e-07, -1.013704308381484e-08,  3.327322905610431e-10, -9.816772821502555e-12,
  2.659685593336069e-13, -6.721783336376426e-15,  1.598619780413437e-16, -3.606974415238709e-18,  7.774144748012855e-20, -1.604179594793603e-21,  1.847891854687435e-05,
 -1.601880700225738e-06,  9.384439811091223e-08, -4.364082931286709e-09,  1.736038569934697e-10, -6.136876234725531e-12,  1.973110941452480e-13, -5.864551620794684e-15,
  1.628405537995676e-16, -4.260130506876499e-18,  1.057046348428131e-19, -2.497719753171939e-21,  2.020296136683247e-06, -2.327942570725928e-07,  1.739908803033825e-08,
 -1.008638741822183e-09,  4.918541035040761e-11, -2.102927126042641e-12,  8.086444870951756e-14, -2.845442070430348e-15,  9.273028635169571e-17, -2.824490248083141e-18,
  8.097725031936826e-20, -2.195813273246541e-21,  1.105838839399672e-07, -1.772494424902916e-08,  1.741746768029738e-09, -1.291136413337234e-10,  7.882918826761441e-12,
 -4.149460924888214e-13,  1.936912924476539e-14, -8.170995895341624e-16,  3.157529173554478e-17, -1.129068521762476e-18,  3.765229674535124e-20, -1.177341286677244e-21,
  3.168316561293161e-09, -7.444436295219128e-10,  1.005856071499385e-10, -9.887272335993176e-12,  7.782755052961707e-13, -5.163201829108760e-14,  2.979741168992161e-15,
 -1.528313189928982e-16,  7.074767245676435e-18, -2.990314244820430e-19,  1.164538018850452e-20, -4.204433475694130e-22,  6.629918956841431e-11, -2.312890812341800e-11,
  4.387000743962422e-12, -5.787978347860889e-13,  5.897159323144180e-14, -4.915162086345035e-15,  3.475514285821164e-16, -2.137783023153473e-17,  1.164959173070553e-18,
 -5.703103574512542e-20,  2.535895630720652e-21, -1.031945651127289e-22,  4.372934556448540e-05, -1.748258367145959e-06,  4.351352088350507e-08, -8.723825542407888e-10,
  1.534666720699058e-11, -2.452375504815485e-13,  3.811327599463638e-15, -5.345982765743640e-17,  7.068985003141175e-19, -1.151038566082768e-20,  1.182613941832590e-22,
 -1.116157865819534e-24,  1.511606484146535e-04, -6.673748704950954e-06,  1.939183261961791e-07, -4.649678788773334e-09,  9.884010956520824e-11, -1.924268648611749e-12,
  3.531699920238840e-14, -6.086578210295436e-16,  1.001535991368344e-17, -1.629036191586163e-19,  2.452892012519177e-21, -3.608207004716239e-23,  1.520670404116203e-04,
 -7.751467729314267e-06,  2.722613284203866e-07, -7.912899745943526e-09,  2.028341286427000e-10, -4.738334520058152e-12,  1.027504475899636e-13, -2.100838398134132e-15,
  4.080300368673451e-17, -7.559605306380789e-19,  1.352889128142869e-20, -2.334354625717133e-22,  6.525939750685672e-05, -4.001980479697487e-06,  1.727239851944997e-07,
 -6.092128530052613e-09,  1.875310552486084e-10, -5.215492566546660e-12,  1.334497962929526e-13, -3.198817369892635e-15,  7.236229215867046e-17, -1.552343233173051e-18,
  3.196619534462826e-20, -6.312712040862775e-22,  1.329741385748337e-05, -1.021277367226336e-06,  5.479397724842023e-08, -2.357829928991288e-09,  8.745336301939909e-11,
 -2.900162255055230e-12,  8.777309983457561e-14, -2.466621480723557e-15,  6.496642550758651e-17, -1.615183659454794e-18,  3.821551346766071e-20, -8.628782559970465e-22,
  1.306244854408410e-06, -1.312627301179270e-07,  8.909124611543516e-09, -4.747650197288622e-10,  2.148365699293885e-11, -8.584689921164189e-13,  3.100780963917629e-14,
 -1.029818125023591e-15,  3.179902388106937e-17, -9.206849136757135e-19,  2.517140724610519e-20, -6.526787871640063e-22,  6.010280803327941e-08, -8.342576031242702e-09,
  7.399087182757871e-10, -5.024136886115231e-11,  2.841205942753555e-12, -1.396795332014180e-13,  6.128751429133078e-15, -2.443678154151350e-16,  8.966804166981504e-18,
 -3.056902874458189e-19,  9.754135266892016e-21, -2.927864512322681e-22,  1.268658526687409e-09, -2.616097332250070e-10,  3.206904897904601e-11, -2.906808358377053e-12,
  2.135058830324851e-13, -1.333613139403658e-14,  7.298418457305982e-16, -3.570835600852625e-17,  1.584677292361262e-18, -6.448708462892123e-20,  2.426882922235406e-21,
 -8.495288177617076e-23,  1.554652176856947e-11, -5.071440392997666e-12,  9.112549042715401e-13, -1.150373188337620e-13,  1.129965972111067e-14, -9.132297617618213e-16,
  6.290047127065616e-17, -3.782453299576753e-18,  2.021089293934409e-19, -9.725587635809638e-21,  4.259462320849552e-22, -1.710254753406715e-23,  3.737166681719278e-05,
 -1.438193096756950e-06,  3.437116257506936e-08, -6.615714631069814e-10,  1.124708669746230e-11, -1.695240488660106e-13,  2.574965171963210e-15, -3.661886281949771e-17,
  3.708913962698569e-19, -7.208866368557513e-21,  1.101781830189359e-22,  7.016696957621699e-25,  1.272494143096776e-04, -5.321354193822137e-06,  1.464755899310254e-07,
 -3.335272820860878e-09,  6.761679432601917e-11, -1.249764765646984e-12,  2.199898168305920e-14, -3.657392651363102e-16,  5.598288811027754e-18, -8.971064655130600e-20,
  1.351563275559315e-21, -1.607261927752171e-23,  1.248853501756982e-04, -5.904446703103811e-06,  1.940364323581357e-07, -5.309335084896167e-09,  1.286308178131011e-10,
 -2.852517373085125e-12,  5.875795867571448e-14, -1.143374651776287e-15,  2.127692684244939e-17, -3.754410498786593e-19,  6.403511145780783e-21, -1.075404830663715e-22,
  5.161487783652905e-05, -2.868533410906339e-06,  1.146697292863337e-07, -3.778421286493542e-09,  1.091557044458553e-10, -2.869832620169075e-12,  6.938800369162401e-14,
 -1.576270536331242e-15,  3.408132526039996e-17, -6.941066898059943e-19,  1.361087482793410e-20, -2.599733253122547e-22,  9.938395640529497e-06, -6.760802303699745e-07,
  3.329688279744619e-08, -1.327999111438156e-09,  4.594069967845885e-11, -1.432239307983900e-12,  4.081098074980270e-14, -1.084037133187877e-15,  2.714053221362268e-17,
 -6.407217255686102e-19,  1.444340004489094e-20, -3.124776037618840e-22,  8.944673231760423e-07, -7.801852608948697e-08,  4.816218709925931e-09, -2.360160819583496e-10,
  9.906278813633444e-12, -3.701692305210820e-13,  1.255250388605817e-14, -3.932186555945209e-16,  1.150386093429772e-17, -3.162937132120240e-19,  8.239020120303822e-21,
 -2.041906488797127e-22,  3.561749864753195e-08, -4.232037938661840e-09,  3.382763079330944e-10, -2.098994398899048e-11,  1.096826095454495e-12, -5.026478547480309e-14,
  2.068469570865821e-15, -7.778017310151127e-17,  2.704359892546594e-18, -8.769898068933623e-20,  2.671631945580450e-21, -7.681445923625696e-23,  5.758047708885803e-10,
 -1.019459040141631e-10,  1.123528552849833e-11, -9.317202557866726e-13,  6.343165919817757e-14, -3.708540159568227e-15,  1.914233890326384e-16, -8.889820489865729e-18,
  3.764854667687715e-19, -1.468790363284984e-20,  5.320601272052814e-22, -1.799170135171571e-23,  4.110305759230077e-12, -1.221792131335799e-12,  2.046355733600350e-13,
 -2.442150676952852e-14,  2.290938084051346e-15, -1.781758407449771e-16,  1.187968953221305e-17, -6.947731628006391e-19,  3.624267601979252e-20, -1.707922034416096e-21,
  7.344251304438418e-23, -2.901688568228866e-24,  3.212255823026087e-05, -1.192157522725463e-06,  2.741011560431582e-08, -5.057114096549774e-10,  8.397576275754512e-12,
 -1.188951362854588e-13,  1.683308609619842e-15, -2.796958294366590e-17,  2.013073768172559e-19, -1.872522656842798e-21,  1.592383611578051e-22,  9.813379411459868e-25,
  1.080778018726655e-04, -4.292979998154655e-06,  1.122028939406230e-07, -2.427832235114572e-09,  4.716497610497836e-11, -8.270753519174369e-13,  1.384827884528341e-14,
 -2.289967452072018e-16,  3.203986421630753e-18, -4.635882930469479e-20,  8.820693120013864e-22, -7.064140398153569e-24,  1.040128818742013e-04, -4.575902700688312e-06,
  1.410117754973941e-07, -3.640669378554191e-09,  8.343960227180210e-11, -1.760489592151329e-12,  3.454873034158043e-14, -6.373364346688811e-16,  1.141732366410007e-17,
 -1.941789341335153e-19,  3.066703075751658e-21, -5.100213915374799e-23,  4.172512379312451e-05, -2.106690158481702e-06,  7.817038393078370e-08, -2.413672939561736e-09,
  6.538821267207757e-11, -1.630730762531517e-12,  3.740090780816682e-14, -7.993733207606259e-16,  1.664061661867982e-17, -3.251984746953904e-19,  5.900026799818813e-21,
 -1.116091425244665e-22,  7.681048544285787e-06, -4.628294145434837e-07,  2.097383511018110e-08, -7.776815571512879e-10,  2.506134534421845e-11, -7.367764509571711e-13,
  1.981161402318686e-14, -4.953779733503623e-16,  1.184145888068505e-17, -2.663690848116742e-19,  5.662950646892791e-21, -1.185155952979288e-22,  6.446921267688381e-07,
 -4.859530663724914e-08,  2.735057031937939e-09, -1.234847040312050e-10,  4.801083389620204e-12, -1.680501783005054e-13,  5.352989894715817e-15, -1.578716177310489e-16,
  4.381608073061604e-18, -1.144105758952668e-19,  2.831525845989981e-21, -6.719552484020353e-23,  2.284529565203569e-08, -2.296958879492600e-09,  1.655860070965688e-10,
 -9.381570824785274e-12,  4.519568362101318e-13, -1.929268843421945e-14,  7.435041152518007e-16, -2.631309911965679e-17,  8.657627935583944e-19, -2.665828433706696e-20,
  7.737014098127454e-22, -2.127620263337505e-23,  2.955286390217532e-10, -4.388675106564611e-11,  4.321505519237300e-12, -3.257717381311116e-13,  2.043578025987643e-14,
 -1.112729422021836e-15,  5.390975211272909e-17, -2.365560973622902e-18,  9.519856415632717e-20, -3.546099333840043e-21,  1.231701456455640e-22, -4.008995746961383e-24,
  1.259685318945096e-12, -3.292793155874881e-13,  5.043216103125742e-14, -5.608454813829675e-15,  4.968529673642458e-16, -3.685149765975780e-17,  2.360738992097325e-18,
 -1.334415786881696e-19,  6.759941682884365e-21, -3.105691421195979e-22,  1.306198700661282e-23, -5.061454875835915e-25,  2.775705873937696e-05, -9.950343346040116e-07,
  2.207568864976052e-08, -3.884319058740678e-10,  6.363894681668753e-12, -8.718268676144862e-14,  9.892284663421358e-16, -2.134317944481365e-17,  2.507191239280827e-19,
  4.366546593716423e-21,  1.169588591058721e-22, -3.873987769463999e-24,  9.253320235243147e-05, -3.500213790688466e-06,  8.710387683402940e-08, -1.789455603135277e-09,
  3.348186318848726e-11, -5.613871984313413e-13,  8.665985679944046e-15, -1.469559293124682e-16,  2.096278264415038e-18, -1.737355524566038e-20,  5.409818721155642e-22,
 -1.056842318461398e-23,  8.771761664886739e-05, -3.602275672923972e-06,  1.043029998809792e-07, -2.547662403229509e-09,  5.526475074060006e-11, -1.109889829196375e-12,
  2.091382006247337e-14, -3.639245634732777e-16,  6.186733772724775e-18, -1.064664652701268e-19,  1.534424757594195e-21, -2.122734702980918e-23,  3.438784904435410e-05,
 -1.581593466458061e-06,  5.454681565601906e-08, -1.586259381674798e-09,  4.020715872900005e-11, -9.509249364274177e-13,  2.098990458566807e-14, -4.167756204737233e-16,
  8.217088531292884e-18, -1.640751933644062e-19,  2.647138046922731e-21, -4.349670105195250e-23,  6.114541698719692e-06, -3.265234557123534e-07,  1.363370600337911e-08,
 -4.727954703646253e-10,  1.414575388552375e-11, -3.924436848732138e-13,  1.006552804258281e-14, -2.346631973339420e-16,  5.324448471522897e-18, -1.175922405666970e-19,
  2.303022515065027e-21, -4.503916779497556e-23,  4.862430515729238e-07, -3.155275979097721e-08,  1.622329358604282e-09, -6.783504938044952e-11,  2.434923668253888e-12,
 -7.992629186965520e-14,  2.404087906573157e-15, -6.641247760449334e-17,  1.747113207440655e-18, -4.371337990329411e-20,  1.018629582569986e-21, -2.303509051551414e-23,
  1.573537655188878e-08, -1.323728693485953e-09,  8.623238634930597e-11, -4.471309151449596e-12,  1.979356822404316e-13, -7.870392584530344e-15,  2.842274352434571e-16,
 -9.439828745197636e-18,  2.936586528104876e-19, -8.588500117632700e-21,  2.366551896195648e-22, -6.216362169684645e-24,  1.704482975026248e-10, -2.071888154497474e-11,
  1.818036918888654e-12, -1.240983386185640e-13,  7.133927048751978e-15, -3.604054939192243e-16,  1.632615743687233e-17, -6.740197430132815e-19,  2.568189637503255e-20,
 -9.101163705661836e-22,  3.019662805823946e-23, -9.429139236981808e-25,  4.593758866182427e-13, -1.007896753600114e-13,  1.383527252067265e-14, -1.411128983929296e-15,
  1.165766090832842e-16, -8.162066019923308e-18,  4.980858164784329e-19, -2.701470947661410e-20,  1.320834771239243e-21, -5.884774840505812e-23,  2.409734189035920e-24,
 -9.121996751125260e-26,  2.410289003027737e-05, -8.354676497765823e-07,  1.797156622934542e-08, -2.994536473070836e-10,  4.814635327273619e-12, -6.953899381411908e-14,
  5.314562628896376e-16, -1.036099585276587e-17,  4.323274478400179e-19,  3.657868181689478e-21, -1.886353599548920e-22, -8.454852235048965e-24,  7.980182725685302e-05,
 -2.880955882099963e-06,  6.850725014293476e-08, -1.333536077693855e-09,  2.403784484039150e-11, -3.956547973485406e-13,  5.420015435891086e-15, -8.678088680051716e-17,
  1.723436672416508e-18, -7.677489802484454e-21, -1.060654967315111e-22, -1.673787139137225e-23,  7.480294105230930e-05, -2.876633019285297e-06,  7.838369110112062e-08,
 -1.816840730085612e-09,  3.736289588564107e-11, -7.110220276961364e-13,  1.299504837404847e-14, -2.168977568158766e-16,  3.286713160155160e-18, -5.815868889962311e-20,
  9.907990248709454e-22, -6.316213922394344e-24,  2.882740472060538e-05, -1.211708373819169e-06,  3.882294763023246e-08, -1.071218487921033e-09,  2.541379610284945e-11,
 -5.622960144817160e-13,  1.224135502456406e-14, -2.308673914751255e-16,  3.870641351844985e-18, -8.421385594874871e-20,  1.591700317360868e-21, -1.001957125603063e-23,
  4.995395615152823e-06, -2.368214255620052e-07,  9.096288473424426e-09, -2.980610800438774e-10,  8.265340095234657e-12, -2.138232513137127e-13,  5.351709080735025e-15,
 -1.174108100487586e-16,  2.375600228719423e-18, -5.412828722123018e-20,  1.088530443389572e-21, -1.486154617837815e-23,  3.816309683375981e-07, -2.127176308489365e-08,
  9.979753218888615e-10, -3.906433706552657e-11,  1.290121278822510e-12, -3.944029249726307e-14,  1.137072877783207e-15, -2.943916676360278e-17,  7.162577021784422e-19,
 -1.760165425518924e-20,  3.956429758875162e-22, -7.865838276290717e-24,  1.154316422215626e-08, -8.045885336875790e-10,  4.737819621443450e-11, -2.266839708524259e-12,
  9.180978485605982e-14, -3.390387018872909e-15,  1.154607840541494e-16, -3.589672401551333e-18,  1.048455564730614e-19, -2.933971378733205e-21,  7.679655883165006e-23,
 -1.896504051708098e-24,  1.093892003005755e-10, -1.062658476190866e-11,  8.305905960715294e-13, -5.139633361664625e-14,  2.691839466427535e-15, -1.257704591803124e-16,
  5.319864779815177e-18, -2.057739914631056e-19,  7.395352076102775e-21, -2.489022370845843e-22,  7.859298084459879e-24, -2.344250282457623e-25,  2.028356597122180e-13,
 -3.531788294246972e-14,  4.270226968695892e-15, -3.933854566882593e-16,  2.989926858115679e-17, -1.955154398175476e-18,  1.126192911120560e-19, -5.813471102847495e-21,
  2.724449039658480e-22, -1.170116671352279e-23,  4.640323242786962e-25, -1.708173872694094e-26,  2.102752069209296e-05, -7.048608829704143e-07,  1.479647690131944e-08,
 -2.329222985019351e-10,  3.536258979800951e-12, -5.864873562325178e-14,  4.407158458360556e-16,  3.503666831480802e-18,  3.566891121379436e-19, -9.027865460436114e-21,
 -3.515078201957104e-22,  4.147332805803733e-24,  6.928126199710484e-05, -2.390928455038988e-06,  5.457221663146555e-08, -1.005885485060351e-09,  1.725964380183071e-11,
 -2.888183351392277e-13,  3.707325604184342e-15, -3.813430244494512e-17,  1.223381475467017e-18, -2.281870450477738e-20, -4.929349809621173e-22,  4.513927452625548e-24,
  6.442551772682596e-05, -2.327589258448407e-06,  5.974888083024719e-08, -1.317725614692931e-09,  2.582351063658532e-11, -4.618075298747623e-13,  8.131177750334474e-15,
 -1.380862122970340e-16,  1.842414003486320e-18, -2.402588905585370e-20,  6.849010377656462e-22, -1.020711325279899e-23,  2.452907626014288e-05, -9.463917097035337e-07,
  2.808317329576216e-08, -7.405801445702477e-10,  1.664418125265857e-11, -3.344590686632045e-13,  7.138690886902280e-15, -1.439565606359801e-16,  1.895204080246072e-18,
 -2.814770996636344e-20,  1.168877880940652e-21, -1.537794439340810e-23,  4.173794285452882e-06, -1.763945420963456e-07,  6.191783592173817e-09, -1.940322639945842e-10,
  5.044757312752551e-12, -1.177694857757393e-13,  2.889167703270296e-15, -6.522384554199566e-17,  1.084879659809962e-18, -2.049559917757207e-20,  6.326477520289205e-22,
 -9.203090893903334e-24,  3.099696362358097e-07, -1.486367692264904e-08,  6.311592995277939e-10, -2.349030742593664e-11,  7.186963803933356e-13, -1.994282160312136e-14,
  5.568716696525212e-16, -1.415753552743411e-17,  3.020456641363643e-19, -6.827908219385100e-21,  1.764696249652382e-22, -3.187103780027647e-24,  8.940095897421954e-09,
 -5.137199560238778e-10,  2.716059425207744e-11, -1.218206676757975e-12,  4.518245515091312e-14, -1.526160359931766e-15,  4.948518825470309e-17, -1.462808567132008e-18,
  3.913213344289553e-20, -1.037909545733954e-21,  2.712441647312568e-23, -6.167290191575526e-25,  7.709468611308376e-11, -5.870889171956471e-12,  4.073245127956884e-13,
 -2.307903231658753e-14,  1.096119851333558e-15, -4.701511481009100e-17,  1.862676850067468e-18, -6.749043495776475e-20,  2.267393318309205e-21, -7.240835804644780e-23,
  2.186290305620826e-24, -6.167378000611698e-26,  1.084896087783158e-13, -1.414060864717770e-14,  1.487884812601223e-15, -1.225514886952676e-16,  8.450749816193147e-18,
 -5.105857091000417e-19,  2.753026174520752e-20, -1.341093631935822e-21,  5.977146182861108e-23, -2.459502600103708e-24,  9.392880298651181e-26, -3.343364701892133e-27,
  1.842836408606378e-05, -5.967926441268004e-07,  1.230418048814460e-08, -1.850993867729094e-10,  2.482086877975736e-12, -4.598692234113689e-14,  6.340824401208410e-16,
  7.682168046307598e-18, -1.299251018895737e-19, -1.448713062348994e-20,  1.617024577178244e-22,  1.484648145966554e-23,  6.052034296532781e-05, -1.998347714185748e-06,
  4.398273226306516e-08, -7.714021239379918e-10,  1.230575510447649e-11, -2.091066529622952e-13,  3.042093180071582e-15, -1.497913549877333e-17,  1.791335541002214e-19,
 -2.971610840637236e-20,  3.050288364732412e-22,  2.476199566832841e-23,  5.598006576731248e-05, -1.906464176627490e-06,  4.614146128578745e-08, -9.690388849881090e-10,
  1.825731275538806e-11, -3.070288349472921e-13,  4.991997526970341e-15, -8.870703940219092e-17,  1.340865186263625e-18, -7.778896932890940e-21,  1.022919324500396e-22,
 -1.322308760220343e-23,  2.114234565825502e-05, -7.532011877644245e-07,  2.059999566394576e-08, -5.197341423623809e-10,  1.137428648255834e-11, -2.052999395212608e-13,
  3.859537020523718e-15, -9.217518163233144e-17,  1.508132202852338e-18, -3.911546248364128e-22,  1.277872940836034e-22, -2.673101894279407e-23,  3.554266764880615e-06,
 -1.349590022556189e-07,  4.280626504713836e-09, -1.289493232971403e-10,  3.252790548146003e-12, -6.694972630815171e-14,  1.467911853817681e-15, -3.828757641378235e-17,
  6.949061945926836e-19, -4.362062629246321e-21,  1.550000060701440e-22, -1.132593314165669e-23,  2.590694397126047e-07, -1.077264525643161e-08,  4.071339845647943e-10,
 -1.457346714318435e-11,  4.262175643315567e-13, -1.042738243855154e-14,  2.670687537976779e-16, -7.313268497397160e-18,  1.529362890799599e-19, -2.220348002916748e-21,
  6.032581694800480e-23, -2.216042976813503e-24,  7.241948056575315e-09, -3.445801554518032e-10,  1.604863306475786e-11, -6.867024029266287e-13,  2.382638337537576e-14,
 -7.166959821667088e-16,  2.167172128393703e-17, -6.430316724373060e-19,  1.608804640551267e-20, -3.570989219551618e-22,  9.463743401406946e-24, -2.556423690962143e-25,
  5.871760176071698e-11, -3.480306698191753e-12,  2.109840671035937e-13, -1.115541858770906e-14,  4.837825696989417e-16, -1.870350106046492e-17,  6.921648087526191e-19,
 -2.393783660181646e-20,  7.469614701876407e-22, -2.198240905834678e-23,  6.449311410123059e-25, -1.784927911624644e-26,  6.887309840441647e-14, -6.414836000000228e-15,
  5.804540085328443e-16, -4.285247830405747e-17,  2.650191385698882e-18, -1.459274738504577e-19,  7.319375446973516e-21, -3.346636063949356e-22,  1.404987634573035e-23,
 -5.493283132175288e-25,  2.013527246625338e-26, -6.899131074640691e-28,  1.622486095356980e-05, -5.066330620339370e-07,  1.029376251635155e-08, -1.518578830219370e-10,
  1.727733219160925e-12, -2.906659954014810e-14,  7.279196280155495e-16, -2.499589767416562e-18, -4.113472900938413e-19,  9.564273739096175e-22,  4.670625538058579e-22,
 -3.875254351478027e-24,  5.317638723470462e-05, -1.680458763162396e-06,  3.578171187078904e-08, -6.041426104644701e-10,  8.819367260086442e-12, -1.413382326817105e-13,
  2.569816841115212e-15, -2.218750130565610e-17, -4.600745979887709e-19, -2.095021068350101e-21,  8.400579666618233e-22, -6.020392278536364e-24,  4.902526957943788e-05,
 -1.579308604966198e-06,  3.608203934507528e-08, -7.202974263775508e-10,  1.313761019398147e-11, -2.124330241113533e-13,  3.066821411041783e-15, -5.042358972044545e-17,
  1.026761223260570e-18, -1.154851738902733e-20, -1.760270473287248e-22,  1.844343575346328e-24,  1.842363369836815e-05, -6.105379720390401e-07,  1.533376024814581e-08,
 -3.663403448367929e-10,  8.013612345519154e-12, -1.382177621726896e-13,  1.947378109433707e-15, -4.512986375562891e-17,  1.355550018504956e-18, -1.242375606381710e-20,
 -5.088078210944837e-22,  2.210493477624404e-24,  3.074249206633509e-06, -1.061097578229919e-07,  3.006625502161767e-09, -8.602338034982243e-11,  2.191713069502003e-12,
 -4.219612425019291e-14,  6.870141860857439e-16, -1.822155011562672e-17,  5.488878465532750e-19, -5.778338303327747e-21, -1.441269654552352e-22, -5.483827714812455e-25,
  2.215306634233243e-07, -8.113063767853128e-09,  2.672472088548382e-10, -9.134599716062420e-12,  2.677711793873324e-13, -5.983494212798917e-15,  1.211227307581799e-16,
 -3.400061333107298e-18,  9.659723185488597e-20, -1.334266084907739e-21, -3.067219444333162e-24, -4.791567546850553e-25,  6.076127996107010e-09, -2.436044073937181e-10,
  9.699564348057937e-12, -3.970971196573757e-13,  1.349346750251620e-14, -3.642079755996388e-16,  9.351588142207375e-18, -2.795153841593213e-19,  7.837263205414355e-21,
 -1.491519498973531e-22,  2.193854357862040e-24, -8.199950981719872e-26,  4.747880837248248e-11, -2.219832646904061e-12,  1.136184638393720e-13, -5.692047443929781e-15,
  2.329402685534623e-16, -8.019071494852545e-18,  2.657020058986184e-19, -8.950338600355205e-21,  2.754532229661456e-22, -7.206423998129112e-24,  1.827035803805996e-25,
 -5.358137690290933e-27,  5.003192025544011e-14, -3.279849289294830e-15,  2.483234411153801e-16, -1.671448689271476e-17,  9.306394217307348e-19, -4.580716416280689e-20,
  2.108451955070153e-21, -9.079479842635777e-23,  3.589042964147616e-24, -1.311184773727494e-25,  4.550994288316828e-27, -1.512505364301072e-28,  1.435210040746402e-05,
 -4.311404329671009e-07,  8.621094889525143e-09, -1.279645915768731e-10,  1.308305147531345e-12, -1.377756255954129e-14,  5.009812418239896e-16, -1.215840448260813e-17,
 -1.278456445017112e-19,  1.158033048836402e-20,  3.945931336091119e-24, -1.200081026150333e-23,  4.698427413450827e-05, -1.420999275050802e-06,  2.929558460180428e-08,
 -4.825357581637666e-10,  6.550914554266584e-12, -8.864286457303731e-14,  1.771493699367126e-15, -3.271370360572388e-17, -7.637041198846814e-20,  1.791509079953495e-20,
  4.779020461836324e-23, -2.115573157732203e-23,  4.323525443585029e-05, -1.321952183113493e-06,  2.857126685643821e-08, -5.405043847724228e-10,  9.528032135894838e-12,
 -1.524835211195957e-13,  2.044758644804809e-15, -2.520771845222825e-17,  5.342721861272862e-19, -1.392706313611943e-20,  9.321017529717134e-23,  6.804356847327068e-24,
  1.620179892851220e-05, -5.034679140584544e-07,  1.162300912817258e-08, -2.580460247381735e-10,  5.637385021411583e-12, -1.022817655679531e-13,  1.199466409429495e-15,
 -1.213647609586926e-17,  6.394731176511884e-19, -2.330267631991846e-20,  7.068283214391481e-23,  1.646718857748993e-23,  2.692141906234533e-06, -8.564877373814375e-08,
  2.159407749640907e-09, -5.695208029163473e-11,  1.480652342046965e-12, -3.007470218068252e-14,  3.842558804895956e-16, -4.942571255410689e-18,  2.609277278848223e-19,
 -8.983187293452112e-21,  3.058337290629938e-23,  5.718793847420288e-24,  1.927520920267104e-07, -6.348919072250148e-09,  1.798259819922603e-10, -5.676340966933399e-12,
  1.710716804705963e-13, -3.915321618913300e-15,  6.172610006329361e-17, -1.110870553214093e-18,  4.591655676313464e-20, -1.396557971510627e-21,  8.115044649690220e-24,
  6.172228180337245e-25,  5.231261549471929e-09, -1.818840465392949e-10,  6.022723513843265e-12, -2.294902471575825e-13,  7.946931188521421e-15, -2.098333082188934e-16,
  4.320695133715986e-18, -1.024008234074926e-19,  3.526266316586517e-21, -9.700698567993871e-23,  1.089808283250101e-24,  9.816618936150307e-27,  4.006055186636944e-11,
 -1.531041035371554e-12,  6.331037309347647e-14, -2.971518148954690e-15,  1.203112217820979e-16, -3.852177302538827e-18,  1.074111162622337e-19, -3.231438152238242e-21,
  1.063909088156393e-22, -2.975399813439803e-24,  5.959236059874738e-26, -1.092276644703753e-27,  3.989917254556452e-14, -1.897692611549618e-15,  1.138635733359162e-16,
 -7.080523606435825e-18,  3.668817461723935e-19, -1.610031609155829e-20,  6.554405549164313e-22, -2.621105082364379e-23,  1.001006727812581e-24, -3.470572031361421e-26,
  1.097163981903038e-27, -3.370842333347268e-29,  1.275623028890011e-05, -3.679754045929124e-07,  7.203814194069549e-09, -1.087021423584221e-10,  1.124590578347505e-12,
 -5.937517441795045e-15,  1.610723559059284e-16, -1.039474045126320e-17,  1.940525221434320e-19,  4.550963530577721e-21, -2.587584842679995e-22,  6.204407483996915e-25,
  4.173468860774251e-05, -1.208135735268094e-06,  2.408217519373005e-08, -3.899029195303758e-10,  5.130041061740118e-12, -5.682549235325200e-14,  9.118225986038868e-16,
 -2.597864345925556e-17,  4.279366915936943e-19,  6.894490415332645e-21, -4.322590904782244e-22,  5.649026764344691e-25,  3.836688134131366e-05, -1.116950155560799e-06,
  2.290731898208715e-08, -4.099976686697687e-10,  6.920085191396787e-12, -1.103724799056358e-13,  1.510833762323062e-15, -1.495498028848299e-17,  1.522822910202196e-19,
 -6.467082004982447e-21,  2.178090376230327e-22, -1.298146159517651e-24,  1.435625596717241e-05, -4.214824257664094e-07,  9.004970025852321e-09, -1.827322655377839e-10,
  3.860928994568813e-12, -7.598497222187038e-14,  1.030928087183987e-15, -3.382242867084400e-18, -1.351054955400546e-20, -1.057125758745047e-20,  4.294627685705724e-22,
 -1.283087059481406e-24,  2.380281160992881e-06, -7.074710975143589e-08,  1.599803485005457e-09, -3.760625972340862e-11,  9.638443594169106e-13, -2.184927539316366e-14,
  3.183080934064702e-16, -1.117303894381321e-18,  7.572482136909702e-21, -4.216676750864005e-21,  1.605406156341032e-22, -3.918940448045529e-25,  1.698606816101283e-07,
 -5.141714775942989e-09,  1.257864499720201e-10, -3.493306244106148e-12,  1.057330991153598e-13, -2.684125060660876e-15,  4.435682940126171e-17, -3.371654618234003e-19,
  6.857171249705329e-21, -6.740356262079959e-22,  2.267606273560221e-23, -6.501556667241157e-26,  4.585319957570402e-09, -1.428426089117090e-10,  3.909311287723171e-12,
 -1.310621296087120e-13,  4.608362801977506e-15, -1.306952518512892e-16,  2.573574017175237e-18, -3.611901383089579e-20,  9.245506370682512e-22, -4.570028252778589e-23,
  1.329584885356624e-24, -7.586603902804498e-27,  3.476298695567523e-11, -1.139540164180523e-12,  3.704343626887489e-14, -1.547786030927835e-15,  6.333948694945638e-17,
 -2.059745744321181e-18,  5.134848809922221e-20, -1.150950724432345e-21,  3.399428986813320e-23, -1.215320993789058e-24,  3.272465889371266e-26, -4.425090834441884e-28,
  3.370646507227139e-14, -1.246794863927834e-15,  5.570809574280070e-17, -3.128468741264146e-18,  1.574535603031293e-19, -6.467032963750534e-21,  2.292453059068972e-22,
 -7.907284295945876e-24,  2.852347754180390e-25, -1.006456807951694e-26,  3.127213500981485e-28, -8.346457845569238e-30,  1.139174946523590e-05, -3.152648010129156e-07,
  6.003873664686360e-09, -9.153372255645868e-11,  1.024944273368875e-12, -4.778414140889554e-15, -3.156317490160577e-17, -3.353799709607088e-18,  2.003804516873766e-19,
 -3.019347423187699e-21, -9.018350086379893e-23,  4.785833180929747e-24,  3.725969228168980e-05, -1.032878060522990e-06,  1.986156620742969e-08, -3.159429893646550e-10,
  4.162004915781215e-12, -4.200651904629118e-14,  3.913437911986349e-16, -1.132566509845702e-17,  4.107911189004451e-19, -5.876919757679215e-21, -1.516703971052442e-22,
  8.232628371661614e-24,  3.423688942669507e-05, -9.516448694652218e-07,  1.858484101662422e-08, -3.151004383980031e-10,  5.043455611945738e-12, -7.874621314579786e-14,
  1.136203985959590e-15, -1.232602651651895e-17,  4.980644657878423e-20, -1.614534666314286e-22,  8.254974084440456e-23, -3.430292704869502e-24,  1.280185924377379e-05,
 -3.572705804006889e-07,  7.136938911335897e-09, -1.318071364566190e-10,  2.579646411860161e-12, -5.266827024278326e-14,  8.948040753608389e-16, -6.925545053275123e-18,
 -1.312068113426937e-19,  2.184005086739175e-21,  1.644754127968406e-22, -7.438149794877134e-24,  2.120361161464455e-06, -5.952218662781607e-08,  1.227950485814359e-09,
 -2.527708357088861e-11,  6.004188352823441e-13, -1.465635840064097e-14,  2.758050182174007e-16, -2.183004491237872e-18, -4.506270665784835e-20,  6.213688398882520e-22,
  6.438434241681254e-23, -2.762775998204143e-24,  1.510765921006035e-07, -4.278061492078239e-09,  9.242478947884627e-11, -2.176187309701749e-12,  6.198626966672544e-14,
 -1.724565907340301e-15,  3.550084319434752e-17, -3.473887859562354e-19, -3.345549129798215e-21,  1.635618301010219e-23,  9.614319171556744e-24, -3.742631035249537e-25,
  4.068071086228208e-09, -1.167839995655700e-10,  2.702750171881394e-12, -7.518338181976864e-14,  2.542283834985623e-15, -7.890022118452974e-17,  1.796275889853133e-18,
 -2.368571427040677e-20,  9.236497519868408e-23, -5.652669014432819e-24,  5.842407256181138e-25, -1.972008931769856e-26,  3.070057471294429e-11, -9.030008167697993e-13,
  2.338247853998625e-14, -8.061372305557089e-16,  3.235141943421016e-17, -1.123523889108005e-18,  2.935240070111098e-20, -5.490088620946317e-22,  9.063025062096232e-24,
 -2.986032335402438e-25,  1.343949753100991e-26, -3.897077943066487e-28,  2.942241945681072e-14, -9.166679603876186e-16,  2.981320915156183e-17, -1.405284509169583e-18,
  6.937306738421030e-20, -2.854075955193343e-21,  9.493207715609712e-23, -2.737723222788188e-24,  8.056758216594928e-26, -2.720977586530442e-27,  9.382253949751236e-29,
 -2.746838849175521e-30,  1.022017920659997e-05, -2.713562867079272e-07,  5.000517552765421e-09, -7.596066656955916e-11,  9.174525834746045e-13, -6.054248523988010e-15,
 -5.486021179684288e-17,  9.840797753128958e-19,  6.946568371023370e-20, -3.341402146251551e-21,  4.694009085891674e-23,  1.231483260421120e-24,  3.342347110223739e-05,
 -8.880796998168400e-07,  1.644349522364007e-08, -2.556455224023632e-10,  3.396857569693679e-12, -3.515556058872522e-14,  2.218047871001474e-16, -2.112959507871054e-18,
  1.638067093360429e-19, -6.264033854990569e-21,  8.566842275333967e-23,  2.134461079415787e-24,  3.070551008256829e-05, -8.168297798919867e-07,  1.524032169456853e-08,
 -2.456369348865863e-10,  3.714234249309005e-12, -5.542797996979428e-14,  8.155321039103878e-16, -1.044494315697701e-17,  7.303182203378208e-20,  8.012074919265772e-22,
 -1.551456543119766e-23, -9.397283025901308e-25,  1.147784475336273e-05, -3.058729805486563e-07,  5.771719935562650e-09, -9.786610050508182e-11,  1.723301226592632e-12,
 -3.389086887472078e-14,  6.596372778010589e-16, -9.160140273112785e-18, -9.413716163149774e-22,  3.612709401161498e-21, -5.200400050879221e-23, -2.063039684754638e-24,
  1.900202558839144e-06, -5.076862362464863e-08,  9.736945003488992e-10, -1.767906806639765e-11,  3.678264943559288e-13, -8.900449870194432e-15,  2.001512160553809e-16,
 -2.980669031933700e-18, -1.318589961988296e-21,  1.265952072944213e-21, -1.715184896079985e-23, -8.007181203284634e-25,  1.352984571212186e-07, -3.628597694129563e-09,
  7.126346200842012e-11, -1.417542139562076e-12,  3.517433190355138e-14, -9.989047070807597e-16,  2.472296892155168e-17, -3.994937842081460e-19,  7.573339578920178e-22,
  1.367967993658719e-22, -1.613210867109438e-24, -1.155856873396263e-25,  3.639301103405442e-09, -9.818510906041144e-11,  1.999517859804035e-12, -4.500914848749792e-14,
  1.343055680160656e-15, -4.347960391089374e-17,  1.167063847655185e-18, -2.098920148569427e-20,  1.295082673577799e-22,  3.729353156566780e-24, -1.494844525812186e-26,
 -6.580441947419766e-27,  2.741188012895728e-11, -7.473189732117454e-13,  1.618394966022119e-14, -4.347366379536282e-16,  1.581864076438465e-17, -5.777387519434748e-19,
  1.699031886662107e-20, -3.565504089766718e-22,  4.509205144724309e-24, -3.110942559964270e-26,  1.840703268658850e-27, -1.355676419913310e-28,  2.614775376710497e-14,
 -7.303918702758690e-16,  1.806622234164773e-17, -6.499433818358525e-19,  3.006562514991078e-20, -1.273860375589359e-21,  4.366416217653184e-23, -1.193909669077423e-24,
  2.771391574735299e-26, -6.803622539562741e-28,  2.222094490790697e-29, -8.014921819174919e-31,  9.209328986831461e-06, -2.347583180622324e-07,  4.172871122722077e-09,
 -6.230903721147264e-11,  7.863123129242407e-13, -6.885606975367007e-15, -1.132946947872551e-17,  1.699379204907445e-18, -1.151905298937300e-20, -1.165737002748993e-21,
  4.787682167174654e-23, -6.997698189125422e-25,  3.011605539531248e-05, -7.679304002433269e-07,  1.367954689817441e-08, -2.066433282187882e-10,  2.744460034852786e-12,
 -3.013176732172938e-14,  2.074548300416995e-16,  2.761319172156640e-19,  9.417692925113518e-21, -2.332839260118442e-21,  8.643328532130522e-23, -1.245854060854107e-24,
  2.766469101693747e-05, -7.057653221841612e-07,  1.261584768617562e-08, -1.941086066988611e-10,  2.779171018279572e-12, -3.907960605604287e-14,  5.589773222086675e-16,
 -7.812934116963631e-18,  8.576354547603575e-20, -1.233988873378865e-22, -2.138253269673449e-23,  3.523580511091183e-25,  1.033986287400738e-05, -2.639744099760057e-07,
  4.742946587374819e-09, -7.494154524828972e-11,  1.183451948221403e-12, -2.103785871610193e-14,  4.187871217494383e-16, -7.609892032811997e-18,  8.134944083314755e-20,
  9.205442314949534e-22, -6.104869645609734e-23,  9.160172833633126e-25,  1.711488941867006e-06, -4.373958660802168e-08,  7.917514935745543e-10, -1.298489760752417e-11,
  2.312266022024420e-13, -5.066861221308409e-15,  1.217573260172908e-16, -2.465642665312189e-18,  2.773979188883861e-20,  3.260922641765303e-22, -2.172215337413451e-23,
  3.204884161167721e-25,  1.218282949485562e-07, -3.118291981188984e-09,  5.706468746527595e-11, -9.860402801036505e-13,  2.025496828047773e-14, -5.331104661067106e-16,
  1.449018615772507e-17, -3.149164746302184e-19,  3.876991201752121e-21,  3.131956297952239e-23, -2.557610093713989e-24,  3.662823209519135e-26,  3.275572149970525e-09,
 -8.404124845645107e-11,  1.564052094750425e-12, -2.914507206431407e-14,  7.088530995346359e-16, -2.194442419554583e-17,  6.544670350426314e-19, -1.517903558957549e-20,
  2.126620050111766e-22,  4.182292956541264e-25, -9.412089431405293e-26,  1.212110589969083e-27,  2.465358616462630e-11, -6.351619817135111e-13,  1.216756824106515e-14,
 -2.550323328703927e-16,  7.613874086164353e-18, -2.742171935774812e-19,  8.909524765714636e-21, -2.242177660453512e-22,  3.780988887677912e-24, -2.403605861171176e-26,
 -5.083975992415179e-28, -2.723044164685576e-31,  2.347524742427555e-14, -6.104978295503968e-16,  1.246964289590336e-17, -3.255770064641747e-19,  1.279969403978708e-20,
 -5.447445202422802e-22,  1.987638453883022e-23, -5.795932919145759e-25,  1.319064642859587e-26, -2.395277782487207e-28,  4.508214231061923e-30, -1.455678031223760e-31,
  8.332614282695898e-06, -2.041627921100508e-07,  3.496097856542293e-09, -5.082946165965214e-11,  6.493984854050888e-13, -6.655330644017515e-15,  2.704505989144178e-17,
  9.641739012428430e-19, -2.700462475619548e-20,  8.941405255894007e-23,  1.589731374190690e-23, -5.917468697156756e-25,  2.724849736991295e-05, -6.677104416694093e-07,
  1.144429136495683e-08, -1.672800697718074e-10,  2.192164606565093e-12, -2.508259114848181e-14,  2.108731588009717e-16, -2.140396075858752e-19, -2.653433549362359e-20,
 -4.817162137852353e-23,  2.962031108810860e-23, -1.051466140974983e-24,  2.502972546493722e-05, -6.134548315969666e-07,  1.052972338559153e-08, -1.552346046521629e-10,
  2.115580211883790e-12, -2.798835332862888e-14,  3.769874940352658e-16, -5.270746919680740e-18,  7.013108162511352e-20, -6.290864617317100e-22, -4.290717969045698e-24,
  3.190679657257704e-25,  9.354573165128422e-06, -2.293348993777951e-07,  3.944958746470850e-09, -5.889318353175720e-11,  8.475400981663880e-13, -1.323383558747138e-14,
  2.442762759192732e-16, -4.861006327657148e-18,  8.127585249850647e-20, -6.305066373328091e-22, -1.762190160492841e-23,  8.100294001968700e-25,  1.548291570538334e-06,
 -3.797273509793277e-08,  6.552410541297906e-10, -9.958780537495662e-12,  1.540640634902780e-13, -2.867231078744048e-15,  6.589285621861718e-17, -1.527084972881434e-18,
  2.765273315187164e-20, -2.257438402691579e-22, -6.211782116572555e-24,  2.912561896565836e-25,  1.102000702583029e-07, -2.704296463402642e-09,  4.687846669197066e-11,
 -7.311019404553365e-13,  1.243075859952603e-14, -2.767146232059876e-16,  7.458959280901092e-18, -1.889278104906978e-19,  3.615062936406063e-21, -3.318217163772503e-23,
 -6.922028165954645e-25,  3.558929003437892e-26,  2.962451363636653e-09, -7.276345932181896e-11,  1.270280664344781e-12, -2.059182701344281e-14,  3.965594293192585e-16,
 -1.057727006927294e-17,  3.225656812615621e-19, -8.726453977274180e-21,  1.767394236055987e-22, -1.918369814666853e-24, -2.186318955084067e-26,  1.442843203252609e-27,
  2.229069437241509e-11, -5.483429806516821e-13,  9.689497449455119e-15, -1.673671885464271e-16,  3.826081714708367e-18, -1.229814078025488e-19,  4.170381254571417e-21,
 -1.203869180222440e-22,  2.635816336425776e-24, -3.596297209631061e-26, -4.489049596503697e-30,  1.294351021978667e-29,  2.121203244397001e-14, -5.235707161213539e-16,
  9.502703526166082e-18, -1.867735874346824e-19,  5.577067796709420e-21, -2.217161744008897e-22,  8.455825513182884e-24, -2.693702098657775e-25,  6.822301893345314e-27,
 -1.311106677817509e-28,  1.783932717072524e-30, -1.955363859265775e-32,  7.568274008586811e-06, -1.784670353313293e-07,  2.944229295203179e-09, -4.146117775350765e-11,
  5.244897419152349e-13, -5.773686127932572e-15,  4.304722077757201e-17,  2.313327791112322e-19, -1.740255810082762e-20,  3.363568513410089e-22, -5.109220344896547e-25,
 -1.808561058735967e-25,  2.474884473537938e-05, -5.836256413441149e-07,  9.631704911616448e-09, -1.359473921961916e-10,  1.740157546046672e-12, -2.018490630538444e-14,
  1.939078216467366e-16, -9.385652631308160e-19, -1.595034388736892e-20,  4.441633799432902e-22,  3.625992385973195e-25, -3.259383799709824e-25,  2.273334391730851e-05,
 -5.361324477168101e-07,  8.852997193355747e-09, -1.254177559646878e-10,  1.635555527841159e-12, -2.047954648430878e-14,  2.573207564199301e-16, -3.399206000195781e-18,
  4.707540941184807e-20, -5.964508100058637e-22,  4.147056008218351e-24,  7.944884653324888e-26,  8.496178311521311e-06, -2.003898265516130e-07,  3.311787509813666e-09,
 -4.717271275033754e-11,  6.318820507315882e-13, -8.734929935397861e-15,  1.405455150104645e-16, -2.700996214683918e-18,  5.276468836868268e-20, -8.091601517371068e-22,
  4.372126063065581e-24,  2.270255904301487e-25,  1.406181657824475e-06, -3.317078789555778e-08,  5.488761693565936e-10, -7.879435666473606e-12,  1.095507427853291e-13,
 -1.707589495111814e-15,  3.408431923408135e-17, -7.992062006529980e-19,  1.752184655602011e-20, -2.854202104306068e-22,  1.663623463584396e-24,  8.011768503720381e-26,
  1.000816647881760e-07, -2.361345898269977e-09,  3.914308937366298e-11, -5.683365433631504e-13,  8.320523794382665e-15, -1.493356225344512e-16,  3.586096899435474e-18,
 -9.514600996049447e-20,  2.222697757532462e-21, -3.792295162173023e-23,  2.603247604009530e-25,  9.324924456038010e-27,  2.690291111736439e-09, -6.349547092244918e-11,
  1.055428789340285e-12, -1.559104625407179e-14,  2.456571154928298e-16, -5.195851253722201e-18,  1.464349072561651e-19, -4.241348841503120e-21,  1.040490003094296e-22,
 -1.871644623388180e-24,  1.598508635468564e-26,  3.389477359544857e-28,  2.024089559899939e-11, -4.779765784084698e-13,  7.982091191098333e-15, -1.213784740482917e-16,
  2.138563386575403e-18, -5.498461521159361e-20,  1.791018261032482e-21, -5.587082438889140e-23,  1.445262486359490e-24, -2.806767964138695e-26,  3.164204731263871e-28,
  1.943669108990304e-30,  1.925737196965157e-14, -4.552737374777205e-16,  7.680152609608427e-18, -1.241605688565449e-19,  2.671878195739999e-21, -8.851908280011718e-23,
  3.350455961411332e-24, -1.141531385314143e-25,  3.226292427096193e-27, -7.241081517384019e-29,  1.198551370983833e-30, -1.166790459787723e-32,  6.898552787898279e-06,
 -1.567690807765834e-07,  2.493420973246764e-09, -3.393578850164996e-11,  4.195927762343383e-13, -4.715003311715651e-15,  4.345316529938297e-17, -1.467554641432972e-19,
 -6.906130389954749e-21,  2.272700655171467e-22, -3.621002264858924e-24,  2.836207509069243e-27,  2.255874722776646e-05, -5.126532402213512e-07,  8.154861852624393e-09,
 -1.110913877442905e-10,  1.380631826908488e-12, -1.588981895129198e-14,  1.627839099719576e-16, -1.210342344716070e-18, -1.967796346573291e-21,  2.962410052123439e-22,
 -5.424463860929608e-24, -1.676517040714132e-27,  2.072151990844189e-05, -4.709127493093055e-07,  7.492486296968265e-09, -1.022195884448413e-10,  1.280812298065467e-12,
 -1.529433394005653e-14,  1.802593512770833e-16, -2.200141809176279e-18,  2.904150291669610e-20, -4.014087023507394e-22,  4.852399938149846e-24, -2.515825619000425e-26,
  7.744248976699996e-06, -1.760001460306051e-07,  2.801141526627813e-09, -3.829952805420129e-11,  4.856659559884887e-13, -6.103923681557440e-15,  8.449853997075606e-17,
 -1.431744916171599e-18,  2.824149478746933e-20, -5.337002178003854e-22,  7.558780696146302e-24, -2.900362784070890e-26,  1.281720656042691e-06, -2.913053397410949e-08,
  4.638384766353554e-10, -6.361976719373284e-12,  8.205584068425567e-14, -1.103648921050963e-15,  1.813147404285079e-17, -3.854945411306463e-19,  8.951565622320816e-21,
 -1.841674429509593e-22,  2.737107747437424e-24, -1.191104181397605e-26,  9.122230628415997e-08, -2.073418726957756e-09,  3.303624685166268e-11, -4.552021117276833e-13,
  6.015177607110263e-15, -8.837635058679296e-17,  1.730066618525157e-18, -4.333934744132242e-20,  1.101321951436597e-21, -2.373674844824393e-23,  3.676568390542604e-25,
 -1.988840313002066e-27,  2.452096436981305e-09, -5.574042478716177e-11,  8.890129208852719e-13, -1.233527597221760e-14,  1.689630726358266e-16, -2.787622278039288e-18,
  6.514955596004867e-20, -1.849400246968106e-21,  4.998909433841353e-23, -1.119816021415097e-24,  1.824689330574782e-26, -1.288209558108890e-28,  1.844820530250632e-11,
 -4.194350271835594e-13,  6.700875699159017e-15, -9.407246060027537e-17,  1.365371903457105e-18, -2.639127481401765e-20,  7.399662943355533e-22, -2.330419780577005e-23,
  6.649524072470575e-25, -1.559738810975909e-26,  2.741184792376729e-28, -2.656271788877068e-30,  1.755060194482918e-14, -3.991762776409922e-16,  6.399930594220345e-18,
 -9.210922092161881e-20,  1.497903034963627e-21, -3.690004724051488e-23,  1.267816570758561e-24, -4.436953227486535e-26,  1.359375265345658e-27, -3.461274906203093e-29,
  7.014858646941387e-31, -1.025969806097487e-32,  6.308944208659847e-06, -1.383433087274865e-07,  2.123539354620332e-09, -2.792180088089675e-11,  3.352880906802531e-13,
 -3.739821656358530e-15,  3.728775562443068e-17, -2.634586331512523e-19, -1.143800353355108e-21,  1.007901619272438e-22, -2.481224837114685e-24,  3.506514270623476e-26,
  2.063066909780131e-05, -4.523940309061388e-07,  6.944474628377458e-09, -9.134291807004769e-11,  1.099158221222045e-12, -1.238840403196317e-14,  1.293265338770269e-16,
 -1.142752592542137e-18,  5.053659671695961e-21,  1.060112059616537e-22, -3.688418439663614e-24,  5.618393901837260e-26,  1.895044299073042e-05, -4.155528353335901e-07,
  6.379423341793772e-09, -8.395784128892786e-11,  1.013688680893742e-12, -1.161442070361516e-14,  1.297452872447395e-16, -1.467273787740919e-18,  1.774041974964419e-20,
 -2.370693140558656e-22,  3.278851897248381e-24, -3.802840767609292e-26,  7.082330983621357e-06, -1.553059130536281e-07,  2.384466178130432e-09, -3.140731494020622e-11,
  3.810796922062479e-13, -4.470660310980358e-15,  5.456782068785247e-17, -7.809844702691085e-19,  1.396087501424067e-20, -2.770040229959565e-22,  5.021465891651236e-24,
 -6.656574218204998e-26,  1.172165897077071e-06, -2.570442189684756e-08,  3.947115134148126e-10, -5.205182515600481e-12,  6.360404532034686e-14, -7.710567192827445e-16,
  1.049339422571748e-17, -1.855131622672641e-19,  4.095508369579684e-21, -9.215305597326273e-23,  1.778507081277211e-24, -2.455220036199406e-26,  8.342476496175236e-08,
 -1.829463789722769e-09,  2.809928296866772e-11, -3.711935792582368e-13,  4.582156381051444e-15, -5.812787344875862e-17,  9.004445031882902e-19, -1.915933309832001e-20,
  4.823211158739490e-22, -1.157725894962969e-23,  2.315114415657670e-25, -3.319912890782624e-27,  2.242481361662954e-09, -4.917821766459504e-11,  7.556042013558725e-13,
 -1.000771561478686e-14,  1.254455407860205e-16, -1.697200348599607e-18,  3.063042477297666e-20, -7.670433294668151e-22,  2.115888731525157e-23, -5.310411536677908e-25,
  1.096683008527379e-26, -1.651296632226889e-28,  1.687100785115203e-11, -3.700069109810561e-13,  5.688274108906147e-15, -7.566874327275240e-17,  9.727658850777651e-19,
 -1.450691678879042e-20,  3.146337361394372e-22, -9.134009917477418e-24,  2.711181618473581e-25, -7.095561909279741e-27,  1.527514089113492e-28, -2.476044641176532e-30,
  1.604980801697097e-14, -3.520377767723572e-16,  5.418449952161742e-18, -7.274051908982942e-20,  9.847043300943751e-22, -1.744352430009361e-23,  4.809610329879669e-25,
 -1.620831024064338e-26,  5.197026387754918e-28, -1.445401915409767e-29,  3.360881415136549e-31, -6.254431777189573e-33,  5.787547185126169e-06, -1.226094232233108e-07,
  1.818347670964598e-09, -2.310948540465443e-11,  2.688337882018856e-13, -2.934832809319504e-15,  2.982437737201216e-17, -2.582529487984140e-19,  1.051437472958054e-21,
  3.009440922115864e-23, -1.139752502345287e-24,  2.381947567351888e-26,  1.892566107291057e-05, -4.009415101769245e-07,  5.946219875710909e-09, -7.558040351065308e-11,
  8.799428235000391e-13, -9.647632682478291e-15,  9.999146334161534e-17, -9.437826182697359e-19,  6.781224173248116e-21,  4.270213097545833e-24, -1.540024799176923e-24,
  3.779832176889086e-26,  1.738428891336350e-05, -3.682883213645545e-07,  5.462090294034743e-09, -6.944084890724848e-11,  8.095124716148749e-13, -8.936447308408188e-15,
  9.548865280460119e-17, -1.013918836247978e-18,  1.119077954106419e-20, -1.362373988024452e-22,  1.855531123122837e-24, -2.565247081652663e-26,  6.497009751015895e-06,
 -1.376404477695935e-07,  2.041423547244788e-09, -2.596082129879682e-11,  3.032178949868634e-13, -3.380926039991824e-15,  3.770014783779865e-17, -4.604651225133833e-19,
  6.944517761269182e-21, -1.293066876621935e-22,  2.534367847597739e-24, -4.393639190731755e-26,  1.075290981027584e-06, -2.278036916485942e-08,  3.378864773516856e-10,
 -4.298737966769081e-12,  5.034573560034573e-14, -5.693631083374313e-16,  6.721286094735516e-18, -9.580342225394662e-20,  1.816685956913992e-21, -4.046821037353648e-23,
  8.714400511381876e-25, -1.583432045676914e-26,  7.652993931721805e-08, -1.621321990516208e-09,  2.404985367426844e-11, -3.061607348170119e-13,  3.599842477951449e-15,
 -4.153863213990704e-17,  5.285805533214146e-19, -8.874057418777518e-21,  1.998430023053683e-22, -4.915593459840666e-24,  1.109239118070017e-25, -2.073456633486845e-27,
  2.057142630252731e-09, -4.358198482506277e-11,  6.465465391069756e-13, -8.238321854022521e-15,  9.744358409911453e-17, -1.158256716618925e-18,  1.628480616883008e-20,
 -3.243323034775558e-22,  8.349863068562016e-24, -2.193022059970990e-25,  5.117823789604175e-27, -9.838098909468250e-29,  1.547658914441986e-11, -3.278879798219101e-13,
  4.865188191534693e-15, -6.208727954577606e-17,  7.416263739052387e-19, -9.243155589732162e-21,  1.492100676903946e-22, -3.559589071326644e-24,  1.023888012547913e-25,
 -2.835072379333624e-27,  6.846902499684424e-29, -1.367552860612921e-30,  1.472317133937058e-14, -3.119369695776525e-16,  4.630262186235889e-18, -5.927487784082736e-20,
  7.224745063485507e-22, -9.867327784852558e-24,  1.974396631939430e-25, -5.780589298775502e-27,  1.850063819954518e-28, -5.438254157892497e-30,  1.386268598627020e-31,
 -2.977125024295497e-33,  5.324544388623308e-06, -1.091029945305100e-07,  1.565024347730238e-09, -1.924120711822606e-11,  2.167321661797691e-13, -2.301286244700701e-15,
  2.317509469895566e-17, -2.142756382020308e-19,  1.528477732722569e-21,  1.320340190271145e-24, -3.928300607231034e-25,  1.100496209405176e-26,  1.741161001858267e-05,
 -3.567741261857856e-07,  5.117760979992027e-09, -6.292309611526305e-11,  7.089736407698557e-13, -7.540637976086752e-15,  7.655863428217491e-17, -7.333830945471476e-19,
  6.163134743903602e-21, -3.096874244370141e-23, -3.778474141355329e-25,  1.651922692908164e-26,  1.599354547616540e-05, -3.277173919399848e-07,  4.700993854497171e-09,
 -5.780294162065150e-11,  6.515928385300118e-13, -6.949000487881231e-15,  7.146557157396024e-17, -7.219367008515230e-19,  7.385294017035854e-21, -8.079675627753564e-23,
  1.002253358558544e-24, -1.391962984108481e-26,  5.977247752352621e-06, -1.224775432592751e-07,  1.756919446103421e-09, -2.160510290123227e-11,  2.437168718260121e-13,
 -2.609414420596742e-15,  2.733826541261229e-17, -2.964896610962193e-19,  3.715711751473245e-21, -5.931789914044550e-23,  1.128675703635765e-24, -2.156661828389646e-26,
  9.892672423964220e-07, -2.027073531895609e-08,  2.907851825715004e-10, -3.576348724355205e-12,  4.038331417711479e-14, -4.348093007162713e-16,  4.674545924315521e-18,
 -5.544810576362717e-20,  8.443820220207116e-22, -1.684551875733421e-23,  3.700164234645442e-25, -7.582205201578943e-27,  7.040748507909258e-08, -1.442698752891323e-09,
  2.069612340176379e-11, -2.545934729854585e-13,  2.878942097307130e-15, -3.124864568647760e-17,  3.482160653782226e-19, -4.610182634636433e-21,  8.412632479702805e-23,
 -1.940689715355429e-24,  4.585861666436221e-26, -9.729488086083335e-28,  1.892568577697955e-09, -3.878018330105645e-11,  5.563382908502746e-13, -6.845935708336295e-15,
  7.758083343760734e-17, -8.522752222078866e-19,  9.995484948682795e-21, -1.513105813770787e-22,  3.261904169598160e-24, -8.339878553542671e-26,  2.066506691422156e-27,
 -4.502078642084616e-29,  1.423842927930859e-11, -2.917578716968087e-13,  4.185787891011829e-15, -5.153386207168800e-17,  5.860741113251153e-19, -6.565916063307702e-21,
  8.323551483460309e-23, -1.489096968612781e-24,  3.754282941454313e-26, -1.040573305119101e-27,  2.682731990630773e-29, -6.018402797314101e-31,  1.354526224530419e-14,
 -2.775571101442208e-16,  3.982516978255517e-18, -4.908157866916097e-20,  5.622139194733304e-22, -6.550314421389271e-24,  9.537435208402681e-26, -2.139886017617939e-27,
  6.327701206892192e-29, -1.895482865705734e-30,  5.131494622410299e-32, -1.209088481686594e-33,  4.911789317154039e-06, -9.745073788134226e-08,  1.353509857972716e-09,
 -1.611341873837427e-11,  1.758109094938566e-13, -1.811597601792536e-15,  1.785037053094527e-17, -1.668446815655730e-19,  1.386728581235634e-21, -7.168315907179159e-24,
 -8.237306934506258e-26,  3.995189420479972e-27,  1.606187344530568e-05, -3.186703523765416e-07,  4.426073716776650e-09, -5.269278230821385e-11,  5.749821653080455e-13,
 -5.928465629658287e-15,  5.860355671827828e-17, -5.557506996163078e-19,  4.913473557946060e-21, -3.557002779192766e-23,  6.536349161131674e-26,  5.134870747040855e-27,
  1.475373579563503e-05, -2.927167383562795e-07,  4.065609305331989e-09, -4.840252947661825e-11,  5.282547449472479e-13, -5.452130168770900e-15,  5.417163893985501e-17,
 -5.254601206806772e-19,  5.072543160522731e-21, -5.061610696899631e-23,  5.563906586990053e-25, -7.077278123822417e-27,  5.513894936388151e-06, -1.093966894515740e-07,
  1.519441114317591e-09, -1.809009355421313e-11,  1.974793961889303e-13, -2.041183033388145e-15,  2.043288580271185e-17, -2.046260643286796e-19,  2.204574397988727e-21,
 -2.885462762809529e-23,  4.838399697533655e-25, -9.230795277577694e-27,  9.125797443043898e-07, -1.810575806286168e-08,  2.514772432469721e-10, -2.994168800662816e-12,
  3.269699018722317e-14, -3.386699963267626e-16,  3.426190540111922e-18, -3.582858014439979e-20,  4.386080599392883e-22, -7.158778173320308e-24,  1.465857376416450e-25,
 -3.125800892207418e-27,  6.494952530345823e-08, -1.288611926185845e-09,  1.789811859894863e-11, -2.131152422636719e-13,  2.328423490198983e-15, -2.419000810499833e-17,
  2.484198159840663e-19, -2.752806388218941e-21,  3.888054782195826e-23, -7.587324794126807e-25,  1.744008325279807e-26, -3.924390888660020e-28,  1.745857147964971e-09,
 -3.463819707602313e-11,  4.811110490571352e-13, -5.729231177658510e-15,  6.264206118470871e-17, -6.537171166874531e-19,  6.863101026868972e-21, -8.228026787403118e-23,
  1.360567067281313e-24, -3.074644996567450e-26,  7.630467648107701e-28, -1.778603356125504e-29,  1.313466653233020e-11, -2.605951186149896e-13,  3.619629050143653e-15,
 -4.311079724900132e-17,  4.719330597310108e-19, -4.961178333487573e-21,  5.394675369015768e-23, -7.234188890277294e-25,  1.425992803888134e-26, -3.652651581738411e-28,
  9.614857080485178e-30, -2.312024470109595e-31,  1.249522755128243e-14, -2.479092032253717e-16,  3.443542955054037e-18, -4.102677984233553e-20,  4.502034481651967e-22,
 -4.802649228814730e-24,  5.585767849688346e-26, -8.969858979351999e-28,  2.179696024352933e-29, -6.288928443716431e-31,  1.755363254479545e-32, -4.400536729318722e-34
  };
  int offset = -9;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 9;
    if (std::isnan(t)) {
      fill_n(rr+offset, 9, 0.5);
      fill_n(ww+offset, 9, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 9; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=9; ++j) {
        const int boxof = it*108+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
