/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.extension.exslt;

import java.util.Vector;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.object.XEmptyNodeSet;
import jd.xml.xpath.object.XNodeSet;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XString;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.extension.exslt.ExsltUtil;

public class MathFunctions {
    public static double min(XObject xObject) throws XsltException {
        XNodeSet xNodeSet = xObject.toNodeSet();
        if (xNodeSet.isEmpty()) {
            return Double.NaN;
        }
        double d = Double.POSITIVE_INFINITY;
        int n = xNodeSet.size();
        for (int i = 0; i < n; ++i) {
            double d2 = xNodeSet.toNumberValue(i);
            if (Double.isNaN(d2)) {
                return d2;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double max(XObject xObject) throws XsltException {
        XNodeSet xNodeSet = xObject.toNodeSet();
        if (xNodeSet.isEmpty()) {
            return Double.NaN;
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = xNodeSet.size();
        for (int i = 0; i < n; ++i) {
            double d2 = xNodeSet.toNumberValue(i);
            if (Double.isNaN(d2)) {
                return d2;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static XObject lowest(XObject xObject) throws XsltException {
        XNodeSet xNodeSet = xObject.toNodeSet();
        Vector<XPathNode> vector = new Vector<XPathNode>();
        double d = Double.POSITIVE_INFINITY;
        int n = xNodeSet.size();
        for (int i = 0; i < n; ++i) {
            XPathNode xPathNode = xNodeSet.getNode(i);
            double d2 = XString.toNumberValue(xPathNode.getValue());
            if (Double.isNaN(d2)) {
                return XEmptyNodeSet.INSTANCE;
            }
            if (d2 == d) {
                vector.addElement(xPathNode);
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
            vector.removeAllElements();
            vector.addElement(xPathNode);
        }
        return ExsltUtil.getNodeSet(vector);
    }

    public static XObject highest(XObject xObject) throws XsltException {
        XNodeSet xNodeSet = xObject.toNodeSet();
        Vector<XPathNode> vector = new Vector<XPathNode>();
        double d = Double.NEGATIVE_INFINITY;
        int n = xNodeSet.size();
        for (int i = 0; i < n; ++i) {
            XPathNode xPathNode = xNodeSet.getNode(i);
            double d2 = XString.toNumberValue(xPathNode.getValue());
            if (Double.isNaN(d2)) {
                return XEmptyNodeSet.INSTANCE;
            }
            if (d2 == d) {
                vector.addElement(xPathNode);
                continue;
            }
            if (!(d2 > d)) continue;
            d = d2;
            vector.removeAllElements();
            vector.addElement(xPathNode);
        }
        return ExsltUtil.getNodeSet(vector);
    }
}

