/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class PgProcedure {
    private String name;
    private final List<Argument> arguments = new ArrayList<Argument>();
    private String body;
    private String comment;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("CREATE OR REPLACE PROCEDURE ");
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        stringBuilder.append('(');
        boolean bl = false;
        for (Argument argument : this.arguments) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(argument.getDeclaration(true));
            bl = true;
        }
        stringBuilder.append(") ");
        stringBuilder.append(this.body);
        stringBuilder.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON PROCEDURE ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append('(');
            bl = false;
            for (Argument argument : this.arguments) {
                if (bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(argument.getDeclaration(false));
                bl = true;
            }
            stringBuilder.append(") IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getBody() {
        return this.body;
    }

    public String getDropSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("DROP PROCEDURE ");
        stringBuilder.append(PgDiffUtils.getDropIfExists());
        stringBuilder.append(this.name);
        stringBuilder.append('(');
        boolean bl = false;
        for (Argument argument : this.arguments) {
            if ("OUT".equalsIgnoreCase(argument.getMode())) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(argument.getDeclaration(false));
            bl = true;
        }
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    public String getSignature() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.name);
        stringBuilder.append('(');
        boolean bl = false;
        for (Argument argument : this.arguments) {
            if ("OUT".equalsIgnoreCase(argument.getMode())) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(argument.getDataType().toLowerCase(Locale.ENGLISH));
            bl = true;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PgProcedure)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean bl) {
        boolean bl2 = false;
        if (this == object) {
            bl2 = true;
        } else if (object instanceof PgProcedure) {
            String string;
            String string2;
            PgProcedure pgProcedure = (PgProcedure)object;
            if (this.name == null && pgProcedure.getName() != null || this.name != null && !this.name.equals(pgProcedure.getName())) {
                return false;
            }
            if (bl) {
                string2 = this.body.replaceAll("\\s+", " ");
                string = pgProcedure.getBody().replaceAll("\\s+", " ");
            } else {
                string2 = this.body;
                string = pgProcedure.getBody();
            }
            if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
                return false;
            }
            if (this.arguments.size() != pgProcedure.getArguments().size()) {
                return false;
            }
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (this.arguments.get(i).equals(pgProcedure.getArguments().get(i))) continue;
                return false;
            }
            return true;
        }
        return bl2;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(this.body);
        stringBuilder.append('|');
        stringBuilder.append(this.name);
        for (Argument argument : this.arguments) {
            stringBuilder.append('|');
            stringBuilder.append(argument.getDeclaration(true));
        }
        return stringBuilder.toString().hashCode();
    }

    public static class Argument {
        private String mode = "IN";
        private String name;
        private String dataType;
        private String defaultExpression;

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String string) {
            this.dataType = string;
        }

        public String getDefaultExpression() {
            return this.defaultExpression;
        }

        public void setDefaultExpression(String string) {
            this.defaultExpression = string;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String string) {
            this.mode = string == null || string.isEmpty() ? "IN" : string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDeclaration(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(50);
            if (this.mode != null && !"IN".equalsIgnoreCase(this.mode)) {
                stringBuilder.append(this.mode);
                stringBuilder.append(' ');
            }
            if (this.name != null && !this.name.isEmpty()) {
                stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.dataType);
            if (bl && this.defaultExpression != null && !this.defaultExpression.isEmpty()) {
                stringBuilder.append(" = ");
                stringBuilder.append(this.defaultExpression);
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Argument)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            Argument argument = (Argument)object;
            return (this.dataType == null ? argument.getDataType() == null : this.dataType.equalsIgnoreCase(argument.getDataType())) && (this.defaultExpression == null ? argument.getDefaultExpression() == null : this.defaultExpression.equals(this.defaultExpression)) && (this.mode == null ? argument.getMode() == null : this.mode.equalsIgnoreCase(argument.getMode())) && (this.name == null ? argument.getName() == null : this.name.equals(argument.getName()));
        }

        public int hashCode() {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append(this.mode == null ? null : this.mode.toUpperCase(Locale.ENGLISH));
            stringBuilder.append('|');
            stringBuilder.append(this.name);
            stringBuilder.append('|');
            stringBuilder.append(this.dataType == null ? null : this.dataType.toUpperCase(Locale.ENGLISH));
            stringBuilder.append('|');
            stringBuilder.append(this.defaultExpression);
            return stringBuilder.toString().hashCode();
        }
    }
}

