#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
author: Francisco Munoz (@fmunoz)
description:
  - Get all networks.
  - Get networks by id.
  - List the networks that the user has privileges on in an organization.
  - Return a network.
extends_documentation_fragment:
  - cisco.meraki.module_info
  - cisco.meraki.module_info_pagination
module: networks_info
notes:
  - SDK Method used are networks.Networks.get_network, networks.Networks.get_organization_networks,
  - Paths used are get /networks/{networkId}, get /organizations/{organizationId}/networks,
options:
  configTemplateId:
    description:
      - 'ConfigTemplateId query parameter. An optional parameter that is the ID of
        a config template. Will return all networks bound to that template.

        '
    type: str
  endingBefore:
    description:
      - 'EndingBefore query parameter. A token used by the server to indicate the
        end of the page. Often this is a timestamp or an ID but it is not limited
        to those. This parameter should not be defined by client applications. The
        link for the first, last, prev, or next page in the HTTP Link header should
        define it.

        '
    type: str
  headers:
    description: Additional headers.
    type: dict
  isBoundToConfigTemplate:
    description:
      - 'IsBoundToConfigTemplate query parameter. An optional parameter to filter
        config template bound networks. If configTemplateId is set, this cannot be
        false.

        '
    type: bool
  networkId:
    description:
      - NetworkId path parameter. Network ID.
    type: str
  organizationId:
    description:
      - OrganizationId path parameter. Organization ID.
    type: str
  perPage:
    description:
      - PerPage query parameter. The number of entries per page returned. Acceptable
        range is 3 - 100000. Default is 1000.
    type: int
  productTypes:
    description:
      - 'ProductTypes query parameter. An optional parameter to filter networks by
        product type. Results will have at least one of the included product types.

        '
    elements: str
    type: list
  startingAfter:
    description:
      - 'StartingAfter query parameter. A token used by the server to indicate the
        start of the page. Often this is a timestamp or an ID but it is not limited
        to those. This parameter should not be defined by client applications. The
        link for the first, last, prev, or next page in the HTTP Link header should
        define it.

        '
    type: str
  tags:
    description:
      - 'Tags query parameter. An optional parameter to filter networks by tags. The
        filtering is case-sensitive. If tags are included, ''tagsFilterType'' should
        also be included (see below).

        '
    elements: str
    type: list
  tagsFilterType:
    description:
      - 'TagsFilterType query parameter. An optional parameter of value ''withAnyTags''
        or ''withAllTags'' to indicate whether to return networks which contain ANY
        or ALL of the included tags. If no type is included, ''withAnyTags'' will
        be selected.

        '
    type: str
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - description: Complete reference of the getNetwork API.
    link: https://developer.cisco.com/meraki/api-v1/#!get-network
    name: Cisco Meraki documentation for networks getNetwork
  - description: Complete reference of the getOrganizationNetworks API.
    link: https://developer.cisco.com/meraki/api-v1/#!get-organization-networks
    name: Cisco Meraki documentation for networks getOrganizationNetworks
short_description: Information module for networks
version_added: 2.16.0
"""

EXAMPLES = r"""
- name: Get all networks
  cisco.meraki.networks_info:
    meraki_api_key: '{{ meraki_api_key }}'
    meraki_base_url: '{{ meraki_base_url }}'
    meraki_single_request_timeout: '{{ meraki_single_request_timeout }}'
    meraki_certificate_path: '{{ meraki_certificate_path }}'
    meraki_requests_proxy: '{{ meraki_requests_proxy }}'
    meraki_wait_on_rate_limit: '{{ meraki_wait_on_rate_limit }}'
    meraki_nginx_429_retry_wait_time: '{{ meraki_nginx_429_retry_wait_time }}'
    meraki_action_batch_retry_wait_time: '{{ meraki_action_batch_retry_wait_time }}'
    meraki_retry_4xx_error: '{{ meraki_retry_4xx_error }}'
    meraki_retry_4xx_error_wait_time: '{{ meraki_retry_4xx_error_wait_time }}'
    meraki_maximum_retries: '{{ meraki_maximum_retries }}'
    meraki_output_log: '{{ meraki_output_log }}'
    meraki_log_file_prefix: '{{ meraki_log_file_prefix }}'
    meraki_log_path: '{{ meraki_log_path }}'
    meraki_print_console: '{{ meraki_print_console }}'
    meraki_suppress_logging: '{{ meraki_suppress_logging }}'
    meraki_simulate: '{{ meraki_simulate }}'
    meraki_be_geo_id: '{{ meraki_be_geo_id }}'
    meraki_use_iterator_for_get_pages: '{{ meraki_use_iterator_for_get_pages }}'
    meraki_inherit_logging_config: '{{ meraki_inherit_logging_config }}'
    configTemplateId: string
    isBoundToConfigTemplate: true
    tags: []
    tagsFilterType: string
    productTypes: []
    perPage: 0
    startingAfter: string
    endingBefore: string
    organizationId: string
    total_pages: -1
    direction: next
  register: result
- name: Get networks by id
  cisco.meraki.networks_info:
    meraki_api_key: '{{ meraki_api_key }}'
    meraki_base_url: '{{ meraki_base_url }}'
    meraki_single_request_timeout: '{{ meraki_single_request_timeout }}'
    meraki_certificate_path: '{{ meraki_certificate_path }}'
    meraki_requests_proxy: '{{ meraki_requests_proxy }}'
    meraki_wait_on_rate_limit: '{{ meraki_wait_on_rate_limit }}'
    meraki_nginx_429_retry_wait_time: '{{ meraki_nginx_429_retry_wait_time }}'
    meraki_action_batch_retry_wait_time: '{{ meraki_action_batch_retry_wait_time }}'
    meraki_retry_4xx_error: '{{ meraki_retry_4xx_error }}'
    meraki_retry_4xx_error_wait_time: '{{ meraki_retry_4xx_error_wait_time }}'
    meraki_maximum_retries: '{{ meraki_maximum_retries }}'
    meraki_output_log: '{{ meraki_output_log }}'
    meraki_log_file_prefix: '{{ meraki_log_file_prefix }}'
    meraki_log_path: '{{ meraki_log_path }}'
    meraki_print_console: '{{ meraki_print_console }}'
    meraki_suppress_logging: '{{ meraki_suppress_logging }}'
    meraki_simulate: '{{ meraki_simulate }}'
    meraki_be_geo_id: '{{ meraki_be_geo_id }}'
    meraki_use_iterator_for_get_pages: '{{ meraki_use_iterator_for_get_pages }}'
    meraki_inherit_logging_config: '{{ meraki_inherit_logging_config }}'
    networkId: string
  register: result
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "enrollmentString": "string",
      "id": "string",
      "isBoundToConfigTemplate": true,
      "name": "string",
      "notes": "string",
      "organizationId": "string",
      "productTypes": [
        "string"
      ],
      "tags": [
        "string"
      ],
      "timeZone": "string",
      "url": "string"
    }
"""
